/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.hexdiff;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HTMLViewFrm;
import jkcemu.base.ReplyIntDlg;
import jkcemu.tools.hexdiff.FileData;

public class HexDiffFrm
extends HTMLViewFrm
implements DropTargetListener,
ListSelectionListener {
    private static HexDiffFrm instance = null;
    private int lastDiffs;
    private Vector<FileData> files;
    private JMenuItem mnuFileAdd;
    private JMenuItem mnuFileRemove;
    private JMenuItem mnuMaxDiffs;
    private JList<FileData> listFiles;
    private JButton btnFileAdd;
    private JButton btnFileRemove;

    public static HexDiffFrm open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new HexDiffFrm();
        }
        instance.setVisible(true);
        instance.toFront();
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public int addFiles(Collection collection) {
        int n = 0;
        if (collection != null) {
            File file = null;
            try {
                boolean bl = false;
                for (Object e : collection) {
                    void var9_14;
                    if (!(e instanceof File) || !((File)e).isFile()) continue;
                    file = (File)e;
                    boolean bl2 = false;
                    for (FileData fileData : this.files) {
                        if (!file.equals(fileData.getFile())) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        if (collection.size() != 1) continue;
                        BaseDlg.showInfoDlg(this, "Die Datei wurde bereits hinzugef\u00fcgt.");
                        continue;
                    }
                    FileData fileData = new FileData(file);
                    if (file.length() > 0L) {
                        this.files.add(fileData);
                        ++n;
                        continue;
                    }
                    String string = file.getName();
                    if (string == null) {
                        String string2 = file.getPath();
                    }
                    if (BaseDlg.showOptionDlg(this, (String)var9_14 + ": Datei ist leer.", "Datei leer", "Weiter", "Abbrechen") == 0) continue;
                    break;
                }
                if (n > 0) {
                    this.listFiles.setListData(this.files);
                    this.updResult();
                }
            }
            catch (IOException iOException) {
                BaseDlg.showOpenFileErrorDlg(this, file, iOException);
            }
        }
        return n;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (EmuUtil.isFileDrop(dropTargetDropEvent)) {
            dropTargetDropEvent.acceptDrop(1);
            int n = 0;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable != null) {
                try {
                    Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (object != null && object instanceof Collection) {
                        n = this.addFiles((Collection)object);
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            dropTargetDropEvent.dropComplete(n > 0);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.listFiles) {
            boolean bl = this.listFiles.getSelectedIndex() >= 0;
            this.mnuFileRemove.setEnabled(bl);
            this.btnFileRemove.setEnabled(bl);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.mnuFileAdd || object == this.btnFileAdd) {
                bl = true;
                this.doFileAdd();
            } else if (object == this.mnuFileRemove || object == this.btnFileRemove) {
                bl = true;
                this.doFileRemove();
            } else if (object == this.mnuMaxDiffs) {
                bl = true;
                this.doMaxDiffs();
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl && !Main.checkQuit(this)) {
            this.files.clear();
            this.listFiles.setListData(this.files);
            this.updResult();
        }
        return bl;
    }

    private HexDiffFrm() {
        this.setTitle("JKCEMU Hex-Dateivergleicher");
        this.files = new Vector();
        this.lastDiffs = 0;
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuFileAdd = this.createJMenuItem("Datei hinzuf\u00fcgen...");
        jMenu.add(this.mnuFileAdd);
        this.mnuFileRemove = this.createJMenuItem("Datei entfernen");
        this.mnuFileRemove.setEnabled(false);
        jMenu.add(this.mnuFileRemove);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Einstellungen");
        jMenu2.setMnemonic(69);
        this.mnuMaxDiffs = this.createJMenuItem("Max. Dateiunterschiede...");
        jMenu2.add(this.mnuMaxDiffs);
        this.createMenuBar(jMenu, jMenu2, "/help/tools/hexdiff.htm");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Dateien:"), gridBagConstraints);
        this.listFiles = new JList();
        this.listFiles.setSelectionMode(2);
        this.listFiles.setVisibleRowCount(2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JScrollPane(this.listFiles), gridBagConstraints);
        this.btnFileAdd = this.createImageButton("/images/file/open.png", "Datei hinzuf\u00fcgen");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnFileAdd, gridBagConstraints);
        this.btnFileRemove = this.createImageButton("/images/file/delete.png", "Datei entfernen");
        this.btnFileRemove.setEnabled(false);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFileRemove, gridBagConstraints);
        this.listFiles.addListSelectionListener(this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.createEditorPane(gridBagConstraints);
        new DropTarget(this.listFiles, this).setActive(true);
        new DropTarget(this.editorPane, this).setActive(true);
        new DropTarget(this.scrollPane, this).setActive(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.editorPane.setPreferredSize(new Dimension(300, 300));
            this.pack();
            this.editorPane.setPreferredSize(null);
            this.setScreenCentered();
        }
        this.setResizable(true);
        this.updResult();
    }

    private void doFileAdd() {
        List<File> list = EmuUtil.showMultiFileOpenDlg(this, "Dateien \u00f6ffnen", Main.getLastDirFile("hexdiff"), new FileFilter[0]);
        if (list != null && !list.isEmpty() && this.addFiles(list) > 0) {
            Main.setLastFile(list.get(0), "hexdiff");
        }
    }

    private void doFileRemove() {
        int[] nArray = this.listFiles.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                if (n < 0 || n > this.files.size()) continue;
                this.files.remove(n);
                this.listFiles.setListData(this.files);
            }
            this.updResult();
        }
    }

    private void doMaxDiffs() {
        int n = this.getMaxDiffs();
        ReplyIntDlg replyIntDlg = new ReplyIntDlg(this, "Max. Dateiunterschiede (0 f\u00fcr unendlich):", n, 0, null);
        replyIntDlg.setTitle("Einstellung");
        replyIntDlg.setVisible(true);
        Integer n2 = replyIntDlg.getReply();
        if (n2 != null) {
            Main.setProperty("jkcemu.hexdiff.differences.max", n2.toString());
            if (this.lastDiffs > 0 && this.lastDiffs >= n) {
                this.updResult();
            }
        }
    }

    private int getMaxDiffs() {
        int n = 100;
        String string = Main.getProperty("jkcemu.hexdiff.differences.max");
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 >= 0) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updResult() {
        this.setHTMLText("");
        int n = this.files.size();
        if (n > 1) {
            StringBuilder stringBuilder = null;
            int n2 = this.getMaxDiffs();
            int n3 = 0;
            int[] nArray = new int[n];
            try {
                try {
                    int n4 = 0;
                    boolean bl = true;
                    while (bl && (n2 <= 0 || n3 < n2)) {
                        int n5;
                        int n6;
                        bl = false;
                        boolean bl2 = false;
                        boolean bl3 = true;
                        nArray[0] = this.files.get(0).read();
                        if (nArray[0] >= 0) {
                            bl = true;
                            bl3 = false;
                        } else {
                            bl2 = true;
                        }
                        for (n6 = 1; n6 < n; ++n6) {
                            n5 = this.files.get(n6).read();
                            if (n5 >= 0) {
                                bl = true;
                                bl3 = false;
                                if (nArray[0] != n5) {
                                    bl2 = true;
                                }
                            } else {
                                bl2 = true;
                            }
                            nArray[n6] = n5;
                        }
                        if (bl2 && !bl3) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(65536);
                                stringBuilder.append("<htm>\n<table border=\"1\">\n<tr><th>Position</th>");
                                for (n6 = 0; n6 < n; ++n6) {
                                    stringBuilder.append("<th>Datei ");
                                    stringBuilder.append(n6 + 1);
                                    stringBuilder.append("</th>");
                                }
                                stringBuilder.append("</tr>\n");
                            }
                            stringBuilder.append("<tr><td>");
                            stringBuilder.append(String.format("%08X", n4));
                            stringBuilder.append("</td>");
                            for (n6 = 0; n6 < n; ++n6) {
                                stringBuilder.append("<td>");
                                n5 = nArray[n6];
                                if (n5 >= 0) {
                                    stringBuilder.append(String.format("%02X", n5));
                                    if (n5 > 32 && n5 < 127) {
                                        stringBuilder.append(' ');
                                        stringBuilder.append((char)n5);
                                    }
                                }
                                stringBuilder.append("</td>");
                            }
                            stringBuilder.append("</tr>\n");
                            ++n3;
                        }
                        ++n4;
                    }
                    if (stringBuilder != null) {
                        stringBuilder.append("</table>\n");
                        if (n2 > 0 && n3 >= n2) {
                            stringBuilder.append("<br>\n");
                            if (n2 == 1) {
                                stringBuilder.append("Es wird nur der erste Unterschied angezeigt.\n");
                            } else {
                                stringBuilder.append("Es werden nur die ersten ");
                                stringBuilder.append(n2);
                                stringBuilder.append(" Unterschiede angezeigt.\n");
                            }
                        } else if (n3 == 1) {
                            stringBuilder.append("1 unterschiedliches Byte\n");
                        } else {
                            stringBuilder.append(n3);
                            stringBuilder.append(" unterschiedliche Bytes\n");
                        }
                        stringBuilder.append("</html>\n");
                        this.setHTMLText(stringBuilder.toString());
                    } else {
                        this.setHTMLText("<html>Der Inhalt der Dateien ist identisch.</html>");
                    }
                    this.lastDiffs = n3;
                }
                finally {
                    for (FileData fileData : this.files) {
                        try {
                            fileData.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException.getMessage());
            }
        }
    }
}

