/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.base.UserInputException;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class IntelHexFileTarget
extends AbstractConvertTarget {
    private byte[] dataBytes;
    private int offs;
    private int len;

    public IntelHexFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2) {
        super(fileConvertFrm, "Intel-HEX-Datei (*.hex)");
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
    }

    @Override
    public FileFilter getFileFilter() {
        return EmuUtil.getHexFileFilter();
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtension(file, ".hex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(File file) throws IOException, UserInputException {
        this.checkFileExtension(file, ".hex");
        int n = this.fileConvertFrm.getBegAddr(true);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            int n2 = this.offs;
            int n3 = Math.min(this.offs + this.len, this.dataBytes.length);
            int n4 = Math.min(n3 - n2, 32);
            while (n4 > 0) {
                int n5 = n4 & 0xFF;
                n5 += n & 0xFF;
                n5 += n >> 8 & 0xFF;
                fileWriter.write(String.format(":%02X%04X00", n4, n));
                for (int i = 0; i < n4; ++i) {
                    int n6 = this.dataBytes[n2++] & 0xFF;
                    fileWriter.write(String.format("%02X", n6));
                    n5 += n6;
                }
                fileWriter.write(String.format("%02X", -n5 & 0xFF));
                ((Writer)fileWriter).write(13);
                ((Writer)fileWriter).write(10);
                n += n4;
                n4 = Math.min(n3 - n2, 32);
            }
            fileWriter.write(":00000001FF");
            ((Writer)fileWriter).write(13);
            ((Writer)fileWriter).write(10);
            ((Writer)fileWriter).close();
            fileWriter = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileWriter);
            throw throwable;
        }
        EmuUtil.closeSilent(fileWriter);
        return null;
    }

    @Override
    public boolean usesBegAddr() {
        return true;
    }
}

