/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.base.UserInputException;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class HeadersaveFileTarget
extends AbstractConvertTarget {
    private byte[] dataBytes;
    private int offs;
    private int len;

    public HeadersaveFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2) {
        super(fileConvertFrm, "Headersave-Datei (*.z80)");
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
    }

    public static void setFileTypesTo(JComboBox<String> jComboBox, FileConvertFrm fileConvertFrm) {
        jComboBox.removeAllItems();
        EmuUtil.addHeadersaveFileTypeItemsTo(jComboBox);
        jComboBox.setEnabled(true);
        int n = fileConvertFrm.getOrgFileTypeChar();
        if (n > 32 && n < 127) {
            if (!EmuUtil.setSelectedHeadersaveFileTypeItem(jComboBox, n)) {
                jComboBox.setSelectedItem(Character.toString((char)n));
            }
        } else if (fileConvertFrm.getOrgIsBasicPrg()) {
            EmuUtil.setSelectedHeadersaveFileTypeItem(jComboBox, 66);
        } else if (fileConvertFrm.getOrgStartAddr() >= 0) {
            EmuUtil.setSelectedHeadersaveFileTypeItem(jComboBox, 67);
        } else {
            EmuUtil.setSelectedHeadersaveFileTypeItem(jComboBox, 77);
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return EmuUtil.getHeadersaveFileFilter();
    }

    @Override
    public int getMaxFileDescLength() {
        return 16;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtension(file, ".z80");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(File file) throws IOException, UserInputException {
        this.checkFileExtension(file, ".z80");
        int n = this.fileConvertFrm.getBegAddr(true);
        int n2 = n + this.len - 1;
        int n3 = this.fileConvertFrm.getStartAddr(false);
        int n4 = this.fileConvertFrm.getFileTypeChar(true);
        String string = this.fileConvertFrm.getFileDesc(true);
        FileOutputStream fileOutputStream = null;
        try {
            int n5;
            int n6;
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(n);
            ((OutputStream)fileOutputStream).write(n >> 8);
            ((OutputStream)fileOutputStream).write(n2);
            ((OutputStream)fileOutputStream).write(n2 >> 8);
            if (n3 >= 0) {
                ((OutputStream)fileOutputStream).write(n3);
                ((OutputStream)fileOutputStream).write(n3 >> 8);
            } else {
                ((OutputStream)fileOutputStream).write(0);
                ((OutputStream)fileOutputStream).write(0);
            }
            ((OutputStream)fileOutputStream).write(74);
            ((OutputStream)fileOutputStream).write(75);
            ((OutputStream)fileOutputStream).write(67);
            ((OutputStream)fileOutputStream).write(69);
            ((OutputStream)fileOutputStream).write(77);
            ((OutputStream)fileOutputStream).write(85);
            ((OutputStream)fileOutputStream).write(n4);
            ((OutputStream)fileOutputStream).write(211);
            ((OutputStream)fileOutputStream).write(211);
            ((OutputStream)fileOutputStream).write(211);
            if (string != null) {
                n6 = 0;
                int n7 = string.length();
                for (n5 = 16; n5 > 0 && n6 < n7; --n5) {
                    ((OutputStream)fileOutputStream).write(string.charAt(n6++) & 0xFF);
                }
            }
            while (n5 > 0) {
                ((OutputStream)fileOutputStream).write(32);
                --n5;
            }
            n5 = Math.min(this.dataBytes.length - this.offs, this.len);
            ((OutputStream)fileOutputStream).write(this.dataBytes, this.offs, n5);
            if ((n5 %= 32) > 0) {
                for (n6 = n5; n6 < 32; ++n6) {
                    ((OutputStream)fileOutputStream).write(0);
                }
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
        return null;
    }

    @Override
    public void setFileTypesTo(JComboBox<String> jComboBox) {
        HeadersaveFileTarget.setFileTypesTo(jComboBox, this.fileConvertFrm);
    }

    @Override
    public boolean usesBegAddr() {
        return true;
    }

    @Override
    public boolean usesStartAddr(int n) {
        return n == 67 || n == 77;
    }
}

