/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.CopyQMDisk;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class CopyQMFileTarget
extends AbstractConvertTarget {
    private AbstractFloppyDisk disk;

    public CopyQMFileTarget(FileConvertFrm fileConvertFrm, AbstractFloppyDisk abstractFloppyDisk) {
        super(fileConvertFrm, "CopyQM-Datei (*.cqm)");
        this.disk = abstractFloppyDisk;
    }

    @Override
    public int getMaxRemarkLength() {
        return 32766;
    }

    @Override
    public FileFilter getFileFilter() {
        return EmuUtil.getCopyQMFileFilter();
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtension(file, ".cqm");
    }

    @Override
    public String save(File file) throws IOException {
        this.checkFileExtension(file, ".cqm");
        return CopyQMDisk.export(this.disk, file, this.fileConvertFrm.getRemark());
    }
}

