/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.BitSampleBuffer;
import jkcemu.audio.CSWFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class CSWFileTarget
extends AbstractConvertTarget {
    private BitSampleBuffer samples;
    private FileFilter[] fileFilters;

    public CSWFileTarget(FileConvertFrm fileConvertFrm, BitSampleBuffer bitSampleBuffer) {
        super(fileConvertFrm, "CSW-Datei (" + CSWFile.getFileExtensionText() + ")");
        this.samples = bitSampleBuffer;
        this.fileFilters = null;
    }

    @Override
    public boolean canPlay() {
        return true;
    }

    @Override
    public PCMDataSource createPCMDataSource() throws IOException {
        return this.samples.newReader();
    }

    @Override
    public synchronized FileFilter[] getFileFilters() {
        if (this.fileFilters == null) {
            this.fileFilters = new FileFilter[]{CSWFile.getFileFilter()};
        }
        return this.fileFilters;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.getSuggestedOutFile(file, CSWFile.getFileExtensions(), "csw");
    }

    @Override
    public String save(File file) throws IOException {
        if (file != null) {
            CSWFile.write(this.createPCMDataSource(), file);
        }
        return null;
    }
}

