/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class BinFileTarget
extends AbstractConvertTarget {
    private byte[] dataBytes;
    private int offs;
    private int len;
    private int begAddr;
    private int endAddr;
    private int startAddr;

    public BinFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        super(fileConvertFrm, "Einfache Speicherabbilddatei (*.bin)");
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
        this.begAddr = n3;
        this.endAddr = n4;
        this.startAddr = n5;
    }

    @Override
    public FileFilter getFileFilter() {
        return EmuUtil.getBinaryFileFilter();
    }

    @Override
    public File getSuggestedOutFile(File file) {
        String string;
        File file2 = null;
        if (file != null && (string = file.getName()) != null) {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (!string.isEmpty()) {
                String string2 = "";
                if (this.begAddr >= 0) {
                    string2 = String.format("_%04X", this.begAddr);
                    if (string.toUpperCase().indexOf(string2) < 0) {
                        if (this.endAddr >= 0) {
                            string2 = this.startAddr >= 0 ? String.format("_%04X_%04X_%04X", this.begAddr, this.endAddr, this.startAddr) : String.format("_%04X_%04X", this.begAddr, this.endAddr);
                        }
                        if (!string.toUpperCase().endsWith(string2)) {
                            string = string + string2;
                        }
                    }
                }
                string = string.endsWith(".") ? string + "bin" : string + ".bin";
                File file3 = file.getParentFile();
                file2 = file3 != null ? new File(file3, string) : new File(string);
            }
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(File file) throws IOException {
        this.checkFileExtension(file, ".bin", ".rom");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(this.dataBytes, this.offs, Math.min(this.dataBytes.length - this.offs, this.len));
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
        return null;
    }
}

