/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.AudioFile;
import jkcemu.audio.BitSampleBuffer;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.EmuUtil;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class AudioFileTarget
extends AbstractConvertTarget {
    private File file;
    private FileFilter[] fileFilters;
    private BitSampleBuffer samples;

    public AudioFileTarget(FileConvertFrm fileConvertFrm, File file) {
        super(fileConvertFrm, "Sound-Datei (" + AudioFile.getFileExtensionText() + ")");
        this.file = file;
        this.fileFilters = null;
        this.samples = null;
    }

    public AudioFileTarget(FileConvertFrm fileConvertFrm, BitSampleBuffer bitSampleBuffer) {
        super(fileConvertFrm, "Sound-Datei (" + AudioFile.getFileExtensionText() + ")");
        this.file = null;
        this.fileFilters = null;
        this.samples = bitSampleBuffer;
    }

    @Override
    public boolean canPlay() {
        return true;
    }

    @Override
    public PCMDataSource createPCMDataSource() throws IOException {
        PCMDataSource pCMDataSource = null;
        try {
            if (this.samples != null) {
                pCMDataSource = this.samples.newReader();
            } else if (this.file != null) {
                pCMDataSource = AudioFile.open(this.file);
            }
        }
        catch (IOException iOException) {
            EmuUtil.closeSilent(pCMDataSource);
            throw iOException;
        }
        return pCMDataSource;
    }

    @Override
    public synchronized FileFilter[] getFileFilters() {
        if (this.fileFilters == null) {
            this.fileFilters = new FileFilter[]{AudioFile.getFileFilter()};
        }
        return this.fileFilters;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.getSuggestedOutFile(file, AudioFile.getFileExtensions(), "wav");
    }

    @Override
    public String save(File file) throws IOException {
        if (file != null) {
            AudioFile.write(this.createPCMDataSource(), file);
        }
        return null;
    }
}

