/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jkcemu.base.HexDocument;
import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.AbstractBreakpointDlg;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.debugger.OutputBreakpoint;

public class OutputBreakpointDlg
extends AbstractBreakpointDlg {
    private HexDocument docBegPort;
    private HexDocument docEndPort;
    private HexDocument docMask;
    private HexDocument docValue;
    private JLabel labelValue1;
    private JLabel labelValue2;
    private JComboBox<String> comboCond;
    private JCheckBox btnCheckValue;
    private JTextField fldBegPort;
    private JTextField fldEndPort;
    private JTextField fldMask;
    private JTextField fldValue;

    public OutputBreakpointDlg(DebugFrm debugFrm, AbstractBreakpoint abstractBreakpoint) {
        super(debugFrm, "Ausgabetor", abstractBreakpoint);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Ausgabeadresse (8 oder 16 Bit):"), gridBagConstraints);
        this.docBegPort = new HexDocument(4);
        this.fldBegPort = new JTextField(this.docBegPort, "", 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldBegPort, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Bis Ausgabeadresse (optional):"), gridBagConstraints);
        this.docEndPort = new HexDocument(4);
        this.fldEndPort = new JTextField(this.docEndPort, "", 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldEndPort, gridBagConstraints);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        this.btnCheckValue = new JCheckBox("Zus\u00e4tzlich auszugebenden Wert pr\u00fcfen", false);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnCheckValue, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 50;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.labelValue1 = new JLabel("Nur anhalten/loggen wenn Wert UND");
        jPanel.add((Component)this.labelValue1, gridBagConstraints2);
        this.docMask = new HexDocument(2);
        this.fldMask = new JTextField(this.docMask, "", 2);
        this.fldMask.setToolTipText("Maske");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldMask, gridBagConstraints2);
        this.comboCond = new JComboBox<String>(conditions);
        this.comboCond.setEditable(false);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add(this.comboCond, gridBagConstraints2);
        this.docValue = new HexDocument(2);
        this.fldValue = new JTextField(this.docValue, "", 2);
        this.fldValue.setToolTipText("Vergleichswert");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldValue, gridBagConstraints2);
        this.labelValue2 = new JLabel("ist.");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.labelValue2, gridBagConstraints2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.createGeneralButtons(), gridBagConstraints);
        boolean bl = false;
        String string = null;
        int n = 65535;
        int n2 = 0;
        if (abstractBreakpoint != null && abstractBreakpoint instanceof OutputBreakpoint) {
            OutputBreakpoint outputBreakpoint = (OutputBreakpoint)abstractBreakpoint;
            int n3 = outputBreakpoint.get8Bit() ? 2 : 4;
            this.docBegPort.setValue(outputBreakpoint.getBegPort(), n3);
            int n4 = outputBreakpoint.getEndPort();
            if (n4 >= 0) {
                this.docEndPort.setValue(n4, n3);
            }
            n = outputBreakpoint.getMask();
            string = outputBreakpoint.getCondition();
            n2 = outputBreakpoint.getValue();
            if (string != null) {
                bl = true;
            }
        }
        this.docMask.setValue(n, 2);
        this.comboCond.setSelectedItem(string != null ? string : "=");
        this.docValue.setValue(n2, 2);
        this.btnCheckValue.setSelected(bl);
        this.updCheckValueFieldsEnabled();
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.fldBegPort.setColumns(0);
        this.fldEndPort.setColumns(0);
        this.fldMask.setColumns(0);
        this.fldValue.setColumns(0);
        this.fldBegPort.addActionListener(this);
        this.fldEndPort.addActionListener(this);
        this.btnCheckValue.addActionListener(this);
        this.fldMask.addActionListener(this);
        this.fldValue.addActionListener(this);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnCheckValue) {
                bl = true;
                this.updCheckValueFieldsEnabled();
            } else if (object == this.fldBegPort) {
                bl = true;
                this.fldEndPort.requestFocus();
            } else if (object == this.fldEndPort || object == this.fldValue) {
                bl = true;
                this.doApprove();
            } else if (object == this.fldMask) {
                bl = true;
                this.comboCond.requestFocus();
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    protected void doApprove() {
        String string = "Ausgabeadresse";
        try {
            boolean bl = true;
            boolean bl2 = false;
            int n = this.docBegPort.intValue();
            String string2 = this.fldBegPort.getText();
            if (string2 != null && string2.trim().length() < 3) {
                bl2 = true;
                n &= 0xFF;
            }
            int n2 = -1;
            Integer n3 = this.docEndPort.getInteger();
            if (n3 != null) {
                n2 = n3 & 0xFFFF;
                if (bl2) {
                    n2 &= 0xFF;
                }
            }
            String string3 = null;
            int n4 = 255;
            int n5 = 0;
            if (this.btnCheckValue.isSelected()) {
                Object object = this.comboCond.getSelectedItem();
                if (object != null) {
                    string3 = object.toString();
                }
                if (string3 != null) {
                    string = "Maske";
                    n4 = this.docMask.intValue() & 0xFF;
                    string = "Wert";
                    n5 = this.docValue.intValue() & 0xFF;
                    bl = this.checkMaskValue(true, n4, n5);
                }
            }
            if (bl) {
                this.approveBreakpoint(new OutputBreakpoint(this.debugFrm, bl2, n, n2, string3, n4, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showInvalidFmt(string);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (this.fldBegPort != null) {
            this.fldBegPort.requestFocus();
        }
    }

    private void updCheckValueFieldsEnabled() {
        boolean bl = this.btnCheckValue.isSelected();
        this.labelValue1.setEnabled(bl);
        this.labelValue2.setEnabled(bl);
        this.fldMask.setEnabled(bl);
        this.comboCond.setEnabled(bl);
        this.fldValue.setEnabled(bl);
    }
}

