/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.DebugFrm;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;

public class OutputBreakpoint
extends AbstractBreakpoint {
    private boolean is8Bit;
    private int begPort;
    private int endPort;
    private int mask;
    private String cond;
    private int value;

    public OutputBreakpoint(DebugFrm debugFrm, boolean bl, int n, int n2, String string, int n3, int n4) {
        super(debugFrm);
        this.is8Bit = bl;
        this.begPort = n & 0xFFFF;
        this.endPort = n2 >= 0 ? n2 & 0xFFFF : -1;
        this.mask = n3 & 0xFF;
        this.cond = string;
        this.value = n4 & 0xFF;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.is8Bit) {
            this.begPort &= 0xFF;
            stringBuilder.append(String.format("%02X", this.begPort));
            if (this.endPort >= 0) {
                this.endPort &= 0xFF;
                stringBuilder.append(String.format("-%02X", this.endPort));
            }
        } else {
            stringBuilder.append(String.format("%04X", this.begPort));
            if (this.endPort >= 0) {
                stringBuilder.append(String.format("-%04X", this.endPort));
            }
        }
        if (this.cond != null) {
            if (this.mask != 255) {
                stringBuilder.append(String.format(":(Wert&%02X)%s%02X", this.mask, this.cond, this.value));
            } else {
                stringBuilder.append(String.format(":Wert%s%02X", this.cond, this.value));
            }
        }
        this.setText(stringBuilder.toString());
    }

    public boolean get8Bit() {
        return this.is8Bit;
    }

    public int getBegPort() {
        return this.begPort;
    }

    public String getCondition() {
        return this.cond;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public int getMask() {
        return this.mask;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    protected boolean matchesImpl(Z80CPU z80CPU, Z80InterruptSource z80InterruptSource) {
        boolean bl = false;
        int n = z80CPU.getRegPC();
        int n2 = z80CPU.getMemByte(n, false);
        int n3 = z80CPU.getMemByte(n + 1, false);
        int n4 = -1;
        int n5 = -1;
        if (n2 == 211) {
            int n6 = z80CPU.getRegA();
            n4 = n6 << 8 | n3;
            n5 = n6;
        } else if (n2 == 237) {
            switch (n3) {
                case 65: {
                    n4 = z80CPU.getRegBC();
                    n5 = z80CPU.getRegB();
                    break;
                }
                case 73: {
                    n4 = z80CPU.getRegBC();
                    n5 = z80CPU.getRegC();
                    break;
                }
                case 81: {
                    n4 = z80CPU.getRegBC();
                    n5 = z80CPU.getRegD();
                    break;
                }
                case 89: {
                    n4 = z80CPU.getRegBC();
                    n5 = z80CPU.getRegE();
                    break;
                }
                case 97: {
                    n4 = z80CPU.getRegBC();
                    n5 = z80CPU.getRegH();
                    break;
                }
                case 105: {
                    n4 = z80CPU.getRegBC();
                    n5 = z80CPU.getRegL();
                    break;
                }
                case 113: {
                    n4 = z80CPU.getRegBC();
                    n5 = 0;
                    break;
                }
                case 121: {
                    n4 = z80CPU.getRegBC();
                    n5 = z80CPU.getRegA();
                    break;
                }
                case 163: 
                case 171: 
                case 179: 
                case 187: {
                    n4 = z80CPU.getRegBC();
                    if (!this.is8Bit) {
                        n4 = n4 - 256 & 0xFF00 | n4 & 0xFF;
                    }
                    n5 = z80CPU.getMemByte(z80CPU.getRegHL(), false);
                }
            }
        }
        if (n4 >= 0 && this.matchesPort(n4)) {
            bl = this.cond != null && n5 >= 0 ? OutputBreakpoint.checkValues(n5 & this.mask, this.cond, this.value) : true;
        }
        return bl;
    }

    private boolean matchesPort(int n) {
        n = this.is8Bit ? (n &= 0xFF) : (n &= 0xFFFF);
        return n == this.begPort || n >= this.begPort && n <= this.endPort;
    }
}

