/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jkcemu.base.HexDocument;
import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.AbstractBreakpointDlg;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.debugger.InputBreakpoint;

public class InputBreakpointDlg
extends AbstractBreakpointDlg {
    private HexDocument docBegPort;
    private HexDocument docEndPort;
    private JTextField fldBegPort;
    private JTextField fldEndPort;

    public InputBreakpointDlg(DebugFrm debugFrm, AbstractBreakpoint abstractBreakpoint) {
        super(debugFrm, "Eingabetor", abstractBreakpoint);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Eingabeadresse (8 oder 16 Bit):"), gridBagConstraints);
        this.docBegPort = new HexDocument(4);
        this.fldBegPort = new JTextField(this.docBegPort, "", 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldBegPort, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Bis Eingabeadresse (optional):"), gridBagConstraints);
        this.docEndPort = new HexDocument(4);
        this.fldEndPort = new JTextField(this.docEndPort, "", 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldEndPort, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.createGeneralButtons(), gridBagConstraints);
        if (abstractBreakpoint != null && abstractBreakpoint instanceof InputBreakpoint) {
            InputBreakpoint inputBreakpoint = (InputBreakpoint)abstractBreakpoint;
            int n = inputBreakpoint.get8Bit() ? 2 : 4;
            this.docBegPort.setValue(inputBreakpoint.getBegPort(), n);
            int n2 = inputBreakpoint.getEndPort();
            if (n2 >= 0) {
                this.docEndPort.setValue(n2, n);
            }
        }
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.fldBegPort.setColumns(0);
        this.fldEndPort.setColumns(0);
        this.fldBegPort.addActionListener(this);
        this.fldEndPort.addActionListener(this);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.fldBegPort) {
                bl = true;
                this.fldEndPort.requestFocus();
            } else if (object == this.fldEndPort) {
                bl = true;
                this.doApprove();
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    protected void doApprove() {
        String string = "Ausgabeadresse";
        try {
            boolean bl = false;
            int n = this.docBegPort.intValue() & 0xFFFF;
            String string2 = this.fldBegPort.getText();
            if (string2 != null && string2.trim().length() < 3) {
                bl = true;
                n &= 0xFF;
            }
            int n2 = -1;
            Integer n3 = this.docEndPort.getInteger();
            if (n3 != null) {
                n2 = n3 & 0xFFFF;
                if (bl) {
                    n2 &= 0xFF;
                }
            }
            this.approveBreakpoint(new InputBreakpoint(this.debugFrm, bl, n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            this.showInvalidFmt(string);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (this.fldBegPort != null) {
            this.fldBegPort.requestFocus();
        }
    }
}

