/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.ReplyIntDlg;
import jkcemu.text.TextUtil;
import jkcemu.tools.Label;
import jkcemu.tools.ToolsUtil;
import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.AbstractBreakpointDlg;
import jkcemu.tools.debugger.BreakpointCellRenderer;
import jkcemu.tools.debugger.BreakpointListModel;
import jkcemu.tools.debugger.InputBreakpointDlg;
import jkcemu.tools.debugger.InterruptBreakpoint;
import jkcemu.tools.debugger.InterruptBreakpointDlg;
import jkcemu.tools.debugger.LabelBreakpoint;
import jkcemu.tools.debugger.LabelImportDlg;
import jkcemu.tools.debugger.LabelImportOptions;
import jkcemu.tools.debugger.MemoryBreakpointDlg;
import jkcemu.tools.debugger.OutputBreakpointDlg;
import jkcemu.tools.debugger.PCBreakpoint;
import jkcemu.tools.debugger.PCBreakpointDlg;
import jkcemu.tools.debugger.VarData;
import jkcemu.tools.debugger.VarDataDlg;
import jkcemu.tools.debugger.VarTableModel;
import z80emu.Z80Breakpoint;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;
import z80emu.Z80Memory;
import z80emu.Z80ReassInstr;
import z80emu.Z80Reassembler;
import z80emu.Z80StatusListener;

public class DebugFrm
extends BaseFrm
implements ChangeListener,
ComponentListener,
FocusListener,
ListSelectionListener,
Z80StatusListener {
    private static final String HELP_PAGE = "/help/tools/debugger.htm";
    private static final int BP_PC_IDX = 0;
    private static final int BP_MEMORY_IDX = 1;
    private static final int BP_INPUT_IDX = 2;
    private static final int BP_OUTPUT_IDX = 3;
    private static final int BP_INTERRUPT_IDX = 4;
    private static final int BP_GROUP_CNT = 5;
    private static final int TAB_IDX_CPU = 0;
    private static final int TAB_IDX_LOG = 1;
    private static final int TAB_IDX_VAR = 2;
    private static final int DEFAULT_FLD_MEM_PC_ROWS = 5;
    private static final String TEXT_STOP = "Programmausf\u00fchrung anhalten";
    private static final String TEXT_RUN = "Programm bis Haltepunkt ausf\u00fchren";
    private static final String TEXT_WALK = "Programm bis Haltepunkt langsam ausf\u00fchren";
    private static final String TEXT_STEP_OVER = "Einzelschritt \u00fcber Aufruf hinweg";
    private static final String TEXT_STEP_INTO = "Einzelschritt in Aufruf hinein";
    private static final String TEXT_STEP_TO_RET = "Bis RET ausf\u00fchren";
    private static final String TEXT_BP_REMOVE = "Markierte Halte-/Log-Punkte entfernen";
    private static final String TEXT_BP_REMOVE_ALL = "Alle Halte-/Log-Punkte entfernen";
    private static final String TEXT_BP_ENABLE_STOP = "In markierten Halte-/Log-Punkten Anhalten aktivieren";
    private static final String TEXT_BP_DISABLE_STOP = "In markierten Halte-/Log-Punkten Anhalten deaktivieren";
    private static final String TEXT_BP_ENABLE_STOP_ALL = "In allen Halte-/Log-Punkten Anhalten aktivieren";
    private static final String TEXT_BP_DISABLE_STOP_ALL = "In allen Halte-/Log-Punkten Anhalten deaktivieren";
    private static final String TEXT_BP_ENABLE_LOG = "In markierten Halte-/Log-Punkten Loggen aktivieren";
    private static final String TEXT_BP_DISABLE_LOG = "In markierten Halte-/Log-Punkten Loggen deaktivieren";
    private static final String TEXT_BP_ENABLE_LOG_ALL = "In allen Halte-/Log-Punkten Loggen aktivieren";
    private static final String TEXT_BP_DISABLE_LOG_ALL = "In allen Halte-/Log-Punkten Loggen deaktivieren";
    private static final String TEXT_VAR_ADD = "Variable hinzuf\u00fcgen...";
    private static final String TEXT_VAR_EDIT = "Variable bearbeiten...";
    private static final String TEXT_VAR_REMOVE = "Selektierte Variablen entfernen";
    private static final String TEXT_VAR_REMOVE_ALL = "Alle Variablen entfernen";
    private static final String TEXT_LOG_COPY = "Selektierte Log-Meldungen kopieren";
    private static final String TEXT_LOG_SELECT_ALL = "Alle Log-Meldungen ausw\u00e4hlen";
    private static final String TEXT_LOG_REMOVE = "Selektierte Log-Meldungen entfernen";
    private static final String TEXT_LOG_REMOVE_ALL = "Alle Log-Meldungen entfernen";
    private static final int DEFAULT_MAX_LOG_CNT = 500;
    private EmuThread emuThread;
    private Z80CPU cpu;
    private Z80Memory memory;
    private LabelImportOptions labelImportOptions;
    private Set<Integer> removedImportedBreakAddrs;
    private Set<String> removedImportedBreakNames;
    private Set<String> removedImportedVarNames;
    private int maxLogCnt;
    private int memPCClickAddr;
    private int walkMillis;
    private Timer walkTimer;
    private AbstractBreakpointDlg bpDlg;
    private BreakpointListModel[] bpModels;
    private DefaultListModel<String> listModelLog;
    private VarTableModel tableModelVar;
    private Z80InterruptSource[] interruptSources;
    private Z80InterruptSource lastSelectedIntSrc;
    private File lastBreakpointFile;
    private File lastTraceFile;
    private PrintWriter traceWriter;
    private int popupBreakGroupIdx;
    private JMenuItem mnuFileClose;
    private JMenuItem mnuFileBreakImport;
    private JMenuItem mnuFileBreakImportAgain;
    private JMenuItem mnuFileBreakRemoveImported;
    private JMenuItem mnuFileOpenTrace;
    private JMenuItem mnuDebugRun;
    private JMenuItem mnuDebugWalk100;
    private JMenuItem mnuDebugWalk300;
    private JMenuItem mnuDebugWalk500;
    private JMenuItem mnuDebugStop;
    private JMenuItem mnuDebugStepOver;
    private JMenuItem mnuDebugStepInto;
    private JMenuItem mnuDebugStepToRET;
    private JMenuItem mnuDebugBreakInterruptAdd;
    private JMenuItem mnuDebugBreakInputAdd;
    private JMenuItem mnuDebugBreakOutputAdd;
    private JMenuItem mnuDebugBreakMemoryAdd;
    private JMenuItem mnuDebugBreakPCAdd;
    private JMenuItem mnuDebugBreakEdit;
    private JMenuItem mnuDebugBreakEnableStop;
    private JMenuItem mnuDebugBreakDisableStop;
    private JMenuItem mnuDebugBreakEnableStopAll;
    private JMenuItem mnuDebugBreakDisableStopAll;
    private JMenuItem mnuDebugBreakEnableLog;
    private JMenuItem mnuDebugBreakDisableLog;
    private JMenuItem mnuDebugBreakEnableLogAll;
    private JMenuItem mnuDebugBreakDisableLogAll;
    private JMenuItem mnuDebugBreakRemove;
    private JMenuItem mnuDebugBreakRemoveAll;
    private JCheckBoxMenuItem mnuDebugTracer;
    private JMenuItem mnuVarAdd;
    private JMenuItem mnuVarEdit;
    private JMenuItem mnuVarRemove;
    private JMenuItem mnuVarRemoveAll;
    private JMenuItem mnuLogCopy;
    private JMenuItem mnuLogSelectAll;
    private JMenuItem mnuLogRemove;
    private JMenuItem mnuLogRemoveAll;
    private JMenuItem mnuLogMaxLogCnt;
    private JMenuItem mnuHelpContent;
    private JPopupMenu popupBreak;
    private JMenuItem popupBreakAdd;
    private JMenuItem popupBreakRemove;
    private JMenuItem popupBreakRemoveAll;
    private JMenuItem popupBreakEnableStop;
    private JMenuItem popupBreakDisableStop;
    private JMenuItem popupBreakEnableStopAll;
    private JMenuItem popupBreakDisableStopAll;
    private JMenuItem popupBreakEnableLog;
    private JMenuItem popupBreakDisableLog;
    private JMenuItem popupBreakEnableLogAll;
    private JMenuItem popupBreakDisableLogAll;
    private JPopupMenu popupLog;
    private JMenuItem popupLogCopy;
    private JMenuItem popupLogSelectAll;
    private JMenuItem popupLogRemove;
    private JMenuItem popupLogRemoveAll;
    private JPopupMenu popupVar;
    private JMenuItem popupVarAdd;
    private JMenuItem popupVarEdit;
    private JMenuItem popupVarRemove;
    private JMenuItem popupVarRemoveAll;
    private JPopupMenu popupWalk;
    private JMenuItem popupWalk100;
    private JMenuItem popupWalk300;
    private JMenuItem popupWalk500;
    private JPopupMenu popupMemPC;
    private JMenuItem popupMemPCCopy;
    private JMenuItem popupMemPCBreak;
    private JTabbedPane tabbedPane;
    private JButton btnRun;
    private JButton btnWalk;
    private JButton btnStop;
    private JButton btnStepOver;
    private JButton btnStepInto;
    private JButton btnStepToRET;
    private AbstractButton btnFlagSign;
    private AbstractButton btnFlagZero;
    private AbstractButton btnFlagHalf;
    private AbstractButton btnFlagPV;
    private AbstractButton btnFlagN;
    private AbstractButton btnFlagCarry;
    private AbstractButton btnIFF1;
    private AbstractButton btnIFF2;
    private JSpinner spinnerIntMode;
    private JTextField fldRegAF;
    private JTextField fldRegAsciiA;
    private JTextField fldRegBC;
    private JTextField fldRegAsciiB;
    private JTextField fldRegAsciiC;
    private JTextField fldRegDE;
    private JTextField fldRegAsciiD;
    private JTextField fldRegAsciiE;
    private JTextField fldRegHL;
    private JTextField fldRegAsciiH;
    private JTextField fldRegAsciiL;
    private JTextField fldRegIX;
    private JTextField fldRegAsciiIXH;
    private JTextField fldRegAsciiIXL;
    private JTextField fldRegIY;
    private JTextField fldRegAsciiIYH;
    private JTextField fldRegAsciiIYL;
    private JTextField fldRegPC;
    private JTextField fldRegSP;
    private JTextField fldRegAF2;
    private JTextField fldRegBC2;
    private JTextField fldRegDE2;
    private JTextField fldRegHL2;
    private JTextField fldRegI;
    private JTextField fldMemBC;
    private JTextField fldMemDE;
    private JTextField fldMemHL;
    private JTextField fldMemIX;
    private JTextField fldMemIY;
    private JTextField fldMemSP;
    private JTextArea fldMemPC;
    private JScrollPane spMemPC;
    private JTextField fldTStates;
    private JButton btnResetTStates;
    private JLabel labelIntMode;
    private JLabel labelRegI;
    private JLabel labelStatus;
    private BreakpointList[] bpLists;
    private JScrollPane[] bpScrollPanes;
    private JList<Z80InterruptSource> listIntSrc;
    private JEditorPane fldIntSrc;
    private JList<String> listLog;
    private JTable tableVar;
    private ListSelectionModel selectionModelVar;
    private JEditorPane fldEtc;
    private Timer timerForClear;

    public DebugFrm(EmuThread emuThread, Z80CPU z80CPU, Z80Memory z80Memory) {
        this.emuThread = emuThread;
        this.cpu = z80CPU;
        this.memory = z80Memory;
        this.labelImportOptions = null;
        this.removedImportedBreakAddrs = new TreeSet<Integer>();
        this.removedImportedBreakNames = new TreeSet<String>();
        this.removedImportedVarNames = new TreeSet<String>();
        this.maxLogCnt = 500;
        this.memPCClickAddr = -1;
        this.walkMillis = 0;
        this.walkTimer = new Timer(300, this);
        this.walkTimer.setRepeats(false);
        this.lastSelectedIntSrc = null;
        this.lastBreakpointFile = null;
        this.lastTraceFile = null;
        this.traceWriter = null;
        this.bpDlg = null;
        this.bpModels = new BreakpointListModel[5];
        this.bpLists = new BreakpointList[5];
        this.bpScrollPanes = new JScrollPane[5];
        this.popupBreakGroupIdx = -1;
        this.interruptSources = z80CPU.getInterruptSources();
        if (this.interruptSources != null && this.interruptSources.length == 0) {
            this.interruptSources = null;
        }
        this.setTitle("JKCEMU Debugger");
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuFileBreakImport = this.createJMenuItem("Halte-/Log-Punkte importieren...");
        jMenu.add(this.mnuFileBreakImport);
        this.mnuFileBreakImportAgain = this.createJMenuItem("Halte-/Log-Punkte erneut importieren", 114, 0);
        this.mnuFileBreakImportAgain.setEnabled(false);
        jMenu.add(this.mnuFileBreakImportAgain);
        jMenu.addSeparator();
        this.mnuFileBreakRemoveImported = this.createJMenuItem("Importierte Halte-/Log-Punkte entfernen");
        this.mnuFileBreakRemoveImported.setEnabled(false);
        jMenu.add(this.mnuFileBreakRemoveImported);
        jMenu.addSeparator();
        this.mnuFileClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuFileClose);
        JMenu jMenu2 = new JMenu("Debuggen");
        jMenu2.setMnemonic(66);
        this.mnuDebugStop = this.createJMenuItem(TEXT_STOP, 115, 0);
        jMenu2.add(this.mnuDebugStop);
        this.mnuDebugRun = this.createJMenuItem(TEXT_RUN, 116, 0);
        jMenu2.add(this.mnuDebugRun);
        JMenu jMenu3 = new JMenu(TEXT_WALK);
        jMenu2.add(jMenu3);
        this.mnuDebugWalk500 = this.createJMenuItem("sehr langsam");
        jMenu3.add(this.mnuDebugWalk500);
        this.mnuDebugWalk300 = this.createJMenuItem("langsam");
        jMenu3.add(this.mnuDebugWalk300);
        this.mnuDebugWalk100 = this.createJMenuItem("etwas schneller");
        jMenu3.add(this.mnuDebugWalk100);
        this.mnuDebugStepOver = this.createJMenuItem(TEXT_STEP_OVER, 117, 0);
        jMenu2.add(this.mnuDebugStepOver);
        this.mnuDebugStepInto = this.createJMenuItem(TEXT_STEP_INTO, 118, 0);
        jMenu2.add(this.mnuDebugStepInto);
        this.mnuDebugStepToRET = this.createJMenuItem(TEXT_STEP_TO_RET, 119, 0);
        jMenu2.add(this.mnuDebugStepToRET);
        jMenu2.addSeparator();
        this.mnuDebugBreakPCAdd = this.createJMenuItem("Halte-/Log-Punkt auf Programmadresse hinzuf\u00fcgen...", 65, 2);
        jMenu2.add(this.mnuDebugBreakPCAdd);
        this.mnuDebugBreakMemoryAdd = this.createJMenuItem("Halte-/Log-Punkt auf Speicherbereich hinzuf\u00fcgen...", 77, 2);
        jMenu2.add(this.mnuDebugBreakMemoryAdd);
        this.mnuDebugBreakInputAdd = this.createJMenuItem("Halte-/Log-Punkt auf Eingabetor hinzuf\u00fcgen...", 73, 2);
        jMenu2.add(this.mnuDebugBreakInputAdd);
        this.mnuDebugBreakOutputAdd = this.createJMenuItem("Halte-/Log-Punkt auf Ausgabetor hinzuf\u00fcgen...", 79, 2);
        jMenu2.add(this.mnuDebugBreakOutputAdd);
        this.mnuDebugBreakInterruptAdd = this.createJMenuItem("Halte-/Log-Punkt auf Interrupt-Quelle hinzuf\u00fcgen...", 81, 2);
        jMenu2.add(this.mnuDebugBreakInterruptAdd);
        this.mnuDebugBreakEdit = this.createJMenuItem("Halte-/Log-Punkt bearbeiten", 69, 2);
        jMenu2.add(this.mnuDebugBreakEdit);
        jMenu2.addSeparator();
        this.mnuDebugBreakRemove = this.createJMenuItem(TEXT_BP_REMOVE);
        jMenu2.add(this.mnuDebugBreakRemove);
        this.mnuDebugBreakRemoveAll = this.createJMenuItem(TEXT_BP_REMOVE_ALL);
        jMenu2.add(this.mnuDebugBreakRemoveAll);
        jMenu2.addSeparator();
        this.mnuDebugBreakEnableStop = this.createJMenuItem(TEXT_BP_ENABLE_STOP);
        jMenu2.add(this.mnuDebugBreakEnableStop);
        this.mnuDebugBreakDisableStop = this.createJMenuItem(TEXT_BP_DISABLE_STOP);
        jMenu2.add(this.mnuDebugBreakDisableStop);
        jMenu2.addSeparator();
        this.mnuDebugBreakEnableStopAll = this.createJMenuItem(TEXT_BP_ENABLE_STOP_ALL);
        jMenu2.add(this.mnuDebugBreakEnableStopAll);
        this.mnuDebugBreakDisableStopAll = this.createJMenuItem(TEXT_BP_DISABLE_STOP_ALL);
        jMenu2.add(this.mnuDebugBreakDisableStopAll);
        jMenu2.addSeparator();
        this.mnuDebugBreakEnableLog = this.createJMenuItem(TEXT_BP_ENABLE_LOG);
        jMenu2.add(this.mnuDebugBreakEnableLog);
        this.mnuDebugBreakDisableLog = this.createJMenuItem(TEXT_BP_DISABLE_LOG);
        jMenu2.add(this.mnuDebugBreakDisableLog);
        jMenu2.addSeparator();
        this.mnuDebugBreakEnableLogAll = this.createJMenuItem(TEXT_BP_ENABLE_LOG_ALL);
        jMenu2.add(this.mnuDebugBreakEnableLogAll);
        this.mnuDebugBreakDisableLogAll = this.createJMenuItem(TEXT_BP_DISABLE_LOG_ALL);
        jMenu2.add(this.mnuDebugBreakDisableLogAll);
        jMenu2.addSeparator();
        this.mnuDebugTracer = new JCheckBoxMenuItem("Befehle aufzeichnen");
        this.mnuDebugTracer.setSelected(false);
        this.mnuDebugTracer.addActionListener(this);
        jMenu2.add(this.mnuDebugTracer);
        JMenu jMenu4 = new JMenu("Log-Meldungen");
        jMenu4.setMnemonic(76);
        this.mnuLogCopy = this.createJMenuItem(TEXT_LOG_COPY);
        jMenu4.add(this.mnuLogCopy);
        this.mnuLogSelectAll = this.createJMenuItem(TEXT_LOG_SELECT_ALL);
        jMenu4.add(this.mnuLogSelectAll);
        jMenu4.addSeparator();
        this.mnuLogRemove = this.createJMenuItem(TEXT_LOG_REMOVE);
        jMenu4.add(this.mnuLogRemove);
        this.mnuLogRemoveAll = this.createJMenuItem(TEXT_LOG_REMOVE_ALL);
        jMenu4.add(this.mnuLogRemoveAll);
        jMenu4.addSeparator();
        this.mnuLogMaxLogCnt = this.createJMenuItem("Max. Anzahl Log-Meldungen...");
        jMenu4.add(this.mnuLogMaxLogCnt);
        JMenu jMenu5 = new JMenu("Variablen");
        jMenu5.setMnemonic(86);
        this.mnuVarAdd = this.createJMenuItem(TEXT_VAR_ADD);
        jMenu5.add(this.mnuVarAdd);
        this.mnuVarEdit = this.createJMenuItem(TEXT_VAR_EDIT);
        jMenu5.add(this.mnuVarEdit);
        jMenu5.addSeparator();
        this.mnuVarRemove = this.createJMenuItem(TEXT_VAR_REMOVE);
        jMenu5.add(this.mnuVarRemove);
        this.mnuVarRemoveAll = this.createJMenuItem(TEXT_VAR_REMOVE_ALL);
        jMenu5.add(this.mnuVarRemoveAll);
        JMenu jMenu6 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu6.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu4);
        jMenuBar.add(jMenu5);
        jMenuBar.add(jMenu6);
        this.setJMenuBar(jMenuBar);
        this.popupBreak = new JPopupMenu();
        this.popupBreakAdd = this.createJMenuItem("Halte-/Log-Punkt hinzuf\u00fcgen...");
        this.popupBreak.add(this.popupBreakAdd);
        this.popupBreakRemove = this.createJMenuItem(TEXT_BP_REMOVE);
        this.popupBreak.add(this.popupBreakRemove);
        this.popupBreakRemoveAll = this.createJMenuItem(TEXT_BP_REMOVE_ALL);
        this.popupBreak.add(this.popupBreakRemoveAll);
        this.popupBreak.addSeparator();
        this.popupBreakEnableStop = this.createJMenuItem(TEXT_BP_ENABLE_STOP);
        this.popupBreak.add(this.popupBreakEnableStop);
        this.popupBreakDisableStop = this.createJMenuItem(TEXT_BP_DISABLE_STOP);
        this.popupBreak.add(this.popupBreakDisableStop);
        this.popupBreak.addSeparator();
        this.popupBreakEnableStopAll = this.createJMenuItem(TEXT_BP_ENABLE_STOP_ALL);
        this.popupBreak.add(this.popupBreakEnableStopAll);
        this.popupBreakDisableStopAll = this.createJMenuItem(TEXT_BP_DISABLE_STOP_ALL);
        this.popupBreak.add(this.popupBreakDisableStopAll);
        this.popupBreak.addSeparator();
        this.popupBreakEnableLog = this.createJMenuItem(TEXT_BP_ENABLE_LOG);
        this.popupBreak.add(this.popupBreakEnableLog);
        this.popupBreakDisableLog = this.createJMenuItem(TEXT_BP_DISABLE_LOG);
        this.popupBreak.add(this.popupBreakDisableLog);
        this.popupBreak.addSeparator();
        this.popupBreakEnableLogAll = this.createJMenuItem(TEXT_BP_ENABLE_LOG_ALL);
        this.popupBreak.add(this.popupBreakEnableLogAll);
        this.popupBreakDisableLogAll = this.createJMenuItem(TEXT_BP_DISABLE_LOG_ALL);
        this.popupBreak.add(this.popupBreakDisableLogAll);
        this.popupLog = new JPopupMenu();
        this.popupLogCopy = this.createJMenuItem(TEXT_LOG_COPY);
        this.popupLog.add(this.popupLogCopy);
        this.popupLogSelectAll = this.createJMenuItem(TEXT_LOG_SELECT_ALL);
        this.popupLog.add(this.popupLogSelectAll);
        this.popupLog.addSeparator();
        this.popupLogRemove = this.createJMenuItem(TEXT_LOG_REMOVE);
        this.popupLog.add(this.popupLogRemove);
        this.popupLogRemoveAll = this.createJMenuItem(TEXT_LOG_REMOVE_ALL);
        this.popupLog.add(this.popupLogRemoveAll);
        this.popupVar = new JPopupMenu();
        this.popupVarAdd = this.createJMenuItem(TEXT_VAR_ADD);
        this.popupVar.add(this.popupVarAdd);
        this.popupVarEdit = this.createJMenuItem(TEXT_VAR_EDIT);
        this.popupVar.add(this.popupVarEdit);
        this.popupVar.addSeparator();
        this.popupVarRemove = this.createJMenuItem(TEXT_VAR_REMOVE);
        this.popupVar.add(this.popupVarRemove);
        this.popupVarRemoveAll = this.createJMenuItem(TEXT_VAR_REMOVE_ALL);
        this.popupVar.add(this.popupVarRemoveAll);
        this.popupWalk = new JPopupMenu();
        this.popupWalk500 = this.createJMenuItem("Programm sehr langsam ausf\u00fchren");
        this.popupWalk.add(this.popupWalk500);
        this.popupWalk300 = this.createJMenuItem("Programm langsam ausf\u00fchren");
        this.popupWalk.add(this.popupWalk300);
        this.popupWalk100 = this.createJMenuItem("Programm etwas schneller ausf\u00fchren");
        this.popupWalk.add(this.popupWalk100);
        this.popupMemPC = new JPopupMenu();
        this.popupMemPCCopy = this.createJMenuItem("Kopieren");
        this.popupMemPC.add(this.popupMemPCCopy);
        this.popupMemPC.addSeparator();
        this.popupMemPCBreak = this.createJMenuItem("Halte-/Log-Punkt anlegen");
        this.popupMemPC.add(this.popupMemPCBreak);
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        this.add((Component)jToolBar, "North");
        this.btnStop = this.createImageButton("/images/debug/stop.png", TEXT_STOP);
        jToolBar.add(this.btnStop);
        this.btnRun = this.createImageButton("/images/debug/run.png", TEXT_RUN);
        jToolBar.add(this.btnRun);
        this.btnWalk = this.createImageButton("/images/debug/walk.png", TEXT_WALK);
        jToolBar.add(this.btnWalk);
        this.btnStepOver = this.createImageButton("/images/debug/step_over.png", TEXT_STEP_OVER);
        jToolBar.add(this.btnStepOver);
        this.btnStepInto = this.createImageButton("/images/debug/step_into.png", TEXT_STEP_INTO);
        jToolBar.add(this.btnStepInto);
        this.btnStepToRET = this.createImageButton("/images/debug/step_up.png", TEXT_STEP_TO_RET);
        jToolBar.add(this.btnStepToRET);
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("CPU", jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Flags"));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
        this.btnFlagSign = this.createFlagField("S");
        jPanel2.add((Component)this.btnFlagSign, gridBagConstraints2);
        this.btnFlagZero = this.createFlagField("Z");
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.btnFlagZero, gridBagConstraints2);
        this.btnFlagHalf = this.createFlagField("H");
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.btnFlagHalf, gridBagConstraints2);
        this.btnFlagPV = this.createFlagField("PV");
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.btnFlagPV, gridBagConstraints2);
        this.btnFlagN = this.createFlagField("N");
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.btnFlagN, gridBagConstraints2);
        this.btnFlagCarry = this.createFlagField("C");
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.btnFlagCarry, gridBagConstraints2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Interrupt"));
        ++gridBagConstraints.gridx;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
        this.labelIntMode = new JLabel("IM:");
        jPanel3.add((Component)this.labelIntMode, gridBagConstraints3);
        this.spinnerIntMode = new JSpinner(new SpinnerNumberModel(0, 0, 2, 1));
        gridBagConstraints3.insets.left = 0;
        ++gridBagConstraints3.gridx;
        jPanel3.add((Component)this.spinnerIntMode, gridBagConstraints3);
        this.labelRegI = new JLabel("IR:");
        gridBagConstraints3.insets.left = 5;
        ++gridBagConstraints3.gridx;
        jPanel3.add((Component)this.labelRegI, gridBagConstraints3);
        this.fldRegI = new JTextField(3);
        this.fldRegI.addActionListener(this);
        this.fldRegI.addFocusListener(this);
        this.fldRegI.setEditable(false);
        gridBagConstraints3.insets.left = 0;
        ++gridBagConstraints3.gridx;
        jPanel3.add((Component)this.fldRegI, gridBagConstraints3);
        this.btnIFF1 = this.createFlagField("IFF1");
        gridBagConstraints3.insets.left = 5;
        ++gridBagConstraints3.gridx;
        jPanel3.add((Component)this.btnIFF1, gridBagConstraints3);
        this.btnIFF2 = this.createFlagField("IFF2");
        ++gridBagConstraints3.gridx;
        jPanel3.add((Component)this.btnIFF2, gridBagConstraints3);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Register"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0);
        jPanel4.add((Component)new JLabel("Hex"), gridBagConstraints4);
        gridBagConstraints4.gridwidth = 2;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)new JLabel("ASCII"), gridBagConstraints4);
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx += 2;
        jPanel4.add((Component)new JLabel("Zeigt im Speicher auf"), gridBagConstraints4);
        gridBagConstraints4.gridx += 2;
        jPanel4.add((Component)new JLabel("Hex"), gridBagConstraints4);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("AF:"), gridBagConstraints4);
        this.fldRegAF = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAF, gridBagConstraints4);
        this.fldRegAsciiA = new JTextField(2);
        this.fldRegAsciiA.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiA, gridBagConstraints4);
        gridBagConstraints4.gridx += 3;
        jPanel4.add((Component)new JLabel("AF':"), gridBagConstraints4);
        this.fldRegAF2 = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAF2, gridBagConstraints4);
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("BC:"), gridBagConstraints4);
        this.fldRegBC = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegBC, gridBagConstraints4);
        this.fldRegAsciiB = new JTextField(2);
        this.fldRegAsciiB.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiB, gridBagConstraints4);
        this.fldRegAsciiC = new JTextField(2);
        this.fldRegAsciiC.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiC, gridBagConstraints4);
        this.fldMemBC = new JTextField();
        this.fldMemBC.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldMemBC, gridBagConstraints4);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)new JLabel("BC':"), gridBagConstraints4);
        this.fldRegBC2 = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegBC2, gridBagConstraints4);
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("DE:"), gridBagConstraints4);
        this.fldRegDE = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegDE, gridBagConstraints4);
        this.fldRegAsciiD = new JTextField(2);
        this.fldRegAsciiD.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiD, gridBagConstraints4);
        this.fldRegAsciiE = new JTextField(2);
        this.fldRegAsciiE.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiE, gridBagConstraints4);
        this.fldMemDE = new JTextField();
        this.fldMemDE.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldMemDE, gridBagConstraints4);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)new JLabel("DE':"), gridBagConstraints4);
        this.fldRegDE2 = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegDE2, gridBagConstraints4);
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("HL:"), gridBagConstraints4);
        this.fldRegHL = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegHL, gridBagConstraints4);
        this.fldRegAsciiH = new JTextField(2);
        this.fldRegAsciiH.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiH, gridBagConstraints4);
        this.fldRegAsciiL = new JTextField(2);
        this.fldRegAsciiL.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiL, gridBagConstraints4);
        this.fldMemHL = new JTextField();
        this.fldMemHL.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldMemHL, gridBagConstraints4);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)new JLabel("HL':"), gridBagConstraints4);
        this.fldRegHL2 = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegHL2, gridBagConstraints4);
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("IX:"), gridBagConstraints4);
        this.fldRegIX = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegIX, gridBagConstraints4);
        this.fldRegAsciiIXH = new JTextField(2);
        this.fldRegAsciiIXH.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiIXH, gridBagConstraints4);
        this.fldRegAsciiIXL = new JTextField(2);
        this.fldRegAsciiIXL.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiIXL, gridBagConstraints4);
        this.fldMemIX = new JTextField();
        this.fldMemIX.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldMemIX, gridBagConstraints4);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("IY:"), gridBagConstraints4);
        this.fldRegIY = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegIY, gridBagConstraints4);
        this.fldRegAsciiIYH = new JTextField(2);
        this.fldRegAsciiIYH.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiIYH, gridBagConstraints4);
        this.fldRegAsciiIYL = new JTextField(2);
        this.fldRegAsciiIYL.setEditable(false);
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegAsciiIYL, gridBagConstraints4);
        this.fldMemIY = new JTextField();
        this.fldMemIY.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldMemIY, gridBagConstraints4);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("SP:"), gridBagConstraints4);
        this.fldRegSP = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegSP, gridBagConstraints4);
        this.fldMemSP = new JTextField();
        this.fldMemSP.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.gridx += 3;
        jPanel4.add((Component)this.fldMemSP, gridBagConstraints4);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("PC:"), gridBagConstraints4);
        this.fldRegPC = this.createHexField();
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldRegPC, gridBagConstraints4);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.gridx = 4;
        jPanel4.add((Component)jPanel5, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel5.add((Component)new JLabel("Taktzyklen:"), gridBagConstraints5);
        this.fldTStates = new JTextField();
        this.fldTStates.setEditable(false);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.insets.left = 5;
        ++gridBagConstraints5.gridx;
        jPanel5.add((Component)this.fldTStates, gridBagConstraints5);
        this.btnResetTStates = new JButton("Zur\u00fccksetzen");
        this.btnResetTStates.addActionListener(this);
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.weightx = 0.0;
        ++gridBagConstraints5.gridx;
        jPanel5.add((Component)this.btnResetTStates, gridBagConstraints5);
        this.fldMemPC = new JTextArea(5, 38);
        this.fldMemPC.setEditable(false);
        this.fldMemPC.setPreferredSize(new Dimension(1, 1));
        this.fldMemPC.addMouseListener(this);
        this.spMemPC = new JScrollPane(this.fldMemPC);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.gridx = 1;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)this.spMemPC, gridBagConstraints4);
        Font font = this.fldMemPC.getFont();
        font = font != null ? new Font("Monospaced", font.getStyle(), font.getSize()) : new Font("Monospaced", 0, 12);
        this.fldMemPC.setFont(font);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder("Halte-/Log-Punkte auf..."));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints(0, 0, 1, 2, 0.33, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0);
        JPanel jPanel7 = new JPanel(new BorderLayout(0, 0));
        jPanel7.setBorder(BorderFactory.createTitledBorder("Programmadresse"));
        jPanel6.add((Component)jPanel7, gridBagConstraints6);
        this.createBreakpointFields(jPanel7, 0);
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 0));
        jPanel8.setBorder(BorderFactory.createTitledBorder("Speicher"));
        ++gridBagConstraints6.gridx;
        jPanel6.add((Component)jPanel8, gridBagConstraints6);
        this.createBreakpointFields(jPanel8, 1);
        JPanel jPanel9 = new JPanel(new BorderLayout(0, 0));
        jPanel9.setBorder(BorderFactory.createTitledBorder("Eingabetor"));
        gridBagConstraints6.weighty = 0.5;
        gridBagConstraints6.gridheight = 1;
        ++gridBagConstraints6.gridx;
        jPanel6.add((Component)jPanel9, gridBagConstraints6);
        this.createBreakpointFields(jPanel9, 2);
        JPanel jPanel10 = new JPanel(new BorderLayout(0, 0));
        jPanel10.setBorder(BorderFactory.createTitledBorder("Ausgabetor"));
        ++gridBagConstraints6.gridy;
        jPanel6.add((Component)jPanel10, gridBagConstraints6);
        this.createBreakpointFields(jPanel10, 3);
        JPanel jPanel11 = new JPanel(new BorderLayout(0, 0));
        jPanel11.setBorder(BorderFactory.createTitledBorder("Interrupt-Quelle"));
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 0.0;
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.gridx = 0;
        ++gridBagConstraints6.gridy;
        jPanel6.add((Component)jPanel11, gridBagConstraints6);
        this.createBreakpointFields(jPanel11, 4);
        this.listModelLog = new DefaultListModel();
        this.listLog = new JList<String>(this.listModelLog);
        this.listLog.setDragEnabled(false);
        this.listLog.setLayoutOrientation(0);
        this.listLog.setSelectionMode(2);
        this.listLog.addListSelectionListener(this);
        this.listLog.addKeyListener(this);
        this.listLog.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.listLog);
        jScrollPane.addMouseListener(this);
        this.tabbedPane.addTab("Log-Meldungen", jScrollPane);
        this.tableModelVar = new VarTableModel();
        this.tableVar = new JTable(this.tableModelVar);
        this.tableVar.setAutoCreateRowSorter(true);
        this.tableVar.setAutoResizeMode(0);
        this.tableVar.setColumnSelectionAllowed(false);
        this.tableVar.setRowSelectionAllowed(true);
        this.tableVar.setDragEnabled(false);
        this.tableVar.setFillsViewportHeight(true);
        this.tableVar.setPreferredScrollableViewportSize(new Dimension(1, 1));
        this.tableVar.setShowGrid(false);
        this.tableVar.setSelectionMode(2);
        this.selectionModelVar = this.tableVar.getSelectionModel();
        if (this.selectionModelVar != null) {
            this.selectionModelVar.addListSelectionListener(this);
            this.updVarActionsEnabled();
        }
        EmuUtil.setTableColWidths(this.tableVar, 120, 90, 90, 200, 200);
        this.tableVar.addKeyListener(this);
        this.tableVar.addMouseListener(this);
        this.tabbedPane.addTab("Variablen", new JScrollPane(this.tableVar));
        JPanel jPanel12 = new JPanel(new BorderLayout(5, 5));
        this.tabbedPane.addTab("Interrupt-Quellen", jPanel12);
        this.listIntSrc = new JList();
        this.listIntSrc.setDragEnabled(false);
        this.listIntSrc.setLayoutOrientation(0);
        this.listIntSrc.setSelectionMode(2);
        this.listIntSrc.setVisibleRowCount(4);
        if (this.interruptSources != null) {
            this.listIntSrc.setListData((Z80InterruptSource[])this.interruptSources);
        }
        this.listIntSrc.addListSelectionListener(this);
        jPanel12.add((Component)new JScrollPane(this.listIntSrc), "North");
        this.fldIntSrc = new JEditorPane();
        this.fldIntSrc.setEditable(false);
        jPanel12.add((Component)new JScrollPane(this.fldIntSrc), "Center");
        this.fldEtc = new JEditorPane(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(1, 1);
            }
        };
        this.fldEtc.setEditable(false);
        this.tabbedPane.addTab("Sonstiges", new JScrollPane(this.fldEtc));
        JPanel jPanel13 = new JPanel(new FlowLayout(0, 5, 5));
        this.add((Component)jPanel13, "South");
        this.labelStatus = new JLabel("Bereit");
        jPanel13.add(this.labelStatus);
        this.tabbedPane.addChangeListener(this);
        this.timerForClear = new Timer(300, this);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
        this.fldMemPC.setRows(0);
        this.fldMemPC.setColumns(0);
        this.cpu.addStatusListener(this);
        this.updDebuggerInternal(null, null);
        for (int i = 0; i < 5; ++i) {
            this.updBreakpointList(i, null);
        }
        this.updBreakpointActionsEnabled();
        this.updLogActionsEnabled();
        this.addComponentListener(this);
    }

    public void appendLogEntry(Z80InterruptSource z80InterruptSource) {
        if (z80InterruptSource != null) {
            this.fireAppendLogEntry("--- Interrupt: " + z80InterruptSource.toString() + " ---");
        }
        StringWriter stringWriter = new StringWriter(128);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.write("T:");
        printWriter.write(String.valueOf(this.cpu.getProcessedTStates()));
        printWriter.write("   ");
        this.cpu.writeDebugStatusEntry(printWriter);
        printWriter.close();
        this.fireAppendLogEntry(stringWriter.toString());
    }

    public void doDebugBreakPCAdd(int n) {
        if (this.bpDlg == null) {
            this.bpDlg = new PCBreakpointDlg(this, null, n);
            this.bpDlg.setVisible(true);
            AbstractBreakpoint abstractBreakpoint = this.bpDlg.getApprovedBreakpoint();
            if (abstractBreakpoint != null) {
                this.addBreakpoint(0, abstractBreakpoint);
            }
            this.bpDlg = null;
        }
    }

    public VarData getVarByName(String string) {
        VarData varData = null;
        int n = this.tableModelVar.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2;
            VarData varData2 = this.tableModelVar.getRow(i);
            if (varData2 == null || (string2 = varData2.getName()) == null || !string2.equalsIgnoreCase(string)) continue;
            varData = varData2;
            break;
        }
        return varData;
    }

    public Z80CPU getZ80CPU() {
        return this.cpu;
    }

    public Z80Memory getZ80Memory() {
        return this.memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importLabels(Component component, LabelImportOptions labelImportOptions) {
        boolean bl = false;
        Reader reader = null;
        String string = null;
        try {
            switch (labelImportOptions.getLabelSource()) {
                case CLIPBOARD: {
                    String string2 = EmuUtil.getClipboardText(this);
                    if (string2 == null) break;
                    reader = new StringReader(string2);
                    string = " der Zwischenablage";
                    break;
                }
                case FILE: {
                    File file = labelImportOptions.getFile();
                    if (file == null) {
                        throw new IOException("Datei nicht angegeben");
                    }
                    reader = new FileReader(file);
                    string = " der Datei";
                }
            }
            if (reader != null) {
                try {
                    bl = this.importLabels(ToolsUtil.readLabels(reader), labelImportOptions.getSuppressRecreateRemovedLabels(), labelImportOptions.getRemoveObsoleteLabels(), labelImportOptions.getCaseSensitive());
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(reader);
                    throw throwable;
                }
                EmuUtil.closeSilent(reader);
            }
            if (bl) {
                this.labelImportOptions = labelImportOptions;
                this.mnuFileBreakImportAgain.setEnabled(true);
            } else if (reader != null) {
                BaseDlg.showErrorDlg((Component)this, "Der Inhalt" + string + " konnte nicht als Liste\n" + "mit Halte-/Log-Punkten interpretiert werden.");
            }
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
        return bl;
    }

    public void selectVar(VarData varData) {
        int n;
        int n2;
        if (varData != null && (n2 = this.tableModelVar.indexOf(varData)) >= 0 && (n = this.tableVar.convertRowIndexToView(n2)) >= 0) {
            JTable jTable = this.tableVar;
            EmuUtil.fireSelectRow(jTable, n);
        }
    }

    public void setLabels(Label[] labelArray, boolean bl, boolean bl2) {
        this.importLabels(labelArray, bl, true, bl2);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabbedPane) {
            this.updBreakpointActionsEnabled();
            this.updLogActionsEnabled();
            this.updVarActionsEnabled();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this && this.cpu.isPause()) {
            this.updFieldsPC();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component != null) {
            this.fieldValueChanged(component);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.listIntSrc) {
            this.updIntSrcInfoField();
        } else if (object == this.listLog) {
            this.updLogActionsEnabled();
        } else if (object == this.selectionModelVar) {
            this.updVarActionsEnabled();
        } else {
            int n;
            JList jList = null;
            for (n = 0; n < 5; ++n) {
                if (object != this.bpLists[n] && object != this.bpScrollPanes[n]) continue;
                jList = this.bpLists[n];
                break;
            }
            if (jList != null) {
                if (jList.getSelectedIndex() >= 0) {
                    for (n = 0; n < this.bpLists.length; ++n) {
                        if (jList == this.bpLists[n]) continue;
                        this.bpLists[n].clearSelection();
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DebugFrm.this.updBreakpointActionsEnabled();
                    }
                });
            }
        }
    }

    @Override
    public void z80StatusChanged(Z80Breakpoint z80Breakpoint, Z80InterruptSource z80InterruptSource) {
        this.fireUpdDebugger(z80Breakpoint, z80InterruptSource);
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        if (properties != null) {
            this.setMaxLogCnt(properties.getProperty(this.getSettingsPrefix() + "max_log_count"));
        }
        this.updIntSrcFields();
        this.updEtcField();
        return super.applySettings(properties, bl);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object;
            Component component = this.getFocusOwner();
            if (component != null && !(component instanceof JTextComponent)) {
                this.fieldValueChanged(component);
            }
            if ((object = eventObject.getSource()) == this.mnuFileBreakImport) {
                bl = true;
                this.doBreakpointImport(true);
            } else if (object == this.mnuFileBreakImport) {
                bl = true;
                this.doBreakpointImport(false);
            } else if (object == this.mnuFileBreakRemoveImported) {
                bl = true;
                this.doBreakpointRemoveImported();
            } else if (object == this.mnuFileClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuDebugRun || object == this.btnRun) {
                bl = true;
                this.doDebugRun();
            } else if (object == this.btnWalk) {
                bl = true;
                this.popupWalk.show(this.btnWalk, 0, this.btnWalk.getHeight());
            } else if (object == this.mnuDebugWalk100 || object == this.popupWalk100) {
                bl = true;
                this.doDebugWalk(100);
            } else if (object == this.mnuDebugWalk300 || object == this.popupWalk300) {
                bl = true;
                this.doDebugWalk(300);
            } else if (object == this.mnuDebugWalk500 || object == this.popupWalk500) {
                bl = true;
                this.doDebugWalk(500);
            } else if (object == this.mnuDebugStop || object == this.btnStop) {
                bl = true;
                this.doDebugStop();
            } else if (object == this.mnuDebugStepOver || object == this.btnStepOver) {
                bl = true;
                this.doDebugStepOver();
            } else if (object == this.mnuDebugStepInto || object == this.btnStepInto) {
                bl = true;
                this.doDebugStepInto();
            } else if (object == this.mnuDebugStepToRET || object == this.btnStepToRET) {
                bl = true;
                this.doDebugStepToRET();
            } else if (object == this.mnuDebugBreakInputAdd) {
                bl = true;
                this.doDebugBreakInputAdd();
            } else if (object == this.mnuDebugBreakInterruptAdd) {
                bl = true;
                this.doDebugBreakInterruptAdd();
            } else if (object == this.mnuDebugBreakMemoryAdd) {
                bl = true;
                this.doDebugBreakMemoryAdd();
            } else if (object == this.mnuDebugBreakOutputAdd) {
                bl = true;
                this.doDebugBreakOutputAdd();
            } else if (object == this.mnuDebugBreakPCAdd) {
                bl = true;
                this.doDebugBreakPCAdd(-1);
            } else if (object == this.mnuDebugBreakEdit) {
                bl = true;
                this.doDebugBreakEdit();
            } else if (object == this.mnuDebugBreakRemove) {
                bl = true;
                this.doDebugBreakRemove();
            } else if (object == this.mnuDebugBreakRemoveAll) {
                bl = true;
                this.doDebugBreakRemoveAll();
            } else if (object == this.mnuDebugBreakEnableStop) {
                bl = true;
                this.doDebugBreakSetStopEnabled(true);
            } else if (object == this.mnuDebugBreakDisableStop) {
                bl = true;
                this.doDebugBreakSetStopEnabled(false);
            } else if (object == this.mnuDebugBreakEnableStopAll) {
                bl = true;
                this.doDebugBreakSetAllStopEnabled(true);
            } else if (object == this.mnuDebugBreakDisableStopAll) {
                bl = true;
                this.doDebugBreakSetAllStopEnabled(false);
            } else if (object == this.mnuDebugBreakEnableLog) {
                bl = true;
                this.doDebugBreakSetLogEnabled(true);
            } else if (object == this.mnuDebugBreakDisableLog) {
                bl = true;
                this.doDebugBreakSetLogEnabled(false);
            } else if (object == this.mnuDebugBreakEnableLogAll) {
                bl = true;
                this.doDebugBreakSetAllLogEnabled(true);
            } else if (object == this.mnuDebugBreakDisableLogAll) {
                bl = true;
                this.doDebugBreakSetAllLogEnabled(false);
            } else if (object == this.mnuDebugTracer) {
                bl = true;
                this.doDebugTracer();
            } else if (object == this.mnuVarAdd || object == this.popupVarAdd) {
                bl = true;
                this.doVarAdd();
            } else if (object == this.mnuVarEdit || object == this.popupVarEdit || object == this.tableVar) {
                bl = true;
                this.doVarEdit();
            } else if (object == this.mnuVarRemove || object == this.popupVarRemove) {
                bl = true;
                this.doVarRemove();
            } else if (object == this.mnuVarRemoveAll || object == this.popupVarRemoveAll) {
                bl = true;
                this.doVarRemoveAll();
            } else if (object == this.mnuLogCopy || object == this.popupLogCopy) {
                bl = true;
                this.doLogCopy();
            } else if (object == this.mnuLogSelectAll || object == this.popupLogSelectAll) {
                bl = true;
                this.doLogSelectAll();
            } else if (object == this.mnuLogRemove || object == this.popupLogRemove) {
                bl = true;
                this.doLogRemove();
            } else if (object == this.mnuLogRemoveAll || object == this.popupLogRemoveAll) {
                bl = true;
                this.doLogRemoveAll();
            } else if (object == this.mnuLogMaxLogCnt) {
                bl = true;
                this.doLogMaxLogCnt();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else if (object == this.popupBreakAdd) {
                bl = true;
                this.doDebugBreakAdd(this.popupBreakGroupIdx);
            } else if (object == this.popupBreakRemove) {
                bl = true;
                this.doDebugBreakRemove(this.popupBreakGroupIdx);
            } else if (object == this.popupBreakRemoveAll) {
                bl = true;
                this.doDebugBreakRemoveAll(this.popupBreakGroupIdx);
            } else if (object == this.popupBreakEnableStop) {
                bl = true;
                this.doDebugBreakSetStopEnabled(this.popupBreakGroupIdx, true);
            } else if (object == this.popupBreakDisableStop) {
                bl = true;
                this.doDebugBreakSetStopEnabled(this.popupBreakGroupIdx, false);
            } else if (object == this.popupBreakEnableStopAll) {
                bl = true;
                this.doDebugBreakSetAllStopEnabled(this.popupBreakGroupIdx, true);
            } else if (object == this.popupBreakDisableStopAll) {
                bl = true;
                this.doDebugBreakSetAllStopEnabled(this.popupBreakGroupIdx, false);
            } else if (object == this.popupBreakEnableLog) {
                bl = true;
                this.doDebugBreakSetLogEnabled(this.popupBreakGroupIdx, true);
            } else if (object == this.popupBreakDisableLog) {
                bl = true;
                this.doDebugBreakSetLogEnabled(this.popupBreakGroupIdx, false);
            } else if (object == this.popupBreakEnableLogAll) {
                bl = true;
                this.doDebugBreakSetAllLogEnabled(this.popupBreakGroupIdx, true);
            } else if (object == this.popupBreakDisableLogAll) {
                bl = true;
                this.doDebugBreakSetAllLogEnabled(this.popupBreakGroupIdx, false);
            } else if (object == this.btnFlagSign) {
                bl = true;
                if (this.btnFlagSign.isEnabled()) {
                    this.cpu.setFlagSign(this.btnFlagSign.isSelected());
                }
                this.updFieldsAF();
            } else if (object == this.btnFlagZero) {
                bl = true;
                if (this.btnFlagZero.isEnabled()) {
                    this.cpu.setFlagZero(this.btnFlagZero.isSelected());
                }
                this.updFieldsAF();
            } else if (object == this.btnFlagHalf) {
                bl = true;
                if (this.btnFlagHalf.isEnabled()) {
                    this.cpu.setFlagHalf(this.btnFlagHalf.isSelected());
                }
                this.updFieldsAF();
            } else if (object == this.btnFlagPV) {
                bl = true;
                if (this.btnFlagPV.isEnabled()) {
                    this.cpu.setFlagPV(this.btnFlagPV.isSelected());
                }
                this.updFieldsAF();
            } else if (object == this.btnFlagN) {
                bl = true;
                if (this.btnFlagN.isEnabled()) {
                    this.cpu.setFlagN(this.btnFlagN.isSelected());
                }
                this.updFieldsAF();
            } else if (object == this.btnFlagCarry) {
                bl = true;
                if (this.btnFlagCarry.isEnabled()) {
                    this.cpu.setFlagCarry(this.btnFlagCarry.isSelected());
                }
                this.updFieldsAF();
            } else if (object == this.btnIFF1) {
                bl = true;
                if (this.btnIFF1.isEnabled()) {
                    this.cpu.setIFF1(this.btnIFF1.isSelected());
                }
            } else if (object == this.btnIFF2) {
                bl = true;
                if (this.btnIFF2.isEnabled()) {
                    this.cpu.setIFF2(this.btnIFF2.isSelected());
                }
            } else if (object == this.btnResetTStates) {
                bl = true;
                this.cpu.resetSpeed();
                this.updFieldsTStates();
            } else if (object == this.popupMemPCCopy) {
                bl = true;
                this.fldMemPC.copy();
            } else if (object == this.popupMemPCBreak) {
                bl = true;
                if (this.memPCClickAddr >= 0) {
                    this.doDebugBreakPCAdd(this.memPCClickAddr);
                }
            } else if (object == this.timerForClear) {
                bl = true;
                this.clear();
            } else if (object == this.walkTimer) {
                bl = true;
                this.doWalkTimer();
            } else if (object == this.spinnerIntMode || object == this.fldRegAF || object == this.fldRegAF2 || object == this.fldRegBC || object == this.fldRegBC2 || object == this.fldRegDE || object == this.fldRegDE2 || object == this.fldRegHL || object == this.fldRegHL2 || object == this.fldRegIX || object == this.fldRegIY || object == this.fldRegSP || object == this.fldRegPC || object == this.fldRegI) {
                bl = true;
                this.fieldValueChanged(object);
            } else if (object instanceof BreakpointList) {
                if (object == this.bpLists[0]) {
                    bl = true;
                    this.editBreakpoint(0);
                } else if (object == this.bpLists[1]) {
                    bl = true;
                    this.editBreakpoint(1);
                } else if (object == this.bpLists[2]) {
                    bl = true;
                    this.editBreakpoint(2);
                } else if (object == this.bpLists[3]) {
                    bl = true;
                    this.editBreakpoint(3);
                } else if (object == this.bpLists[4]) {
                    bl = true;
                    this.editBreakpoint(4);
                }
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        this.closeTrace();
        this.cpu.setDebugEnabled(false);
        return super.doClose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getKeyCode() == 127) {
            switch (this.tabbedPane.getSelectedIndex()) {
                case 0: {
                    this.doDebugBreakRemove();
                    bl = true;
                    break;
                }
                case 1: {
                    this.doLogRemove();
                    bl = true;
                    break;
                }
                case 2: {
                    this.doVarRemove();
                    bl = true;
                }
            }
        }
        if (bl) {
            keyEvent.consume();
        } else {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void lookAndFeelChanged() {
        if (this.popupBreak != null) {
            SwingUtilities.updateComponentTreeUI(this.popupBreak);
        }
    }

    @Override
    public void putSettingsTo(Properties properties) {
        super.putSettingsTo(properties);
        if (properties != null) {
            properties.setProperty(this.getSettingsPrefix() + "max_log_count", String.valueOf(this.maxLogCnt));
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.cpu.setDebugEnabled(bl);
            this.fireUpdDebugger(null, null);
        }
        super.setVisible(bl);
    }

    @Override
    protected boolean showPopup(MouseEvent mouseEvent) {
        Component component;
        boolean bl = false;
        if (mouseEvent != null && (component = mouseEvent.getComponent()) != null) {
            if (component == this.fldMemPC) {
                this.memPCClickAddr = ToolsUtil.getReassAddr(this.fldMemPC, mouseEvent.getPoint());
                this.popupMemPCCopy.setEnabled(this.fldMemPC.getSelectionStart() != this.fldMemPC.getSelectionEnd());
                this.popupMemPCBreak.setEnabled(this.memPCClickAddr >= 0);
                this.popupMemPC.show(component, mouseEvent.getX(), mouseEvent.getY());
                bl = true;
            } else {
                int n = this.tabbedPane.getSelectedIndex();
                if (n == 0) {
                    int n2 = -1;
                    for (int i = 0; i < 5; ++i) {
                        if (component != this.bpLists[i] && component != this.bpScrollPanes[i]) continue;
                        n2 = i;
                        break;
                    }
                    if (n2 >= 0 && n2 < 5) {
                        int[] nArray;
                        BreakpointListModel breakpointListModel = this.bpModels[n2];
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (breakpointListModel != null) {
                            for (AbstractBreakpoint abstractBreakpoint : breakpointListModel) {
                                if (abstractBreakpoint.isStopEnabled()) {
                                    bl2 = true;
                                } else {
                                    bl3 = true;
                                }
                                if (abstractBreakpoint.isLogEnabled()) {
                                    bl4 = true;
                                } else {
                                    bl5 = true;
                                }
                                if (!bl2 || !bl3 || !bl4 || !bl5) continue;
                                break;
                            }
                            this.popupBreakRemoveAll.setEnabled(!breakpointListModel.isEmpty());
                        } else {
                            this.popupBreakRemoveAll.setEnabled(false);
                        }
                        this.popupBreakEnableStopAll.setEnabled(bl3);
                        this.popupBreakDisableStopAll.setEnabled(bl2);
                        this.popupBreakEnableLogAll.setEnabled(bl5);
                        this.popupBreakDisableLogAll.setEnabled(bl4);
                        boolean bl6 = false;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        if (breakpointListModel != null && (nArray = this.bpLists[n2].getSelectedIndices()) != null) {
                            for (int i = 0; i < nArray.length; ++i) {
                                int n3 = nArray[i];
                                if (n3 >= 0 && n3 < breakpointListModel.size()) {
                                    bl6 = true;
                                    if (((AbstractBreakpoint)breakpointListModel.get(n3)).isStopEnabled()) {
                                        bl7 = true;
                                    } else {
                                        bl8 = true;
                                    }
                                    if (((AbstractBreakpoint)breakpointListModel.get(n3)).isLogEnabled()) {
                                        bl9 = true;
                                    } else {
                                        bl10 = true;
                                    }
                                }
                                if (bl7 && bl8 && bl9 && bl10) break;
                            }
                        }
                        this.popupBreakRemove.setEnabled(bl6);
                        this.popupBreakEnableStop.setEnabled(bl8);
                        this.popupBreakDisableStop.setEnabled(bl7);
                        this.popupBreakEnableLog.setEnabled(bl10);
                        this.popupBreakDisableLog.setEnabled(bl9);
                        this.popupBreakGroupIdx = n2;
                        this.popupBreak.show(component, mouseEvent.getX(), mouseEvent.getY());
                        bl = true;
                    }
                } else if (n == 2) {
                    boolean bl11 = !this.tableModelVar.isEmpty();
                    int n4 = this.tableVar.getSelectedRowCount();
                    this.popupVarEdit.setEnabled(n4 == 1);
                    this.popupVarRemove.setEnabled(n4 > 0);
                    this.popupVarRemoveAll.setEnabled(bl11);
                    this.popupVar.show(component, mouseEvent.getX(), mouseEvent.getY());
                    bl = true;
                } else if (n == 1) {
                    boolean bl12 = !this.listModelLog.isEmpty();
                    boolean bl13 = this.listLog.getSelectedIndex() >= 0;
                    this.popupLogCopy.setEnabled(bl13);
                    this.popupLogSelectAll.setEnabled(bl12);
                    this.popupLogRemove.setEnabled(bl13);
                    this.popupLogRemoveAll.setEnabled(bl12);
                    this.popupLog.show(component, mouseEvent.getX(), mouseEvent.getY());
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void doBreakpointImport(boolean bl) {
        Object var2_2 = null;
        if (bl) {
            LabelImportDlg.showDlg(this, this.labelImportOptions);
        } else if (this.labelImportOptions != null) {
            this.importLabels(this, this.labelImportOptions);
        }
    }

    private void doBreakpointRemoveImported() {
        int n;
        BreakpointListModel breakpointListModel = this.bpModels[0];
        if (breakpointListModel != null && (n = breakpointListModel.size()) > 0) {
            boolean bl = false;
            for (int i = n - 1; i >= 0; --i) {
                if (!(breakpointListModel.get(i) instanceof LabelBreakpoint)) continue;
                breakpointListModel.remove(i);
                bl = true;
            }
            if (bl) {
                this.updBreakpointList(0, null);
            }
        }
    }

    private void doDebugRun() {
        this.walkMillis = 0;
        this.cpu.fireAction(Z80CPU.Action.DEBUG_RUN);
    }

    private void doDebugWalk(int n) {
        this.walkMillis = n;
        this.labelStatus.setText("Programm wird langsam ausgef\u00fchrt...");
        this.cpu.fireAction(Z80CPU.Action.DEBUG_WALK);
    }

    private void doDebugStop() {
        if (this.walkMillis > 0) {
            this.walkMillis = 0;
            this.fireUpdDebugger(null, null);
        }
        this.labelStatus.setText("Programmausf\u00fchrung wird angehalten...");
        this.cpu.fireAction(Z80CPU.Action.DEBUG_STOP);
    }

    private void doDebugStepOver() {
        this.walkMillis = 0;
        this.cpu.fireAction(Z80CPU.Action.DEBUG_STEP_OVER);
    }

    private void doDebugStepInto() {
        this.walkMillis = 0;
        this.cpu.fireAction(Z80CPU.Action.DEBUG_STEP_INTO);
    }

    private void doDebugStepToRET() {
        this.walkMillis = 0;
        this.cpu.fireAction(Z80CPU.Action.DEBUG_STEP_TO_RET);
    }

    private void doDebugBreakAdd(int n) {
        switch (n) {
            case 0: {
                this.doDebugBreakPCAdd(-1);
                break;
            }
            case 1: {
                this.doDebugBreakMemoryAdd();
                break;
            }
            case 2: {
                this.doDebugBreakInputAdd();
                break;
            }
            case 3: {
                this.doDebugBreakOutputAdd();
                break;
            }
            case 4: {
                this.doDebugBreakInterruptAdd();
            }
        }
    }

    private void doDebugBreakEdit() {
        int n = -1;
        if (this.tabbedPane.getSelectedIndex() == 0) {
            for (int i = 0; i < 5; ++i) {
                int[] nArray;
                if (this.bpModels[i] == null || (nArray = this.bpLists[i].getSelectedIndices()) == null || nArray.length <= 0) continue;
                if (n < 0) {
                    n = i;
                    continue;
                }
                n = -1;
                break;
            }
        }
        if (n >= 0) {
            this.editBreakpoint(n);
        }
    }

    private void doDebugBreakInputAdd() {
        if (this.bpDlg == null) {
            this.bpDlg = new InputBreakpointDlg(this, null);
            this.bpDlg.setVisible(true);
            AbstractBreakpoint abstractBreakpoint = this.bpDlg.getApprovedBreakpoint();
            if (abstractBreakpoint != null) {
                this.addBreakpoint(2, abstractBreakpoint);
            }
            this.bpDlg = null;
        }
    }

    private void doDebugBreakInterruptAdd() {
        if (this.interruptSources != null) {
            if (this.bpDlg == null) {
                this.bpDlg = new InterruptBreakpointDlg(this, null, this.interruptSources);
                this.bpDlg.setVisible(true);
                AbstractBreakpoint abstractBreakpoint = this.bpDlg.getApprovedBreakpoint();
                if (abstractBreakpoint != null) {
                    this.addBreakpoint(4, abstractBreakpoint);
                }
                this.bpDlg = null;
            }
        } else {
            BaseDlg.showErrorDlg((Component)this, "Das emulierte System hat keine Interrupt-Quellen.");
        }
    }

    private void doDebugBreakMemoryAdd() {
        if (this.bpDlg == null) {
            this.bpDlg = new MemoryBreakpointDlg(this, null);
            this.bpDlg.setVisible(true);
            AbstractBreakpoint abstractBreakpoint = this.bpDlg.getApprovedBreakpoint();
            if (abstractBreakpoint != null) {
                this.addBreakpoint(1, abstractBreakpoint);
            }
            this.bpDlg = null;
        }
    }

    private void doDebugBreakOutputAdd() {
        if (this.bpDlg == null) {
            this.bpDlg = new OutputBreakpointDlg(this, null);
            this.bpDlg.setVisible(true);
            AbstractBreakpoint abstractBreakpoint = this.bpDlg.getApprovedBreakpoint();
            if (abstractBreakpoint != null) {
                this.addBreakpoint(3, abstractBreakpoint);
            }
            this.bpDlg = null;
        }
    }

    private void doDebugBreakRemove() {
        for (int i = 0; i < 5; ++i) {
            this.doDebugBreakRemove(i);
        }
    }

    private void doDebugBreakRemove(int n) {
        int[] nArray;
        BreakpointListModel breakpointListModel;
        if (n >= 0 && n < 5 && (breakpointListModel = this.bpModels[n]) != null && (nArray = this.bpLists[n].getSelectedIndices()) != null && nArray.length > 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = nArray[i];
                if (n2 < 0 || n2 >= breakpointListModel.size()) continue;
                this.registerRemove(breakpointListModel.getElementAt(n2));
                breakpointListModel.remove(n2);
            }
            this.updBreakpointList(n, null);
            this.updBreakpointActionsEnabled();
        }
    }

    private void doDebugBreakRemoveAll() {
        if (BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie alle Halte-/Log-Punkte entfernen?")) {
            for (int i = 0; i < this.bpModels.length; ++i) {
                this.removeAllBreakpointsFromModel(this.bpModels[i]);
                this.updBreakpointList(i, null);
            }
            this.updBreakpointActionsEnabled();
        }
    }

    private void doDebugBreakRemoveAll(int n) {
        if (n >= 0 && n < 5 && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie alle Halte-/Log-Punkte dieser Gruppe entfernen?")) {
            this.removeAllBreakpointsFromModel(this.bpModels[n]);
            this.updBreakpointList(n, null);
            this.updBreakpointActionsEnabled();
        }
    }

    private void doDebugBreakSetStopEnabled(boolean bl) {
        for (int i = 0; i < 5; ++i) {
            this.doDebugBreakSetStopEnabled(i, bl);
        }
    }

    private void doDebugBreakSetStopEnabled(int n, boolean bl) {
        int[] nArray;
        if (n >= 0 && n < 5 && this.bpModels[n] != null && (nArray = this.bpLists[n].getSelectedIndices()) != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 < 0 || n2 >= this.bpModels[n].size()) continue;
                AbstractBreakpoint abstractBreakpoint = (AbstractBreakpoint)this.bpModels[n].get(n2);
                abstractBreakpoint.setStopEnabled(bl);
            }
            this.updBreakpointList(n, null);
            this.updBreakpointActionsEnabled();
            EmuUtil.fireSelectRows(this.bpLists[n], nArray);
        }
    }

    private void doDebugBreakSetAllStopEnabled(boolean bl) {
        for (int i = 0; i < 5; ++i) {
            this.doDebugBreakSetAllStopEnabled(i, bl);
        }
    }

    private void doDebugBreakSetAllStopEnabled(int n, boolean bl) {
        if (n >= 0 && n < 5 && this.bpModels[n] != null) {
            for (int i = 0; i < this.bpModels[n].size(); ++i) {
                ((AbstractBreakpoint)this.bpModels[n].get(i)).setStopEnabled(bl);
            }
            this.updBreakpointList(n, null);
            this.updBreakpointActionsEnabled();
        }
    }

    private void doDebugBreakSetLogEnabled(boolean bl) {
        for (int i = 0; i < 5; ++i) {
            this.doDebugBreakSetLogEnabled(i, bl);
        }
    }

    private void doDebugBreakSetLogEnabled(int n, boolean bl) {
        int[] nArray;
        if (n >= 0 && n < 5 && this.bpModels[n] != null && (nArray = this.bpLists[n].getSelectedIndices()) != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 < 0 || n2 >= this.bpModels[n].size()) continue;
                AbstractBreakpoint abstractBreakpoint = (AbstractBreakpoint)this.bpModels[n].get(n2);
                abstractBreakpoint.setLogEnabled(bl);
            }
            this.updBreakpointList(n, null);
            this.updBreakpointActionsEnabled();
            EmuUtil.fireSelectRows(this.bpLists[n], nArray);
        }
    }

    private void doDebugBreakSetAllLogEnabled(boolean bl) {
        for (int i = 0; i < 5; ++i) {
            this.doDebugBreakSetAllLogEnabled(i, bl);
        }
    }

    private void doDebugBreakSetAllLogEnabled(int n, boolean bl) {
        if (n >= 0 && n < 5 && this.bpModels[n] != null) {
            for (int i = 0; i < this.bpModels[n].size(); ++i) {
                ((AbstractBreakpoint)this.bpModels[n].get(i)).setLogEnabled(bl);
            }
            this.updBreakpointList(n, null);
            this.updBreakpointActionsEnabled();
        }
    }

    private void doDebugTracer() {
        if (this.mnuDebugTracer.isSelected()) {
            this.mnuDebugTracer.setSelected(false);
            int n = 1;
            boolean bl = false;
            File file = null;
            if (this.lastTraceFile != null) {
                String[] stringArray = new String[]{"Anh\u00e4ngen", "Neue Datei", "Abbrechen"};
                n = BaseDlg.showOptionDlg(this, "Soll die Befehlsaufzeichnung an die alte Datei\n" + this.lastTraceFile.getPath() + "\nangeh\u00e4ngt werden oder m\u00f6chten Sie\n" + "eine neue Datei anlegen?", "Entscheidung", stringArray);
                if (n == 0) {
                    file = this.lastTraceFile;
                    bl = true;
                }
            }
            if (n == 0 && file == null || n == 1) {
                file = EmuUtil.showFileSaveDlg(this, "Befehlsaufzeichnung speichern", Main.getLastDirFile("debug"), EmuUtil.getTextFileFilter());
                bl = false;
            }
            if (file != null) {
                try {
                    this.traceWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file.getPath(), bl)), true);
                    this.cpu.setDebugTracer(this.traceWriter);
                    this.mnuDebugTracer.setSelected(true);
                    this.lastTraceFile = file;
                    Main.setLastFile(file, "debug");
                }
                catch (IOException iOException) {
                    this.traceWriter = null;
                    BaseDlg.showErrorDlg((Component)this, "Die Befehlsaufzeichnungsdatei kann nicht\nzum Schreiben ge\u00f6ffnet werden.\n\n" + iOException.getMessage());
                }
            }
        } else {
            this.closeTrace();
        }
    }

    private void doLogCopy() {
        int[] nArray;
        if (this.tabbedPane.getSelectedIndex() == 1 && (nArray = this.listLog.getSelectedIndices()) != null && nArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(nArray.length * 128);
            for (int n : nArray) {
                String string = this.listModelLog.getElementAt(n);
                if (string == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
            EmuUtil.copyToClipboard(this, stringBuilder.toString());
        }
    }

    private void doLogMaxLogCnt() {
        ReplyIntDlg replyIntDlg = new ReplyIntDlg(this, "Max. Anzahl Log-Meldungen:", this.maxLogCnt, 1, 10000);
        replyIntDlg.setVisible(true);
        this.setMaxLogCnt(replyIntDlg.getReply());
    }

    private void doLogRemove() {
        int[] nArray = this.listLog.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.listModelLog.remove(nArray[i]);
            }
            this.updLogActionsEnabled();
        }
    }

    private void doLogRemoveAll() {
        if (!this.listModelLog.isEmpty() && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie alle Log-Meldungen entfernen?")) {
            this.listModelLog.clear();
            this.updLogActionsEnabled();
        }
    }

    private void doLogSelectAll() {
        int n = this.listModelLog.getSize();
        if (n > 0) {
            this.listLog.setSelectionInterval(0, n - 1);
        }
    }

    private void doVarAdd() {
        int n;
        VarData varData = VarDataDlg.showNewVarDlg(this);
        if (varData != null && (n = this.tableModelVar.addRow(varData)) >= 0) {
            int n2;
            String string = varData.getName();
            if (string != null) {
                this.removedImportedVarNames.remove(string);
            }
            if (this.tableModelVar.getValuesEnabled()) {
                varData.update(this.memory);
                this.tableModelVar.fireTableRowsUpdated(n, n);
            }
            if ((n2 = this.tableVar.convertRowIndexToView(n)) >= 0) {
                EmuUtil.fireSelectRow(this.tableVar, n2);
            }
        }
    }

    private void doVarEdit() {
        VarData varData;
        VarData varData2;
        int n;
        int[] nArray = this.tableVar.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (n = this.tableVar.convertRowIndexToModel(nArray[0])) >= 0 && (varData2 = this.tableModelVar.getRow(n)) != null && (varData = VarDataDlg.showEditVarDlg(this, varData2)) != null) {
            this.tableModelVar.setRow(n, varData);
            String string = varData.getName();
            if (string != null) {
                this.removedImportedVarNames.remove(string);
            }
            if (this.tableModelVar.getValuesEnabled()) {
                varData.update(this.memory);
                this.tableModelVar.fireTableRowsUpdated(n, n);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DebugFrm.this.selectVar(varData);
                    }
                });
            }
        }
    }

    private void doVarRemove() {
        int[] nArray = this.tableVar.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] < 0) continue;
                nArray[n] = this.tableVar.convertRowIndexToModel(nArray[n]);
            }
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                int n2 = nArray[n];
                this.registerRemove(this.tableModelVar.getRow(n2));
                this.tableModelVar.remove(n2);
            }
        }
    }

    private void doVarRemoveAll() {
        if (!this.tableModelVar.isEmpty() && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie alle Variablen entfernen?")) {
            int n = this.tableModelVar.getRowCount();
            for (int i = 0; i < n; ++i) {
                this.registerRemove(this.tableModelVar.getRow(i));
            }
            this.tableModelVar.clear();
            this.updVarActionsEnabled();
        }
    }

    private void doWalkTimer() {
        this.walkTimer.stop();
        if (this.walkMillis > 0) {
            this.cpu.fireAction(Z80CPU.Action.DEBUG_STEP_INTO);
        }
    }

    private void addBreakpoint(int n, AbstractBreakpoint abstractBreakpoint) {
        try {
            if (n >= 0 && n < 5) {
                BreakpointListModel breakpointListModel = this.bpModels[n];
                if (breakpointListModel != null) {
                    int n2 = Collections.binarySearch(breakpointListModel, abstractBreakpoint);
                    if (n2 < 0) {
                        if ((n2 = -(n2 + 1)) < breakpointListModel.size()) {
                            breakpointListModel.add(n2, abstractBreakpoint);
                        } else {
                            breakpointListModel.add(abstractBreakpoint);
                        }
                    }
                    this.updBreakpointList(n, abstractBreakpoint);
                }
                this.updBreakpointActionsEnabled();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void appendLogEntryInternal(String string) {
        int n = this.listModelLog.getSize() - this.maxLogCnt + 1;
        if (n > 0) {
            try {
                this.listModelLog.removeRange(0, n - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.listModelLog.addElement(string);
        this.updLogActionsEnabled();
    }

    private void clear() {
        if (this.timerForClear.isRunning()) {
            this.timerForClear.stop();
        }
        this.btnFlagSign.setSelected(false);
        this.btnFlagZero.setSelected(false);
        this.btnFlagHalf.setSelected(false);
        this.btnFlagPV.setSelected(false);
        this.btnFlagN.setSelected(false);
        this.btnFlagCarry.setSelected(false);
        this.btnIFF1.setSelected(false);
        this.btnIFF2.setSelected(false);
        this.fldRegAF.setText("");
        this.fldRegAsciiA.setText("");
        this.fldRegBC.setText("");
        this.fldRegAsciiB.setText("");
        this.fldRegAsciiC.setText("");
        this.fldRegDE.setText("");
        this.fldRegAsciiD.setText("");
        this.fldRegAsciiE.setText("");
        this.fldRegHL.setText("");
        this.fldRegAsciiH.setText("");
        this.fldRegAsciiL.setText("");
        this.fldRegIX.setText("");
        this.fldRegAsciiIXH.setText("");
        this.fldRegAsciiIXL.setText("");
        this.fldRegIY.setText("");
        this.fldRegAsciiIYH.setText("");
        this.fldRegAsciiIYL.setText("");
        this.fldRegPC.setText("");
        this.fldRegSP.setText("");
        this.fldRegAF2.setText("");
        this.fldRegBC2.setText("");
        this.fldRegDE2.setText("");
        this.fldRegHL2.setText("");
        this.fldRegI.setText("");
        this.fldMemBC.setText("");
        this.fldMemDE.setText("");
        this.fldMemHL.setText("");
        this.fldMemIX.setText("");
        this.fldMemIY.setText("");
        this.fldMemSP.setText("");
        this.fldMemPC.setText("");
        this.fldTStates.setText("");
        this.listIntSrc.clearSelection();
        this.listIntSrc.setEnabled(false);
        this.fldIntSrc.setContentType("text/plain");
        this.fldIntSrc.setText("");
        this.fldIntSrc.setEnabled(false);
        this.fldEtc.setContentType("text/plain");
        this.fldEtc.setText("");
        this.fldEtc.setEnabled(false);
    }

    private void closeTrace() {
        if (this.traceWriter != null) {
            this.cpu.setDebugTracer(null);
            this.traceWriter.println("---");
            this.traceWriter.flush();
            this.traceWriter.close();
            boolean bl = this.traceWriter.checkError();
            this.traceWriter = null;
            if (bl) {
                BaseDlg.showErrorDlg((Component)this, "Die Befehlsaufzeichnungsdatei konnte nicht gespeichert werden.");
            }
        }
    }

    private void createBreakpointFields(Container container, int n) {
        BreakpointListModel breakpointListModel;
        this.bpModels[n] = breakpointListModel = new BreakpointListModel();
        BreakpointList breakpointList = new BreakpointList(breakpointListModel);
        breakpointList.setVisibleRowCount(4);
        breakpointList.setPrototypeCellValue(new PCBreakpoint(this, 65535, "HL", 65535, "=", 65535, false));
        breakpointList.setSelectionMode(2);
        breakpointList.setCellRenderer(new BreakpointCellRenderer(this));
        this.bpLists[n] = breakpointList;
        JScrollPane jScrollPane = new JScrollPane(breakpointList);
        jScrollPane.addMouseListener(this);
        this.bpScrollPanes[n] = jScrollPane;
        container.add(jScrollPane);
        breakpointList.addListSelectionListener(this);
        breakpointList.addKeyListener(this);
        breakpointList.addMouseListener(this);
    }

    private AbstractButton createFlagField(String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setEnabled(false);
        jCheckBox.addActionListener(this);
        return jCheckBox;
    }

    private JTextField createHexField() {
        JTextField jTextField = new JTextField(5);
        jTextField.addActionListener(this);
        jTextField.addFocusListener(this);
        jTextField.setEditable(false);
        return jTextField;
    }

    private void editBreakpoint(int n) {
        AbstractBreakpoint abstractBreakpoint;
        int n2;
        int[] nArray;
        BreakpointList breakpointList = this.bpLists[n];
        BreakpointListModel breakpointListModel = this.bpModels[n];
        if (breakpointList != null && breakpointListModel != null && (nArray = breakpointList.getSelectedIndices()) != null && nArray.length == 1 && (n2 = nArray[0]) >= 0 && n2 < breakpointListModel.size() && (abstractBreakpoint = (AbstractBreakpoint)breakpointListModel.get(n2)) != null && this.bpDlg == null) {
            switch (n) {
                case 0: {
                    this.bpDlg = new PCBreakpointDlg(this, abstractBreakpoint, -1);
                    break;
                }
                case 1: {
                    this.bpDlg = new MemoryBreakpointDlg(this, abstractBreakpoint);
                    break;
                }
                case 2: {
                    this.bpDlg = new InputBreakpointDlg(this, abstractBreakpoint);
                    break;
                }
                case 3: {
                    this.bpDlg = new OutputBreakpointDlg(this, abstractBreakpoint);
                    break;
                }
                case 4: {
                    this.bpDlg = new InterruptBreakpointDlg(this, abstractBreakpoint, this.interruptSources);
                }
            }
            if (this.bpDlg != null) {
                this.bpDlg.setVisible(true);
                AbstractBreakpoint abstractBreakpoint2 = this.bpDlg.getApprovedBreakpoint();
                if (abstractBreakpoint2 != null) {
                    breakpointListModel.remove(n2);
                    this.addBreakpoint(n, abstractBreakpoint2);
                }
                this.bpDlg = null;
            }
        }
    }

    private void fieldValueChanged(Object object) {
        JTextField jTextField;
        if (object == this.spinnerIntMode) {
            int n;
            Object object2 = this.spinnerIntMode.getValue();
            if (object2 != null && object2 instanceof Number && (n = ((Number)object2).intValue()) >= 0 && n <= 2) {
                this.cpu.setInterruptMode(n);
            }
            this.updFieldIntMode();
        } else if (object instanceof JTextField && (jTextField = (JTextField)object).isEditable()) {
            int n = -1;
            String string = jTextField.getText();
            if (string != null && !string.isEmpty()) {
                try {
                    n = Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
            if (jTextField == this.fldRegAF) {
                if (n != -1) {
                    this.cpu.setRegAF(n);
                }
                this.updFieldsFlag();
                this.updFieldsAF();
            } else if (jTextField == this.fldRegAF2) {
                if (n != -1) {
                    this.cpu.setRegAF2(n);
                }
                this.updFieldsAF2();
            } else if (jTextField == this.fldRegBC) {
                if (n != -1) {
                    this.cpu.setRegBC(n);
                }
                this.updFieldsBC();
            } else if (jTextField == this.fldRegBC2) {
                if (n != -1) {
                    this.cpu.setRegBC2(n);
                }
                this.updFieldsBC2();
            } else if (jTextField == this.fldRegDE) {
                if (n != -1) {
                    this.cpu.setRegDE(n);
                }
                this.updFieldsDE();
            } else if (jTextField == this.fldRegDE2) {
                if (n != -1) {
                    this.cpu.setRegDE2(n);
                }
                this.updFieldsDE2();
            } else if (jTextField == this.fldRegHL) {
                if (n != -1) {
                    this.cpu.setRegHL(n);
                }
                this.updFieldsHL();
            } else if (jTextField == this.fldRegHL2) {
                if (n != -1) {
                    this.cpu.setRegHL2(n);
                }
                this.updFieldsHL2();
            } else if (jTextField == this.fldRegIX) {
                if (n != -1) {
                    this.cpu.setRegIX(n);
                }
                this.updFieldsIX();
            } else if (jTextField == this.fldRegIY) {
                if (n != -1) {
                    this.cpu.setRegIY(n);
                }
                this.updFieldsIY();
            } else if (jTextField == this.fldRegSP) {
                if (n != -1) {
                    this.cpu.setRegSP(n);
                }
                this.updFieldsSP();
            } else if (jTextField == this.fldRegPC) {
                if (n != -1) {
                    this.cpu.setRegPC(n);
                }
                this.updFieldsPC();
            } else if (jTextField == this.fldRegI) {
                if (n != -1) {
                    this.cpu.setRegI(n);
                }
                this.updFieldI();
            }
        }
    }

    private void fireAppendLogEntry(final String string) {
        if (string != null && !string.isEmpty()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugFrm.this.appendLogEntryInternal(string);
                }
            });
        }
    }

    private void fireUpdDebugger(final Z80Breakpoint z80Breakpoint, final Z80InterruptSource z80InterruptSource) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugFrm.this.updDebugger(z80Breakpoint, z80InterruptSource);
            }
        });
    }

    private String getAscii(int n) {
        String string = "";
        if (n > 32 && n < 127) {
            string = string + (char)n;
        }
        return string;
    }

    private String getMemInfo(int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder(n2 * 4 + 6);
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuilder.append(String.format("%02X ", this.memory.getMemByte(n + n3, false)));
        }
        n3 = this.memory.getMemByte(n, false);
        if (n3 >= 32 && n3 <= 126) {
            stringBuilder.append(" \"");
            for (int i = 0; i < n2 && (n3 = this.memory.getMemByte(n + i, false)) >= 32 && n3 <= 126; ++i) {
                stringBuilder.append((char)n3);
            }
            stringBuilder.append("...\"");
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private boolean importLabels(Label[] var1_1, boolean var2_2, boolean var3_3, boolean var4_4) {
        var5_5 = false;
        var6_6 = null;
        var7_7 = null;
        var8_8 = this.bpModels[0];
        var9_9 = var8_8.size();
        if (var9_9 > 0) {
            for (var10_10 = var9_9 - 1; var10_10 >= 0; --var10_10) {
                var11_12 = (AbstractBreakpoint)var8_8.get(var10_10);
                if (var11_12 == null || !(var11_12 instanceof LabelBreakpoint)) continue;
                var12_14 = 0;
                var13_21 = ((LabelBreakpoint)var11_12).getLabelName();
                if (var13_21 != null && !var13_21.isEmpty()) {
                    if (!var4_4) {
                        var13_21 = var13_21.toUpperCase();
                    }
                    if (var6_6 == null) {
                        var6_6 = new HashMap<Object, LabelBreakpoint>(var9_9);
                    }
                    var6_6.put(var13_21, (LabelBreakpoint)var11_12);
                    var12_14 = 1;
                }
                if (var12_14 == 0) {
                    if (var7_7 == null) {
                        var7_7 = new HashMap<Integer, LabelBreakpoint>(var9_9);
                    }
                    var7_7.put(((LabelBreakpoint)var11_12).getAddress(), (LabelBreakpoint)var11_12);
                }
                var8_8.remove(var10_10);
            }
        }
        var10_11 = null;
        var11_13 = this.tableModelVar.getRowCount();
        if (var11_13 > 0) {
            var10_11 = new HashMap<String, Integer>(var11_13);
            for (var12_14 = 0; var12_14 < var11_13; ++var12_14) {
                var13_21 = this.tableModelVar.getRow(var12_14);
                if (var13_21 == null || !var13_21.wasImported() || (var14_25 = var13_21.getName()) == null) continue;
                if (!var4_4) {
                    var14_25 = var14_25.toUpperCase();
                }
                var10_11.put(var14_25, var12_14);
            }
        }
        if (var1_1 != null) {
            for (Label var15_31 : var1_1) {
                var16_33 = var15_31.getLabelName();
                var17_34 = var15_31.getVarSize();
                if (var17_34 > 0) {
                    if (var16_33 == null) continue;
                    if (!var4_4) {
                        var16_33 = var16_33.toUpperCase();
                    }
                    if (var2_2 && this.removedImportedVarNames.contains(var16_33)) continue;
                    var18_35 = null;
                    if (var10_11 != null) {
                        var18_35 = (Integer)var10_11.get(var16_33);
                    }
                    if (var18_35 != null) {
                        var19_36 = this.tableModelVar.getRow(var18_35.intValue());
                        if (var19_36 != null) {
                            this.tableModelVar.setRow(var18_35.intValue(), VarData.createWithDefaultType(var16_33, var15_31.intValue(), var17_34, true));
                        } else {
                            var18_35 = null;
                        }
                        var10_11.remove(var16_33);
                    }
                    if (var18_35 == null) {
                        this.tableModelVar.addRow(VarData.createWithDefaultType(var16_33, var15_31.intValue(), var17_34, true));
                    }
                    this.removedImportedVarNames.remove(var16_33);
                    var5_5 = true;
                    continue;
                }
                if (var16_33 != null) {
                    if (!var4_4) {
                        var16_33 = var16_33.toUpperCase();
                    }
                    if (var2_2 && this.removedImportedBreakNames.contains(var16_33)) continue;
                    var18_35 = null;
                    if (var6_6 != null) {
                        var18_35 = (LabelBreakpoint)var6_6.remove(var16_33);
                    }
                    var8_8.add(new LabelBreakpoint(this, var16_33, var15_31.intValue(), (PCBreakpoint)var18_35, true));
                    this.removedImportedBreakNames.remove(var16_33);
                    var5_5 = true;
                    continue;
                }
                var18_35 = var15_31.intValue();
                if (var2_2 && this.removedImportedBreakAddrs.contains(var18_35)) continue;
                var19_36 = null;
                if (var7_7 != null) {
                    var19_36 = (LabelBreakpoint)var7_7.remove(var18_35);
                }
                var8_8.add(new LabelBreakpoint(this, null, var15_31.intValue(), (PCBreakpoint)var19_36, true));
                this.removedImportedBreakAddrs.remove(var18_35);
                var5_5 = true;
            }
        }
        if (var5_5) {
            if (var3_3) {
                if (var10_11 != null && (var12_17 = var10_11.values()) != null && (var13_24 = var12_17.size()) > 0) {
                    try {
                        var14_28 = var12_17.toArray(new Integer[var13_24]);
                        if (var14_28 == null) ** GOTO lbl112
                        Arrays.sort(var14_28);
                        for (var15_32 = var14_28.length - 1; var15_32 >= 0; --var15_32) {
                            this.tableModelVar.remove(var14_28[var15_32].intValue());
                        }
                    }
                    catch (ArrayStoreException var14_29) {
                    }
                    catch (ClassCastException var14_30) {}
                }
            } else {
                if (var6_6 != null && (var12_18 = var6_6.values()) != null) {
                    var8_8.addAll(var12_18);
                }
                if (var7_7 != null && (var12_19 = var7_7.values()) != null) {
                    var8_8.addAll(var12_19);
                }
            }
lbl112:
            // 7 sources

            try {
                Collections.sort(var8_8);
            }
            catch (ClassCastException var12_20) {
                // empty catch block
            }
            this.bpLists[0].setListData(new AbstractBreakpoint[0]);
            this.bpLists[0].setModel(var8_8);
            this.updBreakpointList(0, null);
            this.tableModelVar.update(this.memory);
            if (this.cpu.isPause()) {
                this.updFieldsPC();
            }
        }
        return var5_5;
    }

    private void registerRemove(AbstractBreakpoint abstractBreakpoint) {
        PCBreakpoint pCBreakpoint;
        if (abstractBreakpoint != null && abstractBreakpoint instanceof PCBreakpoint && (pCBreakpoint = (PCBreakpoint)abstractBreakpoint).wasImported()) {
            String string = null;
            if (pCBreakpoint instanceof LabelBreakpoint && (string = ((LabelBreakpoint)pCBreakpoint).getLabelName()) != null && string.isEmpty()) {
                string = null;
            }
            if (string != null) {
                this.removedImportedBreakNames.add(string);
            } else {
                this.removedImportedBreakAddrs.add(pCBreakpoint.getAddress());
            }
        }
    }

    private void registerRemove(VarData varData) {
        String string;
        if (varData != null && (string = varData.getName()) != null && !string.isEmpty()) {
            this.removedImportedVarNames.add(string);
        }
    }

    private void removeAllBreakpointsFromModel(BreakpointListModel breakpointListModel) {
        if (breakpointListModel != null) {
            int n = breakpointListModel.getSize();
            for (int i = 0; i < n; ++i) {
                this.registerRemove(breakpointListModel.getElementAt(i));
            }
            breakpointListModel.clear();
        }
    }

    private void setDebuggerEditable(boolean bl) {
        this.btnFlagSign.setEnabled(bl);
        this.btnFlagZero.setEnabled(bl);
        this.btnFlagHalf.setEnabled(bl);
        this.btnFlagPV.setEnabled(bl);
        this.btnFlagN.setEnabled(bl);
        this.btnFlagCarry.setEnabled(bl);
        this.btnIFF1.setEnabled(bl);
        this.btnIFF2.setEnabled(bl);
        this.labelIntMode.setEnabled(bl);
        this.spinnerIntMode.setEnabled(bl);
        this.labelRegI.setEnabled(bl);
        this.fldRegI.setEditable(bl);
        this.fldRegAF.setEditable(bl);
        this.fldRegBC.setEditable(bl);
        this.fldRegDE.setEditable(bl);
        this.fldRegHL.setEditable(bl);
        this.fldRegIX.setEditable(bl);
        this.fldRegIY.setEditable(bl);
        this.fldRegPC.setEditable(bl);
        this.fldRegSP.setEditable(bl);
        this.fldRegAF2.setEditable(bl);
        this.fldRegBC2.setEditable(bl);
        this.fldRegDE2.setEditable(bl);
        this.fldRegHL2.setEditable(bl);
    }

    private void setDebuggerDisabled(String string) {
        this.clear();
        this.setDebuggerEditable(false);
        this.mnuDebugRun.setEnabled(false);
        this.mnuDebugWalk100.setEnabled(false);
        this.mnuDebugWalk300.setEnabled(false);
        this.mnuDebugWalk500.setEnabled(false);
        this.mnuDebugStop.setEnabled(false);
        this.mnuDebugStepOver.setEnabled(false);
        this.mnuDebugStepInto.setEnabled(false);
        this.mnuDebugStepToRET.setEnabled(false);
        this.btnRun.setEnabled(false);
        this.btnWalk.setEnabled(false);
        this.popupWalk100.setEnabled(false);
        this.popupWalk300.setEnabled(false);
        this.popupWalk500.setEnabled(false);
        this.btnStop.setEnabled(false);
        this.btnStepOver.setEnabled(false);
        this.btnStepInto.setEnabled(false);
        this.btnStepToRET.setEnabled(false);
        this.btnResetTStates.setEnabled(false);
        this.tableModelVar.setValuesEnabled(false);
        this.labelStatus.setText(string);
    }

    private void setDebugRunning() {
        this.setDebuggerEditable(false);
        this.timerForClear.start();
        this.mnuDebugRun.setEnabled(false);
        this.mnuDebugWalk100.setEnabled(true);
        this.mnuDebugWalk300.setEnabled(true);
        this.mnuDebugWalk500.setEnabled(true);
        this.mnuDebugStop.setEnabled(true);
        this.mnuDebugStepOver.setEnabled(false);
        this.mnuDebugStepInto.setEnabled(false);
        this.mnuDebugStepToRET.setEnabled(false);
        this.btnRun.setEnabled(false);
        this.btnWalk.setEnabled(true);
        this.popupWalk100.setEnabled(true);
        this.popupWalk300.setEnabled(true);
        this.popupWalk500.setEnabled(true);
        this.btnStop.setEnabled(true);
        this.btnStepOver.setEnabled(false);
        this.btnStepInto.setEnabled(false);
        this.btnStepToRET.setEnabled(false);
        this.btnResetTStates.setEnabled(false);
        this.tableModelVar.setValuesEnabled(false);
        this.labelStatus.setText("Programm wird gerade ausgef\u00fchrt...");
    }

    private void setDebugStopped(Z80Breakpoint z80Breakpoint, Z80InterruptSource z80InterruptSource) {
        if (z80Breakpoint != null || z80InterruptSource != null) {
            this.walkMillis = 0;
        }
        boolean bl = this.walkMillis > 0;
        boolean bl2 = !bl;
        this.updFieldsFlag();
        this.updFieldsInterrupt();
        this.updFieldsAF();
        this.updFieldsAF2();
        this.updFieldsBC();
        this.updFieldsBC2();
        this.updFieldsDE();
        this.updFieldsDE2();
        this.updFieldsHL();
        this.updFieldsHL2();
        this.updFieldsIX();
        this.updFieldsIY();
        this.updFieldsSP();
        this.updFieldsPC();
        this.updFieldsTStates();
        this.mnuDebugRun.setEnabled(true);
        this.mnuDebugWalk100.setEnabled(true);
        this.mnuDebugWalk300.setEnabled(true);
        this.mnuDebugWalk500.setEnabled(true);
        this.mnuDebugStop.setEnabled(bl);
        this.mnuDebugStepOver.setEnabled(bl2);
        this.mnuDebugStepInto.setEnabled(bl2);
        this.mnuDebugStepToRET.setEnabled(bl2);
        this.btnRun.setEnabled(true);
        this.btnWalk.setEnabled(true);
        this.popupWalk100.setEnabled(true);
        this.popupWalk300.setEnabled(true);
        this.popupWalk500.setEnabled(true);
        this.btnStop.setEnabled(bl);
        this.btnStepOver.setEnabled(bl2);
        this.btnStepInto.setEnabled(bl2);
        this.btnStepToRET.setEnabled(bl2);
        this.btnResetTStates.setEnabled(true);
        this.listIntSrc.setEnabled(true);
        this.fldIntSrc.setEnabled(true);
        this.updIntSrcFields();
        ListModel<Z80InterruptSource> listModel = this.listIntSrc.getModel();
        if (listModel != null && listModel.getSize() == 1) {
            this.listIntSrc.setSelectedIndex(0);
        }
        this.tableModelVar.update(this.memory);
        this.tableModelVar.setValuesEnabled(true);
        this.fldEtc.setEnabled(true);
        this.updEtcField();
        if (this.walkMillis > 0) {
            this.walkTimer.setInitialDelay(this.walkMillis);
            this.walkTimer.restart();
        } else {
            this.setDebuggerEditable(true);
            String string = "Programmausf\u00fchrung angehalten";
            if (z80InterruptSource != null) {
                StringBuilder stringBuilder = new StringBuilder(128);
                stringBuilder.append(string);
                stringBuilder.append(", Interrupt von ");
                stringBuilder.append(z80InterruptSource.toString());
                stringBuilder.append(" angenommen");
                string = stringBuilder.toString();
            }
            this.labelStatus.setText(string);
        }
    }

    private boolean setMaxLogCnt(Object object) {
        boolean bl = false;
        if (object != null) {
            try {
                int n = -1;
                if (object instanceof Number) {
                    n = ((Number)object).intValue();
                } else {
                    String string = object.toString();
                    if (string != null) {
                        n = Integer.parseInt(string);
                    }
                }
                if (n > 0) {
                    this.maxLogCnt = n;
                    bl = true;
                    int n2 = this.listModelLog.getSize() - n;
                    if (n2 > 0) {
                        try {
                            this.listModelLog.removeRange(0, n2 - 1);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    private void updBreakpointActionsEnabled() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        int n = 0;
        if (this.tabbedPane.getSelectedIndex() == 0) {
            for (int i = 0; i < 5; ++i) {
                if (this.bpModels[i] != null) {
                    BreakpointListModel breakpointListModel = this.bpModels[i];
                    Object object = breakpointListModel.iterator();
                    while (object.hasNext()) {
                        AbstractBreakpoint abstractBreakpoint = (AbstractBreakpoint)object.next();
                        bl = true;
                        if (abstractBreakpoint.isStopEnabled()) {
                            bl2 = true;
                        } else {
                            bl3 = true;
                        }
                        if (abstractBreakpoint.isLogEnabled()) {
                            bl4 = true;
                        } else {
                            bl5 = true;
                        }
                        if (!bl2 || !bl3 || !bl4 || !bl5) continue;
                        break;
                    }
                    if ((object = (Object)this.bpLists[i].getSelectedIndices()) != null) {
                        for (int j = 0; j < ((Object)object).length; ++j) {
                            Object object2 = object[j];
                            if (object2 >= 0 && object2 < breakpointListModel.size()) {
                                ++n;
                                if (((AbstractBreakpoint)breakpointListModel.get((int)object2)).isStopEnabled()) {
                                    bl6 = true;
                                } else {
                                    bl7 = true;
                                }
                                if (((AbstractBreakpoint)breakpointListModel.get((int)object2)).isLogEnabled()) {
                                    bl8 = true;
                                } else {
                                    bl9 = true;
                                }
                            }
                            if (n > 1 && bl6 && bl7 && bl8 && bl9) break;
                        }
                    }
                }
                if (n > 1 && bl6 && bl7 && bl8 && bl9 && bl2 && bl3 && bl4 && bl5) break;
            }
        }
        this.mnuDebugBreakEnableStop.setEnabled(bl7);
        this.mnuDebugBreakDisableStop.setEnabled(bl6);
        this.mnuDebugBreakEnableStopAll.setEnabled(bl3);
        this.mnuDebugBreakDisableStopAll.setEnabled(bl2);
        this.mnuDebugBreakEnableLog.setEnabled(bl9);
        this.mnuDebugBreakDisableLog.setEnabled(bl8);
        this.mnuDebugBreakEnableLogAll.setEnabled(bl5);
        this.mnuDebugBreakDisableLogAll.setEnabled(bl4);
        this.mnuDebugBreakEdit.setEnabled(n == 1);
        this.mnuDebugBreakRemove.setEnabled(n > 0);
        this.mnuDebugBreakRemoveAll.setEnabled(bl);
    }

    private void updBreakpointList(int n, AbstractBreakpoint abstractBreakpoint) {
        boolean bl = false;
        if (n >= 0 && n < 5 && this.bpModels[n] != null && this.bpLists[n] != null) {
            this.bpLists[n].setModel(this.bpModels[n]);
            this.bpLists[n].repaint();
            if (abstractBreakpoint != null) {
                EmuUtil.fireSelectRow((JList)this.bpLists[n], abstractBreakpoint);
            }
            ArrayList<AbstractBreakpoint> arrayList = null;
            for (int i = 0; i < this.bpModels.length; ++i) {
                int n2;
                BreakpointListModel breakpointListModel = this.bpModels[i];
                if (breakpointListModel == null || (n2 = breakpointListModel.size()) <= 0) continue;
                for (AbstractBreakpoint abstractBreakpoint2 : breakpointListModel) {
                    if ((abstractBreakpoint2.isLogEnabled() || abstractBreakpoint2.isStopEnabled()) && abstractBreakpoint2 instanceof Z80Breakpoint) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<AbstractBreakpoint>();
                        }
                        arrayList.add(abstractBreakpoint2);
                    }
                    if (!(abstractBreakpoint2 instanceof LabelBreakpoint)) continue;
                    bl = true;
                }
            }
            this.cpu.setBreakpoints(arrayList != null ? arrayList.toArray(new Z80Breakpoint[arrayList.size()]) : null);
        }
        if (n == 0) {
            this.mnuFileBreakRemoveImported.setEnabled(bl);
        }
    }

    private void updDebugger(Z80Breakpoint z80Breakpoint, Z80InterruptSource z80InterruptSource) {
        if (this.isShowing()) {
            this.updDebuggerInternal(z80Breakpoint, z80InterruptSource);
            if (this.cpu.isPause() && this.walkMillis == 0) {
                this.setState(0);
                this.toFront();
            }
        }
    }

    private void updDebuggerInternal(Z80Breakpoint z80Breakpoint, Z80InterruptSource z80InterruptSource) {
        if (this.timerForClear.isRunning()) {
            this.timerForClear.stop();
        }
        if (this.cpu.isActive()) {
            if (this.cpu.isDebugEnabled()) {
                if (this.cpu.isPause()) {
                    this.setDebugStopped(z80Breakpoint, z80InterruptSource);
                    if (z80Breakpoint != null) {
                        block0: for (int i = 0; i < this.bpModels.length; ++i) {
                            if (this.bpModels[i] == null) continue;
                            for (AbstractBreakpoint abstractBreakpoint : this.bpModels[i]) {
                                if (abstractBreakpoint != z80Breakpoint) continue;
                                this.bpLists[i].requestFocus();
                                EmuUtil.fireSelectRow((JList)this.bpLists[i], abstractBreakpoint);
                                continue block0;
                            }
                        }
                    }
                } else {
                    this.setDebugRunning();
                }
            } else {
                this.setDebugRunning();
            }
        } else {
            this.setDebuggerDisabled("Prozessorsystem nicht aktiv");
        }
    }

    private void updEtcField() {
        EmuSys emuSys;
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("<html>\n");
        int n = stringBuilder.length();
        if (this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null) {
            emuSys.appendStatusHTMLTo(stringBuilder, this.cpu);
        }
        if (stringBuilder.length() == n) {
            stringBuilder.append("Keine sonstigen Daten verf&uuml;gbar");
        }
        stringBuilder.append("</html>\n");
        this.fldEtc.setContentType("text/html");
        this.fldEtc.setText(stringBuilder.toString());
        try {
            this.fldEtc.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void updFieldsInterrupt() {
        this.btnIFF1.setSelected(this.cpu.getIFF1());
        this.btnIFF2.setSelected(this.cpu.getIFF2());
        this.updFieldIntMode();
        this.updFieldI();
    }

    private void updFieldsFlag() {
        this.btnFlagSign.setSelected(this.cpu.getFlagSign());
        this.btnFlagZero.setSelected(this.cpu.getFlagZero());
        this.btnFlagHalf.setSelected(this.cpu.getFlagHalf());
        this.btnFlagPV.setSelected(this.cpu.getFlagPV());
        this.btnFlagN.setSelected(this.cpu.getFlagN());
        this.btnFlagCarry.setSelected(this.cpu.getFlagCarry());
    }

    private void updFieldsAF() {
        this.fldRegAF.setText(String.format("%04X", this.cpu.getRegAF()));
        this.fldRegAsciiA.setText(this.getAscii(this.cpu.getRegA()));
    }

    private void updFieldsAF2() {
        this.fldRegAF2.setText(String.format("%04X", this.cpu.getRegAF2()));
    }

    private void updFieldsBC() {
        int n = this.cpu.getRegBC();
        this.fldRegBC.setText(String.format("%04X", n));
        this.fldRegAsciiB.setText(this.getAscii(this.cpu.getRegB()));
        this.fldRegAsciiC.setText(this.getAscii(this.cpu.getRegC()));
        this.fldMemBC.setText(this.getMemInfo(n, 6));
    }

    private void updFieldsBC2() {
        this.fldRegBC2.setText(String.format("%04X", this.cpu.getRegBC2()));
    }

    private void updFieldsDE() {
        int n = this.cpu.getRegDE();
        this.fldRegDE.setText(String.format("%04X", n));
        this.fldRegAsciiD.setText(this.getAscii(this.cpu.getRegD()));
        this.fldRegAsciiE.setText(this.getAscii(this.cpu.getRegE()));
        this.fldMemDE.setText(this.getMemInfo(n, 6));
    }

    private void updFieldsDE2() {
        this.fldRegDE2.setText(String.format("%04X", this.cpu.getRegDE2()));
    }

    private void updFieldsHL() {
        int n = this.cpu.getRegHL();
        this.fldRegHL.setText(String.format("%04X", n));
        this.fldRegAsciiH.setText(this.getAscii(this.cpu.getRegH()));
        this.fldRegAsciiL.setText(this.getAscii(this.cpu.getRegL()));
        this.fldMemHL.setText(this.getMemInfo(n, 6));
    }

    private void updFieldsHL2() {
        this.fldRegHL2.setText(String.format("%04X", this.cpu.getRegHL2()));
    }

    private void updFieldsIX() {
        int n = this.cpu.getRegIX();
        this.fldRegIX.setText(String.format("%04X", n));
        this.fldRegAsciiIXH.setText(this.getAscii(this.cpu.getRegIXH()));
        this.fldRegAsciiIXL.setText(this.getAscii(this.cpu.getRegIXL()));
        this.fldMemIX.setText(this.getMemInfo(n, 8));
    }

    private void updFieldsIY() {
        int n = this.cpu.getRegIY();
        this.fldRegIY.setText(String.format("%04X", n));
        this.fldRegAsciiIYH.setText(this.getAscii(this.cpu.getRegIYH()));
        this.fldRegAsciiIYL.setText(this.getAscii(this.cpu.getRegIYL()));
        this.fldMemIY.setText(this.getMemInfo(n, 8));
    }

    private void updFieldI() {
        this.fldRegI.setText(String.format("%02X", this.cpu.getRegI()));
    }

    private void updFieldsSP() {
        int n = this.cpu.getRegSP();
        this.fldRegSP.setText(String.format("%04X", n));
        int n2 = 6;
        StringBuilder stringBuilder = new StringBuilder(n2 * 5);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(String.format("%04X ", this.memory.getMemWord(n)));
            ++n;
            ++n;
        }
        this.fldMemSP.setText(stringBuilder.toString());
    }

    private void updFieldsPC() {
        int n;
        Insets insets;
        Document document = this.fldMemPC.getDocument();
        BreakpointListModel breakpointListModel = this.bpModels[0];
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.cpu.getRegPC();
        this.fldRegPC.setText(String.format("%04X", n2));
        int n3 = 0;
        int n4 = this.fldMemPC.getHeight();
        Border border = this.fldMemPC.getBorder();
        if (border != null && border != null && (insets = border.getBorderInsets(this.fldMemPC)) != null) {
            n4 -= insets.top;
            n4 -= insets.bottom;
        }
        if ((insets = this.fldMemPC.getMargin()) != null) {
            n4 -= insets.top;
            n4 -= insets.bottom;
        }
        if (n4 > 0) {
            n3 = 5;
            Font font = this.fldMemPC.getFont();
            if (font != null && (n = font.getSize()) > 0) {
                n3 = n4 / n;
            }
        }
        this.fldMemPC.setText("");
        for (int i = 0; i < n3; ++i) {
            int n5;
            Object object;
            Object object22;
            if (i > 0) {
                this.fldMemPC.append("\n");
            }
            n = 0;
            Object object3 = null;
            if (document != null && breakpointListModel != null) {
                n = document.getLength();
                for (Object object22 : breakpointListModel) {
                    if (!(object22 instanceof LabelBreakpoint) || ((LabelBreakpoint)object22).getAddress() != n2) continue;
                    object = ((LabelBreakpoint)object22).getLabelName();
                    if (object != null && ((String)object).isEmpty()) {
                        object = null;
                    }
                    if (object == null) continue;
                    if (object3 != null) {
                        object3 = (String)object3 + ", " + (String)object;
                        continue;
                    }
                    object3 = object;
                }
            }
            int n6 = 0;
            if (this.emuThread != null && (object22 = this.emuThread.getEmuSys()) != null && object22 != null) {
                stringBuilder.setLength(0);
                n6 = ((EmuSys)object22).reassembleSysCall(this.memory, n2, stringBuilder, false, 18, 26, 40);
            }
            int n7 = stringBuilder.length();
            if (n6 > 0 && n7 > 0) {
                if (stringBuilder.charAt(n7 - 1) == '\n') {
                    stringBuilder.setLength(n7 - 1);
                }
                this.fldMemPC.append(stringBuilder.toString());
                n2 += n6;
                continue;
            }
            object = Z80Reassembler.reassInstruction(this.memory, n2);
            if (object != null) {
                this.fldMemPC.append(String.format("%04X  ", n2));
                n5 = 12;
                int n8 = ((Z80ReassInstr)object).getLength();
                for (int j = 0; j < n8; ++j) {
                    this.fldMemPC.append(String.format("%02X ", ((Z80ReassInstr)object).getByte(j)));
                    ++n2;
                    n5 -= 3;
                }
                while (n5 > 0) {
                    this.fldMemPC.append(" ");
                    --n5;
                }
                String string = ((Z80ReassInstr)object).getName();
                if (string != null) {
                    this.fldMemPC.append(string);
                    n5 = 8 - string.length();
                    string = ((Z80ReassInstr)object).getArg1();
                    if (string != null) {
                        while (n5 > 0) {
                            this.fldMemPC.append(" ");
                            --n5;
                        }
                        this.fldMemPC.append(string);
                        string = ((Z80ReassInstr)object).getArg2();
                        if (string != null) {
                            this.fldMemPC.append(",");
                            this.fldMemPC.append(string);
                        }
                    }
                }
            } else {
                this.fldMemPC.append(String.format("%02X", this.memory.getMemByte(n2, true)));
                ++n2;
            }
            if (object3 == null || document == null) continue;
            n5 = document.getLength() - n;
            do {
                this.fldMemPC.append(" ");
            } while (++n5 < 40);
            this.fldMemPC.append(";");
            if (((String)object3).length() > 20) {
                this.fldMemPC.append(((String)object3).substring(0, 17));
                this.fldMemPC.append("...");
                continue;
            }
            this.fldMemPC.append((String)object3);
        }
        try {
            this.fldMemPC.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void updFieldsTStates() {
        this.fldTStates.setText(Long.toString(this.cpu.getProcessedTStates()));
    }

    private void updIntBreakpoints(Z80InterruptSource[] z80InterruptSourceArray) {
        BreakpointListModel breakpointListModel = this.bpModels[4];
        if (breakpointListModel != null && z80InterruptSourceArray != null) {
            int n = breakpointListModel.size();
            for (int i = n - 1; i >= 0; --i) {
                InterruptBreakpoint interruptBreakpoint;
                Z80InterruptSource z80InterruptSource;
                boolean bl = false;
                AbstractBreakpoint abstractBreakpoint = (AbstractBreakpoint)breakpointListModel.get(i);
                if (abstractBreakpoint instanceof InterruptBreakpoint && (z80InterruptSource = (interruptBreakpoint = (InterruptBreakpoint)abstractBreakpoint).getInterruptSource()) != null) {
                    String string = z80InterruptSource.toString();
                    for (int j = 0; j < z80InterruptSourceArray.length; ++j) {
                        if (!TextUtil.equals(string, z80InterruptSourceArray[j].toString())) continue;
                        interruptBreakpoint.setInterruptSource(z80InterruptSourceArray[j]);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                breakpointListModel.remove(i);
            }
        }
        this.updBreakpointList(4, null);
    }

    private void updIntSrcFields() {
        Z80InterruptSource[] z80InterruptSourceArray = this.cpu.getInterruptSources();
        if (z80InterruptSourceArray != null && z80InterruptSourceArray.length == 0) {
            z80InterruptSourceArray = null;
        }
        if (this.interruptSources == null || z80InterruptSourceArray != this.interruptSources) {
            AbstractBreakpointDlg abstractBreakpointDlg = this.bpDlg;
            if (abstractBreakpointDlg != null && abstractBreakpointDlg instanceof InterruptBreakpointDlg) {
                ((InterruptBreakpointDlg)abstractBreakpointDlg).setInterruptSources(z80InterruptSourceArray);
            }
            this.updIntBreakpoints(z80InterruptSourceArray);
            if (z80InterruptSourceArray != null) {
                this.listIntSrc.setListData((Z80InterruptSource[])z80InterruptSourceArray);
            } else {
                this.listIntSrc.setListData((Z80InterruptSource[])new Z80InterruptSource[0]);
            }
            this.interruptSources = z80InterruptSourceArray;
        }
        if (this.interruptSources != null && this.lastSelectedIntSrc != null) {
            for (int i = 0; i < this.interruptSources.length; ++i) {
                if (this.interruptSources[i] != this.lastSelectedIntSrc) continue;
                this.listIntSrc.setSelectedValue(this.lastSelectedIntSrc, true);
            }
        }
        this.updIntSrcInfoField();
    }

    private void updIntSrcInfoField() {
        boolean bl = false;
        if (this.listIntSrc.isEnabled()) {
            Object object;
            int[] nArray = this.listIntSrc.getSelectedIndices();
            if (nArray != null && nArray.length == 1 && (object = this.listIntSrc.getSelectedValue()) != null && object instanceof Z80InterruptSource) {
                this.lastSelectedIntSrc = (Z80InterruptSource)object;
                StringBuilder stringBuilder = new StringBuilder(2048);
                stringBuilder.append("<html>\n<h1>");
                EmuUtil.appendHTML(stringBuilder, this.lastSelectedIntSrc.toString());
                stringBuilder.append("</h1>\n");
                this.lastSelectedIntSrc.appendInterruptStatusHTMLTo(stringBuilder);
                stringBuilder.append("</html>\n");
                this.fldIntSrc.setContentType("text/html");
                this.fldIntSrc.setText(stringBuilder.toString());
                bl = true;
            }
            if (!bl && (object = this.listIntSrc.getModel()) != null && object.getSize() > 0) {
                this.fldIntSrc.setContentType("text/plain");
                this.fldIntSrc.setText("Bitte Interrupt-Quelle ausw\u00e4hlen!");
            }
        }
        try {
            this.fldIntSrc.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void updFieldIntMode() {
        try {
            this.spinnerIntMode.setValue(this.cpu.getInterruptMode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void updLogActionsEnabled() {
        boolean bl = this.tabbedPane.getSelectedIndex() == 1;
        boolean bl2 = !this.listModelLog.isEmpty();
        boolean bl3 = this.listLog.getSelectedIndex() >= 0;
        this.mnuLogCopy.setEnabled(bl && bl3);
        this.mnuLogSelectAll.setEnabled(bl && bl2);
        this.mnuLogRemove.setEnabled(bl && bl3);
        this.mnuLogRemoveAll.setEnabled(bl && bl2);
    }

    private void updVarActionsEnabled() {
        boolean bl = this.tabbedPane.getSelectedIndex() == 2;
        boolean bl2 = !this.tableModelVar.isEmpty();
        boolean bl3 = this.tableVar.getSelectedRow() >= 0;
        this.mnuVarEdit.setEnabled(bl && bl3);
        this.mnuVarRemove.setEnabled(bl && bl3);
        this.mnuVarRemoveAll.setEnabled(bl && bl2);
    }

    public class BreakpointList
    extends JList<AbstractBreakpoint> {
        public BreakpointList(BreakpointListModel breakpointListModel) {
            super(breakpointListModel);
        }
    }
}

