/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import jkcemu.base.EmuUtil;
import jkcemu.tools.Label;

public class ToolsUtil {
    public static int getReassAddr(JTextArea jTextArea, Point point) {
        int n = -1;
        if (point != null) {
            try {
                int n2;
                String string;
                int n3;
                int n4 = jTextArea.viewToModel(point);
                if (n4 >= 0 && (n3 = jTextArea.getLineOfOffset(n4)) >= 0 && (n4 = jTextArea.getLineStartOffset(n3)) >= 0 && (string = jTextArea.getText()) != null && n4 + 4 < string.length() && string.charAt(n4 + 4) == ' ' && (n2 = EmuUtil.getHex4(string, n4)) >= 0) {
                    n = n2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Label[] readLabels(Reader reader) throws IOException {
        TreeSet<1> treeSet = null;
        if (reader != null) {
            BufferedReader bufferedReader = new BufferedReader(reader);
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    String[] stringArray = string.split("\\s");
                    if (stringArray != null) {
                        String string2 = null;
                        int n = -1;
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string3 = stringArray[i];
                            if (string3 == null || (string3 = string3.trim()).isEmpty()) continue;
                            boolean bl = false;
                            if (n < 0 && (n = ToolsUtil.parseLabelValue(string3)) >= 0) {
                                bl = true;
                            }
                            if (bl || string2 != null) continue;
                            string2 = ToolsUtil.parseLabelName(string3, n < 0);
                        }
                        if (n >= 0) {
                            if (treeSet == null) {
                                treeSet = new TreeSet<1>();
                            }
                            final String string4 = string2;
                            final int n2 = n;
                            treeSet.add(new Label(){

                                @Override
                                public int compareTo(Label label) {
                                    int n = EmuUtil.compare(string4, label.getLabelName());
                                    if (n == 0) {
                                        n = n2 - label.intValue();
                                    }
                                    return n;
                                }

                                @Override
                                public String getLabelName() {
                                    return string4;
                                }

                                @Override
                                public int getVarSize() {
                                    return -1;
                                }

                                @Override
                                public int intValue() {
                                    return n2;
                                }
                            });
                        }
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
            finally {
                EmuUtil.closeSilent(bufferedReader);
            }
        }
        return treeSet != null ? treeSet.toArray(new Label[treeSet.size()]) : null;
    }

    private static String parseLabelName(String string, boolean bl) {
        int n;
        String string2 = null;
        if (string != null && (n = string.length()) > 0) {
            char c;
            int n2 = n;
            if (bl && string.charAt(n - 1) == ':') {
                n2 = n - 1;
            }
            if (n2 > 0 && ((c = string.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '$' || c == '.')) {
                for (int i = 1; i < n2; ++i) {
                    c = string.charAt(i);
                    if (c >= 'A' && c <= 'Z' || c >= 'a' || c <= 'z' || c >= '0' || c <= '9' || c == '_' || c == '$' || c == '.') continue;
                    n2 = 0;
                    break;
                }
                if (n2 > 0) {
                    string2 = n2 < n ? string.substring(0, n2) : string;
                }
            }
        }
        return string2;
    }

    private static int parseLabelValue(String string) {
        int n = -1;
        if (string != null) {
            int n2;
            int n3 = string.length();
            if (n3 > 1 && ((n2 = string.charAt(n3 - 1)) == 72 || n2 == 104)) {
                --n3;
            }
            if (n3 == 4 || n3 == 5) {
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    char c = string.charAt(i);
                    if (c >= '0' && c <= '9') {
                        n2 = n2 << 4 | c - 48;
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        n2 = n2 << 4 | c - 65 + 10;
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        n2 = n2 << 4 | c - 97 + 10;
                        continue;
                    }
                    n2 = -1;
                    break;
                }
                if (n2 >= 0 && n2 <= 65535) {
                    n = n2;
                }
            }
        }
        return n;
    }
}

