/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.ReplyIntDlg;
import jkcemu.base.ScreenFrm;
import jkcemu.base.UserCancelException;
import jkcemu.print.PlainTextPrintable;
import jkcemu.print.PrintOptionsDlg;
import jkcemu.print.PrintUtil;
import jkcemu.programming.AbstractOptionsDlg;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.PrgSource;
import jkcemu.programming.PrgThread;
import jkcemu.programming.assembler.AsmOptionsDlg;
import jkcemu.programming.assembler.AsmThread;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.BasicCompilerThread;
import jkcemu.programming.basic.BasicOptions;
import jkcemu.programming.basic.BasicOptionsDlg;
import jkcemu.text.CharConverter;
import jkcemu.text.EditText;
import jkcemu.text.FindTextDlg;
import jkcemu.text.LineAddrRowHeader;
import jkcemu.text.LogFrm;
import jkcemu.text.ReplyShiftWidthDlg;
import jkcemu.text.ReplyTabSizeDlg;
import jkcemu.text.SaveTextDlg;
import jkcemu.text.SelectEncodingDlg;
import jkcemu.text.TextPropDlg;
import jkcemu.text.TextUtil;
import jkcemu.tools.debugger.DebugFrm;

public class TextEditFrm
extends BaseFrm
implements ChangeListener,
DropTargetListener,
FlavorListener {
    public static final String PROP_SHOW_LINE_ADDRS = "jkcemu.texteditor.show_line_addrs";
    public static final String PROP_TABSIZE = "jkcemu.texteditor.tabsize";
    public static final String PROP_SHIFT_WIDTH = "jkcemu.texteditor.shift.width";
    public static final String PROP_SHIFT_USE_TABS = "jkcemu.texteditor.shift.use_tabs";
    private static final String DEFAULT_STATUS_TEXT = "Bereit";
    private static final String HELP_PAGE = "/help/tools/texteditor.htm";
    private static TextEditFrm instance = null;
    private static FileFilter[] textFileFilters = null;
    private EmuThread emuThread;
    private JMenuItem mnuFileNew;
    private JMenuItem mnuFileOpen;
    private JMenuItem mnuFileOpenCharset;
    private JMenuItem mnuFileSave;
    private JMenuItem mnuFileSaveAs;
    private JMenuItem mnuFilePrintOptions;
    private JMenuItem mnuFilePrint;
    private JMenuItem mnuFileProperties;
    private JMenuItem mnuFileTabClose;
    private JMenuItem mnuFileClose;
    private JMenuItem mnuEditUndo;
    private JMenuItem mnuEditCut;
    private JMenuItem mnuEditCopy;
    private JMenuItem mnuEditPaste;
    private JMenuItem mnuEditUpper;
    private JMenuItem mnuEditLower;
    private JMenuItem mnuEditTabSize;
    private JMenuItem mnuEditTabToSpaces;
    private JMenuItem mnuEditShiftIn;
    private JMenuItem mnuEditShiftOut;
    private JMenuItem mnuEditShiftWidth;
    private JMenuItem mnuEditUmlautGerToUni;
    private JMenuItem mnuEditUmlautDosToUni;
    private JMenuItem mnuEditRemoveWordstarFmt;
    private JMenuItem mnuEditFind;
    private JMenuItem mnuEditFindPrev;
    private JMenuItem mnuEditFindNext;
    private JMenuItem mnuEditReplace;
    private JMenuItem mnuEditBracket;
    private JMenuItem mnuEditGoto;
    private JMenuItem mnuEditSelectAll;
    private JMenuItem mnuPrgAssemble;
    private JMenuItem mnuPrgAssembleRun;
    private JMenuItem mnuPrgAssembleOpt;
    private JCheckBoxMenuItem mnuPrgLineAddrs;
    private JMenuItem mnuRemoveRowHeader;
    private JMenuItem mnuPrgCompile;
    private JMenuItem mnuPrgCompileRun;
    private JMenuItem mnuPrgCompileOpt;
    private JMenuItem mnuPrgCancel;
    private JMenuItem mnuPrjOpen;
    private JMenuItem mnuPrjSave;
    private JMenuItem mnuPrjSaveAs;
    private JMenuItem mnuHelpContent;
    private JPopupMenu mnuPopup;
    private JMenuItem mnuPopupCut;
    private JMenuItem mnuPopupCopy;
    private JMenuItem mnuPopupPaste;
    private JMenuItem mnuPopupFind;
    private JMenuItem mnuPopupFindPrev;
    private JMenuItem mnuPopupFindNext;
    private JMenuItem mnuPopupReplace;
    private JMenuItem mnuPopupBreak;
    private JMenuItem mnuPopupSelectAll;
    private JButton btnNew;
    private JButton btnOpen;
    private JButton btnSave;
    private JButton btnPrint;
    private JButton btnClose;
    private JButton btnUndo;
    private JButton btnCut;
    private JButton btnCopy;
    private JButton btnPaste;
    private JButton btnFind;
    private JTabbedPane tabbedPane;
    private JLabel labelStatus;
    private List<EditText> editTexts;
    private boolean hasTextFind;
    private boolean findIgnoreCase;
    private String textFind;
    private String textReplace;
    private Clipboard clipboard;
    private LogFrm logFrm;
    private PrgThread prgThread;
    private AbstractOptionsDlg prgOptionsDlg;
    private int lastNewTextNum;
    private int popupLineAddr;
    private int shiftWidth;
    private boolean shiftUseTabs;

    public static TextEditFrm open(EmuThread emuThread) {
        if (instance == null) {
            instance = new TextEditFrm(emuThread);
        }
        EmuUtil.showFrame(instance);
        return instance;
    }

    public static TextEditFrm open(EmuThread emuThread, File file) {
        TextEditFrm textEditFrm = TextEditFrm.open(emuThread);
        if (file != null) {
            textEditFrm.openFile(file);
        }
        return textEditFrm;
    }

    public void caretPositionChanged() {
        this.updCaretButtons();
        this.updStatusBar();
    }

    public boolean contains(EditText editText) {
        return editText != null ? this.editTexts.contains(editText) : false;
    }

    public void dataChangedStateChanged(EditText editText) {
        EditText editText2 = this.getSelectedEditText();
        if (editText2 != null && editText2 == editText) {
            this.setSaveBtnsEnabled(!editText2.isSaved());
            this.setSavePrjBtnsEnabled(editText2.hasProjectChanged());
        }
    }

    public void doPrgCancel() {
        PrgThread prgThread = this.prgThread;
        if (prgThread != null) {
            prgThread.cancel();
        }
    }

    public int getNewTextNum() {
        return ++this.lastNewTextNum;
    }

    public boolean getShiftUseTabs() {
        return this.shiftUseTabs;
    }

    public int getShiftWidth() {
        return this.shiftWidth;
    }

    public static FileFilter[] getTextFileFilters() {
        if (textFileFilters == null) {
            textFileFilters = new FileFilter[2];
            TextEditFrm.textFileFilters[0] = new FileNameExtensionFilter("Quelltextdateien (*.asm; *.bas)", "asm", "bas");
            TextEditFrm.textFileFilters[1] = EmuUtil.getTextFileFilter();
        }
        return textFileFilters;
    }

    public void gotoLine(final JTextArea jTextArea, int n) {
        String string = jTextArea.getText();
        int n2 = 0;
        try {
            n2 = jTextArea.getLineStartOffset(n - 1);
        }
        catch (BadLocationException badLocationException) {
            n2 = string != null ? string.length() : 0;
        }
        jTextArea.requestFocus();
        final int n3 = n2;
        try {
            jTextArea.setCaretPosition(n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string != null) {
            try {
                int n4 = string.indexOf(10, n3);
                if (n4 > n3) {
                    jTextArea.moveCaretPosition(n4);
                    Timer timer = new Timer(500, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                jTextArea.setCaretPosition(n3);
                                jTextArea.moveCaretPosition(n3);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProject(File file) throws IOException {
        Properties properties = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties = new Properties();
            properties.loadFromXML(fileInputStream);
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            try {
                properties = null;
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(fileInputStream);
                throw throwable;
            }
            EmuUtil.closeSilent(fileInputStream);
        }
        EmuUtil.closeSilent(fileInputStream);
        if (properties != null) {
            String string = properties.getProperty("jkcemu.properties.type");
            if (string != null) {
                if (!string.equals("project")) {
                    properties = null;
                }
            } else {
                properties = null;
            }
        }
        return properties;
    }

    public void openFile(File file) {
        Properties properties = null;
        try {
            properties = TextEditFrm.loadProject(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (properties != null) {
            this.setState(0);
            this.toFront();
            Object[] objectArray = new String[]{"Projekt", "Inhalt", "Abbrechen"};
            int n = JOptionPane.showOptionDialog(this, "Die ausgew\u00e4hlte Datei ist eine JKCEMU-Projektdatei.\nM\u00f6chten Sie das Projekt oder den Inhalt\nder Projektdatei \u00f6ffnen?", "Projektdatei ausgew\u00e4hlt", 1, 3, null, objectArray, "Projekt");
            if (n == 0) {
                this.openProject(file, properties);
            } else if (n == 1) {
                this.openTextFile(file);
            }
        } else {
            this.openTextFile(file);
        }
    }

    public void openProject(File file, Properties properties) {
        String string;
        if (properties != null && (string = properties.getProperty("jkcemu.programming.source.file.name")) != null) {
            Object object;
            File file2 = new File(string);
            if (!file2.isAbsolute() && (object = file.getParentFile()) != null) {
                file2 = new File((File)object, string);
            }
            if ((object = this.openTextFile(file2)) != null) {
                ((EditText)object).setProject(file, properties);
                Main.setLastFile(file, "project");
            }
        }
    }

    public EditText openText(String string) {
        EditText editText = this.getSelectedEditText();
        if (editText != null && editText.isUsed()) {
            editText = null;
        }
        if (editText == null) {
            editText = this.doFileNew();
        }
        editText.setText(string);
        return editText;
    }

    public void setSelectedTabComponent(Component component) {
        if (component != null) {
            this.tabbedPane.setSelectedComponent(component);
            this.updTitle();
            this.updUndoButtons();
            this.updCaretButtons();
            this.updPasteButtons();
            this.updStatusBar();
        }
    }

    public void setShiftUseTabs(boolean bl) {
        this.shiftUseTabs = bl;
    }

    public void setShiftWidth(int n) {
        this.shiftWidth = n;
    }

    public void threadTerminated(final Thread thread) {
        if (thread != null && thread == this.prgThread) {
            this.prgThread = null;
            final JMenuItem jMenuItem = this.mnuPrgCancel;
            final JCheckBoxMenuItem jCheckBoxMenuItem = this.mnuPrgLineAddrs;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jMenuItem.setEnabled(false);
                    TextEditFrm.this.updFileButtons();
                    if (thread instanceof AsmThread && jCheckBoxMenuItem.isSelected()) {
                        TextEditFrm.this.setLineAddrs(((AsmThread)thread).getPrgSources());
                    }
                }
            });
        }
    }

    public void updCaretButtons() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            boolean bl = jTextArea.getSelectionEnd() > jTextArea.getSelectionStart();
            boolean bl2 = jTextArea.isEditable();
            this.setCutBtnsEnabled(bl && bl2);
            this.setCopyBtnsEnabled(bl);
            this.setReplaceBtnsEnabled(bl && bl2);
        } else {
            this.setCutBtnsEnabled(false);
            this.setCopyBtnsEnabled(false);
            this.setReplaceBtnsEnabled(false);
        }
    }

    public void updUndoButtons() {
        EditText editText = this.getSelectedEditText();
        this.setUndoBtnsEnabled(editText != null ? editText.canUndo() : false);
    }

    public void updTitle() {
        this.updTitle(this.getSelectedEditText());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent != null && changeEvent.getSource() == this.tabbedPane) {
            this.updTitle();
            this.updFileButtons();
            this.updUndoButtons();
            this.updCaretButtons();
            this.updPasteButtons();
            this.updStatusBar();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null) {
            this.openFile(file);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        if (this.clipboard != null && flavorEvent.getSource() == this.clipboard) {
            this.updPasteButtons();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        JTextArea jTextArea;
        super.setVisible(bl);
        if (bl && !this.editTexts.isEmpty() && (jTextArea = this.editTexts.get(0).getJTextArea()) != null) {
            jTextArea.setColumns(0);
            jTextArea.setRows(0);
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        boolean bl2 = super.applySettings(properties, bl);
        AbstractOptionsDlg abstractOptionsDlg = this.prgOptionsDlg;
        if (abstractOptionsDlg != null) {
            abstractOptionsDlg.settingsChanged();
        }
        this.mnuPrgLineAddrs.setSelected(EmuUtil.getBooleanProperty(properties, PROP_SHOW_LINE_ADDRS, true));
        this.updShowLineAddrs();
        return bl2;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.mnuFileNew || object == this.btnNew) {
                bl = true;
                this.doFileNew();
            } else if (object == this.mnuFileOpen || object == this.btnOpen) {
                bl = true;
                this.doFileOpen();
            } else if (object == this.mnuFileOpenCharset) {
                bl = true;
                this.doFileOpenCharset();
            } else if (object == this.mnuFileSave || object == this.btnSave) {
                bl = true;
                this.doFileSave(false);
            } else if (object == this.mnuFileSaveAs) {
                bl = true;
                this.doFileSave(true);
            } else if (object == this.mnuFilePrintOptions) {
                bl = true;
                this.doFilePrintOptions();
            } else if (object == this.mnuFilePrint || object == this.btnPrint) {
                bl = true;
                this.doFilePrint();
            } else if (object == this.mnuFileProperties) {
                bl = true;
                this.doFileProperties();
            } else if (object == this.mnuFileTabClose || object == this.btnClose) {
                bl = true;
                this.doFileClose();
            } else if (object == this.mnuFileClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuEditUndo || object == this.btnUndo) {
                bl = true;
                this.doEditUndo();
            } else if (object == this.mnuEditCut || object == this.mnuPopupCut || object == this.btnCut) {
                bl = true;
                this.doEditCut();
            } else if (object == this.mnuEditCopy || object == this.mnuPopupCopy || object == this.btnCopy) {
                bl = true;
                this.doEditCopy();
            } else if (object == this.mnuEditPaste || object == this.mnuPopupPaste || object == this.btnPaste) {
                bl = true;
                this.doEditPaste();
            } else if (object == this.mnuEditUpper) {
                bl = true;
                this.doEditUpper();
            } else if (object == this.mnuEditLower) {
                bl = true;
                this.doEditLower();
            } else if (object == this.mnuEditTabSize) {
                bl = true;
                this.doEditTabSize();
            } else if (object == this.mnuEditTabToSpaces) {
                bl = true;
                this.doEditTabToSpaces();
            } else if (object == this.mnuEditShiftIn) {
                bl = true;
                this.doEditShift(false);
            } else if (object == this.mnuEditShiftOut) {
                bl = true;
                this.doEditShift(true);
            } else if (object == this.mnuEditShiftWidth) {
                bl = true;
                new ReplyShiftWidthDlg(this).setVisible(true);
            } else if (object == this.mnuEditUmlautGerToUni) {
                bl = true;
                this.doEditUmlautGerToUni();
            } else if (object == this.mnuEditUmlautDosToUni) {
                bl = true;
                this.doEditUmlautDosToUni();
            } else if (object == this.mnuEditRemoveWordstarFmt) {
                bl = true;
                this.doEditRemoveWordstarFmt();
            } else if (object == this.mnuEditFind || object == this.mnuPopupFind || object == this.btnFind) {
                bl = true;
                this.doEditFind();
            } else if (object == this.mnuEditFindPrev || object == this.mnuPopupFindPrev) {
                bl = true;
                this.doEditFindNext(true);
            } else if (object == this.mnuEditFindNext || object == this.mnuPopupFindNext) {
                bl = true;
                this.doEditFindNext(false);
            } else if (object == this.mnuEditReplace || object == this.mnuPopupReplace) {
                bl = true;
                this.doEditReplace();
            } else if (object == this.mnuEditBracket) {
                bl = true;
                this.doEditBracket();
            } else if (object == this.mnuEditGoto) {
                bl = true;
                this.doEditGoto();
            } else if (object == this.mnuEditSelectAll || object == this.mnuPopupSelectAll) {
                bl = true;
                this.doEditSelectAll();
            } else if (object == this.mnuPrgAssemble) {
                bl = true;
                this.doPrgAssemble(false, false);
            } else if (object == this.mnuPrgAssembleRun) {
                bl = true;
                this.doPrgAssemble(false, true);
            } else if (object == this.mnuPrgAssembleOpt) {
                bl = true;
                this.doPrgAssemble(true, false);
            } else if (object == this.mnuPrgLineAddrs) {
                bl = true;
                this.updShowLineAddrs();
            } else if (object == this.mnuRemoveRowHeader) {
                bl = true;
                this.doRemoveRowHeader();
            } else if (object == this.mnuPrgCompile) {
                bl = true;
                this.doPrgCompile(false, false);
            } else if (object == this.mnuPrgCompileRun) {
                bl = true;
                this.doPrgCompile(false, true);
            } else if (object == this.mnuPrgCompileOpt) {
                bl = true;
                this.doPrgCompile(true, false);
            } else if (object == this.mnuPrgCancel) {
                bl = true;
                this.doPrgCancel();
            } else if (object == this.mnuPrjSave) {
                bl = true;
                this.doPrjSave(false);
            } else if (object == this.mnuPrjSaveAs) {
                bl = true;
                this.doPrjSave(true);
            } else if (object == this.mnuPrjOpen) {
                bl = true;
                this.doPrjOpen();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else if (object == this.mnuPopupBreak) {
                bl = true;
                this.doCreateBreakpoint();
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = true;
        if (this.logFrm != null) {
            this.logFrm.doClose();
        }
        while (bl && !this.editTexts.isEmpty()) {
            EditText editText = this.editTexts.get(0);
            this.setSelectedEditText(editText);
            bl = this.doFileClose();
        }
        if (bl) {
            bl = super.doClose();
        }
        if (bl && !Main.checkQuit(this)) {
            this.lastNewTextNum = 0;
            this.doFileNew();
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        if (this.mnuPopup != null) {
            SwingUtilities.updateComponentTreeUI(this.mnuPopup);
        }
    }

    @Override
    public void putSettingsTo(Properties properties) {
        if (properties != null) {
            super.putSettingsTo(properties);
            properties.setProperty(PROP_SHOW_LINE_ADDRS, String.valueOf(this.mnuPrgLineAddrs.isSelected()));
        }
    }

    @Override
    public void resetFired() {
        this.removeRowHeaders();
    }

    @Override
    protected boolean showPopup(MouseEvent mouseEvent) {
        boolean bl = false;
        Component component = mouseEvent.getComponent();
        if (component != null) {
            this.popupLineAddr = -1;
            if (this.mnuPopupBreak != null) {
                PrgOptions prgOptions;
                EditText editText = this.getSelectedEditText();
                if (editText != null && (prgOptions = editText.getPrgOptions()) != null && prgOptions.getCodeToEmu()) {
                    this.popupLineAddr = this.getLineAddr(mouseEvent);
                }
                this.mnuPopupBreak.setEnabled(this.popupLineAddr >= 0);
            }
            this.mnuPopup.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    private EditText doFileNew() {
        JTextArea jTextArea = this.createJTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        EditText editText = new EditText(this, jScrollPane, jTextArea);
        this.editTexts.add(editText);
        this.tabbedPane.addTab(editText.getName(), jScrollPane);
        this.setSelectedTabComponent(jScrollPane);
        this.updFileButtons();
        this.updStatusBar();
        return editText;
    }

    private void doFileOpen() {
        File file = EmuUtil.showFileOpenDlg(this, "Textdatei \u00f6ffnen", Main.getLastDirFile("text"), TextEditFrm.getTextFileFilters());
        if (file != null) {
            this.openFile(file);
        }
    }

    private void doFileOpenCharset() {
        File file = EmuUtil.showFileOpenDlg(this, "Textdatei \u00f6ffnen mit Zeichensatz", Main.getLastDirFile("text"), TextEditFrm.getTextFileFilters());
        if (file != null && this.checkFileAlreadyOpen(file) == null) {
            SelectEncodingDlg selectEncodingDlg = new SelectEncodingDlg(this);
            selectEncodingDlg.setVisible(true);
            this.forceOpenFile(file, selectEncodingDlg.getCharConverter(), selectEncodingDlg.getEncodingName(), selectEncodingDlg.getEncodingDisplayText(), selectEncodingDlg.getIgnoreEofByte());
        }
    }

    private boolean doFileSave(boolean bl) {
        boolean bl2 = false;
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            bl |= editText.getAskFileNameOnSave();
            try {
                if (SaveTextDlg.saveFile(editText, this.editTexts, bl)) {
                    int n;
                    Component component = editText.getTabComponent();
                    if (component != null && (n = this.tabbedPane.indexOfComponent(component)) >= 0) {
                        this.tabbedPane.setTitleAt(n, editText.getName());
                    }
                    bl2 = true;
                    editText.setAskFileNameOnSave(false);
                    this.labelStatus.setText("Datei gespeichert");
                }
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, "Die Datei kann nicht gespeichert werden.\n\n" + iOException.getMessage());
            }
        }
        return bl2;
    }

    private void doFilePrintOptions() {
        if (PrintOptionsDlg.showPrintOptionsDlg(this, true, true)) {
            this.labelStatus.setText("Druckoptionen ge\u00e4ndert");
        }
    }

    private void doFilePrint() {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            File file = editText.getFile();
            if (PrintUtil.doPrint(this, new PlainTextPrintable(editText.getText(), editText.getTabSize(), file != null ? file.getName() : null), editText.getName())) {
                this.labelStatus.setText("Datei gedruckt");
            }
        }
    }

    private void doFileProperties() {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            new TextPropDlg((Frame)this, editText).setVisible(true);
        }
    }

    private boolean doFileClose() {
        boolean bl = false;
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            Object object;
            Component component;
            Object[] objectArray;
            boolean bl2 = editText.hasDataChanged();
            boolean bl3 = false;
            if (editText.getProjectFile() != null) {
                bl3 = editText.hasProjectChanged();
            }
            if (bl2 || bl3) {
                objectArray = new String[]{"Speichern", "Verwerfen", "Abbrechen"};
                component = new JOptionPane(String.format("%s wurde ge\u00e4ndert und nicht gespeichert.\nM\u00f6chten Sie jetzt speichern?", bl3 ? "Das Projekt" : "Der Text"), 2);
                ((JOptionPane)component).setWantsInput(false);
                ((JOptionPane)component).setOptions(objectArray);
                ((JOptionPane)component).setInitialValue(objectArray[0]);
                this.setState(0);
                this.toFront();
                ((JOptionPane)component).createDialog(this, "Daten ge\u00e4ndert").setVisible(true);
                object = ((JOptionPane)component).getValue();
                if (object != null) {
                    if (object.equals(objectArray[0])) {
                        bl = true;
                        if (bl2 && !this.doFileSave(false)) {
                            bl = false;
                        }
                        if (bl && bl3 && !editText.saveProject(this, false)) {
                            bl = false;
                        }
                    } else if (object.equals(objectArray[1])) {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                objectArray = this.prgThread;
                if (objectArray != null && editText == objectArray.getEditText()) {
                    objectArray.cancel();
                }
                if ((component = editText.getTabComponent()) != null) {
                    this.tabbedPane.remove(component);
                }
                if ((object = editText.getJTextArea()) != null) {
                    ((Component)object).removeMouseListener(this);
                }
                this.editTexts.remove(editText);
                editText.die();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextEditFrm.this.updTitle(TextEditFrm.this.getSelectedEditText());
                        TextEditFrm.this.updUndoButtons();
                        TextEditFrm.this.updCaretButtons();
                        TextEditFrm.this.updPasteButtons();
                        TextEditFrm.this.updFileButtons();
                        TextEditFrm.this.updStatusBar();
                    }
                });
            }
        } else {
            bl = super.doClose();
        }
        return bl;
    }

    private void doEditUndo() {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            editText.undo();
            this.updUndoButtons();
        }
    }

    private void doEditCut() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            jTextArea.cut();
        }
    }

    private void doEditCopy() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            jTextArea.copy();
        }
    }

    private void doEditPaste() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            jTextArea.paste();
        }
    }

    private void doEditUpper() {
        String string;
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null && (string = jTextArea.getSelectedText()) != null && !string.isEmpty()) {
            jTextArea.replaceSelection(string.toUpperCase());
        }
    }

    private void doEditLower() {
        String string;
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null && (string = jTextArea.getSelectedText()) != null && !string.isEmpty()) {
            jTextArea.replaceSelection(string.toLowerCase());
        }
    }

    private void doEditTabSize() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            new ReplyTabSizeDlg((Frame)this, jTextArea).setVisible(true);
        }
    }

    private void doEditTabToSpaces() {
        String string;
        EditText editText = this.getSelectedEditText();
        if (editText != null && (string = editText.getText()) != null) {
            if (string.indexOf(9) < 0) {
                BaseDlg.showInfoDlg(this, "Der Text enth\u00e4lt keine Tabulatoren.");
            } else if (BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie die Tabulatoren durch Leerzeichen ersetzen?")) {
                int n = editText.getTabSize();
                int n2 = editText.getCaretPosition();
                int n3 = -1;
                int n4 = string.length();
                StringBuilder stringBuilder = new StringBuilder(2 * n4);
                int n5 = 0;
                int n6 = 0;
                block4: for (int i = 0; i < n4; ++i) {
                    if (n2 >= 0 && n2 == i) {
                        n3 = stringBuilder.length();
                    }
                    char c = string.charAt(i);
                    switch (c) {
                        case '\n': {
                            stringBuilder.append(c);
                            n6 = 0;
                            continue block4;
                        }
                        case '\t': {
                            int n7 = n - n6 % n;
                            for (int j = 0; j < n7; ++j) {
                                stringBuilder.append(' ');
                                ++n6;
                            }
                            ++n5;
                            continue block4;
                        }
                        default: {
                            stringBuilder.append(c);
                            ++n6;
                        }
                    }
                }
                if (n5 > 0) {
                    editText.replaceText(stringBuilder.toString());
                    editText.setDataChanged();
                }
                this.showConvResult(n5);
                if (n3 >= 0) {
                    editText.setCaretPosition(n3);
                }
            }
        }
    }

    private void doEditShift(boolean bl) {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            int n;
            String string = jTextArea.getText();
            int n2 = jTextArea.getSelectionStart();
            int n3 = jTextArea.getSelectionEnd();
            if (n3 < n2) {
                n = n3;
                n3 = n2;
                n2 = n;
            }
            if (string != null) {
                n = string.length();
                if (n2 >= 0 && n2 < n) {
                    String string2;
                    boolean bl2;
                    boolean bl3 = bl2 = n3 > n2;
                    if (n3 < n2) {
                        n3 = n2;
                    } else if (n3 > n) {
                        n3 = n;
                    }
                    int n4 = jTextArea.getTabSize();
                    if (n4 < 1) {
                        n4 = 8;
                    }
                    while (n2 > 0 && string.charAt(n2 - 1) != '\n') {
                        --n2;
                    }
                    boolean bl4 = false;
                    if (bl2 && n3 > 0 && string.charAt(n3 - 1) == '\n') {
                        bl4 = true;
                    }
                    if (!bl4) {
                        while (n3 < n && string.charAt(n3++) != '\n') {
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder(2 * n);
                    int n5 = n2;
                    while (n5 < n3) {
                        int n6 = string.indexOf(10, n5);
                        if (n6 >= n5 && n6 + 1 < n) {
                            this.appendShiftedLine(stringBuilder, string.substring(n5, Math.min(n6 + 1, n3)), n4, bl);
                            n5 = n6 + 1;
                            continue;
                        }
                        if (n3 < n - 1) {
                            this.appendShiftedLine(stringBuilder, string.substring(n5, n3), n4, bl);
                            break;
                        }
                        this.appendShiftedLine(stringBuilder, string.substring(n5), n4, bl);
                        break;
                    }
                    String string3 = stringBuilder.toString();
                    String string4 = string2 = n3 + 1 < n ? string.substring(n2, n3) : string.substring(n2);
                    if (!string3.equals(string2)) {
                        try {
                            jTextArea.replaceRange(stringBuilder.toString(), n2, n3);
                            if (bl2) {
                                jTextArea.setCaretPosition(n3);
                                jTextArea.setSelectionStart(n2);
                                jTextArea.setSelectionEnd(n2 + stringBuilder.length());
                            } else {
                                jTextArea.setCaretPosition(n2);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private void doEditUmlautGerToUni() {
        String string;
        EditText editText = this.getSelectedEditText();
        if (editText != null && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie die Zeichen \"[\\]{|}~\"\nin deutsche Umlaute konvertieren?") && (string = editText.getText()) != null) {
            int n = editText.getCaretPosition();
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            int n3 = 0;
            int n4 = 0;
            block9: while (n3 < n2) {
                char c = string.charAt(n3++);
                switch (c) {
                    case '[': {
                        stringBuilder.append('\u00c4');
                        ++n4;
                        continue block9;
                    }
                    case '\\': {
                        stringBuilder.append('\u00d6');
                        ++n4;
                        continue block9;
                    }
                    case ']': {
                        stringBuilder.append('\u00dc');
                        ++n4;
                        continue block9;
                    }
                    case '{': {
                        stringBuilder.append('\u00e4');
                        ++n4;
                        continue block9;
                    }
                    case '|': {
                        stringBuilder.append('\u00f6');
                        ++n4;
                        continue block9;
                    }
                    case '}': {
                        stringBuilder.append('\u00fc');
                        ++n4;
                        continue block9;
                    }
                    case '~': {
                        stringBuilder.append('\u00df');
                        ++n4;
                        continue block9;
                    }
                }
                stringBuilder.append(c);
            }
            if (n4 > 0) {
                editText.replaceText(stringBuilder.toString());
                editText.setDataChanged();
            }
            this.showConvResult(n4);
            editText.setCaretPosition(n);
        }
    }

    private void doEditUmlautDosToUni() {
        String string;
        EditText editText = this.getSelectedEditText();
        if (editText != null && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie die im DOS-Zeichensatz kodierten\ndeutschen Umlaute konvertieren und so sichtbar machen?") && (string = editText.getText()) != null) {
            int n = editText.getCaretPosition();
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            int n3 = 0;
            int n4 = 0;
            block9: while (n3 < n2) {
                char c = string.charAt(n3++);
                switch (c) {
                    case '\u008e': {
                        stringBuilder.append('\u00c4');
                        ++n4;
                        continue block9;
                    }
                    case '\u0099': {
                        stringBuilder.append('\u00d6');
                        ++n4;
                        continue block9;
                    }
                    case '\u009a': {
                        stringBuilder.append('\u00dc');
                        ++n4;
                        continue block9;
                    }
                    case '\u0084': {
                        stringBuilder.append('\u00e4');
                        ++n4;
                        continue block9;
                    }
                    case '\u0094': {
                        stringBuilder.append('\u00f6');
                        ++n4;
                        continue block9;
                    }
                    case '\u0081': {
                        stringBuilder.append('\u00fc');
                        ++n4;
                        continue block9;
                    }
                    case '\u00e1': {
                        stringBuilder.append('\u00df');
                        ++n4;
                        continue block9;
                    }
                }
                stringBuilder.append(c);
            }
            if (n4 > 0) {
                editText.replaceText(stringBuilder.toString());
                editText.setDataChanged();
            }
            this.showConvResult(n4);
            editText.setCaretPosition(n);
        }
    }

    private void doEditRemoveWordstarFmt() {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            String string;
            String string2 = "M\u00f6chten Sie die WordStar-Formatierungen entfernen\nund so aus der Datei eine reine Textdatei machen?";
            if (editText.getCharsLostOnOpen()) {
                string2 = "Beim \u00d6ffnen der Datei konnten nicht alle Bytes in Zeichen gemappt werden.\nDadurch k\u00f6nnen Zeichen fehlen oder der Text anderweitig zerst\u00f6rt sein.\nAus diesem Grund sollten Sie die Datei zuerst mit dem Zeichensatz\nISO-8859-1 (Latin 1) \u00f6ffnen (Men\u00fcpunkt 'Datei \u00f6ffnen mit Zeichensatz...')\nund dann erst die WordStar-Formatierungen entfernen.\n\n" + string2;
            }
            if (BaseDlg.showYesNoDlg(this, string2) && (string = editText.getText()) != null) {
                int n = editText.getCaretPosition();
                int n2 = -1;
                int n3 = string.length();
                int n4 = 0;
                boolean bl = true;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder(n3);
                while (n4 < n3) {
                    if (n2 < 0 && n == n4) {
                        n2 = stringBuilder.length();
                    }
                    char c = string.charAt(n4++);
                    if (bl && c == '.') {
                        bl2 = true;
                    }
                    if ((c = (char)(c & 0x7F)) != '\n' && c != '\t' && c < ' ') continue;
                    if (!bl2) {
                        stringBuilder.append(c);
                    }
                    if (c <= ' ') {
                        bl2 = false;
                    }
                    if (c == '\n') {
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                editText.replaceText(stringBuilder.toString());
                editText.setDataChanged();
                editText.setCaretPosition(n2);
            }
        }
    }

    private void doEditFind() {
        JTextArea jTextArea;
        EditText editText = this.getSelectedEditText();
        if (editText != null && (jTextArea = editText.getJTextArea()) != null) {
            String string = jTextArea.getSelectedText();
            if (string != null && string.isEmpty()) {
                string = null;
            }
            if (string == null) {
                string = this.textFind;
            }
            FindTextDlg findTextDlg = new FindTextDlg((Frame)this, string, this.textReplace, this.findIgnoreCase);
            findTextDlg.setVisible(true);
            switch (findTextDlg.getAction()) {
                case FIND_NEXT: {
                    this.textFind = findTextDlg.getFindText();
                    this.textReplace = findTextDlg.getReplaceText();
                    this.findIgnoreCase = findTextDlg.getIgnoreCase();
                    this.findText(editText, jTextArea, Math.max(jTextArea.getCaretPosition(), jTextArea.getSelectionEnd()), false, true);
                    break;
                }
                case REPLACE_ALL: {
                    this.textFind = findTextDlg.getFindText();
                    this.textReplace = findTextDlg.getReplaceText();
                    this.findIgnoreCase = findTextDlg.getIgnoreCase();
                    boolean bl = this.findText(editText, jTextArea, 0, false, false);
                    int n = 0;
                    while (bl) {
                        if (this.replaceText(jTextArea)) {
                            ++n;
                        }
                        bl = this.findText(editText, jTextArea, Math.max(jTextArea.getCaretPosition(), jTextArea.getSelectionEnd()), false, false);
                    }
                    if (n == 0) {
                        TextUtil.showTextNotFound(this);
                        break;
                    }
                    BaseDlg.showInfoDlg(this, String.valueOf(n) + " Textersetzungen durchgef\u00fchrt.", "Text ersetzen");
                }
            }
        }
    }

    private void doEditFindNext(boolean bl) {
        JTextArea jTextArea;
        EditText editText = this.getSelectedEditText();
        if (editText != null && (jTextArea = editText.getJTextArea()) != null) {
            if (this.textFind == null) {
                this.doEditFind();
            } else if (bl) {
                this.findText(editText, jTextArea, Math.min(jTextArea.getCaretPosition(), jTextArea.getSelectionStart()) - 1, true, true);
            } else {
                this.findText(editText, jTextArea, Math.max(jTextArea.getCaretPosition(), jTextArea.getSelectionEnd()), false, true);
            }
        }
    }

    private void doEditReplace() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null && this.textReplace != null) {
            this.replaceText(jTextArea);
        }
    }

    private void doEditBracket() {
        String string;
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null && (string = jTextArea.getText()) != null) {
            Integer n = null;
            int n2 = string.length();
            int n3 = jTextArea.getCaretPosition();
            if (n3 >= 0 && n3 < n2) {
                char c = string.charAt(n3);
                block0 : switch (c) {
                    case '(': {
                        n = this.findBracket(string, n3, c, ')', 1);
                        break;
                    }
                    case ')': {
                        n = this.findBracket(string, n3, c, '(', -1);
                        break;
                    }
                    case '[': {
                        n = this.findBracket(string, n3, c, ']', 1);
                        break;
                    }
                    case ']': {
                        n = this.findBracket(string, n3, c, '[', -1);
                        break;
                    }
                    case '{': {
                        n = this.findBracket(string, n3, c, '}', 1);
                        break;
                    }
                    case '}': {
                        n = this.findBracket(string, n3, c, '{', -1);
                        break;
                    }
                    default: {
                        while (n3 < n2) {
                            c = string.charAt(n3);
                            if (c == ')' || c == ']' || c == '}') {
                                n = n3;
                                break block0;
                            }
                            ++n3;
                        }
                        break block0;
                    }
                }
                if (n != null) {
                    jTextArea.setCaretPosition(n);
                    jTextArea.requestFocus();
                }
            }
        }
    }

    private void doEditGoto() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            Integer n = null;
            try {
                n = jTextArea.getLineOfOffset(jTextArea.getCaretPosition()) + 1;
            }
            catch (BadLocationException badLocationException) {
                n = null;
            }
            ReplyIntDlg replyIntDlg = new ReplyIntDlg(this, "Zeilenummer:", n, 1, null);
            replyIntDlg.setTitle("Gehe zu Zeile");
            replyIntDlg.setVisible(true);
            n = replyIntDlg.getReply();
            if (n != null) {
                this.gotoLine(jTextArea, n);
            }
        }
    }

    private void doEditSelectAll() {
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null) {
            jTextArea.requestFocus();
            jTextArea.selectAll();
            this.updCaretButtons();
        }
    }

    private void doPrgAssemble(boolean bl, boolean bl2) {
        EditText editText;
        if (this.prgThread == null && (editText = this.getSelectedEditText()) != null) {
            PrgOptions prgOptions = editText.getPrgOptions();
            if (prgOptions != null && prgOptions instanceof BasicOptions) {
                bl = true;
            }
            if (bl || prgOptions == null) {
                this.prgOptionsDlg = new AsmOptionsDlg((Frame)this, this.emuThread, prgOptions);
                this.prgOptionsDlg.setVisible(true);
                prgOptions = this.prgOptionsDlg.getAppliedOptions();
                this.prgOptionsDlg = null;
            }
            if (prgOptions != null) {
                prgOptions.setForceRun(bl2);
                editText.setPrgOptions(prgOptions);
                AsmThread asmThread = new AsmThread(this.emuThread, editText, prgOptions, this.openLog(editText, editText.getName()));
                this.prgThread = asmThread;
                this.mnuPrgCancel.setEnabled(true);
                this.updFileButtons();
                asmThread.start();
            }
        }
    }

    private void doPrgCompile(boolean bl, boolean bl2) {
        EditText editText;
        if (this.prgThread == null && (editText = this.getSelectedEditText()) != null) {
            Runnable runnable;
            AbstractTarget abstractTarget = null;
            BasicOptions basicOptions = null;
            PrgOptions prgOptions = editText.getPrgOptions();
            if (prgOptions != null && prgOptions instanceof BasicOptions) {
                basicOptions = (BasicOptions)prgOptions;
                abstractTarget = basicOptions.getTarget();
            }
            if (!bl && this.emuThread != null) {
                bl = true;
                if (basicOptions != null) {
                    runnable = basicOptions.getEmuSys();
                    EmuSys emuSys = this.emuThread.getEmuSys();
                    if (runnable != null && emuSys != null && runnable == emuSys) {
                        bl = false;
                    }
                }
            }
            if (bl || abstractTarget == null || basicOptions == null) {
                basicOptions = null;
                this.prgOptionsDlg = new BasicOptionsDlg((Frame)this, this.emuThread, prgOptions);
                this.prgOptionsDlg.setVisible(true);
                prgOptions = this.prgOptionsDlg.getAppliedOptions();
                if (prgOptions != null && prgOptions instanceof BasicOptions) {
                    basicOptions = (BasicOptions)prgOptions;
                }
                this.prgOptionsDlg = null;
            }
            if (basicOptions != null) {
                if (this.emuThread != null) {
                    basicOptions.setEmuSys(this.emuThread.getEmuSys());
                }
                basicOptions.setForceRun(bl2);
                editText.setPrgOptions(basicOptions);
                runnable = new BasicCompilerThread(this.emuThread, editText, basicOptions, this.openLog(editText, editText.getName()));
                this.prgThread = runnable;
                this.mnuPrgCancel.setEnabled(true);
                this.updFileButtons();
                ((Thread)runnable).start();
            }
        }
    }

    private void doPrjOpen() {
        File file = EmuUtil.showFileOpenDlg(this, "Projekt \u00f6ffnen", Main.getLastDirFile("text"), EmuUtil.getProjectFileFilter());
        if (file != null) {
            try {
                Properties properties = TextEditFrm.loadProject(file);
                if (properties != null) {
                    this.openProject(file, properties);
                } else {
                    BaseDlg.showErrorDlg((Component)this, "Die ausgew\u00e4hlte Datei ist keine JKCEMU-Projektdatei.");
                }
            }
            catch (IOException iOException) {
                BaseDlg.showOpenFileErrorDlg(this, file, iOException);
            }
        }
    }

    private void doPrjSave(boolean bl) {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            editText.saveProject(this, bl);
        }
    }

    private void doRemoveRowHeader() {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            editText.removeRowHeader();
            this.updRemoveRowHeaderButtons();
        }
    }

    private void doCreateBreakpoint() {
        if (this.popupLineAddr >= 0) {
            EditText editText = this.getSelectedEditText();
            ScreenFrm screenFrm = Main.getScreenFrm();
            if (editText != null && screenFrm != null) {
                boolean bl = false;
                DebugFrm debugFrm = null;
                PrgOptions prgOptions = editText.getPrgOptions();
                if (prgOptions != null) {
                    bl = prgOptions.getCodeToSecondSystem();
                }
                if ((debugFrm = bl ? screenFrm.openSecondDebugger() : screenFrm.openPrimaryDebugger()) != null) {
                    debugFrm.doDebugBreakPCAdd(this.popupLineAddr);
                }
            }
        }
    }

    private TextEditFrm(EmuThread emuThread) {
        this.emuThread = emuThread;
        this.editTexts = new ArrayList<EditText>();
        this.hasTextFind = false;
        this.findIgnoreCase = true;
        this.textFind = null;
        this.textReplace = null;
        this.clipboard = null;
        this.logFrm = null;
        this.prgThread = null;
        this.prgOptionsDlg = null;
        this.lastNewTextNum = 0;
        this.popupLineAddr = -1;
        this.shiftWidth = Main.getIntProperty(PROP_SHIFT_WIDTH, 2);
        this.shiftUseTabs = Main.getBooleanProperty(PROP_SHIFT_USE_TABS, true);
        Main.updIcon(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuFileNew = this.createJMenuItem("Neuer Text", KeyStroke.getKeyStroke(78, 2));
        jMenu.add(this.mnuFileNew);
        this.mnuFileOpen = this.createJMenuItem("\u00d6ffnen...", KeyStroke.getKeyStroke(79, 2));
        jMenu.add(this.mnuFileOpen);
        this.mnuFileOpenCharset = this.createJMenuItem("\u00d6ffnen mit Zeichensatz...");
        jMenu.add(this.mnuFileOpenCharset);
        jMenu.addSeparator();
        this.mnuFileSave = this.createJMenuItem("Speichern", KeyStroke.getKeyStroke(83, 2));
        jMenu.add(this.mnuFileSave);
        this.mnuFileSaveAs = this.createJMenuItem("Speichern unter...", KeyStroke.getKeyStroke(83, 3));
        jMenu.add(this.mnuFileSaveAs);
        jMenu.addSeparator();
        this.mnuFilePrintOptions = this.createJMenuItem("Druckoptionen...");
        jMenu.add(this.mnuFilePrintOptions);
        this.mnuFilePrint = this.createJMenuItem("Drucken...", KeyStroke.getKeyStroke(80, 2));
        jMenu.add(this.mnuFilePrint);
        jMenu.addSeparator();
        this.mnuFileProperties = this.createJMenuItem("Eigenschaften...");
        jMenu.add(this.mnuFileProperties);
        jMenu.addSeparator();
        this.mnuFileTabClose = this.createJMenuItem("Unterfenster schlie\u00dfen", KeyStroke.getKeyStroke(87, 2));
        jMenu.add(this.mnuFileTabClose);
        this.mnuFileClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuFileClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuEditUndo = this.createJMenuItem("R\u00fcckg\u00e4ngig", KeyStroke.getKeyStroke(90, 2));
        this.mnuEditUndo.setEnabled(false);
        jMenu2.add(this.mnuEditUndo);
        jMenu2.addSeparator();
        this.mnuEditCut = this.createJMenuItem("Ausschneiden", KeyStroke.getKeyStroke(88, 2));
        jMenu2.add(this.mnuEditCut);
        this.mnuEditCopy = this.createJMenuItem("Kopieren", KeyStroke.getKeyStroke(67, 2));
        jMenu2.add(this.mnuEditCopy);
        this.mnuEditPaste = this.createJMenuItem("Einf\u00fcgen", KeyStroke.getKeyStroke(86, 2));
        jMenu2.add(this.mnuEditPaste);
        jMenu2.addSeparator();
        this.mnuEditUpper = this.createJMenuItem("In Gro\u00dfbuchstaben wandeln", KeyStroke.getKeyStroke(85, 2));
        jMenu2.add(this.mnuEditUpper);
        this.mnuEditLower = this.createJMenuItem("In Kleinbuchstaben wandeln", KeyStroke.getKeyStroke(76, 2));
        jMenu2.add(this.mnuEditLower);
        jMenu2.addSeparator();
        this.mnuEditTabSize = this.createJMenuItem("Tabulatorbreite...", KeyStroke.getKeyStroke(84, 2));
        jMenu2.add(this.mnuEditTabSize);
        this.mnuEditTabToSpaces = this.createJMenuItem("Tabulatoren durch Leerzeichen ersetzen");
        jMenu2.add(this.mnuEditTabToSpaces);
        jMenu2.addSeparator();
        this.mnuEditShiftIn = this.createJMenuItem("Einr\u00fccken", KeyStroke.getKeyStroke(73, 2));
        jMenu2.add(this.mnuEditShiftIn);
        this.mnuEditShiftOut = this.createJMenuItem("Herausr\u00fccken", KeyStroke.getKeyStroke(73, 3));
        jMenu2.add(this.mnuEditShiftOut);
        this.mnuEditShiftWidth = this.createJMenuItem("Einr\u00fccktiefe...");
        jMenu2.add(this.mnuEditShiftWidth);
        jMenu2.addSeparator();
        JMenu jMenu3 = new JMenu("Deutsche Umlaute konvertieren");
        this.mnuEditUmlautGerToUni = this.createJMenuItem("\"[\\]{|}~\" in Umlaute konvertieren");
        jMenu3.add(this.mnuEditUmlautGerToUni);
        this.mnuEditUmlautDosToUni = this.createJMenuItem("Umlaute im DOS-Zeichensatz konvertieren");
        jMenu3.add(this.mnuEditUmlautDosToUni);
        jMenu2.add(jMenu3);
        this.mnuEditRemoveWordstarFmt = this.createJMenuItem("WordStar-Formatierungen entfernen");
        jMenu2.add(this.mnuEditRemoveWordstarFmt);
        jMenu2.addSeparator();
        this.mnuEditFind = this.createJMenuItem("Suchen und Ersetzen...", KeyStroke.getKeyStroke(70, 2));
        jMenu2.add(this.mnuEditFind);
        this.mnuEditFindNext = this.createJMenuItem("Weitersuchen", KeyStroke.getKeyStroke(114, 0));
        jMenu2.add(this.mnuEditFindNext);
        this.mnuEditFindPrev = this.createJMenuItem("R\u00fcckw\u00e4rts suchen", KeyStroke.getKeyStroke(114, 1));
        jMenu2.add(this.mnuEditFindPrev);
        this.mnuEditReplace = this.createJMenuItem("Ersetzen", KeyStroke.getKeyStroke(82, 2));
        jMenu2.add(this.mnuEditReplace);
        jMenu2.addSeparator();
        this.mnuEditBracket = this.createJMenuItem("Klammer pr\u00fcfen", KeyStroke.getKeyStroke(75, 2));
        jMenu2.add(this.mnuEditBracket);
        this.mnuEditGoto = this.createJMenuItem("Gehe zu Zeile...", KeyStroke.getKeyStroke(71, 2));
        jMenu2.add(this.mnuEditGoto);
        this.mnuEditSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        jMenu2.add(this.mnuEditSelectAll);
        JMenu jMenu4 = new JMenu("Programmierung");
        jMenu4.setMnemonic(80);
        jMenuBar.add(jMenu4);
        this.mnuPrgCompile = this.createJMenuItem("BASIC-Programm compilieren", KeyStroke.getKeyStroke(120, 0));
        jMenu4.add(this.mnuPrgCompile);
        this.mnuPrgCompileRun = this.createJMenuItem("BASIC-Programm compilieren und starten", KeyStroke.getKeyStroke(120, 1));
        jMenu4.add(this.mnuPrgCompileRun);
        this.mnuPrgCompileOpt = this.createJMenuItem("BASIC-Programm compilieren mit...");
        jMenu4.add(this.mnuPrgCompileOpt);
        jMenu4.addSeparator();
        this.mnuPrgAssemble = this.createJMenuItem("Assemblieren", KeyStroke.getKeyStroke(119, 0));
        jMenu4.add(this.mnuPrgAssemble);
        this.mnuPrgAssembleRun = this.createJMenuItem("Assemblieren und Programm starten", KeyStroke.getKeyStroke(119, 1));
        jMenu4.add(this.mnuPrgAssembleRun);
        this.mnuPrgAssembleOpt = this.createJMenuItem("Assemblieren mit...");
        jMenu4.add(this.mnuPrgAssembleOpt);
        jMenu4.addSeparator();
        this.mnuPrgLineAddrs = new JCheckBoxMenuItem("Adressspalte nach Assemblieren anzeigen", Main.getBooleanProperty(PROP_SHOW_LINE_ADDRS, true));
        this.mnuPrgLineAddrs.addActionListener(this);
        jMenu4.add(this.mnuPrgLineAddrs);
        this.mnuRemoveRowHeader = this.createJMenuItem("Adressspalte ausblenden");
        jMenu4.add(this.mnuRemoveRowHeader);
        jMenu4.addSeparator();
        this.mnuPrgCancel = this.createJMenuItem("Assembler/Compiler abbrechen", KeyStroke.getKeyStroke(118, 0));
        this.mnuPrgCancel.setEnabled(false);
        jMenu4.add(this.mnuPrgCancel);
        jMenu4.addSeparator();
        this.mnuPrjOpen = this.createJMenuItem("Projekt \u00f6ffnen...");
        jMenu4.add(this.mnuPrjOpen);
        this.mnuPrjSave = this.createJMenuItem("Projekt speichern");
        jMenu4.add(this.mnuPrjSave);
        this.mnuPrjSaveAs = this.createJMenuItem("Projekt speichern unter...");
        jMenu4.add(this.mnuPrjSaveAs);
        JMenu jMenu5 = new JMenu("?");
        jMenuBar.add(jMenu5);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu5.add(this.mnuHelpContent);
        this.mnuPopup = new JPopupMenu();
        this.mnuPopupCut = this.createJMenuItem("Ausschneiden");
        this.mnuPopup.add(this.mnuPopupCut);
        this.mnuPopupCopy = this.createJMenuItem("Kopieren");
        this.mnuPopup.add(this.mnuPopupCopy);
        this.mnuPopupPaste = this.createJMenuItem("Einf\u00fcgen");
        this.mnuPopup.add(this.mnuPopupPaste);
        this.mnuPopup.addSeparator();
        this.mnuPopupFind = this.createJMenuItem("Suchen...");
        this.mnuPopup.add(this.mnuPopupFind);
        this.mnuPopupFindNext = this.createJMenuItem("Weitersuchen");
        this.mnuPopup.add(this.mnuPopupFindNext);
        this.mnuPopupFindPrev = this.createJMenuItem("R\u00fcckw\u00e4rts suchen");
        this.mnuPopup.add(this.mnuPopupFindPrev);
        this.mnuPopupReplace = this.createJMenuItem("Ersetzen");
        this.mnuPopup.add(this.mnuPopupReplace);
        this.mnuPopup.addSeparator();
        if (this.emuThread != null) {
            this.mnuPopupBreak = this.createJMenuItem("Halte-/Log-Punkt anlegen");
            this.mnuPopup.add(this.mnuPopupBreak);
            this.mnuPopup.addSeparator();
        } else {
            this.mnuPopupBreak = null;
        }
        this.mnuPopupSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        this.mnuPopup.add(this.mnuPopupSelectAll);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        this.btnNew = this.createImageButton("/images/file/new.png", "Neu");
        jToolBar.add(this.btnNew);
        this.btnOpen = this.createImageButton("/images/file/open.png", "\u00d6ffnen");
        jToolBar.add(this.btnOpen);
        this.btnSave = this.createImageButton("/images/file/save.png", "Speichern");
        jToolBar.add(this.btnSave);
        this.btnPrint = this.createImageButton("/images/file/print.png", "Drucken");
        jToolBar.add(this.btnPrint);
        jToolBar.addSeparator();
        this.btnUndo = this.createImageButton("/images/edit/undo.png", "R\u00fcckg\u00e4ngig");
        jToolBar.add(this.btnUndo);
        jToolBar.addSeparator();
        this.btnCut = this.createImageButton("/images/edit/cut.png", "Ausschneiden");
        jToolBar.add(this.btnCut);
        this.btnCopy = this.createImageButton("/images/edit/copy.png", "Kopieren");
        jToolBar.add(this.btnCopy);
        this.btnPaste = this.createImageButton("/images/edit/paste.png", "Einf\u00fcgen");
        jToolBar.add(this.btnPaste);
        jToolBar.addSeparator();
        this.btnFind = this.createImageButton("/images/edit/find.png", "Suchen und Ersetzen...");
        jToolBar.add(this.btnFind);
        this.add((Component)jToolBar, gridBagConstraints);
        this.btnClose = this.createImageButton("/images/file/close.png", "Unterfenster schlie\u00dfen");
        this.btnClose.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnClose, gridBagConstraints);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(this);
        JTextArea jTextArea = this.createJTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        new DropTarget(this.tabbedPane, this).setActive(true);
        this.labelStatus = new JLabel(DEFAULT_STATUS_TEXT);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelStatus, gridBagConstraints);
        this.doFileNew();
        if (!this.applySettings(Main.getProperties(), true)) {
            JTextArea jTextArea2;
            boolean bl = false;
            if (!this.editTexts.isEmpty() && (jTextArea2 = this.editTexts.get(0).getJTextArea()) != null) {
                jTextArea2.setColumns(80);
                jTextArea2.setRows(25);
                this.setLocationByPlatform(true);
                this.pack();
                bl = true;
            }
            if (!bl) {
                this.setBoundsToDefaults();
            }
        }
        this.setResizable(true);
        this.updCaretButtons();
        this.updUndoButtons();
        this.updTitle();
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null) {
            this.clipboard = toolkit.getSystemClipboard();
            if (this.clipboard != null) {
                this.clipboard.addFlavorListener(this);
            }
        }
        this.updPasteButtons();
    }

    private void appendShiftedLine(StringBuilder stringBuilder, String string, int n, boolean bl) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            n2 = string.charAt(n4);
            if (n2 == 32) {
                ++n5;
                ++n4;
                continue;
            }
            if (n2 != 9) break;
            n5 += n - n5 % n;
            ++n4;
        }
        if (bl) {
            if ((n5 -= this.shiftWidth) < 0) {
                n5 = 0;
            }
        } else {
            n5 += this.shiftWidth;
        }
        if (n4 < n3) {
            if (string.charAt(n4) != '\n') {
                if (this.shiftUseTabs) {
                    while (n5 >= n) {
                        stringBuilder.append('\t');
                        n5 -= n;
                    }
                }
                for (n2 = 0; n2 < n5; ++n2) {
                    stringBuilder.append(' ');
                }
            }
            if (n4 > 0) {
                stringBuilder.append(string.substring(n4));
            } else {
                stringBuilder.append(string);
            }
        }
    }

    private EditText checkFileAlreadyOpen(File file) {
        EditText editText = null;
        for (EditText editText2 : this.editTexts) {
            if (!editText2.isSameFile(file)) continue;
            this.setSelectedEditText(editText2);
            BaseDlg.showInfoDlg(this, "Diese Datei ist bereits ge\u00f6ffnet.", "Hinweis");
            editText = editText2;
        }
        return editText;
    }

    private JTextArea createJTextArea() {
        Font font;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setMargin(new Insets(5, 5, 5, 5));
        String string = Main.getProperty(PROP_TABSIZE);
        if (string != null && !string.isEmpty()) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0 && n < 100) {
                    jTextArea.setTabSize(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((font = jTextArea.getFont()) != null) {
            jTextArea.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        } else {
            jTextArea.setFont(new Font("Monospaced", 0, 12));
        }
        jTextArea.addMouseListener(this);
        return jTextArea;
    }

    private Integer findBracket(String string, int n, char c, char c2, int n2) {
        int n3 = 0;
        int n4 = string.length();
        while (n >= 0 && n < n4) {
            char c3 = string.charAt(n);
            if (c3 == c) {
                ++n3;
            } else if (c3 == c2 && --n3 <= 0) {
                return n;
            }
            n += n2;
        }
        return null;
    }

    private boolean findText(EditText editText, JTextArea jTextArea, int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string = this.textFind;
        String string2 = jTextArea.getText();
        if (string2 == null) {
            string2 = "";
        }
        int n2 = string2.length();
        if (string != null && !string.isEmpty()) {
            this.hasTextFind = true;
            this.setFindNextBtnsEnabled(this.hasTextFind);
            if (this.findIgnoreCase) {
                string = string.toUpperCase();
                string2 = string2.toUpperCase();
            }
            int n3 = -1;
            if (bl) {
                if (n >= n2 - 1) {
                    n = n2 - 1;
                }
                if (n > 0) {
                    n3 = string2.lastIndexOf(string, n);
                }
            } else {
                if (n < 0) {
                    n = 0;
                }
                if (n < n2) {
                    n3 = string2.indexOf(string, n);
                }
            }
            if (n3 >= 0 && n3 < n2) {
                this.toFront();
                jTextArea.requestFocus();
                if (bl2) {
                    jTextArea.setCaretPosition(n3);
                }
                jTextArea.select(n3, n3 + string.length());
                bl3 = true;
            }
        }
        if (!bl3 && bl2) {
            if (bl) {
                if (n < n2 - 1) {
                    bl3 = this.findText(editText, jTextArea, n2 - 1, true, bl2);
                } else {
                    TextUtil.showTextNotFound(this);
                }
            } else if (n > 0) {
                bl3 = this.findText(editText, jTextArea, 0, false, bl2);
            } else {
                TextUtil.showTextNotFound(this);
            }
        }
        return bl3;
    }

    private int getLineAddr(MouseEvent mouseEvent) {
        int n = -1;
        try {
            Component component = mouseEvent.getComponent();
            Point point = mouseEvent.getPoint();
            if (component != null && point != null) {
                int n2;
                JTextArea jTextArea;
                Component component2;
                JViewport jViewport;
                JScrollPane jScrollPane = null;
                for (Container container = component.getParent(); container != null; container = container.getParent()) {
                    if (!(container instanceof JScrollPane)) continue;
                    jScrollPane = (JScrollPane)container;
                    break;
                }
                if (jScrollPane != null && (jViewport = jScrollPane.getRowHeader()) != null && (component2 = jViewport.getView()) != null && component2 instanceof LineAddrRowHeader && (jTextArea = ((LineAddrRowHeader)component2).getJTextArea()) != null && jTextArea == component && (n2 = jTextArea.viewToModel(point)) >= 0) {
                    n = ((LineAddrRowHeader)component2).getAddrByLine(jTextArea.getLineOfOffset(n2));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n;
    }

    private EditText getSelectedEditText() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component != null) {
            for (EditText editText : this.editTexts) {
                if (editText.getTabComponent() != component) continue;
                return editText;
            }
        }
        return null;
    }

    private JTextArea getSelectedJTextArea() {
        EditText editText = this.getSelectedEditText();
        return editText != null ? editText.getJTextArea() : null;
    }

    private EditText forceOpenFile(File file, CharConverter charConverter, String string, String string2, boolean bl) {
        EditText editText = this.getSelectedEditText();
        if (editText != null && editText.isUsed()) {
            editText = null;
        }
        try {
            Component component;
            if (editText != null) {
                int n;
                editText.loadFile(file, charConverter, string, string2, bl);
                component = editText.getTabComponent();
                if (component != null && (n = this.tabbedPane.indexOfComponent(component)) >= 0) {
                    this.tabbedPane.setTitleAt(n, editText.getName());
                }
            }
            if (editText == null) {
                editText = new EditText(this, file, charConverter, string, string2, bl);
                component = this.createJTextArea();
                JScrollPane jScrollPane = new JScrollPane(component);
                editText.setComponents(jScrollPane, (JTextArea)component);
                this.editTexts.add(editText);
                this.tabbedPane.addTab(editText.getName(), jScrollPane);
            }
            Main.setLastFile(file, "text");
            this.setSelectedTabComponent(editText.getTabComponent());
            this.updFileButtons();
            this.updStatusBar();
        }
        catch (IOException iOException) {
            editText = null;
            BaseDlg.showOpenFileErrorDlg(this, file, iOException);
        }
        catch (UserCancelException userCancelException) {
            editText = null;
        }
        return editText;
    }

    private EditText openTextFile(File file) {
        EditText editText = this.checkFileAlreadyOpen(file);
        if (editText == null) {
            editText = this.forceOpenFile(file, null, null, null, false);
        }
        return editText;
    }

    private Appendable openLog(EditText editText, String string) {
        String string2 = "Meldungen";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        if (this.logFrm != null) {
            this.logFrm.reset(editText, string2);
        } else {
            this.logFrm = new LogFrm(editText, string2);
            Rectangle rectangle = this.getBounds();
            Dimension dimension = this.logFrm.getToolkit().getScreenSize();
            if (rectangle != null && dimension != null) {
                if (rectangle.x + 100 < dimension.width || rectangle.y + 100 < dimension.height) {
                    this.logFrm.setLocation(rectangle.x + 50, rectangle.y + 50);
                } else {
                    this.logFrm.setLocation(0, 0);
                }
            }
        }
        EmuUtil.showFrame(this.logFrm);
        return this.logFrm;
    }

    private void removeRowHeaders() {
        for (EditText editText : this.editTexts) {
            editText.removeRowHeader();
        }
        this.updRemoveRowHeaderButtons();
    }

    private boolean replaceText(JTextArea jTextArea) {
        int n = jTextArea.getSelectionStart();
        int n2 = jTextArea.getSelectionEnd();
        if (n < 0 || n >= n2) {
            return false;
        }
        jTextArea.replaceSelection(this.textReplace != null ? this.textReplace : "");
        return true;
    }

    private void setCopyBtnsEnabled(boolean bl) {
        this.mnuEditCopy.setEnabled(bl);
        this.mnuPopupCopy.setEnabled(bl);
        this.btnCopy.setEnabled(bl);
    }

    private void setCutBtnsEnabled(boolean bl) {
        this.mnuEditCut.setEnabled(bl);
        this.mnuPopupCut.setEnabled(bl);
        this.btnCut.setEnabled(bl);
    }

    private void setFileBtnsEnabled(boolean bl) {
        boolean bl2 = bl && this.prgThread == null;
        this.mnuFileSaveAs.setEnabled(bl);
        this.mnuFilePrint.setEnabled(bl);
        this.mnuFileProperties.setEnabled(bl);
        this.mnuFileTabClose.setEnabled(bl);
        this.mnuEditTabSize.setEnabled(bl);
        this.mnuEditTabToSpaces.setEnabled(bl);
        this.mnuEditUmlautGerToUni.setEnabled(bl);
        this.mnuEditUmlautDosToUni.setEnabled(bl);
        this.mnuEditRemoveWordstarFmt.setEnabled(bl);
        this.mnuEditFind.setEnabled(bl);
        this.mnuEditBracket.setEnabled(bl);
        this.mnuEditGoto.setEnabled(bl);
        this.mnuEditSelectAll.setEnabled(bl);
        this.mnuPrgAssemble.setEnabled(bl2);
        this.mnuPrgAssembleRun.setEnabled(bl2);
        this.mnuPrgAssembleOpt.setEnabled(bl2);
        this.mnuPrgCompile.setEnabled(bl2);
        this.mnuPrgCompileRun.setEnabled(bl2);
        this.mnuPrgCompileOpt.setEnabled(bl2);
        this.mnuPrjSaveAs.setEnabled(bl);
        this.mnuPopupFind.setEnabled(bl);
        this.mnuPopupSelectAll.setEnabled(bl);
        this.btnPrint.setEnabled(bl);
        this.btnClose.setEnabled(bl);
        this.btnFind.setEnabled(bl);
    }

    private void setFindNextBtnsEnabled(boolean bl) {
        this.mnuEditFindPrev.setEnabled(bl);
        this.mnuEditFindNext.setEnabled(bl);
        this.mnuPopupFindPrev.setEnabled(bl);
        this.mnuPopupFindNext.setEnabled(bl);
    }

    private void setLineAddrs(Collection<PrgSource> collection) {
        for (EditText editText : this.editTexts) {
            Component component = editText.getTabComponent();
            JTextArea jTextArea = editText.getJTextArea();
            if (component == null || jTextArea == null || !(component instanceof JScrollPane)) continue;
            LineAddrRowHeader lineAddrRowHeader = null;
            if (collection != null) {
                for (PrgSource prgSource : collection) {
                    Map<Integer, Integer> map;
                    if (!editText.isSameText(prgSource) || (map = prgSource.getLineAddrMap()) == null) continue;
                    lineAddrRowHeader = new LineAddrRowHeader(jTextArea, map);
                }
            }
            ((JScrollPane)component).setRowHeaderView(lineAddrRowHeader);
        }
        this.updRemoveRowHeaderButtons();
    }

    private void setPasteBtnsEnabled(boolean bl) {
        this.mnuEditPaste.setEnabled(bl);
        this.mnuPopupPaste.setEnabled(bl);
        this.btnPaste.setEnabled(bl);
    }

    private void setReplaceBtnsEnabled(boolean bl) {
        this.mnuEditUpper.setEnabled(bl);
        this.mnuEditLower.setEnabled(bl);
        this.mnuEditReplace.setEnabled(bl);
        this.mnuPopupReplace.setEnabled(bl);
    }

    private void setSaveBtnsEnabled(boolean bl) {
        this.mnuFileSave.setEnabled(bl);
        this.btnSave.setEnabled(bl);
    }

    private void setSavePrjBtnsEnabled(boolean bl) {
        this.mnuPrjSave.setEnabled(bl);
    }

    private void setSelectedEditText(EditText editText) {
        Component component;
        if (editText != null && (component = editText.getTabComponent()) != null) {
            this.tabbedPane.setSelectedComponent(component);
            this.updTitle(editText);
            this.updUndoButtons();
            this.updCaretButtons();
            this.updPasteButtons();
        }
    }

    private void setUndoBtnsEnabled(boolean bl) {
        this.mnuEditUndo.setEnabled(bl);
        this.btnUndo.setEnabled(bl);
    }

    private void showConvResult(int n) {
        BaseDlg.showInfoDlg(this, String.valueOf(n) + " Ersetzungen");
    }

    private void updFileButtons() {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            this.setFileBtnsEnabled(true);
            this.setSaveBtnsEnabled(!editText.isSaved());
            this.setSavePrjBtnsEnabled(editText.hasProjectChanged());
            this.setFindNextBtnsEnabled(this.hasTextFind);
        } else {
            this.setFileBtnsEnabled(false);
            this.setSaveBtnsEnabled(false);
            this.setSavePrjBtnsEnabled(false);
            this.setFindNextBtnsEnabled(false);
        }
        this.updRemoveRowHeaderButtons();
    }

    private void updPasteButtons() {
        boolean bl = false;
        JTextArea jTextArea = this.getSelectedJTextArea();
        if (jTextArea != null && jTextArea.isEditable() && this.clipboard != null) {
            try {
                bl = this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setPasteBtnsEnabled(bl);
    }

    private void updRemoveRowHeaderButtons() {
        EditText editText = this.getSelectedEditText();
        if (editText != null) {
            this.mnuRemoveRowHeader.setEnabled(editText.hasRowHeader());
        } else {
            this.mnuRemoveRowHeader.setEnabled(false);
        }
    }

    private void updShowLineAddrs() {
        if (!this.mnuPrgLineAddrs.isSelected()) {
            this.removeRowHeaders();
        }
    }

    private void updStatusBar() {
        if (this.labelStatus != null) {
            String string = DEFAULT_STATUS_TEXT;
            JTextArea jTextArea = this.getSelectedJTextArea();
            if (jTextArea != null) {
                try {
                    int n = jTextArea.getCaretPosition();
                    int n2 = jTextArea.getLineOfOffset(n);
                    int n3 = jTextArea.getLineStartOffset(n2);
                    int n4 = n - n3;
                    if (n4 > 0) {
                        Document document = jTextArea.getDocument();
                        int n5 = jTextArea.getTabSize();
                        if (document != null && n5 > 0) {
                            Segment segment = new Segment();
                            segment.setPartialReturn(false);
                            document.getText(n3, n4, segment);
                            n4 = 0;
                            char c = segment.first();
                            while (c != '\uffff') {
                                n4 = c == '\t' ? (n4 / n5 + 1) * n5 : ++n4;
                                c = segment.next();
                            }
                        }
                    }
                    string = String.format("Z:%d S:%d", n2 + 1, n4 + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.labelStatus.setText(string);
        }
    }

    private void updTitle(EditText editText) {
        String string = "JKCEMU Editor";
        if (editText != null) {
            string = string + ": ";
            File file = editText.getFile();
            string = file != null ? string + file.getPath() : string + editText.getName();
        }
        this.setTitle(string);
    }
}

