/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jkcemu.base.BaseDlg;
import jkcemu.text.CharConverter;

public class SelectEncodingDlg
extends BaseDlg {
    private boolean applied = false;
    private boolean ignoreEofByte = false;
    private CharConverter charConverter = null;
    private String encodingName = null;
    private String encodingDisplayText = null;
    private JComboBox<Object> comboEncoding;
    private JCheckBox btnIgnoreEofByte;
    private JButton btnOK;
    private JButton btnCancel;

    public SelectEncodingDlg(Frame frame) {
        super((Window)frame, "Zeichensatz ausw\u00e4hlen");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Mit welchem Zeichensatz soll die Datei ge\u00f6ffnet werden?"), gridBagConstraints);
        this.comboEncoding = new JComboBox();
        this.comboEncoding.addItem("Systemzeichensatz");
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.ASCII_7BIT));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.ISO646DE));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.CP437));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.CP850));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.LATIN1));
        this.comboEncoding.addItem("UTF-8");
        this.comboEncoding.addItem("UTF-16BE (Big Endian)");
        this.comboEncoding.addItem("UTF-16LE (Little Endian)");
        this.comboEncoding.setEditable(false);
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridy;
        this.add(this.comboEncoding, gridBagConstraints);
        JLabel jLabel = new JLabel("Achtung!");
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(font.deriveFont(1));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Die Datei wird als Textdatei mit dem ausgew\u00e4hlten Zeichensatz ge\u00f6ffnet."), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Das gilt auch, wenn die Datei gar keine Textdatei ist oder in einem"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("anderem Zeichensatz gespeichert wurde."), gridBagConstraints);
        this.btnIgnoreEofByte = new JCheckBox("Eventuell vorhandenes Dateiendezeichen ignorieren");
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 20;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnIgnoreEofByte, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        this.btnOK.addKeyListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel.add(this.btnCancel);
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    public boolean encodingChoosen() {
        return this.applied;
    }

    public CharConverter getCharConverter() {
        return this.charConverter;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public String getEncodingDisplayText() {
        return this.encodingDisplayText;
    }

    public boolean getIgnoreEofByte() {
        return this.ignoreEofByte;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnOK) {
                this.doApply();
            } else if (object == this.btnCancel) {
                this.doClose();
            }
        }
        return bl;
    }

    private void doApply() {
        Object object = this.comboEncoding.getSelectedItem();
        if (object != null) {
            this.encodingDisplayText = object.toString();
            if (object instanceof CharConverter) {
                this.charConverter = (CharConverter)object;
                this.encodingName = this.charConverter.getEncodingName();
            } else {
                String string = object.toString();
                if (string != null && (string.startsWith("ISO") || string.startsWith("UTF"))) {
                    int n = string.indexOf(32);
                    this.encodingName = n > 0 ? string.substring(0, n) : string;
                }
            }
        }
        this.ignoreEofByte = this.btnIgnoreEofByte.isSelected();
        this.applied = true;
        this.doClose();
    }
}

