/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.text.TextEditFrm;

public class ReplyShiftWidthDlg
extends BaseDlg {
    private TextEditFrm textEditFrm;
    private JSpinner spinnerShiftWidth;
    private JCheckBox tglUseTabs;
    private JButton btnApply;
    private JButton btnClose;

    public ReplyShiftWidthDlg(TextEditFrm textEditFrm) {
        super((Window)textEditFrm, "Einr\u00fccktiefe \u00e4ndern");
        this.textEditFrm = textEditFrm;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.add(new JLabel("Einr\u00fccktiefe:"));
        int n = this.textEditFrm.getShiftWidth();
        if (n < 1) {
            n = 1;
        } else if (n > 99) {
            n = 99;
        }
        this.spinnerShiftWidth = new JSpinner(new SpinnerNumberModel(n, 1, 99, 1));
        jPanel.add(this.spinnerShiftWidth);
        this.tglUseTabs = new JCheckBox("Tabulatoren verwenden", this.textEditFrm.getShiftUseTabs());
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.tglUseTabs, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        this.btnApply = new JButton("\u00dcbernehmen");
        this.btnApply.addActionListener(this);
        this.btnApply.addKeyListener(this);
        jPanel2.add(this.btnApply);
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnClose.addActionListener(this);
        this.btnClose.addKeyListener(this);
        jPanel2.add(this.btnClose);
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object.equals(this.btnApply)) {
                bl = true;
                this.doApply();
            } else if (object.equals(this.btnClose)) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this && this.spinnerShiftWidth != null) {
            this.spinnerShiftWidth.requestFocus();
            JComponent jComponent = this.spinnerShiftWidth.getEditor();
            if (jComponent != null && jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).selectAll();
            }
        }
    }

    private void doApply() {
        int n;
        Object object = this.spinnerShiftWidth.getValue();
        if (object != null && object instanceof Number && (n = ((Number)object).intValue()) > 0) {
            this.textEditFrm.setShiftWidth(n);
            Main.setProperty("jkcemu.texteditor.shift.width", object.toString());
            boolean bl = this.tglUseTabs.isSelected();
            this.textEditFrm.setShiftUseTabs(bl);
            Main.setProperty("jkcemu.texteditor.shift.use_tabs", Boolean.toString(bl));
            this.doClose();
        }
    }
}

