/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import jkcemu.Main;

public class LineAddrRowHeader
extends JComponent {
    private static final int MARGIN = 5;
    private JTextArea textArea;
    private Map<Integer, Integer> lineAddrMap;
    private Image closeImg;
    private int closeX;
    private int closeY;
    private int closeW;
    private int closeH;

    public LineAddrRowHeader(JTextArea jTextArea, Map<Integer, Integer> map) {
        this.textArea = jTextArea;
        this.lineAddrMap = map;
        this.closeImg = Main.getImage(this, "/images/file/close.png");
        this.closeX = 0;
        this.closeY = 0;
        this.closeW = 0;
        this.closeH = 0;
        this.setToolTipText("Adressen im Arbeitsspeicher");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                LineAddrRowHeader.this.mouseClickedInternal(mouseEvent);
            }
        });
    }

    public int getAddrByLine(int n) {
        Integer n2;
        int n3 = -1;
        if (this.lineAddrMap != null && (n2 = this.lineAddrMap.get(n)) != null) {
            n3 = n2;
        }
        return n3;
    }

    public JTextArea getJTextArea() {
        return this.textArea;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.isPreferredSizeSet()) {
            dimension = super.getPreferredSize();
        } else {
            Serializable serializable;
            int n = 0;
            int n2 = 0;
            Font font = this.textArea.getFont();
            if (font != null && this.lineAddrMap != null && (serializable = this.getFontMetrics(font)) != null && (n2 = ((FontMetrics)serializable).stringWidth("8888")) > 0) {
                n2 += 10;
            }
            if ((serializable = this.textArea.getPreferredSize()) != null) {
                n = ((Dimension)serializable).height;
            }
            dimension = new Dimension(n2, n);
        }
        return dimension;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.isOverClose(mouseEvent) ? "Adressspalte ausblenden" : super.getToolTipText(mouseEvent);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = 0;
        int n3 = this.getHeight();
        if (n > 0 && n3 > 0) {
            Serializable serializable;
            Container container = this.getParent();
            if (container != null && container instanceof JViewport && (serializable = ((JViewport)container).getViewRect()) != null) {
                n2 += ((Rectangle)serializable).y;
                n3 = ((Rectangle)serializable).height;
            }
            graphics.setColor(this.getBackground());
            graphics.setPaintMode();
            graphics.fillRect(0, n2, n, n2 + n3);
            graphics.setColor(Color.gray);
            graphics.drawLine(n - 1, n2, n - 1, n2 + n3);
            try {
                graphics.setColor(SystemColor.textText);
                serializable = this.textArea.getFont();
                if (serializable != null && this.lineAddrMap != null) {
                    int n4;
                    graphics.setFont((Font)serializable);
                    Insets insets = this.textArea.getInsets();
                    int n5 = insets != null ? insets.left : 0;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = this.textArea.viewToModel(new Point(n5, n2));
                    if (n8 >= 0) {
                        n6 = this.textArea.getLineOfOffset(n8);
                    }
                    if ((n8 = this.textArea.viewToModel(new Point(n5, n2 + n3))) >= 0) {
                        n7 = this.textArea.getLineOfOffset(n8) + 1;
                    }
                    if (n7 >= (n4 = this.textArea.getLineCount())) {
                        n7 = n4 - 1;
                    }
                    for (int i = n6; i < n7; ++i) {
                        int n9;
                        Rectangle rectangle;
                        Integer n10 = this.lineAddrMap.get(i + 1);
                        if (n10 == null || (rectangle = this.textArea.modelToView(this.textArea.getLineStartOffset(i))) == null || (n9 = rectangle.y + rectangle.height - 5) < n2 || n9 - ((Font)serializable).getSize() >= n2 + n3) continue;
                        graphics.drawString(String.format("%04X", n10), 5, n9);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.closeImg != null) {
                int n11 = this.closeImg.getWidth(this);
                int n12 = this.closeImg.getHeight(this);
                if (n11 > 0 && n12 > 0 && n11 < n - 10) {
                    this.closeX = n - 5 - n11 - 1;
                    this.closeY = n2 + 1;
                    this.closeW = n11;
                    this.closeH = n12;
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(this.closeX - 1, this.closeY - 1, this.closeW + 2, this.closeH + 2);
                    graphics.drawImage(this.closeImg, this.closeX, this.closeY, this);
                }
            }
        }
    }

    private boolean isOverClose(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.closeW > 0 && this.closeH > 0) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n >= this.closeX && n < this.closeX + this.closeW && n2 >= this.closeY && n2 < this.closeY + this.closeH) {
                bl = true;
            }
        }
        return bl;
    }

    private void mouseClickedInternal(MouseEvent mouseEvent) {
        if (this.isOverClose(mouseEvent)) {
            JScrollPane jScrollPane = null;
            for (Container container = this; jScrollPane == null && container != null; container = container.getParent()) {
                if (!(container instanceof JScrollPane)) continue;
                jScrollPane = (JScrollPane)container;
                break;
            }
            if (jScrollPane != null) {
                jScrollPane.setRowHeader(null);
            }
            mouseEvent.consume();
        }
    }
}

