/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jkcemu.base.BaseDlg;
import jkcemu.base.ListFocusTraversalPolicy;

public class FindTextDlg
extends BaseDlg {
    private static List<String> findHistory = new ArrayList<String>();
    private Action action = Action.NO_ACTION;
    private String findText = null;
    private JComboBox<String> comboFind;
    private JTextField fldFind;
    private JTextField fldReplace;
    private JCheckBox tglNoticeCase;
    private JButton btnFindNext;
    private JButton btnReplaceAll;
    private JButton btnCancel;

    public FindTextDlg(Frame frame, String string, String string2, boolean bl) {
        super((Window)frame, "Suchen und Ersetzen");
        Component component;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Suchen nach:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Ersetzen durch:"), gridBagConstraints);
        this.comboFind = new JComboBox();
        for (String object2 : findHistory) {
            this.comboFind.addItem(object2);
        }
        this.comboFind.setEditable(true);
        if (string != null) {
            this.comboFind.setSelectedItem(this.getFirstLine(string));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.add(this.comboFind, gridBagConstraints);
        this.fldFind = null;
        ComboBoxEditor comboBoxEditor = this.comboFind.getEditor();
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) != null && component instanceof JTextField) {
            this.fldFind = (JTextField)component;
            this.fldFind.addActionListener(this);
        }
        this.fldReplace = new JTextField();
        this.fldReplace.setEditable(true);
        this.fldReplace.addActionListener(this);
        if (string2 != null) {
            this.fldReplace.setText(this.getFirstLine(string2));
        }
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldReplace, gridBagConstraints);
        Font font = this.fldReplace.getFont();
        if (font != null) {
            this.comboFind.setFont(font);
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        this.tglNoticeCase = new JCheckBox(" Gro\u00df-/Kleinschreibung beachten", !bl);
        this.add((Component)this.tglNoticeCase, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 5, 5));
        this.btnFindNext = new JButton("Suchen");
        this.btnFindNext.addActionListener(this);
        this.btnFindNext.addKeyListener(this);
        jPanel.add(this.btnFindNext);
        this.btnReplaceAll = new JButton("Alle ersetzen");
        this.btnReplaceAll.addActionListener(this);
        this.btnReplaceAll.addKeyListener(this);
        jPanel.add(this.btnReplaceAll);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel.add(this.btnCancel);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel, gridBagConstraints);
        this.setFocusTraversalPolicy(new ListFocusTraversalPolicy(this.comboFind, this.fldReplace, this.tglNoticeCase, this.btnFindNext, this.btnReplaceAll, this.btnCancel));
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    public Action getAction() {
        return this.action;
    }

    public String getFindText() {
        return this.findText != null ? this.findText : "";
    }

    public boolean getIgnoreCase() {
        return !this.tglNoticeCase.isSelected();
    }

    public String getReplaceText() {
        String string = this.fldReplace.getText();
        return string != null ? string : "";
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.fldFind && this.fldFind != null) {
                bl = true;
                this.action = Action.FIND_NEXT;
                this.applyFindText(this.fldFind.getText());
                this.doClose();
            }
            if (object == this.fldReplace || object == this.btnFindNext) {
                bl = true;
                this.action = Action.FIND_NEXT;
                this.applyFindText(this.comboFind.getSelectedItem());
                this.doClose();
            } else if (object.equals(this.btnReplaceAll)) {
                bl = true;
                this.action = Action.REPLACE_ALL;
                this.applyFindText(this.comboFind.getSelectedItem());
                this.doClose();
            } else if (object.equals(this.btnCancel)) {
                bl = true;
                this.action = Action.NO_ACTION;
                this.doClose();
            }
        }
        return bl;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.action = Action.NO_ACTION;
        super.windowClosing(windowEvent);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this && this.comboFind != null) {
            this.comboFind.requestFocus();
            if (this.fldFind != null) {
                this.fldFind.selectAll();
            }
        }
    }

    private void applyFindText(Object object) {
        String string = this.findText = object != null ? object.toString() : null;
        if (this.findText != null && !this.findText.isEmpty()) {
            findHistory.remove(this.findText);
            for (int i = findHistory.size(); i >= 10; --i) {
                findHistory.remove(i - 1);
            }
            findHistory.add(0, this.findText);
        }
    }

    private String getFirstLine(String string) {
        int n = string.indexOf(10);
        return n >= 0 ? string.substring(0, n) : string;
    }

    public static enum Action {
        NO_ACTION,
        FIND_NEXT,
        REPLACE_ALL;

    }
}

