/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicLibrary;
import jkcemu.programming.basic.target.Z1013Target;

public class Z1013PetersTarget
extends Z1013Target {
    public static final String BASIC_TARGET_NAME = "TARGET_Z1013_64X16";
    private boolean needsScreenSizeHChar;
    private boolean needsScreenSizeWChar;
    private boolean needsScreenSizePixel;
    private boolean usesScreens;

    public Z1013PetersTarget() {
        this.setNamedValue("LASTSCREEN", 1);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesScreens) {
            asmCodeBuf.append("X_M_SCREEN:\tDS\t1\n");
        }
    }

    @Override
    protected void appendCheckGraphicScreenTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tLD\tA,(X_M_SCREEN)\n\tOR\tA\n\tJR\tZ,X_PST1\n");
            this.appendExitNoGraphicsScreenTo(asmCodeBuf, basicCompiler);
        }
    }

    @Override
    public void appendEtcPastXOutTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("X_SCREEN0:\n\tIN\tA,(04H)\n\tAND\t7FH\n\tOUT\t(04H),A\n\tXOR\tA\n\tLD\t(X_M_SCREEN),A\n\tRET\n");
        }
        if (this.needsScreenSizeHChar || this.needsScreenSizeWChar) {
            if (this.usesScreens) {
                if (this.needsScreenSizeHChar) {
                    asmCodeBuf.append("X_HCHR:\tLD\tHL,0010H\n");
                    if (this.needsScreenSizeWChar) {
                        asmCodeBuf.append("\tJR\tX_HWCHR\n");
                    }
                }
                if (this.needsScreenSizeWChar) {
                    asmCodeBuf.append("X_WCHR:\tLD\tHL,0040H\n");
                }
                asmCodeBuf.append("X_HWCHR:\n\tLD\tA,(X_M_SCREEN)\n\tDEC\tA\n\tRET\tZ\n\tLD\tL,0020H\n\tRET\n");
            } else {
                asmCodeBuf.append("X_HCHR:\nX_WCHR:\tLD\tHL,0020H\n\tRET\n");
            }
        }
        if (this.needsScreenSizePixel) {
            asmCodeBuf.append("X_HPIX:\nX_WPIX:\tLD\tHL,0040H\n");
            if (this.usesScreens) {
                asmCodeBuf.append("\tLD\tA,(X_M_SCREEN)\n\tOR\tA\n\tRET\tZ\n\tLD\tL,00H\n");
            }
            asmCodeBuf.append("\tRET\n");
        }
    }

    @Override
    public void appendPreExitTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tCALL\tX_SCREEN0\n");
        }
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_HCHR\n");
        this.needsScreenSizeHChar = true;
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_HPIX\n");
        this.needsScreenSizePixel = true;
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesScreens) {
            asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_SCREEN),A\n\tCALL\tX_SCREEN0\n");
        }
    }

    @Override
    public void appendSwitchToTextScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tCALL\tX_SCREEN0\n");
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_WCHR\n");
        this.needsScreenSizeWChar = true;
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_WPIX\n");
        this.needsScreenSizePixel = true;
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("XLOCATE:\n\tLD\tA,(X_M_SCREEN)\n\tDEC\tA\n\tJR\tZ,XLOCATE1\n\tLD\tA,1FH\n\tCP\tE\n\tRET\tC\n\tCP\tL\n\tRET\tC\n\tCALL\tXLOCATE3\n\tJR\tXLOCATE2\nXLOCATE1:\n\tLD\tA,0FH\n\tCP\tE\n\tRET\tC\n\tLD\tA,3FH\n\tCP\tL\n\tRET\tC\n\tCALL\tXLOCATE3\n\tADD\tHL,HL\nXLOCATE2:\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,DE\n\tLD\tBC,0EC00H\n\tADD\tHL,BC\n\tLD\tA,(HL)\n\tLD\t(HL),0FFH\n\tLD\t(002BH),HL\n\tRET\nXLOCATE3:\n\tPUSH\tHL\n\tLD\tHL,(002BH)\n\tLD\tA,(001FH)\n\tLD\t(HL),A\n\tPOP\tHL\n\tEX\tDE,HL\n\tRET\n");
        } else {
            super.appendXLocateTo(asmCodeBuf);
        }
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            if (!this.xoutchAppended) {
                asmCodeBuf.append("XOUTCH:\tCP\t0AH\n\tRET\tZ\n\tLD\tD,A\n\tLD\tA,(X_M_SCREEN)\n\tDEC\tA\n\tJR\tZ,XOUTC1\n\tLD\tA,D\n\tRST\t20H\n\tDB\t00H\n\tRET\nXOUTC1:\tLD\tA,(001FH)\n\tLD\tHL,(002BH)\n\tLD\t(HL),A\n\tLD\tA,D\n\tCP\t08H\n\tJR\tZ,XOUTC7\n\tCP\t09H\n\tJR\tZ,XOUTC2\n\tCP\t0CH\n\tJP\tZ,XOUTC8\n\tCP\t0DH\n\tJR\tZ,XOUTC9\n\tLD\t(HL),D\nXOUTC2:\tINC\tHL\nXOUTC3:\tLD\tA,H\n\tCP\t0F0H\n\tCALL\tNC,XOUTC5\nXOUTC4:\tLD\tA,(HL)\n\tLD\t(001FH),A\n\tLD\t(HL),0FFH\n\tLD\t(002BH),HL\n\tRET\nXOUTC5:\tPUSH\tHL\n\tLD\tHL,0EC40H\n\tLD\tDE,0EC00H\n\tLD\tBC,03C0H\n\tLDIR\n\tLD\tA,20H\n\tLD\tB,40H\nXOUTC6:\tLD\t(DE),A\n\tINC\tDE\n\tDJNZ\tXOUTC6\n\tPOP\tHL\n\tLD\tBC,0040H\n\tOR\tA\n\tSBC\tHL,BC\n\tRET\nXOUTC7:\tDEC\tHL\n\tLD\tA,H\n\tCP\t0ECH\n\tJR\tNC,XOUTC4\n\tLD\tHL,0EFFFH\n\tJR\tXOUTC4\nXOUTC8:\tLD\tHL,0EC00H\n\tPUSH\tHL\n\tLD\tA,20H\n\tLD\t(HL),A\n\tLD\tDE,0EC01H\n\tLD\tBC,03FFH\n\tLDIR\n\tPOP\tHL\n\tJR\tXOUTC4\nXOUTC9:\tLD\tB,20H\nXOUTC10:\n\tLD\t(HL),B\n\tINC\tHL\n\tLD\tA,L\n\tAND\t03FH\n\tJR\tNZ,XOUTC10\n\tJR\tXOUTC3\n");
                this.xoutchAppended = true;
            }
        } else {
            super.appendXOutchTo(asmCodeBuf);
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (this.usesScreens) {
            if (!this.xptestAppended) {
                asmCodeBuf.append("XPOINT:\nXPTEST:\tLD\tA,(X_M_SCREEN)\n\tOR\tA\n\tSCF\n\tRET\tZ\n\tCALL\tX_PST1\n\tJR\tC,X_PTEST1\n\tLD\tA,B\n\tAND\tC\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nX_PTEST1:\n\tLD\tHL,0FFFFH\n\tRET\n");
                this.appendPixUtilTo(asmCodeBuf, basicCompiler);
                this.xptestAppended = true;
            }
        } else {
            super.appendXPTestTo(asmCodeBuf, basicCompiler);
        }
    }

    @Override
    public void appendXScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("XSCREEN:\n\tLD\tA,H\n\tOR\tA\n\tJR\tNZ,XSCRN1\n\tLD\tA,(X_M_SCREEN)\n\tCP\tL\n\tRET\tZ\n\tLD\tC,04H\n\tIN\tB,(C)\n\tLD\tA,L\n\tOR\tA\n\tJR\tZ,XSCRN2\n\tCP\t01H\n\tJR\tZ,XSCRN3\nXSCRN1:\tSCF\n\tRET\nXSCRN2:\tRES\t7,B\n\tJR\tXSCRN4\nXSCRN3:\tSET\t7,B\nXSCRN4:\tOUT\t(C),B\n\tLD\t(X_M_SCREEN),A\n\tOR\tA\n\tRET\n");
        }
    }

    @Override
    public String[] getBasicTargetNames() {
        return Z1013PetersTarget.add(super.getBasicTargetNames(), BASIC_TARGET_NAME);
    }

    @Override
    public void preAppendLibraryCode(BasicCompiler basicCompiler) {
        super.preAppendLibraryCode(basicCompiler);
        if (basicCompiler.usesLibItem(BasicLibrary.LibItem.SCREEN) || basicCompiler.usesLibItem(BasicLibrary.LibItem.XSCREEN)) {
            this.usesScreens = true;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.needsScreenSizeHChar = false;
        this.needsScreenSizeWChar = false;
        this.needsScreenSizePixel = false;
        this.usesScreens = false;
    }

    @Override
    public String toString() {
        return "Z1013 mit Peters-Platine (64x16 Zeichen)";
    }
}

