/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.AC1;
import jkcemu.emusys.LLC2;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;

public class SCCHTarget
extends AbstractTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_SCCH";

    public SCCHTarget() {
        this.setNamedValue("JOYST_LEFT", 4);
        this.setNamedValue("JOYST_RIGHT", 8);
        this.setNamedValue("JOYST_DOWN", 2);
        this.setNamedValue("JOYST_UP", 1);
        this.setNamedValue("JOYST_BUTTON1", 16);
    }

    @Override
    public void appendExitTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tJP\t07FDH\n");
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0020H\n");
    }

    @Override
    public void appendInputTo(AsmCodeBuf asmCodeBuf, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            asmCodeBuf.append("XCKBRK:\n");
        }
        if (bl || bl2) {
            asmCodeBuf.append("XINKEY:\tCALL\t07FAH\n\tAND\t7FH\n");
            if (bl4) {
                asmCodeBuf.append("\tCP\t03H\n\tJR\tZ,XBREAK\n");
            }
            asmCodeBuf.append("\tRET\n");
        }
        if (bl3) {
            if (bl4) {
                asmCodeBuf.append("XINCH:\tCALL\t00008H\n\tCP\t03H\n\tJR\tZ,XBREAK\n\tRET\n");
            } else {
                asmCodeBuf.append("XINCH:\tJP\t0008H\n");
            }
        }
    }

    @Override
    public void appendPrologTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler, String string) {
        int n;
        if (string != null && (n = string.length()) > 0) {
            char c;
            boolean bl = false;
            if (n == 1 && ((c = string.charAt(0)) >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                asmCodeBuf.append("\tJR\t");
                asmCodeBuf.append("MSTART");
                asmCodeBuf.append("\n\tDB\t00H,09H,'");
                asmCodeBuf.append(c);
                asmCodeBuf.append("',0DH\n");
                bl = true;
            }
            if (!bl && !string.equals("MYAPP")) {
                basicCompiler.putWarning("Warnung: Applikationsname ignoriert (nur ein Buchstabe oder eine Ziffer erlaubt)\nAufruf des Programms auf dem Zielsystem nur \u00fcber die Startadresse m\u00f6glich");
            }
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0040H\n");
    }

    @Override
    public void appendXJoyTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XJOY:\tLD\tA,H\n\tOR\tL\n\tJR\tNZ,XJOY1\n\tCALL\t0EB4H\n\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXJOY1:\tLD\tHL,0000H\n\tRET\n");
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLOCATE:\n\tLD\tA,D\n\tOR\tH\n\tRET\tNZ\n\tLD\tA,E\n\tCP\t64H\n\tRET\tNC\n\tLD\tA,L\n\tCP\t64H\n\tRET\tNC\n\tPUSH\tHL\n\tPUSH\tDE\n\tLD\tA,0EH\n\tRST\t10H\n\tPOP\tDE\n\tLD\tA,E\n\tCALL\tX_LOC1\n\tPOP\tHL\n\tLD\tA,L\nX_LOC1:\tLD\tB,0FFH\nX_LOC2:\tINC\tB\n\tSUB\t0AH\n\tJR\tNC,X_LOC2\n\tADD\tA,0AH\n\tPUSH\tAF\n\tLD\tA,B\n\tADD\tA,30H\n\tRST\t10H\n\tPOP\tAF\n\tADD\tA,30H\n\tRST\t10H\n\tRET\n");
    }

    @Override
    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tLD\tB,A\n\tLD\tA,(1821H)\n\tPUSH\tAF\n\tAND\t0FH\n\tOR\t20H\n\tLD\t(1821H),A\n\tLD\tA,B\n\tRST\t10H\n\tPOP\tAF\n\tLD\t(1821H),A\n\tRET\n");
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tCP\t0AH\n\tRET\tZ\n\tJP\t0010H\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XOUTNL:\tLD\tA,0DH\n\tJP\t0010H\n");
    }

    @Override
    public int get100msLoopCount() {
        return 58;
    }

    @Override
    public String[] getBasicTargetNames() {
        return new String[]{BASIC_TARGET_NAME};
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null) {
            if (emuSys instanceof AC1) {
                n = 2;
                if (((AC1)emuSys).emulates2010Mode() || ((AC1)emuSys).emulatesSCCHMode()) {
                    n = 3;
                }
            } else if (emuSys instanceof LLC2) {
                n = 3;
            }
        }
        return n;
    }

    @Override
    public int getDefaultBegAddr() {
        return 8192;
    }

    @Override
    public int getMaxAppNameLen() {
        return 1;
    }

    @Override
    public String getStartCmd(EmuSys emuSys, String string, int n) {
        String string2 = null;
        if (emuSys != null && n >= 0 && (emuSys instanceof AC1 || emuSys instanceof LLC2)) {
            string2 = String.format("J %04X", n);
        }
        return string2;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{220, 252};
    }

    @Override
    public boolean supportsXJOY() {
        return true;
    }

    @Override
    public boolean supportsXLOCAT() {
        return true;
    }

    @Override
    public boolean supportsXLPTCH() {
        return true;
    }

    public String toString() {
        return "SCCH (AC1-2010, AC1-SCCH, LLC2)";
    }
}

