/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.KC85;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;

public class KC85Target
extends AbstractTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_KC85";
    protected boolean needsFullWindow;
    protected boolean pixUtilAppended;
    protected boolean xpsetAppended;
    private boolean usesXCOLOR;
    private boolean usesXINK;
    private boolean usesXPAPER;
    private boolean usesJoystick;
    private boolean usesM052;
    private boolean xpresAppended;

    public KC85Target() {
        this.setNamedValue("GRAPHICSCREEN", 0);
        this.setNamedValue("BLACK", 0);
        this.setNamedValue("BLINKING", 16);
        this.setNamedValue("BLUE", 1);
        this.setNamedValue("CYAN", 5);
        this.setNamedValue("GREEN", 4);
        this.setNamedValue("MAGENTA", 3);
        this.setNamedValue("RED", 2);
        this.setNamedValue("WHITE", 7);
        this.setNamedValue("YELLOW", 6);
        this.setNamedValue("JOYST_LEFT", 4);
        this.setNamedValue("JOYST_RIGHT", 8);
        this.setNamedValue("JOYST_DOWN", 2);
        this.setNamedValue("JOYST_UP", 1);
        this.setNamedValue("JOYST_BUTTON1", 32);
        this.setNamedValue("JOYST_BUTTON2", 16);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesM052) {
            asmCodeBuf.append("X_M_M052SLOT:\tDS\t1\nX_M_M052STAT:\tDS\t1\nX_M_M052USED:\tDS\t1\n");
        }
    }

    @Override
    public void appendEnableVdipTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_M052\n");
        this.usesM052 = true;
    }

    @Override
    public void appendEtcPreXOutTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesXINK) {
            asmCodeBuf.append("XINK:\tLD\tA,01H\n");
            if (this.usesXCOLOR || this.usesXPAPER) {
                asmCodeBuf.append("\tJR\tXCOLO1\n");
            } else {
                asmCodeBuf.append("\tLD\t(0B781H),A\n\tCALL\t0F003H\n\tDB\t0FH\n\tRET\n");
            }
        }
        if (this.usesXPAPER) {
            asmCodeBuf.append("XPAPER:\tLD\tE,L\n\tLD\tA,(0B7A3H)\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tLD\tL,A\n");
            this.usesXCOLOR = true;
        }
        if (this.usesXCOLOR) {
            asmCodeBuf.append("XCOLOR:\tLD\tA,02H\nXCOLO1:\tLD\t(0B781H),A\n\tCALL\t0F003H\n\tDB\t0FH\n\tRET\n");
        }
        if (this.usesM052) {
            asmCodeBuf.append("X_M052:\tLD\tA,(X_M_M052USED)\n\tOR\tA\n\tRET\tNZ\n\tLD\tBC,0880H\nX_M052_1:\n\tIN\tA,(C)\n\tCP\t0FDH\n\tJR\tZ,X_M052_2\n\tINC\tB\n\tJR\tNZ,X_M052_1\n\tSCF\n\tRET\nX_M052_2:\n\tLD\tA,B\n\tLD\t(X_M_M052SLOT),A\n\tLD\tH,0B8H\n\tLD\tL,B\n\tLD\tA,(HL)\n\tLD\t(X_M_M052STAT),A\n\tOR\t04H\n\tLD\tD,A\n\tLD\tA,02H\n\tCALL\t0F003H\n\tDB\t26H\n\tLD\tA,0FFH\n\tLD\t(X_M_M052USED),A\n\tOR\tA\n\tRET\n");
        }
    }

    @Override
    public void appendPreExitTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesM052) {
            asmCodeBuf.append("\tLD\tA,(X_M_M052USED)\n\tOR\tA\n\tJR\tZ,X_EXIT1\n\tLD\tA,(X_M_M052STAT)\n\tLD\tD,A\n\tLD\tA,(X_M_M052SLOT)\n\tLD\tL,A\n\tLD\tA,02H\n\tCALL\t0F003H\n\tDB\t26H\nX_EXIT1:\n");
        }
    }

    @Override
    public void appendExitTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tRET\n");
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0020H\n");
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0100H\n");
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesJoystick) {
            asmCodeBuf.append("\tLD\tA,0CFH\n\tOUT\t(92H),A\n\tLD\tA,7FH\n\tOUT\t(92H),A\n");
        }
        if (this.usesM052) {
            asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_M052SLOT),A\n\tLD\t(X_M_M052STAT),A\n\tLD\t(X_M_M052USED),A\n");
        }
        if (this.needsFullWindow) {
            asmCodeBuf.append("\tLD\tHL,(0B79CH)\n\tLD\tA,H\n\tOR\tL\n\tJR\tNZ,X_IWN1\n\tLD\tHL,(0B79EH)\n\tLD\tA,H\n\tCP\t20H\n\tJR\tC,X_IWN1\n\tLD\tA,L\n\tCP\t28H\n\tJR\tNC,X_IWN2\nX_IWN1:\tLD\tHL,0000H\n\tLD\t(0B79CH),HL\n\tLD\tHL,2028H\n\tLD\t(0B79EH),HL\n\tLD\tA,(0B79BH)\n\tLD\tL,A\n\tLD\tH,00H\n\tLD\tC,L\n\tLD\tB,H\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,BC\n\tADD\tHL,HL\n\tLD\tDE,0B99CH\n\tADD\tHL,DE\n\tLD\t(HL),00H\n\tINC\tHL\n\tLD\t(HL),00H\n\tINC\tHL\n\tLD\t(HL),28H\n\tINC\tHL\n\tLD\t(HL),20H\n\tINC\tHL\n\tLD\tA,0CH\n\tCALL\t0F003H\n\tDB\t00H\nX_IWN2:\n");
        }
    }

    @Override
    public void appendInputTo(AsmCodeBuf asmCodeBuf, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            asmCodeBuf.append("XCKBRK:\tCALL\t0F003H\n\tDB\t2AH\n\tRET\tNC\n\tJR\tXBREAK\n");
        }
        if (bl2) {
            asmCodeBuf.append("XINKEY:\tCALL\t0F003H\n\tDB\t0EH\n");
            if (bl4) {
                asmCodeBuf.append("\tJR\tC,XINKE1\n\tXOR\tA\n\tRET\nXINKE1:\tCP\t03H\n\tJR\tZ,XBREAK\n\tRET\n");
            } else {
                asmCodeBuf.append("\tRET\tC\n\tXOR\tA\n\tRET\n");
            }
        }
        if (bl3) {
            asmCodeBuf.append("XINCH:\tCALL\t0F003H\n\tDB\t16H\n");
            if (bl4) {
                asmCodeBuf.append("\tCP\t03H\n\tJR\tZ,XBREAK\n");
            }
            asmCodeBuf.append("\tRET\n");
        }
    }

    @Override
    public void appendPrologTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler, String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            asmCodeBuf.append("\tDB\t7FH,7FH\n");
            asmCodeBuf.appendStringLiteral(string, "01H");
            bl = true;
        }
        if (!bl) {
            basicCompiler.putWarning("Programm kann auf dem Zielsystem nicht aufgerufen werden, da der Programmname leer ist.");
        }
        asmCodeBuf.append("\tENT\n");
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0028H\n");
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0140H\n");
    }

    @Override
    public void appendXClsTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XCLS:\tLD\tA,0CH\n\tCALL\t0F003H\n\tDB\t00H\n\tRET\n");
        this.needsFullWindow = true;
    }

    @Override
    public void appendXColorTo(AsmCodeBuf asmCodeBuf) {
        this.usesXCOLOR = true;
    }

    @Override
    public void appendXHLineTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XHLINE:\tBIT\t7,B\n\tRET\tNZ\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tX_PST\n\tEXX\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tRET\tC\n\tLD\tH,00H\nXHLINE1:\n\tOR\tH\n\tLD\tH,A\n\tSRL\tA\n\tJR\tC,XHLINE2\n\tINC\tDE\n\tDEC\tBC\n\tBIT\t7,B\n\tJR\tZ,XHLINE1\n\tLD\tA,H\n\tEXX\n\tJR\tXPSET_A\nXHLINE2:\n\tLD\tA,H\n\tEXX\n\tCALL\tXPSET_A\n\tEXX\n\tINC\tDE\n\tDEC\tBC\n\tLD\tH,00H\n\tJR\tXHLINE\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXInkTo(AsmCodeBuf asmCodeBuf) {
        this.usesXINK = true;
    }

    @Override
    public void appendXJoyTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XJOY:\tLD\tA,H\n\tOR\tL\n\tJR\tNZ,XJOY1\n\tIN\tA,(90H)\n\tCPL\n\tAND\t3FH\n\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXJOY1:\tLD\tHL,0000H\n\tRET\n");
        this.usesJoystick = true;
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLOCATE:\n\tLD\tH,E\n\tLD\t(0B7A0H),HL\n\tRET\n");
        this.needsFullWindow = true;
    }

    @Override
    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tCALL\t0F003H\n\tDB\t02H\n\tRET\n");
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tCALL\t0F003H\n\tDB\t24H\n\tRET\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT_LEFT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,XPAINT_LEFT5\n\tDEC\tDE\nXPAINT_LEFT1:\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPUSH\tHL\n\tEXX\n\tPOP\tHL\n\tPOP\tDE\n\tJR\tC,XPAINT_LEFT4\n\tLD\tC,A\n\tLD\tB,(HL)\n\tLD\tA,B\nXPAINT_LEFT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_LEFT3\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tDEC\tDE\n\tSLA\tC\n\tJR\tNC,XPAINT_LEFT2\n\tLD\t(HL),B\n\tEXX\n\tCALL\tXPSET_WR_COLOR\n\tEXX\n\tJR\tXPAINT_LEFT1\nXPAINT_LEFT3:\n\tLD\t(HL),B\n\tEXX\n\tCALL\tXPSET_WR_COLOR\n\tEXX\nXPAINT_LEFT4:\n\tINC\tDE\nXPAINT_LEFT5:\n\tLD\t(PAINT_M_X1),DE\n\tRET\nXPAINT_RIGHT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPUSH\tHL\n\tEXX\n\tPOP\tHL\n\tPOP\tDE\n\tRET\tC\n\tLD\tC,A\n\tLD\tB,(HL)\n\tAND\tB\n\tSCF\n\tRET\tNZ\n\tJR\tXPAINT_RIGHT2\nXPAINT_RIGHT1:\n\tAND\tC\n\tJR\tNZ,XPAINT_RIGHT3\nXPAINT_RIGHT2:\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tINC\tDE\n\tSRL\tC\n\tJR\tNC,XPAINT_RIGHT1\n\tLD\t(HL),B\n\tEXX\n\tCALL\tXPSET_WR_COLOR\n\tEXX\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPUSH\tHL\n\tEXX\n\tPOP\tHL\n\tPOP\tDE\n\tJR\tC,XPAINT_RIGHT4\n\tLD\tC,A\n\tLD\tB,(HL)\n\tAND\tB\n\tJR\tNZ,XPAINT_RIGHT4\n\tJR\tXPAINT_RIGHT2\nXPAINT_RIGHT3:\n\tLD\t(HL),B\n\tEXX\n\tCALL\tXPSET_WR_COLOR\n\tEXX\nXPAINT_RIGHT4:\n\tDEC\tDE\n\tLD\t(PAINT_M_X2),DE\n\tOR\tA\n\tRET\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPaperTo(AsmCodeBuf asmCodeBuf) {
        this.usesXPAPER = true;
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPOINT:\tCALL\tX_PST\n\tJR\tC,XPOINT5\n\tLD\tB,A\n\tLD\tA,D\n\tOR\tE\n\tJR\tNZ,XPOINT1\n\tDB\t0DDH,0CBH,01H,0CFH\t;SET 1,(IX+01H),A\n\tOUT\t(84H),A\n\tLD\tC,(HL)\n\tDB\t0DDH,0CBH,01H,8FH\t;RES 1,(IX+01H),A\n\tOUT\t(84H),A\n\tJR\tXPOINT2\nXPOINT1:\n\tLD\tA,(DE)\n\tLD\tC,A\nXPOINT2:\n\tLD\tA,B\n\tAND\t(HL)\n\tLD\tA,C\n\tJR\tZ,XPOINT3\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tAND\t1FH\n\tJR\tXPOINT4\nXPOINT3:\n\tAND\t07H\nXPOINT4:\n\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXPOINT5:\n\tLD\tHL,0FFFFH\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPRES:\tCALL\tX_PST\n\tRET\tC\n\tCPL\n\tAND\t(HL)\n\tJR\tXPSET_WR_A\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\nXPSET_A:\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tB,A\n\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tLD\tA,(HL)\n\tXOR\tB\n\tJR\tXPSET_WR_A\nXPSET1:\tLD\tA,B\n\tCPL\n\tAND\t(HL)\n\tJR\tXPSET_WR_A\nXPSET2:\tLD\tA,B\n");
            }
            asmCodeBuf.append("XPSET_OR_A:\n\tOR\t(HL)\nXPSET_WR_A:\n\tLD\t(HL),A\nXPSET_WR_COLOR:\n\tLD\tA,D\n\tOR\tE\n\tJR\tNZ,XPSET3\n\tDB\t0DDH,0CBH,01H,0CFH\t;SET 1,(IX+01H),A\n\tOUT\t(84H),A\n\tLD\tA,(0B7A3H)\n\tLD\t(HL),A\n\tDB\t0DDH,0CBH,01H,8FH\t;RES 1,(IX+01H),A\n\tOUT\t(84H),A\n\tRET\nXPSET3:\tLD\tA,D\n\tCP\t0A8H\n\tRET\tC\n\tCP\t0B2H\n\tRET\tNC\n\tLD\tA,(0B7A3H)\n\tLD\t(DE),A\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf);
            this.needsFullWindow = true;
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPTEST:\tCALL\tX_PST\n\tJR\tC,X_PTEST1\n\tAND\t(HL)\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nX_PTEST1:\n\tLD\tHL,0FFFFH\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public int get100msLoopCount() {
        return 50;
    }

    @Override
    public String[] getBasicTargetNames() {
        return new String[]{BASIC_TARGET_NAME};
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null && emuSys instanceof KC85) {
            n = 3;
        }
        return n;
    }

    @Override
    public int getDefaultBegAddr() {
        return 768;
    }

    @Override
    public int getMaxAppNameLen() {
        return 38;
    }

    @Override
    public String getStartCmd(EmuSys emuSys, String string, int n) {
        String string2 = null;
        if (emuSys != null && emuSys instanceof KC85) {
            string2 = string;
        }
        return string;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{44};
    }

    @Override
    public boolean needsEnableVdip() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.needsFullWindow = false;
        this.usesJoystick = false;
        this.usesM052 = false;
        this.usesXCOLOR = false;
        this.usesXINK = false;
        this.usesXPAPER = false;
        this.pixUtilAppended = false;
        this.xpsetAppended = false;
    }

    @Override
    public boolean supportsColors() {
        return true;
    }

    @Override
    public boolean supportsGraphics() {
        return true;
    }

    @Override
    public boolean supportsXCLS() {
        return true;
    }

    @Override
    public boolean supportsXHLINE() {
        return true;
    }

    @Override
    public boolean supportsXJOY() {
        return true;
    }

    @Override
    public boolean supportsXLOCAT() {
        return true;
    }

    @Override
    public boolean supportsXLPTCH() {
        return true;
    }

    @Override
    public boolean supportsXPAINT_LEFT_RIGHT() {
        return true;
    }

    public String toString() {
        return "KC85/2..5, HC900";
    }

    protected void appendPixUtilTo(AsmCodeBuf asmCodeBuf) {
        if (!this.pixUtilAppended) {
            asmCodeBuf.append("X_PST:\tLD\tA,H\n\tOR\tA\n\tSCF\n\tRET\tNZ\n\tLD\tA,D\n\tOR\tA\n\tJR\tZ,X_PST1\n\tCP\t02H\n\tCCF\n\tRET\tC\n\tLD\tA,3FH\n\tCP\tE\n\tRET\tC\nX_PST1:\tLD\tA,L\n\tCPL\n\tLD\tH,A\n\tLD\tA,E\n\tAND\t07H\n\tLD\tB,A\n\tLD\tC,80H\n\tJR\tZ,X_PST3\nX_PST2:\tSRL\tC\n\tDJNZ\tX_PST2\nX_PST3:\tPUSH\tBC\n\tSRL\tD\n\tRR\tE\n\tSRL\tE\n\tSRL\tE\n\tLD\tL,E\n\tLD\tDE,0000H\n\tCALL\t0F003H\n\tDB\t34H\n\tPOP\tBC\n\tLD\tA,D\n\tOR\tE\n\tLD\tA,C\n\tRET\tNZ\n\tDB\t0DDH,0CBH,01H,88H\t;RES 1,(IX+01H),B\n\tLD\tC,84H\n\tOUT\t(C),B\n\tRET\n");
            this.pixUtilAppended = true;
        }
    }
}

