/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.HueblerGraphicsMC;
import jkcemu.emusys.huebler.AbstractHueblerMC;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;

public class HueblerGraphicsMCTarget
extends AbstractTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_HUEBLER";
    private boolean usesX_M_INKEY;
    private boolean pixUtilAppended;
    private boolean xpsetAppended;
    private boolean xptestAppended;

    public HueblerGraphicsMCTarget() {
        this.setNamedValue("GRAPHICSCREEN", 0);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesX_M_INKEY) {
            asmCodeBuf.append("X_M_INKEY:\n\tDS\t1\n");
        }
    }

    @Override
    public void appendExitTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tJP\t0F01EH\n");
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0019H\n");
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0100H\n");
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesX_M_INKEY) {
            asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_INKEY),A\n");
        }
    }

    @Override
    public void appendInputTo(AsmCodeBuf asmCodeBuf, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            asmCodeBuf.append("XCKBRK:\tCALL\t0F012H\n\tOR\tA\n\tRET\tZ\n\tCALL\t0F003H\n\tCP\t03H\n");
            if (bl2) {
                asmCodeBuf.append("\tJR\tZ,XBREAK\n\tLD\t(X_M_INKEY),A\n\tRET\nXINKEY:\tLD\tA,(X_M_INKEY)\n\tOR\tA\n\tJR\tZ,XINKE1\n\tPUSH\tAF\n\tXOR\tA\n\tLD\t(X_M_INKEY),A\n\tPOP\tAF\n\tRET\nXINKE1:\tCALL\t0F012H\n\tOR\tA\n\tRET\tZ\n");
                this.usesX_M_INKEY = true;
            } else {
                asmCodeBuf.append("\tRET\tNZ\n\tJR\tXBREAK\n");
            }
            if (bl3) {
                asmCodeBuf.append("XINCH:\n");
                if (this.usesX_M_INKEY) {
                    asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_INKEY),A\n");
                }
                asmCodeBuf.append("XINCH1:\tCALL\t0F003H\n\tCP\t03H\n\tJR\tZ,XBREAK\n\tRET\tNZ\n\tOR\tA\n\tJR\tZ,XINCH1\n\tRET\n");
            }
        } else {
            if (bl2) {
                asmCodeBuf.append("XINKEY:\tCALL\t0F012H\n\tOR\tA\n\tRET\tZ\n");
            }
            if (bl2 || bl3) {
                if (bl4) {
                    asmCodeBuf.append("XINCH:\tCALL\t0F003H\n\tCP\t03H\n\tRET\tNZ\n\tJR\tXBREAK\n");
                } else {
                    asmCodeBuf.append("XINCH:\tJP\t0F003H\n");
                }
            }
        }
    }

    @Override
    public void appendPrologTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler, String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            asmCodeBuf.append("\tJP\t");
            asmCodeBuf.append("MSTART");
            asmCodeBuf.append("\n\tDB\t0EDH,0FFH\n");
            asmCodeBuf.appendStringLiteral(string);
            bl = true;
        }
        if (!bl) {
            basicCompiler.putWarning("Programm kann auf dem Zielsystem nicht aufgerufen werden, da der Programmname leer ist.");
            asmCodeBuf.append("\tENT\n");
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0020H\n");
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0100H\n");
    }

    @Override
    public void appendXCursTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XCURS:\tPUSH\tHL\n\tLD\tC,1BH\n\tCALL\t0F009H\n\tPOP\tHL\n\tLD\tA,H\n\tOR\tL\n\tLD\tC,0BH\n\tJR\tZ,XCURS1\n\tINC\tC\nXCURS1:\tJP\t0F009H\n");
    }

    @Override
    public void appendXHLineTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XHLINE:\tBIT\t7,B\n\tRET\tNZ\n\tPUSH\tBC\n\tCALL\tX_PST\n\tPOP\tBC\n\tRET\tC\n\tLD\tD,00H\nXHLINE1:\n\tOR\tD\n\tLD\tD,A\n\tSLA\tA\n\tJR\tNC,XHLINE2\n\tLD\tA,D\n");
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("\tCALL\tXPSET_A\n");
        } else {
            asmCodeBuf.append("\tOR\t(HL)\n\tLD\t(HL),A\n");
        }
        asmCodeBuf.append("\tINC\tHL\n\tLD\tA,L\n\tAND\t1FH\n\tRET\tZ\n\tLD\tA,01H\n\tLD\tD,00H\nXHLINE2:\n\tDEC\tBC\n\tBIT\t7,B\n\tJR\tZ,XHLINE1\n\tLD\tA,D\n\tOR\tA\n\tJR\tNZ,XPSET_A\n\tRET\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLOCATE:\n\tLD\tA,1BH\n\tCALL\tXOUTCH\n\tLD\tA,E\n\tOR\t80H\n\tCALL\tXOUTCH\n\tLD\tA,L\n\tOR\t80H\n\tJR\tXOUTCH\n");
        this.appendXOutchTo(asmCodeBuf);
    }

    @Override
    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tLD\tC,A\n\tJP\t0F00FH\n");
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tLD\tC,A\n\tJP\t0F009H\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XOUTNL:\tLD\tC,0DH\n\tCALL\t0F009H\n\tLD\tC,0AH\n\tJP\t0F009H\n");
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT_LEFT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,XPAINT_LEFT5\n\tLD\tHL,(PAINT_M_Y)\n\tDEC\tDE\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPOP\tDE\n\tJR\tC,XPAINT_LEFT4\n\tLD\tC,A\n\tLD\tB,(HL)\nXPAINT_LEFT1:\n\tLD\tA,B\nXPAINT_LEFT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_LEFT3\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tDEC\tDE\n\tSRL\tC\n\tJR\tNC,XPAINT_LEFT2\n\tLD\t(HL),B\n\tDEC\tHL\n\tLD\tA,E\n\tINC\tA\n\tJR\tZ,XPAINT_LEFT4\n\tLD\tB,(HL)\n\tLD\tC,80H\n\tJR\tXPAINT_LEFT1\nXPAINT_LEFT3:\n\tLD\t(HL),B\nXPAINT_LEFT4:\n\tINC\tDE\nXPAINT_LEFT5:\n\tLD\t(PAINT_M_X1),DE\n\tRET\nXPAINT_RIGHT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPOP\tDE\n\tRET\tC\n\tLD\tC,A\n\tLD\tB,(HL)\n\tAND\tB\n\tSCF\n\tRET\tNZ\n\tJR\tXPAINT_RIGHT3\nXPAINT_RIGHT1:\n\tLD\tA,B\nXPAINT_RIGHT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_RIGHT4\nXPAINT_RIGHT3:\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tINC\tDE\n\tSLA\tC\n\tJR\tNC,XPAINT_RIGHT2\n\tLD\t(HL),B\n\tINC\tHL\n\tLD\tA,E\n\tOR\tA\n\tJR\tZ,XPAINT_RIGHT5\n\tLD\tB,(HL)\n\tLD\tC,01H\n\tJR\tXPAINT_RIGHT1\nXPAINT_RIGHT4:\n\tLD\t(HL),B\nXPAINT_RIGHT5:\n\tDEC\tDE\n\tLD\t(PAINT_M_X2),DE\n\tOR\tA\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        this.appendXPTestTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPRES:\tCALL\tX_PST\n\tRET\tC\n\tCPL\n\tAND\t(HL)\n\tLD\t(HL),A\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\nXPSET_A:\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tE,A\n\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tLD\tA,(HL)\n\tXOR\tE\n\tLD\t(HL),A\n\tRET\nXPSET1:\tLD\tA,E\n\tCPL\n\tAND\t(HL)\n\tLD\t(HL),A\n\tRET\nXPSET2:\tLD\tA,E\n");
            }
            asmCodeBuf.append("\tOR\t(HL)\n\tLD\t(HL),A\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf);
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xptestAppended) {
            asmCodeBuf.append("XPOINT:\nXPTEST:\tCALL\tX_PST\n\tJR\tC,X_PTEST1\n\tAND\t(HL)\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nX_PTEST1:\n\tLD\tHL,0FFFFH\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf);
            this.xptestAppended = true;
        }
    }

    @Override
    public int get100msLoopCount() {
        return 42;
    }

    @Override
    public String[] getBasicTargetNames() {
        return new String[]{BASIC_TARGET_NAME};
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null) {
            if (emuSys instanceof HueblerGraphicsMC) {
                n = 3;
            } else if (emuSys instanceof AbstractHueblerMC) {
                n = 1;
            }
        }
        return n;
    }

    @Override
    public int getDefaultBegAddr() {
        return 256;
    }

    @Override
    public int getMaxAppNameLen() {
        return 14;
    }

    @Override
    public String getStartCmd(EmuSys emuSys, String string, int n) {
        String string2 = null;
        if (emuSys != null && emuSys instanceof AbstractHueblerMC) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{252};
    }

    @Override
    public void reset() {
        super.reset();
        this.usesX_M_INKEY = false;
        this.pixUtilAppended = false;
        this.xpsetAppended = false;
        this.xptestAppended = false;
    }

    @Override
    public boolean supportsGraphics() {
        return true;
    }

    @Override
    public boolean supportsXCURS() {
        return true;
    }

    @Override
    public boolean supportsXHLINE() {
        return true;
    }

    @Override
    public boolean supportsXLOCAT() {
        return true;
    }

    @Override
    public boolean supportsXLPTCH() {
        return true;
    }

    @Override
    public boolean supportsXPAINT_LEFT_RIGHT() {
        return true;
    }

    public String toString() {
        return "H\u00fcbler-Grafik-MC";
    }

    private void appendPixUtilTo(AsmCodeBuf asmCodeBuf) {
        if (!this.pixUtilAppended) {
            asmCodeBuf.append("X_PST:\tLD\tA,D\n\tOR\tH\n\tSCF\n\tRET\tNZ\n\tLD\tA,E\n\tAND\t07H\n\tLD\tB,A\n\tLD\tA,01H\n\tJR\tZ,X_PST2\nX_PST1:\tSLA\tA\n\tDJNZ\tX_PST1\nX_PST2:\tSRL\tE\n\tSRL\tE\n\tSRL\tE\n\tLD\tC,E\n\tLD\tB,00H\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tLD\tDE,0DFE0H\n\tEX\tDE,HL\n\tOR\tA\n\tSBC\tHL,DE\n\tADD\tHL,BC\n\tOR\tA\n\tRET\n");
            this.pixUtilAppended = true;
        }
    }
}

