/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import java.util.Set;
import jkcemu.base.EmuSys;
import jkcemu.emusys.NANOS;
import jkcemu.emusys.PCM;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicLibrary;

public class CPMTarget
extends AbstractTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_CPM";
    private static final int IOCTB_M_BIN_OFFS = 10;
    private static final int IOCTB_M_ERR_OFFS = 11;
    private static final int IOCTB_M_POS_OFFS = 12;
    private static final int IOCTB_FCB_OFFS = 13;
    private static final int IOCTB_FCB_R0_OFFS = 46;
    private static final int IOCTB_FNAME_OFFS = 14;
    private static final int IOCTB_FTYPE_OFFS = 22;
    private static final int IOCTB_DMA_OFFS = 49;
    private static final int IOCTB_CHANNEL_SIZE = 177;
    private boolean usesFileRead;
    private boolean usesFileWrite;
    private boolean usesX_M_INKEY;

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesFileRead || this.usesFileWrite) {
            asmCodeBuf.append("X_CPM_FILE_M_DRIVE:\tDS\t1\nX_CPM_FILE_M_FNAME:\tDS\t2\n");
        }
        if (this.usesX_M_INKEY) {
            asmCodeBuf.append("X_M_INKEY:\tDS\t1\n");
        }
    }

    @Override
    public void appendDataTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesFileRead || this.usesFileWrite) {
            asmCodeBuf.append("X_CPM_FILE_DATA_VALID_CHR:\n\tDB\t21H,23H,24H,25H,26H,27H,28H,29H,2BH\n\tDB\t2DH,3DH,5EH,5FH,60H,7BH,7DH,7EH,00H\n");
        }
        if (this.usesFileRead) {
            asmCodeBuf.append("X_CPM_FILE_DATA_RDPTRS:\n\tDW\tX_CPM_FILE_CLOSE\n\tDW\tX_CPM_FILE_EOF\n\tDW\tX_CPM_FILE_READ\n");
        }
    }

    @Override
    public void appendExitTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tJP\t0000H\n");
    }

    @Override
    public void appendFileHandler(BasicCompiler basicCompiler) {
        boolean bl = false;
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        Set<BasicLibrary.LibItem> set = basicCompiler.getLibItems();
        AbstractTarget abstractTarget = basicCompiler.getTarget();
        asmCodeBuf.append(this.getFileHandlerLabel());
        asmCodeBuf.append(":\n");
        Set<Integer> set2 = basicCompiler.getIODriverModes(BasicCompiler.IODriver.FILE);
        if (set2 != null && !set2.isEmpty()) {
            boolean bl2 = set2.contains(24);
            boolean bl3 = set2.contains(20);
            boolean bl4 = set2.contains(18) || set2.contains(17);
            boolean bl5 = set2.contains(40);
            boolean bl6 = set2.contains(36);
            boolean bl7 = set2.contains(34) || set2.contains(33);
            asmCodeBuf.append("\tLD\tDE,(IO_M_NAME)\n\tLD\tA,(DE)\n\tCALL\tC_UPR\n\tCP\t41H\n\tJR\tC,X_CPM_FILE_HANDLER2\n\tCP\t51H\n\tJR\tNC,X_CPM_FILE_HANDLER2\n\tLD\tB,A\n\tINC\tDE\n\tLD\tA,(DE)\n\tCP\t30H\n\tJR\tC,X_CPM_FILE_HANDLER2\n\tCP\t3AH\n\tJR\tZ,X_CPM_FILE_HANDLER5\n\tJR\tNC,X_CPM_FILE_HANDLER2\n\tSUB\t30H\nX_CPM_FILE_HANDLER1:\n\tLD\tC,A\n\tINC\tDE\n\tLD\tA,(DE)\n\tSUB\t30H\n\tJR\tC,X_CPM_FILE_HANDLER2\n\tCP\t0AH\n\tJR\tZ,X_CPM_FILE_HANDLER6\n\tJR\tNC,X_CPM_FILE_HANDLER2\n\tPUSH\tAF\n\tLD\tA,C\n\tADD\tA,A\n\tADD\tA,A\n\tADD\tA,C\n\tADD\tA,A\n\tLD\tC,A\n\tPOP\tAF\n\tADD\tA,C\n\tJR\tNC,X_CPM_FILE_HANDLER1\nX_CPM_FILE_HANDLER2:\n\tLD\tDE,(IO_M_NAME)\nX_CPM_FILE_HANDLER3:\n\tLD\tA,(DE)\n\tOR\tA\n\tJR\tZ,X_CPM_FILE_HANDLER4\n\tINC\tDE\n\tCP\t3AH\n\tJR\tNZ,X_CPM_FILE_HANDLER3\n\tSCF\n\tRET\nX_CPM_FILE_HANDLER4:\n\tXOR\tA\n\tLD\t(X_CPM_FILE_M_DRIVE),A\n\tLD\tHL,(IO_M_NAME)\n\tLD\t(X_CPM_FILE_M_FNAME),HL\n\tJR\tX_CPM_FILE_HANDLER7\nX_CPM_FILE_HANDLER5:\n\tLD\tA,B\n\tSUB\t40H\n\tLD\t(X_CPM_FILE_M_DRIVE),A\n\tINC\tDE\n\tLD\t(X_CPM_FILE_M_FNAME),DE\n\tJR\tX_CPM_FILE_HANDLER7\nX_CPM_FILE_HANDLER6:\n\tLD\tA,B\n\tSUB\t40H\n\tLD\t(X_CPM_FILE_M_DRIVE),A\n\tINC\tDE\n\tLD\t(X_CPM_FILE_M_FNAME),DE\n\tLD\tE,C\n\tLD\tC,20H\n\tCALL\t0005H\nX_CPM_FILE_HANDLER7:\n\tCALL\tX_CPM_FILE_FILL_FCB\n\tCCF\n\tRET\tNC\n\tLD\tHL,IO_M_ACCESS\n");
            if (bl4 || bl7) {
                asmCodeBuf.append_LD_A_n(3);
                asmCodeBuf.append("\tAND\t(HL)\n\tJR\tNZ,X_CPM_FILE_HANDLER8\n");
            }
            if (bl3 || bl6) {
                asmCodeBuf.append_LD_A_n(4);
                asmCodeBuf.append("\tAND\t(HL)\n\tJR\tNZ,X_CPM_FILE_HANDLER10\n");
            }
            if (bl2 || bl5) {
                asmCodeBuf.append_LD_A_n(8);
                asmCodeBuf.append("\tAND\t(HL)\n\tJR\tNZ,X_CPM_FILE_HANDLER13\n");
            }
            BasicLibrary.appendSetErrorIOMode(basicCompiler);
            asmCodeBuf.append("\tOR\tA\n\tRET\n");
            if (bl4 || bl7) {
                asmCodeBuf.append("X_CPM_FILE_HANDLER8:\n\tLD\tC,0FH\n\tCALL\tX_CPM_FILE_BDOS\n\tCP\t04H\n\tJR\tC,X_CPM_FILE_HANDLER9\n");
                BasicLibrary.appendSetErrorFileNotFound(basicCompiler);
                asmCodeBuf.append("\tOR\tA\n\tRET\nX_CPM_FILE_HANDLER9:\n\tCALL\tX_CPM_FILE_CLEAR_CHANNEL\n\tLD\tDE,(IO_M_CADDR)\n\tLD\tHL,X_CPM_FILE_DATA_RDPTRS\n\tLD\tBC,0008H\n\tLDIR\n\tLD\tHL,(IO_M_CADDR)\n");
                asmCodeBuf.append_LD_DE_nn(12);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\t(HL),0FFH\n\tOR\tA\n\tRET\n");
                this.usesFileRead = true;
            }
            if (bl3 || bl6) {
                asmCodeBuf.append("X_CPM_FILE_HANDLER10:\n\tLD\tC,13H\n\tCALL\tX_CPM_FILE_BDOS\n");
            }
            if (bl3 || bl6 || bl2 || bl5) {
                asmCodeBuf.append("X_CPM_FILE_HANDLER11:\n\tCALL\tX_CPM_FILE_FILL_FCB\n\tCCF\n\tRET\tNC\n\tLD\tC,16H\n\tCALL\tX_CPM_FILE_BDOS\n\tCP\t04H\n\tJR\tC,X_CPM_FILE_HANDLER12\n");
                BasicLibrary.appendSetErrorDirFull(basicCompiler);
                asmCodeBuf.append("\tOR\tA\n\tRET\nX_CPM_FILE_HANDLER12:\n\tCALL\tX_CPM_FILE_CLEAR_CHANNEL\n\tLD\tHL,(IO_M_CADDR)\n\tPUSH\tHL\n\tLD\t(HL),LOW(X_CPM_FILE_CLOSE)\n\tINC\tHL\n\tLD\t(HL),HIGH(X_CPM_FILE_CLOSE)\n\tPOP\tHL\n");
                asmCodeBuf.append_LD_DE_nn(6);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\t(HL),LOW(X_CPM_FILE_WRITE)\n\tINC\tHL\n\tLD\t(HL),HIGH(X_CPM_FILE_WRITE)\n\tOR\tA\n\tRET\n");
                this.usesFileWrite = true;
            }
            if (bl2 || bl5) {
                asmCodeBuf.append("X_CPM_FILE_HANDLER13:\n\tLD\tC,0FH\n\tCALL\tX_CPM_FILE_BDOS\n\tCP\t04H\n\tJR\tNC,X_CPM_FILE_HANDLER11\n");
                if (bl2 && bl5) {
                    asmCodeBuf.append("\tLD\tDE,(IO_M_CADDR)\n");
                    asmCodeBuf.append_LD_HL_nn(10);
                    asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tJR\tNZ,X_CPM_FILE_HANDLER18\n");
                }
                if (bl2) {
                    asmCodeBuf.append("X_CPM_FILE_HANDLER14:\n\tCALL\tX_CPM_FILE_SET_DMA_ADDR\n\tLD\tC,21H\n\tCALL\tX_CPM_FILE_BDOS\n\tOR\tA\n\tJR\tZ,X_CPM_FILE_HANDLER15\n\tCP\t07H\n\tJR\tC,X_CPM_FILE_HANDLER12\n\tJR\tX_CPM_FILE_HANDLER19\nX_CPM_FILE_HANDLER15:\n\tLD\tDE,(IO_M_CADDR)\n");
                    asmCodeBuf.append_LD_HL_nn(49);
                    asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tC,00H\nX_CPM_FILE_HANDLER16:\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tZ,X_CPM_FILE_HANDLER17\n\tCP\t1AH\n\tJR\tZ,X_CPM_FILE_HANDLER17\n\tINC\tHL\n\tINC\tC\n\tJP\tP,X_CPM_FILE_HANDLER16\n\tLD\tDE,(IO_M_CADDR)\n");
                    asmCodeBuf.append_LD_HL_nn(46);
                    asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,01H\n\tADD\tA,(HL)\n\tLD\t(HL),A\n\tJR\tNC,X_CPM_FILE_HANDLER14\n\tINC\tHL\n\tINC\t(HL)\n\tJR\tX_CPM_FILE_HANDLER14\nX_CPM_FILE_HANDLER17:\n\tPUSH\tBC\n\tPUSH\tDE\n\tCALL\tX_CPM_FILE_HANDLER12\n\tPOP\tDE\n");
                    asmCodeBuf.append_LD_HL_nn(12);
                    asmCodeBuf.append("\tADD\tHL,DE\n\tPOP\tBC\n\tLD\t(HL),C\n\tRET\n");
                }
                if (bl5) {
                    asmCodeBuf.append("X_CPM_FILE_HANDLER18:\n\tCALL\tX_CPM_FILE_SET_DMA_ADDR\n\tLD\tC,14H\n\tCALL\tX_CPM_FILE_BDOS\n\tOR\tA\n\tJR\tZ,X_CPM_FILE_HANDLER18\n\tCP\t01H\n\tJR\tZ,X_CPM_FILE_HANDLER12\n");
                }
                asmCodeBuf.append("X_CPM_FILE_HANDLER19:\n\tINC\tA\n\tJR\tNZ,X_CPM_FILE_HANDLER20\n");
                BasicLibrary.appendSetErrorHardware(basicCompiler);
                asmCodeBuf.append("\tOR\tA\n\tRET\nX_CPM_FILE_HANDLER20:\n");
                BasicLibrary.appendSetError(basicCompiler);
                asmCodeBuf.append("\tOR\tA\n\tRET\n");
            }
            asmCodeBuf.append("X_CPM_FILE_CLOSE:\n");
            if (bl3 || bl2 || bl6 || bl5) {
                if (bl4 || bl7) {
                    asmCodeBuf.append_LD_HL_nn(6);
                    asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tINC\tHL\n\tOR\tA\n\tJR\tZ,X_CPM_FILE_CLOSE2\n");
                }
                if (bl3 || bl2) {
                    if (bl6 || bl5) {
                        asmCodeBuf.append_LD_HL_nn(10);
                        asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tNZ,X_CPM_FILE_CLOSE1\n");
                    }
                    asmCodeBuf.append("\tPUSH\tDE\n\tLD\tA,1AH\n\tCALL\tX_CPM_FILE_WRITE\n\tPOP\tDE\nX_CPM_FILE_CLOSE1:\n");
                }
                asmCodeBuf.append_LD_HL_nn(12);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tOR\tA\n\tCALL\tNZ,X_CPM_FILE_WRITE2\nX_CPM_FILE_CLOSE2:\n");
            }
            asmCodeBuf.append("\tLD\tC,10H\n\tCALL\tX_CPM_FILE_BDOS\n\tCP\t04H\n\tRET\tC\n");
            BasicLibrary.appendSetError(basicCompiler);
            asmCodeBuf.append("\tRET\n");
            if (bl4 || bl7) {
                asmCodeBuf.append("X_CPM_FILE_EOF:\n");
                asmCodeBuf.append_LD_HL_nn(11);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tLD\tHL,0000H\n\tOR\tA\n\tRET\tZ\n\tDEC\tHL\n\tRET\n");
            }
            if (bl4 || bl7) {
                asmCodeBuf.append("X_CPM_FILE_READ:\n");
                asmCodeBuf.append_LD_HL_nn(11);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tCALL\tX_CPM_FILE_READ_CHECK_ERR\n\tLD\tA,00H\n\tRET\tC\n\tINC\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tJP\tP,X_CPM_FILE_READ1\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tX_CPM_FILE_SET_DMA_ADDR\n\tLD\tC,14H\n\tCALL\tX_CPM_FILE_BDOS\n\tPOP\tHL\n\tPOP\tDE\n\tDEC\tHL\n\tLD\t(HL),A\n\tCALL\tX_CPM_FILE_READ_CHECK_ERR\n\tLD\tA,00H\n\tRET\tC\n\tINC\tHL\nX_CPM_FILE_READ1:\n\tINC\tA\n\tLD\t(HL),A\n\tDEC\tA\n");
                asmCodeBuf.append_LD_HL_nn(49);
                asmCodeBuf.append("\tADD\tHL,DE\n\tADD\tA,L\n\tLD\tL,A\n\tLD\tA,H\n\tADC\tA,00H\n\tLD\tH,A\n\tLD\tA,(HL)\n");
                if (bl4) {
                    asmCodeBuf.append("\tOR\tA\n\tJR\tZ,X_CPM_FILE_READ2\n\tCP\t1AH\n\tRET\tNZ\nX_CPM_FILE_READ2:\n");
                    if (bl7) {
                        asmCodeBuf.append("\tLD\tB,A\n");
                        asmCodeBuf.append_LD_HL_nn(10);
                        asmCodeBuf.append("\tADD\tHL,DE\n\tOR\tA\n\tLD\tA,B\n\tRET\tNZ\n\tINC\tHL\n");
                    } else {
                        asmCodeBuf.append_LD_HL_nn(11);
                        asmCodeBuf.append("\tADD\tHL,DE\n");
                    }
                    asmCodeBuf.append("\tLD\tA,01H\n\tLD\t(HL),A\n\tCALL\tX_CPM_FILE_READ_CHECK_ERR\n\tXOR\tA\n");
                }
                asmCodeBuf.append("\tRET\nX_CPM_FILE_READ_CHECK_ERR:\n\tOR\tA\n\tRET\tZ\n");
                if (basicCompiler.usesErrorVars()) {
                    asmCodeBuf.append("\tPUSH\tHL\n\tCP\t01H\n\tJR\tZ,X_CPM_FILE_READ_CHECK_ERR1\n\tCP\t0AH\n\tJR\tZ,X_CPM_FILE_READ_CHECK_ERR2\n\tCP\t0FFH\n\tJR\tZ,X_CPM_FILE_READ_CHECK_ERR3\n");
                    BasicLibrary.appendSetError(basicCompiler);
                    asmCodeBuf.append("\tJR\tX_CPM_FILE_READ_CHECK_ERR4\nX_CPM_FILE_READ_CHECK_ERR1:\n");
                    BasicLibrary.appendSetErrorEOF(basicCompiler);
                    asmCodeBuf.append("\tJR\tX_CPM_FILE_READ_CHECK_ERR4\nX_CPM_FILE_READ_CHECK_ERR2:\n");
                    BasicLibrary.appendSetErrorMediaChanged(basicCompiler);
                    asmCodeBuf.append("\tJR\tX_CPM_FILE_READ_CHECK_ERR4\nX_CPM_FILE_READ_CHECK_ERR3:\n");
                    BasicLibrary.appendSetErrorHardware(basicCompiler);
                    asmCodeBuf.append("X_CPM_FILE_READ_CHECK_ERR4:\n\tPOP\tHL\n");
                }
                asmCodeBuf.append("\tSCF\n\tRET\n");
            }
            asmCodeBuf.append("X_CPM_FILE_WRITE:\n");
            if (bl3 || bl2 || bl6 || bl5) {
                asmCodeBuf.append("\tLD\tB,A\n\tLD\tDE,(IO_M_CADDR)\n");
                asmCodeBuf.append_LD_HL_nn(11);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tCALL\tX_CPM_FILE_WRITE_CHECK_ERR\n\tRET\tC\n\tINC\tHL\n\tLD\tC,(HL)\n\tPUSH\tHL\n");
                asmCodeBuf.append_LD_HL_nn(49);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,L\n\tADD\tA,C\n\tLD\tL,A\n\tLD\tA,H\n\tADC\tA,00H\n\tLD\tH,A\n\tLD\t(HL),B\n\tPOP\tHL\n\tINC\tC\n\tLD\t(HL),C\n\tRET\tP\n\tLD\t(HL),00H\nX_CPM_FILE_WRITE2:\n\tCALL\tX_CPM_FILE_SET_DMA_ADDR\n\tLD\tC,15H\n\tJP\tX_CPM_FILE_BDOS\n");
                asmCodeBuf.append_LD_HL_nn(11);
                asmCodeBuf.append("\tADD\tHL,DE\n\tLD\t(HL),A\nX_CPM_FILE_WRITE_CHECK_ERR:\n\tOR\tA\n\tRET\tZ\n");
                if (basicCompiler.usesErrorVars()) {
                    asmCodeBuf.append("\tPUSH\tHL\n\tCP\t01H\n\tJR\tZ,X_CPM_FILE_WRITE_CHECK_ERR1\n\tCP\t02H\n\tJR\tZ,X_CPM_FILE_WRITE_CHECK_ERR2\n\tCP\t0AH\n\tJR\tZ,X_CPM_FILE_WRITE_CHECK_ERR3\n\tCP\t0FFH\n\tJR\tZ,X_CPM_FILE_WRITE_CHECK_ERR4\n");
                    BasicLibrary.appendSetError(basicCompiler);
                    asmCodeBuf.append("\tJR\tX_CPM_FILE_WRITE_CHECK_ERR5\nX_CPM_FILE_WRITE_CHECK_ERR1:\n");
                    BasicLibrary.appendSetErrorDirFull(basicCompiler);
                    asmCodeBuf.append("\tJR\tX_CPM_FILE_WRITE_CHECK_ERR5\nX_CPM_FILE_WRITE_CHECK_ERR2:\n");
                    BasicLibrary.appendSetErrorDiskFull(basicCompiler);
                    asmCodeBuf.append("\tJR\tX_CPM_FILE_WRITE_CHECK_ERR5\nX_CPM_FILE_WRITE_CHECK_ERR3:\n");
                    BasicLibrary.appendSetErrorMediaChanged(basicCompiler);
                    asmCodeBuf.append("\tJR\tX_CPM_FILE_WRITE_CHECK_ERR5\nX_CPM_FILE_WRITE_CHECK_ERR4:\n");
                    BasicLibrary.appendSetErrorHardware(basicCompiler);
                    asmCodeBuf.append("X_CPM_FILE_WRITE_CHECK_ERR5:\n\tPOP\tHL\n");
                }
                asmCodeBuf.append("\tSCF\n\tRET\n");
            }
            asmCodeBuf.append("X_CPM_FILE_CLEAR_CHANNEL:\n\tLD\tHL,(IO_M_CADDR)\n\tLD\tB,");
            asmCodeBuf.appendHex2(13);
            asmCodeBuf.append("\n\tXOR\tA\nX_CPM_FILE_CLEAR_CHANNEL1:\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tX_CPM_FILE_CLEAR_CHANNEL1\n\tRET\nX_CPM_FILE_FILL_FCB:\n\tLD\tHL,(IO_M_CADDR)\n");
            asmCodeBuf.append_LD_BC_nn(13);
            asmCodeBuf.append("\tADD\tHL,BC\n\tLD\tA,(X_CPM_FILE_M_DRIVE)\n\tLD\t(HL),A\n\tINC\tHL\n\tPUSH\tHL\n\tLD\tA,20H\n\tLD\tB,0BH\nX_CPM_FILE_FILL_FCB1:\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tX_CPM_FILE_FILL_FCB1\n\tXOR\tA\n\tLD\tB,18H\nX_CPM_FILE_FILL_FCB2:\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tX_CPM_FILE_FILL_FCB2\n\tPOP\tHL\n\tLD\tDE,(X_CPM_FILE_M_FNAME)\n\tLD\tA,(DE)\n\tOR\tA\n\tJR\tZ,X_CPM_FILE_FILL_FCB6\n\tLD\tB,08H\nX_CPM_FILE_FILL_FCB3:\n\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tRET\tZ\n\tCP\t2EH\n\tJR\tZ,X_CPM_FILE_FILL_FCB4\n\tCALL\tX_CPM_FILE_TO_VALID_CHR\n\tJR\tC,X_CPM_FILE_FILL_FCB6\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tX_CPM_FILE_FILL_FCB3\n\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tRET\tZ\n\tCP\t2EH\n\tJR\tNZ,X_CPM_FILE_FILL_FCB6\nX_CPM_FILE_FILL_FCB4:\n\tLD\tHL,(IO_M_CADDR)\n");
            asmCodeBuf.append_LD_BC_nn(22);
            asmCodeBuf.append("\tADD\tHL,BC\n\tLD\tB,03H\nX_CPM_FILE_FILL_FCB5:\n\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tRET\tZ\n\tCALL\tX_CPM_FILE_TO_VALID_CHR\n\tJR\tC,X_CPM_FILE_FILL_FCB6\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tX_CPM_FILE_FILL_FCB5\n\tLD\tA,(DE)\n\tOR\tA\n\tRET\tZ\nX_CPM_FILE_FILL_FCB6:\n");
            BasicLibrary.appendSetErrorInvalidFileName(basicCompiler);
            asmCodeBuf.append("\tSCF\n\tRET\nX_CPM_FILE_TO_VALID_CHR:\n\tCP\t30H\n\tJR\tC,X_CPM_FILE_TO_VALID_CHR1\n\tCP\t3AH\n\tCCF\n\tRET\tNC\n\tCP\t40H\n\tJR\tC,X_CPM_FILE_TO_VALID_CHR1\n\tCP\t5BH\n\tCCF\n\tRET\tNC\n\tCP\t61H\n\tJR\tC,X_CPM_FILE_TO_VALID_CHR1\n\tCP\t7BH\n\tJR\tNC,X_CPM_FILE_TO_VALID_CHR1\n\tSUB\t20H\n\tRET\nX_CPM_FILE_TO_VALID_CHR1:\n\tLD\tHL,X_CPM_FILE_DATA_VALID_CHR\n\tLD\tB,A\nX_CPM_FILE_TO_VALID_CHR2:\n\tLD\tA,(HL)\n\tINC\tHL\n\tOR\tA\n\tSCF\n\tRET\tZ\n\tCP\tB\n\tJR\tNZ,X_CPM_FILE_TO_VALID_CHR2\n\tRET\nX_CPM_FILE_BDOS:\n\tLD\tHL,(IO_M_CADDR)\n");
            asmCodeBuf.append_LD_DE_nn(13);
            asmCodeBuf.append("\tADD\tHL,DE\n\tEX\tDE,HL\n\tJP\t0005H\nX_CPM_FILE_SET_DMA_ADDR:\n\tLD\tHL,(IO_M_CADDR)\n");
            asmCodeBuf.append_LD_DE_nn(49);
            asmCodeBuf.append("\tADD\tHL,DE\n\tEX\tDE,HL\n\tLD\tC,1AH\n\tJP\t0005H\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.C_UPR);
            bl = true;
        }
        if (!bl) {
            asmCodeBuf.append("\tSCF\n\tRET\n");
        }
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesX_M_INKEY) {
            asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_INKEY),A\n");
        }
    }

    @Override
    public void appendInputTo(AsmCodeBuf asmCodeBuf, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            if (bl3) {
                asmCodeBuf.append("XINCH:\tXOR\tA\n\tLD\t(X_M_INKEY),A\nXINCH1:\tCALL\tXINKE1\n\tOR\tA\n\tJR\tZ,XINCH1\n\tRET\n");
                bl2 = true;
            }
            asmCodeBuf.append("XCKBRK:\tLD\tC,06H\n\tLD\tE,0FFH\n\tCALL\t0005H\n\tCP\t03H\n");
            if (bl2) {
                asmCodeBuf.append("\tJR\tZ,XBREAK\n\tOR\tA\n\tRET\tZ\n\tLD\t(X_M_INKEY),A\n\tRET\nXINKEY:\tLD\tA,(X_M_INKEY)\n\tOR\tA\n\tJR\tZ,XINKE1\n\tPUSH\tAF\n\tXOR\tA\n\tLD\t(X_M_INKEY),A\n\tPOP\tAF\n\tRET\nXINKE1:\tLD\tC,06H\n\tLD\tE,0FFH\n\tCALL\t0005H\n\tCP\t03H\n");
                this.usesX_M_INKEY = true;
            }
            asmCodeBuf.append("\tRET\tNZ\n\tJR\tXBREAK\n");
        } else {
            if (bl3) {
                asmCodeBuf.append("XINCH:\tCALL\tXINKEY\n\tOR\tA\n\tJR\tZ,XINCH\n\tRET\n");
                bl2 = true;
            }
            asmCodeBuf.append("XINKEY:\tLD\tC,06H\n\tLD\tE,0FFH\n");
            if (bl4) {
                asmCodeBuf.append("\tCALL\t0005H\n\tCP\t03H\n\tJR\tZ,XBREAK\n\tRET\n");
            }
            asmCodeBuf.append("\tJP\t0005H\n");
        }
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLOCATE:\n\tPUSH\tHL\n\tPUSH\tDE\n\tLD\tA,1BH\n\tCALL\tXOUTCH\n\tPOP\tDE\n\tLD\tA,E\n\tOR\t80H\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tLD\tA,L\n\tOR\t80H\n\tCALL\tXOUTCH\n\tRET\n");
        this.appendXOutchTo(asmCodeBuf);
    }

    @Override
    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tLD\tC,5\n\tLD\tE,A\n\tJP\t0005H\n");
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tLD\tC,02H\n\tLD\tE,A\n\tJP\t0005H\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XOUTNL:\tLD\tC,02H\n\tLD\tE,0DH\n\tCALL\t0005H\n\tLD\tC,02H\n\tLD\tE,0AH\n\tJP\t0005H\n");
    }

    @Override
    public int get100msLoopCount() {
        return 69;
    }

    @Override
    public String[] getBasicTargetNames() {
        return new String[]{BASIC_TARGET_NAME};
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null && (emuSys instanceof NANOS || emuSys instanceof PCM)) {
            n = 3;
        }
        return n;
    }

    @Override
    public int getDefaultBegAddr() {
        return 256;
    }

    @Override
    public String getFileHandlerLabel() {
        return "X_CPM_FILE_HANDLER";
    }

    @Override
    public int getFileIOChannelSize() {
        return 177;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{252};
    }

    @Override
    public void reset() {
        super.reset();
        this.usesFileRead = false;
        this.usesFileWrite = false;
        this.usesX_M_INKEY = false;
    }

    @Override
    public boolean startsWithFileDevice(String string) {
        char c;
        int n;
        boolean bl = false;
        if (string != null && (n = string.length()) > 1 && ((c = string.charAt(0)) >= 'A' && c <= 'P' || c >= 'a' && c <= 'p')) {
            int n2 = 1;
            while (n2 < n) {
                if ((c = string.charAt(n2++)) == ':') {
                    bl = true;
                    break;
                }
                if (c >= '0' && c <= '9') continue;
                break;
            }
        }
        return bl;
    }

    @Override
    public boolean supportsXLOCAT() {
        return true;
    }

    @Override
    public boolean supportsXLPTCH() {
        return true;
    }

    public String toString() {
        return "CP/M-kompatibel";
    }
}

