/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.AC1;
import jkcemu.emusys.ac1_llc2.AbstractSCCHSys;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.target.SCCHTarget;

public class AC1Target
extends SCCHTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_AC1";
    private boolean usesColors;
    private boolean pixUtilAppended;
    private boolean xclsAppended;
    private boolean xpsetAppended;

    public AC1Target() {
        this.setNamedValue("GRAPHICSCREEN", 0);
        this.setNamedValue("BLACK", 0);
        this.setNamedValue("BLUE", 4);
        this.setNamedValue("CYAN", 6);
        this.setNamedValue("GREEN", 2);
        this.setNamedValue("MAGENTA", 5);
        this.setNamedValue("RED", 1);
        this.setNamedValue("WHITE", 7);
        this.setNamedValue("YELLOW", 3);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesColors) {
            asmCodeBuf.append("X_MCOS:\tDS\t1\nX_MCOV:\tDS\t1\n");
        }
    }

    @Override
    public void appendXClsTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xclsAppended) {
            asmCodeBuf.append("XCLS:");
            if (this.usesColors) {
                asmCodeBuf.append("\tLD\tA,(X_MCOS)\n\tOR\tA\n\tJR\tZ,XCOL1\n\tIN\tA,(0F0H)\n\tOR\t04H\n\tOUT\t(0F0H),A\n\tEX\tAF,AF'\n\tLD\tA,(X_MCOV)\n\tLD\tHL,1000H\n\tLD\t(HL),A\n\tLD\tDE,1001H\n\tLD\tBC,07FFH\n\tLDIR\n\tEX\tAF,AF'\n\tAND\t0FBH\n\tOUT\t(0F0H),A\nXCOL1:\tLD\tA,20H\n\tLD\tHL,1000H\n\tLD\t(HL),A\n\tLD\tDE,1001H\n\tLD\tBC,07FFH\n\tLDIR\n\tLD\t(1800H),HL\n\tLD\t(1846H),A\n\tRET\n");
            } else {
                asmCodeBuf.append("\tLD\tA,0CH\n");
                if (this.xoutchAppended) {
                    asmCodeBuf.append("\tJR\tXOUTCH\n");
                } else {
                    this.appendXOutchTo(asmCodeBuf);
                }
            }
            this.xclsAppended = true;
        }
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0040H\n");
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesColors) {
            asmCodeBuf.append("\tLD\tB,00H\n\tLD\tC,0F0H\n\tIN\tE,(C)\n\tSET\t2,E\n\tOUT\t(C),E\n\tIN\tD,(C)\n\tRES\t2,E\n\tOUT\t(C),E\n\tIN\tA,(C)\n\tXOR\tD\n\tAND\t04H\n\tJR\tZ,X_INIT1\n\tLD\tB,0FH\n\tLD\tA,(181FH)\n\tLD\tD,A\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tXOR\tD\n\tAND\t0F0H\n\tJR\tZ,X_INIT1\n\tLD\tB,D\nX_INIT1:\n\tLD\tA,B\n\tLD\t(X_MCOS),A\n\tLD\t(X_MCOV),A\n");
        }
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0080H\n");
    }

    @Override
    public void appendXColorTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XCOLOR:\tLD\tA,E\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tAND\t0F0H\n\tLD\tB,A\n\tLD\tA,L\n\tAND\t0FH\n\tOR\tB\n\tLD\t(X_MCOV),A\n\tRET\n");
        this.usesColors = true;
    }

    @Override
    public void appendXInkTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XINK:\tLD\tA,(X_MCOV)\n\tAND\t0F0H\n\tLD\tB,A\n\tLD\tA,L\n\tAND\t0FH\n\tOR\tB\n\tLD\t(X_MCOV),A\n\tRET\n");
        this.usesColors = true;
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesColors) {
            asmCodeBuf.append("XLOCATE:\n\tLD\tA,H\n\tOR\tD\n\tRET\tNZ\n\tLD\tA,3FH\n\tCP\tE\n\tRET\tC\n\tLD\tA,1FH\n\tCP\tL\n\tRET\tC\n\tPUSH\tHL\n\tLD\tHL,(1800H)\n\tLD\tA,(1846H)\n\tLD\t(HL),A\n\tPOP\tHL\n\tEX\tDE,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,DE\n\tEX\tDE,HL\n\tLD\tDE,17FFH\n\tOR\tA\n\tSBC\tHL,DE\n\tLD\t(1800H),HL\n\tLD\tA,(HL)\n\tLD\t(1846H),A\n\tRET\n");
        } else {
            super.appendXLocateTo(asmCodeBuf);
        }
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            if (this.usesColors) {
                asmCodeBuf.append("XOUTCH:\tLD\tD,A\n\tLD\tA,(1846H)\n\tLD\tHL,(1800H)\n\tLD\t(HL),A\n\tLD\tC,0F0H\n\tIN\tE,(C)\n\tLD\tA,D\n\tCP\t08H\n\tJR\tZ,XOUTC7\n\tCP\t09H\n\tJR\tZ,XOUTC1\n\tCP\t0AH\n\tJR\tZ,XOUTC8\n\tCP\t0BH\n\tJR\tZ,XOUTC9\n\tCP\t0CH\n\tJP\tZ,XCLS\n\tCP\t0DH\n\tJR\tZ,XOUTC10\n\tSET\t2,E\n\tOUT\t(C),E\n\tLD\tA,(X_MCOV)\n\tLD\t(HL),A\n\tRES\t2,E\n\tOUT\t(C),E\n\tLD\t(HL),D\nXOUTC1:\tDEC\tHL\nXOUTC2:\tLD\tA,H\n\tCP\t10H\n\tCALL\tC,XOUTC3\n\tLD\tA,(HL)\n\tLD\t(1846H),A\n\tLD\t(1800H),HL\n\tRET\nXOUTC3:\tPUSH\tHL\n\tLD\tA,(X_MCOS)\n\tOR\tA\n\tJR\tZ,XOUTC4\n\tSET\t2,E\n\tLD\tA,(X_MCOV)\n\tPUSH\tDE\n\tCALL\tXOUTC5\n\tPOP\tDE\n\tRES\t2,E\nXOUTC4:\tLD\tA,20H\n\tCALL\tXOUTC5\n\tPOP\tHL\n\tLD\tBC,0040H\n\tADD\tHL,BC\n\tRET\nXOUTC5:\tLD\tC,0F0H\n\tOUT\t(C),E\n\tLD\tHL,17BFH\n\tLD\tDE,17FFH\n\tLD\tBC,07C0H\n\tLDDR\n\tLD\tB,40H\nXOUTC6:\tLD\t(DE),A\n\tDEC\tDE\n\tDJNZ\tXOUTC6\n\tRET\nXOUTC7:\tINC\tHL\n\tLD\tA,H\n\tCP\t18H\n\tJR\tC,XOUTC2\n\tLD\tHL,1000H\n\tJR\tXOUTC2\nXOUTC8:\tLD\tBC,0040H\n\tOR\tA\n\tSBC\tHL,BC\n\tJR\tXOUTC2\nXOUTC9:\tLD\tBC,0040H\n\tADD\tHL,BC\n\tLD\tA,H\n\tCP\t18H\n\tJR\tC,XOUTC2\n\tLD\tA,L\n\tAND\t3FH\n\tLD\tL,A\n\tLD\tH,10H\n\tJR\tXOUTC2\nXOUTC10:\n\tLD\tA,L\n\tAND\t0C0H\n\tLD\tL,A\n\tDEC\tHL\n\tJR\tXOUTC2\n");
                if (!this.xclsAppended) {
                    this.appendXClsTo(asmCodeBuf);
                }
            } else {
                super.appendXOutchTo(asmCodeBuf);
            }
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesColors) {
            asmCodeBuf.append("XOUTNL:\tLD\tA,0DH\n\tJP\tXOUTCH\n");
        } else {
            super.appendXOutnlTo(asmCodeBuf);
        }
    }

    @Override
    public void appendXPaperTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XPAPER:\tLD\tA,L\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tAND\t0F0H\n\tLD\tB,A\n\tLD\tA,(X_MCOV)\n\tAND\t0FH\n\tOR\tB\n\tLD\t(X_MCOV),A\n\tRET\n");
        this.usesColors = true;
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT:\tCALL\tX_PST\n\tRET\tC\n\tLD\tA,B\n\tAND\tC\n\tSCF\n\tRET\tNZ\n\tCALL\tXPSET2\n\tOR\tA\n\tRET\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPOINT:\tCALL\tX_PST\n\tJR\tC,XPOINT2\n\tIN\tA,(0F0H)\n\tOR\t04H\n\tOUT\t(0F0H),A\n\tLD\tD,(HL)\n\tAND\t0FBH\n\tOUT\t(0F0H),A\n\tLD\tA,B\n\tAND\tC\n\tLD\tA,D\n\tJR\tNZ,XPOINT1\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\nXPOINT1:\n\tAND\t0FH\n\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXPOINT2:\n\tLD\tHL,0FFFFH\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPRES:\tCALL\tX_PST\n\tRET\tC\n");
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("\tJR\tXPSET1\n");
        } else {
            asmCodeBuf.append("\tLD\tA,C\n\tCPL\n\tAND\tB\n\tJR\tXPSET3\n");
        }
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tLD\tA,B\n\tXOR\tC\n\tJR\tXPSET3\nXPSET1:\tLD\tA,C\n\tCPL\n\tAND\tB\n\tJR\tXPSET3\n");
            }
            asmCodeBuf.append("XPSET2:\tLD\tA,B\n\tOR\tC\nXPSET3:\tAND\t0FH\n");
            if (this.usesColors) {
                asmCodeBuf.append("\tLD\tD,A\n\tLD\tC,0F0H\n\tIN\tE,(C)\n\tSET\t2,E\n\tOUT\t(C),E\n\tLD\tA,(X_MCOV)\n\tLD\t(HL),A\n\tRES\t2,E\n\tOUT\t(C),E\n\tLD\t(HL),D\n");
            } else {
                asmCodeBuf.append("\tLD\t(HL),A\n");
            }
            asmCodeBuf.append("\tRET\n");
            this.appendPixUtilTo(asmCodeBuf);
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPTEST:\tCALL\tX_PST\n\tJR\tC,X_PTEST1\n\tLD\tA,B\n\tAND\tC\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nX_PTEST1:\n\tLD\tHL,0FFFFH\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public String[] getBasicTargetNames() {
        return AC1Target.add(super.getBasicTargetNames(), BASIC_TARGET_NAME);
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null) {
            if (emuSys instanceof AC1) {
                n = 2;
                if (((AC1)emuSys).emulates2010Mode() || ((AC1)emuSys).emulatesSCCHMode()) {
                    n = 3;
                }
            } else if (emuSys instanceof AbstractSCCHSys) {
                n = 1;
            }
        }
        return n;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{220, 252, 8};
    }

    @Override
    public void reset() {
        super.reset();
        this.usesColors = false;
        this.pixUtilAppended = false;
        this.xclsAppended = false;
        this.xpsetAppended = false;
    }

    @Override
    public boolean supportsColors() {
        return true;
    }

    @Override
    public boolean supportsGraphics() {
        return true;
    }

    @Override
    public boolean supportsXCLS() {
        return true;
    }

    @Override
    public boolean supportsXLOCAT() {
        return this.usesColors ? true : super.supportsXLOCAT();
    }

    @Override
    public String toString() {
        return "AC1-2010, AC1-SCCH mit optionaler Farbgrafikkarte";
    }

    private void appendPixUtilTo(AsmCodeBuf asmCodeBuf) {
        if (!this.pixUtilAppended) {
            asmCodeBuf.append("X_PST:\tLD\tA,D\n\tOR\tH\n\tSCF\n\tRET\tNZ\n\tLD\tA,7FH\n\tCP\tE\n\tRET\tC\n\tLD\tA,3FH\n\tCP\tL\n\tRET\tC\n\tLD\tA,01H\n\tSRL\tL\n\tJR\tC,X_PST1\n\tSLA\tA\n\tSLA\tA\nX_PST1:\tSRL\tE\n\tJR\tNC,X_PST2\n\tSLA\tA\nX_PST2:\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tLD\tBC,103FH\n\tADD\tHL,BC\n\tOR\tA\n\tSBC\tHL,DE\n\tLD\tC,A\n\tLD\tB,00H\n\tLD\tA,(HL)\n\tCP\t10H\n\tRET\tNC\n\tLD\tB,A\n\tOR\tA\n\tRET\n");
            this.pixUtilAppended = true;
        }
    }
}

