/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.text.CharacterIterator;
import jkcemu.programming.PrgException;
import jkcemu.programming.PrgUtil;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;

public class BasicUtil {
    public static String checkIdentifier(CharacterIterator characterIterator) {
        String string = null;
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            int n = characterIterator.getIndex();
            c = characterIterator.next();
            while (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                c = characterIterator.next();
            }
            int n2 = characterIterator.getIndex() - n;
            if (c == '$') {
                ++n2;
            }
            StringBuilder stringBuilder = new StringBuilder(n2);
            characterIterator.setIndex(n);
            c = characterIterator.current();
            do {
                stringBuilder.append(Character.toUpperCase(c));
                c = characterIterator.next();
            } while (--n2 > 0);
            string = stringBuilder.toString();
        }
        return string;
    }

    public static boolean checkKeyword(CharacterIterator characterIterator, String string) {
        return BasicUtil.checkKeyword(characterIterator, string, true, false);
    }

    public static boolean checkKeyword(CharacterIterator characterIterator, String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        char c = BasicUtil.skipSpaces(characterIterator);
        int n = characterIterator.getIndex();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != Character.toUpperCase(c)) {
                characterIterator.setIndex(n);
                bl3 = false;
                break;
            }
            c = characterIterator.next();
        }
        if (bl3 && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '$')) {
            bl3 = false;
        }
        return bl3;
    }

    public static String checkStringLiteral(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        StringBuilder stringBuilder = null;
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c == '\"') {
            stringBuilder = new StringBuilder(64);
            char c2 = characterIterator.next();
            while (c2 != '\uffff' && c2 != c) {
                if (c2 > '\u00ff') {
                    throw new PrgException(String.format("'%c': 16-Bit-Unicodezeichen nicht erlaubt", Character.valueOf(c2)));
                }
                if (basicCompiler.getBasicOptions().getWarnNonAsciiChars() && (c2 < ' ' || c2 > '\u007f')) {
                    basicCompiler.putWarningNonAsciiChar(c2);
                }
                stringBuilder.append(c2);
                c2 = characterIterator.next();
            }
            if (c2 != c) {
                basicCompiler.putWarning("String-Literal nicht geschlossen");
            }
            characterIterator.next();
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static boolean checkToken(CharacterIterator characterIterator, char c) {
        boolean bl = false;
        if (BasicUtil.skipSpaces(characterIterator) == c) {
            characterIterator.next();
            bl = true;
        }
        return bl;
    }

    public static String convertCodeToValueInBC(String string) {
        return BasicUtil.convertCodeToValueInRR(string, "BC");
    }

    public static String convertCodeToValueInDE(String string) {
        return BasicUtil.convertCodeToValueInRR(string, "DE");
    }

    public static boolean isOnly_LD_HL_xx(String string) {
        boolean bl = false;
        if (string != null) {
            int n = string.indexOf(9);
            if (n > 0) {
                string = string.substring(n);
            }
            if (string.startsWith("\tLD\tHL,")) {
                if (string.indexOf(10) == string.length() - 1) {
                    bl = true;
                }
            } else if (string.startsWith("\tLD\tH,") || string.startsWith("\tLD\tL,")) {
                int n2 = string.length();
                int n3 = string.indexOf(10);
                if (n3 > 0 && n3 + 1 < n2) {
                    String string2 = string.substring(0, n3 + 1);
                    String string3 = string.substring(n3 + 1);
                    if (string3.indexOf(10) == string3.length() - 1) {
                        if (string2.startsWith("\tLD\tH,(IY") && string3.startsWith("\tLD\tL,(IY")) {
                            bl = true;
                        } else if (string2.startsWith("\tLD\tL,(IY") && string3.startsWith("\tLD\tH,(IY")) {
                            bl = true;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public static boolean isSingleInst_LD_HL_xx(String string) {
        boolean bl = false;
        if (string != null) {
            int n = string.indexOf(9);
            if (n > 0) {
                string = string.substring(n);
            }
            if (string.startsWith("\tLD\tHL,")) {
                int n2 = string.indexOf(10);
                if (n2 >= 0) {
                    if (n2 == string.length() - 1) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static void parseToken(CharacterIterator characterIterator, char c) throws PrgException {
        if (BasicUtil.skipSpaces(characterIterator) != c) {
            throw new PrgException(String.format("'%c' erwartet", Character.valueOf(c)));
        }
        characterIterator.next();
    }

    public static int parseNumber(CharacterIterator characterIterator) throws PrgException {
        Integer n = BasicUtil.readNumber(characterIterator);
        if (n == null) {
            BasicUtil.throwNumberExpected();
        }
        return n;
    }

    public static int parseUsrNum(CharacterIterator characterIterator) throws PrgException {
        Integer n = BasicUtil.readNumber(characterIterator);
        if (n == null) {
            throw new PrgException("Nummer der USR-Funktion erwartet");
        }
        if (n < 0 || n > 9) {
            throw new PrgException("Ung\u00fcltige USR-Funktionsnummer (0...9 erlaubt)");
        }
        return n;
    }

    public static Integer readHex(CharacterIterator characterIterator) throws PrgException {
        Integer n = null;
        char c = characterIterator.current();
        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
            int n2 = 0;
            while (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
                n2 <<= 4;
                if (c >= '0' && c <= '9') {
                    n2 |= c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    n2 |= c - 65 + 10;
                } else if (c >= 'a' && c <= 'f') {
                    n2 |= c - 97 + 10;
                }
                n2 &= 0xFFFF;
                c = characterIterator.next();
            }
            n = n2;
        }
        return n;
    }

    public static Integer readNumber(CharacterIterator characterIterator) throws PrgException {
        Integer n = null;
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c >= '0' && c <= '9') {
            int n2 = c - 48;
            c = characterIterator.next();
            while (c >= '0' && c <= '9') {
                if ((n2 = n2 * 10 + (c - 48)) > Short.MAX_VALUE) {
                    throw new PrgException("Zahl zu gro\u00df");
                }
                c = characterIterator.next();
            }
            n = n2;
        }
        return n;
    }

    public static Integer removeLastCodeIfConstExpr(BasicCompiler basicCompiler, int n) {
        Integer n2 = null;
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        if (asmCodeBuf != null) {
            String string = asmCodeBuf.substring(n);
            int n3 = string.indexOf(9);
            if (n3 > 0) {
                n = n3;
                string = string.substring(n3);
            }
            if (string.startsWith("\tLD\tHL,") && string.endsWith("H\n")) {
                try {
                    int n4 = Integer.parseInt(string.substring(7, string.length() - 2), 16);
                    if ((n4 & 0x8000) != 0) {
                        n4 = -(65536 - (n4 & 0xFFFF));
                    }
                    n2 = n4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n2 != null) {
                asmCodeBuf.setLength(n);
            }
        }
        return n2;
    }

    public static boolean replaceLastCodeFrom_LD_HL_To_BC(BasicCompiler basicCompiler) {
        return BasicUtil.replaceLastCodeFrom_LD_HL_To_RR(basicCompiler, "BC");
    }

    public static boolean replaceLastCodeFrom_LD_HL_To_DE(BasicCompiler basicCompiler) {
        return BasicUtil.replaceLastCodeFrom_LD_HL_To_RR(basicCompiler, "DE");
    }

    public static char skipSpaces(CharacterIterator characterIterator) {
        char c = characterIterator.current();
        while (c != '\uffff' && PrgUtil.isWhitespace(c)) {
            c = characterIterator.next();
        }
        return c;
    }

    public static void throwHexDigitExpected() throws PrgException {
        throw new PrgException("Hexadezimalziffer erwartet");
    }

    public static void throwIndexOutOfRange() throws PrgException {
        throw new PrgException("Index au\u00dferhalb des g\u00fcltigen Bereichs");
    }

    public static void throwNumberExpected() throws PrgException {
        throw new PrgException("Zahl erwartet");
    }

    public static void throwStringExprExpected() throws PrgException {
        throw new PrgException("String-Ausdruck erwartet");
    }

    public static void throwUnexpectedChar(char c) throws PrgException {
        if (c == '\uffff') {
            throw new PrgException("Unerwartetes Ende der Zeile");
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (c >= ' ') {
            stringBuilder.append('\'');
            stringBuilder.append(c);
            stringBuilder.append("': ");
        }
        stringBuilder.append("Unerwartetes Zeichen");
        throw new PrgException(stringBuilder.toString());
    }

    private static String convertCodeToValueInRR(String string, String string2) {
        String string3 = null;
        if (string != null && string2.length() == 2) {
            String string4 = "";
            int n = string.indexOf(9);
            if (n > 0) {
                string4 = string.substring(0, n);
                string = string.substring(n);
            }
            if (string.startsWith("\tLD\tHL,")) {
                if (string.indexOf(10) == string.length() - 1) {
                    string3 = String.format("%s\tLD\t%s%s", string4, string2, string.substring(6));
                }
            } else if (string.startsWith("\tLD\tH,") || string.startsWith("\tLD\tL,")) {
                int n2 = string.length();
                int n3 = string.indexOf(10);
                if (n3 > 0 && n3 + 1 < n2) {
                    String string5 = string.substring(0, n3 + 1);
                    String string6 = string.substring(n3 + 1);
                    if (string6.indexOf(10) == string6.length() - 1) {
                        if (string5.startsWith("\tLD\tH,(IY") && string6.startsWith("\tLD\tL,(IY")) {
                            string3 = String.format("%s\tLD\t%c%s\tLD\t%c%s", string4, Character.valueOf(string2.charAt(0)), string5.substring(5), Character.valueOf(string2.charAt(1)), string6.substring(5));
                        } else if (string5.startsWith("\tLD\tL,(IY") && string6.startsWith("\tLD\tH,(IY")) {
                            string3 = String.format("%s\tLD\t%c%s\tLD\t%c%s", string4, Character.valueOf(string2.charAt(1)), string5.substring(5), Character.valueOf(string2.charAt(0)), string6.substring(5));
                        }
                    }
                }
            }
        }
        return string3;
    }

    private static boolean replaceLastCodeFrom_LD_HL_To_RR(BasicCompiler basicCompiler, String string) {
        boolean bl = false;
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        if (asmCodeBuf != null) {
            int n = asmCodeBuf.getLastLinePos();
            String string2 = asmCodeBuf.substring(n);
            int n2 = string2.indexOf(9);
            if (n2 > 0) {
                n = n2;
                string2 = string2.substring(n2);
            }
            if (string2.startsWith("\tLD\tHL,")) {
                asmCodeBuf.replace(n + 4, n + 6, string);
                bl = true;
            } else if (string.length() == 2 && (string2.startsWith("\tLD\tH,") || string2.startsWith("\tLD\tL,"))) {
                String string3 = asmCodeBuf.cut(n);
                String string4 = asmCodeBuf.cut(asmCodeBuf.getLastLinePos());
                if (string4.indexOf("\tLD\tH,(IY") >= 0 && string3.indexOf("\tLD\tL,(IY") >= 0) {
                    string4 = string4.replace("\tLD\tH,(IY", String.format("\tLD\t%c,(IY", Character.valueOf(string.charAt(0))));
                    string3 = string3.replace("\tLD\tL,(IY", String.format("\tLD\t%c,(IY", Character.valueOf(string.charAt(1))));
                    bl = true;
                } else if (string4.indexOf("\tLD\tL,(IY") >= 0 && string3.indexOf("\tLD\tH,(IY") >= 0) {
                    string4 = string4.replace("\tLD\tL,(IY", String.format("\tLD\t%c,(IY", Character.valueOf(string.charAt(1))));
                    string3 = string3.replace("\tLD\tH,(IY", String.format("\tLD\t%c,(IY", Character.valueOf(string.charAt(0))));
                    bl = true;
                }
                asmCodeBuf.append(string4);
                asmCodeBuf.append(string3);
            }
        }
        return bl;
    }
}

