/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.util.Properties;
import jkcemu.base.EmuSys;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.assembler.Z80Assembler;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.text.TextUtil;

public class BasicOptions
extends PrgOptions {
    public static final int MAX_HEAP_SIZE = 32768;
    public static final int MIN_HEAP_SIZE = 512;
    public static final int MIN_STACK_SIZE = 64;
    public static final int DEFAULT_HEAP_SIZE = 1024;
    public static final int DEFAULT_STACK_SIZE = 128;
    public static final String DEFAULT_APP_NAME = "MYAPP";
    public static final String OPTION_BASIC_PREFIX = "jkcemu.programming.basic.";
    private static final String OPTION_APP_NAME = "jkcemu.programming.basic.name";
    private static final String OPTION_APP_LANG = "jkcemu.programming.basic.language.code";
    private static final String OPTION_BSS_ADDR = "jkcemu.programming.basic.address.bss";
    private static final String OPTION_CODE_ADDR = "jkcemu.programming.basic.address.code";
    private static final String OPTION_CHECK_BOUNDS = "jkcemu.programming.basic.bounds.check";
    private static final String OPTION_CHECK_STACK = "jkcemu.programming.basic.stack.check";
    private static final String OPTION_BREAK = "jkcemu.programming.basic.breakoption";
    private static final String OPTION_HEAP_SIZE = "jkcemu.programming.basic.heap.size";
    private static final String OPTION_INCLUDE_BASIC_LINES = "jkcemu.programming.basic.include_basic_lines";
    private static final String OPTION_OPEN_FILE_ENABLED = "jkcemu.programming.basic.open.file.enabled";
    private static final String OPTION_OPEN_CRT_ENABLED = "jkcemu.programming.basic.open.crt.enabled";
    private static final String OPTION_OPEN_LPT_ENABLED = "jkcemu.programming.basic.open.lpt.enabled";
    private static final String OPTION_OPEN_VDIP_ENABLED = "jkcemu.programming.basic.open.vdip.enabled";
    private static final String OPTION_PREFER_REL_JUMPS = "jkcemu.programming.basic.prefer_relative_jumps";
    private static final String OPTION_TARGET = "jkcemu.programming.basic.target";
    private static final String OPTION_PRINT_LINE_NUM_ON_ABORT = "jkcemu.programming.basic.print_line_num_on_abort";
    private static final String OPTION_SHOW_ASM_TEXT = "jkcemu.programming.basic.show_assembler_source";
    private static final String OPTION_STACK_SIZE = "jkcemu.programming.basic.stack.size";
    private static final String OPTION_WARN_UNUSED_ITEMS = "jkcemu.programming.basic.warn_unused_items";
    private static final String VALUE_BREAK_ALWAYS = "always";
    private static final String VALUE_BREAK_INPUT = "input";
    private static final String VALUE_BREAK_NEVER = "never";
    private String appName = "MYAPP";
    private String langCode = null;
    private String targetText = null;
    private AbstractTarget target = null;
    private EmuSys emuSys = null;
    private int codeBegAddr = -1;
    private int bssBegAddr = -1;
    private int heapSize = 1024;
    private int stackSize = 128;
    private boolean checkStack = true;
    private boolean checkBounds = true;
    private boolean openCrtEnabled = true;
    private boolean openLptEnabled = true;
    private boolean openFileEnabled = true;
    private boolean openVdipEnabled = true;
    private boolean inclBasicLines = true;
    private boolean preferRelJumps = true;
    private boolean printLineNumOnAbort = true;
    private boolean showAsmText = false;
    private boolean warnUnusedItems = true;
    private BreakOption breakOption = BreakOption.ALWAYS;

    public BasicOptions() {
        this.setAsmSyntax(Z80Assembler.Syntax.ZILOG_ONLY);
        this.setAllowUndocInst(false);
        this.setLabelsCaseSensitive(false);
        this.setPrintLabels(false);
    }

    public boolean canBreakAlways() {
        return this.breakOption == BreakOption.ALWAYS;
    }

    public boolean canBreakOnInput() {
        return this.breakOption == BreakOption.ALWAYS || this.breakOption == BreakOption.INPUT;
    }

    public String getAppName() {
        return this.appName;
    }

    public static BasicOptions getBasicOptions(Properties properties) {
        BasicOptions basicOptions = null;
        if (properties != null) {
            String string = properties.getProperty(OPTION_APP_NAME);
            String string2 = properties.getProperty(OPTION_APP_LANG);
            String string3 = properties.getProperty(OPTION_TARGET);
            String string4 = properties.getProperty(OPTION_BREAK);
            Integer n = BasicOptions.getInteger(properties, OPTION_CODE_ADDR);
            Integer n2 = BasicOptions.getInteger(properties, OPTION_BSS_ADDR);
            Integer n3 = BasicOptions.getInteger(properties, OPTION_HEAP_SIZE);
            Integer n4 = BasicOptions.getInteger(properties, OPTION_STACK_SIZE);
            Boolean bl = BasicOptions.getBoolean(properties, OPTION_CHECK_STACK);
            Boolean bl2 = BasicOptions.getBoolean(properties, OPTION_CHECK_BOUNDS);
            Boolean bl3 = BasicOptions.getBoolean(properties, OPTION_OPEN_CRT_ENABLED);
            Boolean bl4 = BasicOptions.getBoolean(properties, OPTION_OPEN_LPT_ENABLED);
            Boolean bl5 = BasicOptions.getBoolean(properties, OPTION_OPEN_FILE_ENABLED);
            Boolean bl6 = BasicOptions.getBoolean(properties, OPTION_OPEN_VDIP_ENABLED);
            Boolean bl7 = BasicOptions.getBoolean(properties, OPTION_PREFER_REL_JUMPS);
            Boolean bl8 = BasicOptions.getBoolean(properties, OPTION_SHOW_ASM_TEXT);
            Boolean bl9 = BasicOptions.getBoolean(properties, OPTION_PRINT_LINE_NUM_ON_ABORT);
            Boolean bl10 = BasicOptions.getBoolean(properties, OPTION_INCLUDE_BASIC_LINES);
            Boolean bl11 = BasicOptions.getBoolean(properties, OPTION_WARN_UNUSED_ITEMS);
            if (string != null || string2 != null || string3 != null || n != null || n2 != null || n3 != null || n4 != null || bl != null || bl2 != null || bl3 != null || bl4 != null || bl5 != null || bl6 != null || bl7 != null || bl9 != null || bl8 != null || bl10 != null || bl11 != null || string4 != null) {
                basicOptions = new BasicOptions();
                if (string != null) {
                    basicOptions.appName = string;
                }
                if (string2 != null) {
                    basicOptions.langCode = string2;
                }
                if (string3 != null) {
                    basicOptions.targetText = string3;
                }
                if (n != null) {
                    basicOptions.codeBegAddr = n;
                }
                if (n2 != null) {
                    basicOptions.bssBegAddr = n2;
                }
                if (n3 != null) {
                    basicOptions.heapSize = n3;
                }
                if (n4 != null) {
                    basicOptions.stackSize = n4;
                }
                if (bl != null) {
                    basicOptions.checkStack = bl;
                }
                if (bl2 != null) {
                    basicOptions.checkBounds = bl2;
                }
                if (bl3 != null) {
                    basicOptions.openCrtEnabled = bl3;
                }
                if (bl4 != null) {
                    basicOptions.openLptEnabled = bl4;
                }
                if (bl5 != null) {
                    basicOptions.openFileEnabled = bl5;
                }
                if (bl6 != null) {
                    basicOptions.openVdipEnabled = bl6;
                }
                if (bl7 != null) {
                    basicOptions.preferRelJumps = bl7;
                }
                if (bl9 != null) {
                    basicOptions.printLineNumOnAbort = bl9;
                }
                if (bl8 != null) {
                    basicOptions.showAsmText = bl8;
                }
                if (bl10 != null) {
                    basicOptions.inclBasicLines = bl10;
                }
                if (bl11 != null) {
                    basicOptions.warnUnusedItems = bl11;
                }
                if (string4 != null) {
                    basicOptions.breakOption = string4.equals(VALUE_BREAK_NEVER) ? BreakOption.NEVER : (string4.equals(VALUE_BREAK_INPUT) ? BreakOption.INPUT : BreakOption.ALWAYS);
                }
            }
        }
        return basicOptions;
    }

    public BreakOption getBreakOption() {
        return this.breakOption;
    }

    public int getBssBegAddr() {
        return this.bssBegAddr;
    }

    public boolean getCheckBounds() {
        return this.checkBounds;
    }

    public boolean getCheckStack() {
        return this.checkStack;
    }

    public int getCodeBegAddr() {
        return this.codeBegAddr;
    }

    public EmuSys getEmuSys() {
        return this.emuSys;
    }

    public boolean getIncludeBasicLines() {
        return this.inclBasicLines;
    }

    public int getHeapSize() {
        return this.heapSize;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public boolean getPreferRelativeJumps() {
        return this.preferRelJumps;
    }

    public boolean getPrintLineNumOnAbort() {
        return this.printLineNumOnAbort;
    }

    public boolean getShowAssemblerText() {
        return this.showAsmText;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public AbstractTarget getTarget() {
        return this.target;
    }

    public String getTargetText() {
        return this.targetText;
    }

    public boolean getWarnUnusedItems() {
        return this.warnUnusedItems;
    }

    public boolean isOpenCrtEnabled() {
        return this.openCrtEnabled;
    }

    public boolean isOpenFileEnabled() {
        return this.openFileEnabled;
    }

    public boolean isOpenLptEnabled() {
        return this.openLptEnabled;
    }

    public boolean isOpenVdipEnabled() {
        return this.openVdipEnabled;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setBreakOption(BreakOption breakOption) {
        this.breakOption = breakOption;
    }

    public void setCheckBounds(boolean bl) {
        this.checkBounds = bl;
    }

    public void setCheckStack(boolean bl) {
        this.checkStack = bl;
    }

    public void setBssBegAddr(int n) {
        this.bssBegAddr = n;
    }

    public void setCodeBegAddr(int n) {
        this.codeBegAddr = n;
    }

    public void setEmuSys(EmuSys emuSys) {
        this.emuSys = emuSys;
    }

    public void setHeapSize(int n) {
        this.heapSize = n;
    }

    public void setIncludeBasicLines(boolean bl) {
        this.inclBasicLines = bl;
    }

    public void setLangCode(String string) {
        this.langCode = string;
    }

    public void setOpenCrtEnabled(boolean bl) {
        this.openCrtEnabled = bl;
    }

    public void setOpenLptEnabled(boolean bl) {
        this.openLptEnabled = bl;
    }

    public void setOpenFileEnabled(boolean bl) {
        this.openFileEnabled = bl;
    }

    public void setOpenVdipEnabled(boolean bl) {
        this.openVdipEnabled = bl;
    }

    public void setTarget(AbstractTarget abstractTarget) {
        this.target = abstractTarget;
        this.targetText = abstractTarget.toString();
    }

    public void setPreferRelativeJumps(boolean bl) {
        this.preferRelJumps = bl;
    }

    public void setPrintLineNumOnAbort(boolean bl) {
        this.printLineNumOnAbort = bl;
    }

    public void setShowAssemblerText(boolean bl) {
        this.showAsmText = bl;
    }

    public void setStackSize(int n) {
        this.stackSize = n;
    }

    public void setWarnUnusedItems(boolean bl) {
        this.warnUnusedItems = bl;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && super.equals(object) && object instanceof BasicOptions) {
            BasicOptions basicOptions = (BasicOptions)object;
            if (TextUtil.equals(basicOptions.appName, this.appName) && TextUtil.equals(basicOptions.langCode, this.langCode) && TextUtil.equals(basicOptions.targetText, this.targetText) && basicOptions.codeBegAddr == this.codeBegAddr && basicOptions.bssBegAddr == this.bssBegAddr && basicOptions.heapSize == this.heapSize && basicOptions.stackSize == this.stackSize && basicOptions.checkStack == this.checkStack && basicOptions.checkBounds == this.checkBounds && basicOptions.openCrtEnabled == this.openCrtEnabled && basicOptions.openLptEnabled == this.openLptEnabled && basicOptions.openFileEnabled == this.openFileEnabled && basicOptions.openVdipEnabled == this.openVdipEnabled && basicOptions.inclBasicLines == this.inclBasicLines && basicOptions.preferRelJumps == this.preferRelJumps && basicOptions.printLineNumOnAbort == this.printLineNumOnAbort && basicOptions.showAsmText == this.showAsmText && basicOptions.warnUnusedItems == this.warnUnusedItems && basicOptions.breakOption == this.breakOption) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void putOptionsTo(Properties properties) {
        super.putOptionsTo(properties);
        if (properties != null) {
            properties.setProperty(OPTION_APP_NAME, this.appName != null ? this.appName : "");
            properties.setProperty(OPTION_APP_LANG, this.langCode != null ? this.langCode : "");
            properties.setProperty(OPTION_TARGET, this.targetText != null ? this.targetText : "");
            properties.setProperty(OPTION_CODE_ADDR, Integer.toString(this.codeBegAddr));
            properties.setProperty(OPTION_BSS_ADDR, Integer.toString(this.bssBegAddr));
            properties.setProperty(OPTION_HEAP_SIZE, Integer.toString(this.heapSize));
            properties.setProperty(OPTION_STACK_SIZE, Integer.toString(this.stackSize));
            properties.setProperty(OPTION_CHECK_STACK, Boolean.toString(this.checkStack));
            properties.setProperty(OPTION_CHECK_BOUNDS, Boolean.toString(this.checkBounds));
            properties.setProperty(OPTION_OPEN_CRT_ENABLED, Boolean.toString(this.openCrtEnabled));
            properties.setProperty(OPTION_OPEN_LPT_ENABLED, Boolean.toString(this.openLptEnabled));
            properties.setProperty(OPTION_OPEN_FILE_ENABLED, Boolean.toString(this.openFileEnabled));
            properties.setProperty(OPTION_OPEN_VDIP_ENABLED, Boolean.toString(this.openVdipEnabled));
            properties.setProperty(OPTION_PREFER_REL_JUMPS, Boolean.toString(this.preferRelJumps));
            properties.setProperty(OPTION_PRINT_LINE_NUM_ON_ABORT, Boolean.toString(this.printLineNumOnAbort));
            properties.setProperty(OPTION_SHOW_ASM_TEXT, Boolean.toString(this.showAsmText));
            properties.setProperty(OPTION_INCLUDE_BASIC_LINES, Boolean.toString(this.inclBasicLines));
            properties.setProperty(OPTION_WARN_UNUSED_ITEMS, Boolean.toString(this.warnUnusedItems));
            if (this.breakOption != null) {
                String string = VALUE_BREAK_ALWAYS;
                switch (this.breakOption) {
                    case NEVER: {
                        string = VALUE_BREAK_NEVER;
                        break;
                    }
                    case INPUT: {
                        string = VALUE_BREAK_INPUT;
                    }
                }
                properties.setProperty(OPTION_BREAK, string);
            }
        }
    }

    public static enum BreakOption {
        NEVER,
        INPUT,
        ALWAYS;

    }
}

