/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.programming.PrgLogger;
import jkcemu.programming.PrgThread;
import jkcemu.programming.assembler.Z80Assembler;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicOptions;
import jkcemu.programming.basic.target.Z9001KRTTarget;
import jkcemu.programming.basic.target.Z9001Target;
import jkcemu.text.EditText;
import jkcemu.text.TextEditFrm;

public class BasicCompilerThread
extends PrgThread {
    private String sysTitle;
    private PrgLogger logger;
    private BasicCompiler compiler;
    private BasicOptions basicOptions;

    public BasicCompilerThread(EmuThread emuThread, EditText editText, BasicOptions basicOptions, Appendable appendable) {
        super("JKCEMU basic compiler", emuThread, editText, basicOptions, appendable);
        EmuSys emuSys = emuThread != null ? emuThread.getEmuSys() : null;
        this.sysTitle = emuSys != null ? emuSys.getTitle() : null;
        this.basicOptions = basicOptions;
        this.logger = PrgLogger.createLogger(appendable);
        this.compiler = new BasicCompiler(editText.getText(), editText.getFile(), basicOptions, this.logger);
    }

    @Override
    public boolean execute() throws IOException {
        boolean bl = false;
        this.appendToLog("Compiliere...\n");
        AbstractTarget abstractTarget = this.basicOptions.getTarget();
        if (abstractTarget != null) {
            String string;
            String string2 = abstractTarget.toString();
            if (string2 != null) {
                this.appendToLog("Zielsystem: ");
                this.appendToLog(string2);
                this.appendToLog("\n");
            }
            if ((string = this.compiler.compile()) != null) {
                byte[] byArray;
                if (this.basicOptions.getShowAssemblerText()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BasicCompilerThread.this.openAsmText(string);
                        }
                    });
                }
                this.appendToLog("Assembliere...\n");
                Z80Assembler z80Assembler = new Z80Assembler(string, "Assembler-Quelltext", null, this.options, this.logger, true);
                bl = z80Assembler.assemble(abstractTarget.getMaxAppNameLen() > 0 ? this.basicOptions.getAppName() : null, abstractTarget instanceof Z9001Target || abstractTarget instanceof Z9001KRTTarget);
                if (this.basicOptions.getBssBegAddr() >= 0 && z80Assembler.getOrgOverlapped()) {
                    this.appendToLog("\nProgrammcode und Bereich f\u00fcr Variablen/Speicherzellen \u00fcberschneiden sich.\nBitte w\u00e4hlen Sie eine andere Anfangsadresse f\u00fcr Variablen/Speicherzellen!");
                }
                if (z80Assembler.getRelJumpsTooLong()) {
                    this.appendToLog("\nCompilieren Sie bitte mit ausgeschalteter Option 'Relative Spr\u00fcnge bevorzugen'!");
                }
                if (bl && (byArray = z80Assembler.getCreatedCode()) != null && byArray.length > 0) {
                    int n = this.basicOptions.getCodeBegAddr();
                    this.appendToLog("Speicherbelegung:\n");
                    this.appendToLog(String.format("  %04X-%04X: Programmcode\n", n, n + byArray.length - 1));
                    Integer n2 = z80Assembler.getLabelValue("MTOP");
                    if (n2 != null) {
                        int n3 = this.basicOptions.getBssBegAddr();
                        if (n3 < 0) {
                            n3 = this.basicOptions.getCodeBegAddr() + byArray.length;
                        }
                        if (n3 >= 0 && n3 < n2) {
                            this.appendToLog(String.format("  %04X-%04X: Variablen, Speicherzellen%s\n", n3, n2 - 1, this.basicOptions.getStackSize() > 0 ? ", Stack" : ""));
                        }
                    }
                    if (this.options.getCodeToEmu() || this.options.getForceRun()) {
                        String string3;
                        EmuSys emuSys;
                        this.writeCodeToEmu(z80Assembler, false);
                        if (!this.options.getForceRun() && this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null && (string3 = abstractTarget.getStartCmd(emuSys, this.basicOptions.getAppName(), this.basicOptions.getCodeBegAddr())) != null && !string3.isEmpty()) {
                            this.appendToLog("Kommando zum Starten des Programms: ");
                            this.appendToLog(string3);
                            this.appendToLog("\n");
                        }
                    }
                }
            }
        } else if (this.sysTitle != null) {
            this.appendToLog("Fehler: Zielsystem '");
            this.appendToLog(this.sysTitle);
            this.appendToLog("' nicht unterst\u00fctzt.\n");
        } else {
            this.appendToLog("Fehler: Zielsystem unbekannt");
        }
        return bl;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.compiler.cancel();
    }

    private void openAsmText(String string) {
        TextEditFrm textEditFrm = this.editText.getTextEditFrm();
        if (textEditFrm != null) {
            EditText editText = this.editText.getResultEditText();
            if (editText != null && (editText.hasDataChanged() || !textEditFrm.contains(editText))) {
                editText = null;
            }
            if (editText != null) {
                editText.setText(string);
                Component component = editText.getTabComponent();
                if (component != null) {
                    textEditFrm.setSelectedTabComponent(component);
                }
            } else {
                editText = textEditFrm.openText(string);
                this.editText.setResultEditText(editText);
            }
        }
    }
}

