/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.assembler;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Map;
import jkcemu.programming.PrgException;
import jkcemu.programming.PrgUtil;
import jkcemu.programming.assembler.AsmArg;
import jkcemu.programming.assembler.AsmLabel;

public class ExprParser {
    private static String[] sortedReservedWords = new String[]{"AND", "EQ", "GE", "GT", "HIGH", "LE", "LOW", "LT", "MOD", "NE", "NOT", "OR", "SHL", "SHR", "XOR"};
    private CharacterIterator iter;
    private int instBegAddr;
    private Map<String, AsmLabel> labels;
    private boolean checkLabels;
    private boolean labelsCaseSensitive;

    public static boolean isReservedWord(String string) {
        return Arrays.binarySearch(sortedReservedWords, string) >= 0;
    }

    public static Integer parse(String string, int n, Map<String, AsmLabel> map, boolean bl, boolean bl2) throws PrgException {
        return new ExprParser(new StringCharacterIterator(string), n, map, bl, bl2).parse();
    }

    public static int parseNumber(CharacterIterator characterIterator) throws PrgException {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ExprParser.checkAndParseToken(characterIterator, "X'");
        boolean bl2 = ExprParser.checkAndParseToken(characterIterator, "%");
        char c = ExprParser.skipSpaces(characterIterator);
        while (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
            stringBuilder.append(c);
            c = characterIterator.next();
        }
        if (bl || bl2 || c == 'H' || c == 'h') {
            if (bl && c != '\'') {
                throw new PrgException("' als Ende der Hexadezimalzahl erwartet");
            }
            if (!bl2) {
                c = characterIterator.next();
            }
            try {
                n = Integer.parseInt(stringBuilder.toString(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrgException(stringBuilder.toString() + ": Ung\u00fcltige Hexadezimalzahl");
            }
        }
        if (c == 'O' || c == 'o' || c == 'Q' || c == 'q') {
            c = characterIterator.next();
            try {
                n = Integer.parseInt(stringBuilder.toString(), 8);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrgException(stringBuilder.toString() + ": Ung\u00fcltige Oktalzahl");
            }
        }
        boolean bl3 = false;
        int n2 = stringBuilder.length();
        if (n2 > 1 && ((c = stringBuilder.charAt(n2 - 1)) == 'B' || c == 'b')) {
            bl3 = true;
            stringBuilder.setLength(n2 - 1);
            try {
                n = Integer.parseInt(stringBuilder.toString(), 2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrgException(stringBuilder.toString() + ": Ung\u00fcltige Bin\u00e4rzahl");
            }
        }
        if (!bl3) {
            try {
                n = Integer.parseInt(stringBuilder.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrgException(stringBuilder.toString() + ": Ung\u00fcltige Zahl");
            }
        }
        return n;
    }

    public static char skipSpaces(CharacterIterator characterIterator) {
        char c = characterIterator.current();
        while (c != '\uffff' && PrgUtil.isWhitespace(c)) {
            c = characterIterator.next();
        }
        return c;
    }

    private ExprParser(CharacterIterator characterIterator, int n, Map<String, AsmLabel> map, boolean bl, boolean bl2) {
        this.iter = characterIterator;
        this.instBegAddr = n;
        this.labels = map;
        this.checkLabels = bl;
        this.labelsCaseSensitive = bl2;
    }

    private boolean checkAndParseToken(String string) {
        return ExprParser.checkAndParseToken(this.iter, string);
    }

    private static boolean checkAndParseToken(CharacterIterator characterIterator, String string) {
        boolean bl = true;
        int n = string.length();
        if (n > 0) {
            int n2;
            char c = ExprParser.skipSpaces(characterIterator);
            char c2 = '\uffff';
            int n3 = characterIterator.getIndex();
            for (n2 = 0; n2 < n; ++n2) {
                c2 = string.charAt(n2);
                if (Character.toUpperCase(c) != Character.toUpperCase(c2)) {
                    bl = false;
                    break;
                }
                c = characterIterator.next();
            }
            if (bl && AsmLabel.isIdentifierPart(c2) && AsmLabel.isIdentifierPart(c)) {
                bl = false;
            }
            if (!(!bl || c2 != '<' && c2 != '>' || (n2 = (int)characterIterator.current()) != 60 && n2 != 62 && n2 != 61)) {
                bl = false;
            }
            if (!bl) {
                characterIterator.setIndex(n3);
            }
        }
        return bl;
    }

    private Integer parse() throws PrgException {
        Integer n = this.parseExpr();
        char c = this.skipSpaces();
        if (c != '\uffff') {
            throw new PrgException("'" + c + "': Unerwartetes Zeichen hinter Ausdruck");
        }
        return n;
    }

    private Integer parseExpr() throws PrgException {
        Integer n = this.parseXorExpr();
        while (this.checkAndParseToken("OR")) {
            Integer n2 = this.parseXorExpr();
            if (n == null || n2 == null) continue;
            n = n | n2;
        }
        return n;
    }

    private Integer parseXorExpr() throws PrgException {
        Integer n = this.parseAndExpr();
        while (this.checkAndParseToken("XOR")) {
            Integer n2 = this.parseAndExpr();
            if (n == null || n2 == null) continue;
            n = n ^ n2;
        }
        return n;
    }

    private Integer parseAndExpr() throws PrgException {
        Integer n = this.parseEqualityExpr();
        while (this.checkAndParseToken("AND")) {
            Integer n2 = this.parseEqualityExpr();
            if (n == null || n2 == null) continue;
            n = n & n2;
        }
        return n;
    }

    private Integer parseEqualityExpr() throws PrgException {
        Integer n = this.parseRelationalExpr();
        while (true) {
            Integer n2;
            if (this.checkAndParseToken("=") || this.checkAndParseToken("EQ")) {
                n2 = this.parseRelationalExpr();
                if (n == null || n2 == null) continue;
                n = n.intValue() == n2.intValue() ? -1 : 0;
                continue;
            }
            if (!this.checkAndParseToken("<>") && !this.checkAndParseToken("NE")) break;
            n2 = this.parseRelationalExpr();
            if (n == null || n2 == null) continue;
            n = n.intValue() != n2.intValue() ? 0 : -1;
        }
        return n;
    }

    private Integer parseRelationalExpr() throws PrgException {
        Integer n = this.parseShiftExpr();
        while (true) {
            Integer n2;
            if (this.checkAndParseToken("<=") || this.checkAndParseToken("LE")) {
                n2 = this.parseShiftExpr();
                if (n == null || n2 == null) continue;
                n = n <= n2 ? -1 : 0;
                continue;
            }
            if (this.checkAndParseToken("<") || this.checkAndParseToken("LT")) {
                n2 = this.parseShiftExpr();
                if (n == null || n2 == null) continue;
                n = n < n2 ? -1 : 0;
                continue;
            }
            if (this.checkAndParseToken(">=") || this.checkAndParseToken("GE")) {
                n2 = this.parseShiftExpr();
                if (n == null || n2 == null) continue;
                n = n >= n2 ? -1 : 0;
                continue;
            }
            if (!this.checkAndParseToken(">") && !this.checkAndParseToken("GT")) break;
            n2 = this.parseShiftExpr();
            if (n == null || n2 == null) continue;
            n = n > n2 ? -1 : 0;
        }
        return n;
    }

    private Integer parseShiftExpr() throws PrgException {
        Integer n = this.parseAddExpr();
        while (true) {
            Integer n2;
            if (this.checkAndParseToken("<<") || this.checkAndParseToken("SHL")) {
                n2 = this.parseAddExpr();
                if (n == null || n2 == null) continue;
                n = n << n2;
                continue;
            }
            if (!this.checkAndParseToken(">>") && !this.checkAndParseToken("SHR")) break;
            n2 = this.parseAddExpr();
            if (n == null || n2 == null) continue;
            n = n >> n2;
        }
        return n;
    }

    private Integer parseAddExpr() throws PrgException {
        Integer n = this.parseMulExpr();
        while (true) {
            Integer n2;
            if (this.checkAndParseToken("+")) {
                n2 = this.parseMulExpr();
                if (n == null || n2 == null) continue;
                n = n + n2;
                continue;
            }
            if (!this.checkAndParseToken("-")) break;
            n2 = this.parseMulExpr();
            if (n == null || n2 == null) continue;
            n = n - n2;
        }
        return n;
    }

    private Integer parseMulExpr() throws PrgException {
        Integer n = this.parseUnaryExpr();
        while (true) {
            Integer n2;
            if (this.checkAndParseToken("*")) {
                n2 = this.parseUnaryExpr();
                if (n == null || n2 == null) continue;
                n = n * n2;
                continue;
            }
            if (this.checkAndParseToken("/")) {
                n2 = this.parseUnaryExpr();
                if (n != null && n2 != null) {
                    if (n2 == 0) {
                        throw new PrgException("Division durch 0");
                    }
                    n = n / n2;
                }
                n = n / this.parseUnaryExpr();
                continue;
            }
            if (!this.checkAndParseToken("MOD")) break;
            n2 = this.parseUnaryExpr();
            if (n == null || n2 == null) continue;
            if (n2 == 0) {
                throw new PrgException("Modulo 0");
            }
            n = n % n2;
        }
        return n;
    }

    private Integer parseUnaryExpr() throws PrgException {
        Integer n = null;
        if (this.checkAndParseToken("+")) {
            n = this.parsePrimExpr();
        } else if (this.checkAndParseToken("-")) {
            Integer n2 = this.parsePrimExpr();
            if (n2 != null) {
                n = -n2.intValue();
            }
        } else if (this.checkAndParseToken("LOW")) {
            this.parseToken('(');
            Integer n3 = this.parseExpr();
            if (n3 != null) {
                n = n3 & 0xFF;
            }
            this.parseToken(')');
        } else if (this.checkAndParseToken("HIGH")) {
            this.parseToken('(');
            Integer n4 = this.parseExpr();
            if (n4 != null) {
                n = n4 >> 8 & 0xFF;
            }
            this.parseToken(')');
        } else if (this.checkAndParseToken("NOT")) {
            Integer n5 = this.parseExpr();
            if (n5 != null) {
                n = ~n5.intValue();
            }
            this.parseToken(')');
        } else if (this.checkAndParseToken("(")) {
            n = this.parseExpr();
            this.parseToken(')');
        } else {
            n = this.parsePrimExpr();
        }
        return n;
    }

    private Integer parsePrimExpr() throws PrgException {
        Integer n = null;
        if (this.checkAndParseToken("$")) {
            n = this.instBegAddr;
        } else if (this.checkAndParseToken("'")) {
            char c = this.iter.current();
            if (c == '\uffff') {
                throw new PrgException("Unerwartetes Ende des Zeichenliterals");
            }
            n = c;
            c = this.iter.next();
            if (c != '\'') {
                throw new PrgException("' als Ende des Zeichenliterals erwartet");
            }
            this.iter.next();
        } else {
            boolean bl = false;
            char c = this.skipSpaces();
            if (c == 'X' || c == 'x') {
                bl = this.iter.next() == '\'';
                this.iter.previous();
            }
            if (bl || c == '%' || c >= '0' && c <= '9') {
                n = ExprParser.parseNumber(this.iter);
            } else if (AsmLabel.isIdentifierStart(c)) {
                n = this.parseLabel();
            } else {
                throw new PrgException("'" + c + "': Ung\u00fcltiges Zeichen im Argument");
            }
        }
        return n;
    }

    private Integer parseLabel() throws PrgException {
        Integer n = null;
        StringBuilder stringBuilder = null;
        if (this.labels != null) {
            stringBuilder = new StringBuilder();
        }
        char c = this.skipSpaces();
        while (AsmLabel.isIdentifierPart(c)) {
            if (stringBuilder != null) {
                if (this.labelsCaseSensitive) {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(Character.toUpperCase(c));
                }
            }
            c = this.iter.next();
        }
        if (stringBuilder != null) {
            String string;
            String string2 = string = stringBuilder.toString();
            if (this.labelsCaseSensitive) {
                string2 = string.toUpperCase();
            }
            if (AsmArg.isFlagCondition(string2)) {
                throw new PrgException(string + ": Unerwartete Flag-Bedingung");
            }
            if (AsmArg.isRegister(string2)) {
                throw new PrgException(string + ": Unerwartete Register-Angabe");
            }
            AsmLabel asmLabel = this.labels.get(string);
            if (asmLabel != null) {
                Object object = asmLabel.getLabelValue();
                if (object != null && object instanceof Integer) {
                    n = (Integer)object;
                }
            } else if (this.checkLabels) {
                throw new PrgException(stringBuilder.toString() + ": Unbekannte Marke");
            }
        }
        return n;
    }

    private void parseToken(char c) throws PrgException {
        if (this.skipSpaces() != c) {
            throw new PrgException("'" + c + "' erwartet");
        }
        this.iter.next();
    }

    private char skipSpaces() {
        return ExprParser.skipSpaces(this.iter);
    }
}

