/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.assembler;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jkcemu.base.EmuUtil;
import jkcemu.programming.CmdLineArgIterator;
import jkcemu.programming.PrgException;
import jkcemu.programming.PrgLogger;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.assembler.AsmLabel;
import jkcemu.programming.assembler.ExprParser;
import jkcemu.programming.assembler.Z80Assembler;

public class CmdLineAssembler {
    private static final String[] usageLines = new String[]{"", "Aufruf:", "  java -jar jkcemu.jar --as [Optionen] <Datei>", "  java -jar jkcemu.jar --assembler [Optionen] <Datei>", "", "Optionen:", "  -h              diese Hilfe anzeigen", "  -f <Datei>      Kommandozeile aus Datei lesen", "  -l              Markentabelle ausgeben", "  -o <Datei>      Ausgabedatei festlegen", "  -9              Ausgabedatei f\u00fcr Z9001, KC85/1 und KC87 erzeugen", "  -C              Gro\u00df-/Kleinschreibung bei Marken beachten", "  -D <Marke>      Marke mit dem Wert -1 (alle Bits gesetzt) definieren", "  -D <Marke=Wert> Marke mit angegebenen Wert definieren", "  -U              undokumentierte Befehle erlauben", "  -R              nur Robotron-Syntax erlauben", "  -Z              nur Zilog-Syntax erlauben", ""};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(String[] stringArray, int n) {
        ArrayList<Map.Entry<String, Integer>> arrayList = new ArrayList<Map.Entry<String, Integer>>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        String string = null;
        String string2 = null;
        CmdLineArgIterator cmdLineArgIterator = null;
        CmdLineArgIterator cmdLineArgIterator2 = CmdLineArgIterator.createFromStringArray(stringArray, n);
        try {
            String string3 = cmdLineArgIterator2.next();
            while (string3 != null) {
                if (!string3.isEmpty()) {
                    if (string3.charAt(0) == '-') {
                        int n2 = string3.length();
                        if (n2 < 2) {
                            CmdLineAssembler.throwWrongCmdLine();
                        }
                        int n3 = 1;
                        block20: while (n3 < n2) {
                            String string4;
                            int n4 = string3.charAt(n3++);
                            switch (n4) {
                                case 102: {
                                    if (cmdLineArgIterator != null) {
                                        throw new IOException("Option -f in der Datei nicht erlaubt");
                                    }
                                    string4 = null;
                                    if (n3 < n2) {
                                        string4 = string3.substring(n3);
                                        n3 = n2;
                                    } else {
                                        string4 = cmdLineArgIterator2.next();
                                    }
                                    if (string4 == null) {
                                        CmdLineAssembler.throwWrongCmdLine();
                                    }
                                    try {
                                        cmdLineArgIterator = cmdLineArgIterator2;
                                        cmdLineArgIterator2 = CmdLineArgIterator.createFromReader(new FileReader(string4));
                                    }
                                    catch (IOException iOException) {
                                        cmdLineArgIterator2 = cmdLineArgIterator;
                                        cmdLineArgIterator = null;
                                    }
                                    break;
                                }
                                case 72: 
                                case 104: {
                                    bl3 = true;
                                    break;
                                }
                                case 67: {
                                    bl2 = true;
                                    break;
                                }
                                case 68: {
                                    string4 = null;
                                    if (n3 < n2) {
                                        string4 = string3.substring(n3);
                                        n3 = n2;
                                    } else {
                                        string4 = cmdLineArgIterator2.next();
                                    }
                                    CmdLineAssembler.parseLabel(arrayList, string4);
                                    break;
                                }
                                case 82: {
                                    bl4 = true;
                                    break;
                                }
                                case 90: {
                                    bl5 = true;
                                    break;
                                }
                                case 85: {
                                    bl6 = true;
                                    break;
                                }
                                case 108: {
                                    bl7 = true;
                                    break;
                                }
                                case 111: {
                                    if (string != null) {
                                        CmdLineAssembler.throwWrongCmdLine();
                                    }
                                    if (n3 < n2) {
                                        string = string3.substring(n3);
                                        n3 = n2;
                                    } else {
                                        string = cmdLineArgIterator2.next();
                                    }
                                    if (string != null) continue block20;
                                    CmdLineAssembler.throwWrongCmdLine();
                                    break;
                                }
                                case 57: {
                                    bl8 = true;
                                    break;
                                }
                                default: {
                                    throw new IOException(String.format("Unbekannte Option '%c'", Character.valueOf((char)n4)));
                                }
                            }
                        }
                    } else {
                        if (string2 != null) {
                            CmdLineAssembler.throwWrongCmdLine();
                        }
                        string2 = string3;
                    }
                }
                if ((string3 = cmdLineArgIterator2.next()) != null || cmdLineArgIterator == null) continue;
                EmuUtil.closeSilent(cmdLineArgIterator2);
                cmdLineArgIterator2 = cmdLineArgIterator;
                cmdLineArgIterator = null;
                string3 = cmdLineArgIterator2.next();
            }
            if (bl3) {
                EmuUtil.printlnOut();
                EmuUtil.printlnOut("JKCEMU Version 0.9.7 Assembler");
                for (String string4 : usageLines) {
                    EmuUtil.printlnOut(string4);
                }
            } else {
                if (bl4 && bl5) {
                    throw new IOException("Optionen 'R' und 'Z' schlie\u00dfen sich gegenseitig aus");
                }
                if (string2 == null) {
                    throw new IOException("Quelltextdatei nicht angegeben");
                }
                File file = new File(string2);
                PrgOptions prgOptions = new PrgOptions();
                if (bl4) {
                    prgOptions.setAsmSyntax(Z80Assembler.Syntax.ROBOTRON_ONLY);
                } else if (bl5) {
                    prgOptions.setAsmSyntax(Z80Assembler.Syntax.ZILOG_ONLY);
                } else {
                    prgOptions.setAsmSyntax(Z80Assembler.Syntax.ALL);
                }
                prgOptions.setLabelsCaseSensitive(bl2);
                prgOptions.setAllowUndocInst(bl6);
                prgOptions.setPrintLabels(bl7);
                bl = CmdLineAssembler.assemble(file, string, bl8, arrayList, prgOptions);
            }
        }
        catch (IOException iOException) {
            EmuUtil.printlnErr();
            EmuUtil.printlnErr("JKCEMU Version 0.9.7 Assembler:");
            String string5 = iOException.getMessage();
            if (string5 != null && !string5.isEmpty()) {
                EmuUtil.printlnErr(string5);
            }
            for (String string6 : usageLines) {
                EmuUtil.printlnErr(string6);
            }
            bl = false;
        }
        finally {
            EmuUtil.closeSilent(cmdLineArgIterator2);
        }
        return bl;
    }

    private static boolean assemble(File file, String string, boolean bl, List<Map.Entry<String, Integer>> list, PrgOptions prgOptions) {
        boolean bl2;
        block9: {
            bl2 = false;
            try {
                Object object;
                File file2 = null;
                if (string != null) {
                    file2 = new File(string);
                } else {
                    object = file.getName();
                    if (object != null) {
                        int n = ((String)object).lastIndexOf(46);
                        if (n >= 0 && n < ((String)object).length()) {
                            object = ((String)object).substring(0, n);
                        }
                        object = (String)object + ".bin";
                    } else {
                        object = "out.bin";
                    }
                    File file3 = file.getParentFile();
                    file2 = file3 != null ? new File(file3, (String)object) : new File((String)object);
                }
                if (file2.equals(file)) {
                    throw new IOException("Quelltext- und Ausgabedatei sind identisch");
                }
                prgOptions.setCodeToFile(true, file2);
                object = new Z80Assembler(null, null, file, prgOptions, PrgLogger.createStandardLogger(), false);
                for (Map.Entry entry : list) {
                    Integer n;
                    String string2 = (String)entry.getKey();
                    if (((Z80Assembler)object).addLabel(string2, (n = (Integer)entry.getValue()) != null ? n : -1)) continue;
                    throw new IOException("Marke " + string2 + " bereits vorhanden");
                }
                bl2 = ((Z80Assembler)object).assemble(null, bl);
            }
            catch (IOException iOException) {
                String string3 = iOException.getMessage();
                if (string3 == null || string3.isEmpty()) break block9;
                EmuUtil.printlnErr(string3);
            }
        }
        return bl2;
    }

    private static void parseLabel(List<Map.Entry<String, Integer>> list, String string) throws IOException {
        int n;
        boolean bl;
        if (string == null) {
            CmdLineAssembler.throwWrongCmdLine();
        }
        String string2 = string;
        String string3 = null;
        int n2 = string.indexOf(61);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        if (string2.isEmpty()) {
            CmdLineAssembler.throwWrongCmdLine();
        }
        if ((bl = AsmLabel.isIdentifierStart(string.charAt(0))) && (n = string2.length()) > 1) {
            for (int i = 1; i < n; ++i) {
                if (AsmLabel.isIdentifierPart(string.charAt(i))) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            throw new IOException(string2 + ": Marke enth\u00e4lht ung\u00fcltige Zeichen");
        }
        n = -1;
        if (string3 != null) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string3);
            if (stringCharacterIterator.first() == '\uffff') {
                throw new IOException("Marke " + string2 + ": Wert fehlt");
            }
            try {
                n = ExprParser.parseNumber(stringCharacterIterator);
            }
            catch (PrgException prgException) {
                throw new IOException("Marke " + string2 + ": " + prgException.getMessage());
            }
            if (ExprParser.skipSpaces(stringCharacterIterator) != '\uffff') {
                throw new IOException("Ung\u00fcltige Zahl bei Marke " + string2);
            }
        }
        list.add(new AbstractMap.SimpleImmutableEntry<String, Integer>(string2, n));
    }

    private static void throwWrongCmdLine() throws IOException {
        throw new IOException("Kommandozeile fehlerhaft");
    }
}

