/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.assembler;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jkcemu.base.EmuThread;
import jkcemu.base.UserInputException;
import jkcemu.programming.AbstractOptionsDlg;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.assembler.Z80Assembler;

public class AsmOptionsDlg
extends AbstractOptionsDlg {
    private JRadioButton btnSyntaxZilog;
    private JRadioButton btnSyntaxRobotron;
    private JRadioButton btnSyntaxBoth;
    private JCheckBox btnAllowUndocInst;
    private JCheckBox btnLabelsCaseSensitive;
    private JCheckBox btnPrintLabels;
    private JCheckBox btnLabelsToReass;
    private JCheckBox btnLabelsToDebugger;
    private JCheckBox btnSuppressLabelRecreateInDebugger;
    private JCheckBox btnFormatSource;
    private JCheckBox btnWarnNonAsciiChars;

    public AsmOptionsDlg(Frame frame, EmuThread emuThread, PrgOptions prgOptions) {
        super(frame, emuThread, "Assembler-Optionen");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Mnemonik/Syntax"));
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnSyntaxBoth = new JRadioButton("Zilog- und Robotron-Mnemonik/-Syntax");
        buttonGroup.add(this.btnSyntaxBoth);
        jPanel.add((Component)this.btnSyntaxBoth, gridBagConstraints2);
        this.btnSyntaxZilog = new JRadioButton("Nur Zilog-Mnemonik/-Syntax erlauben");
        buttonGroup.add(this.btnSyntaxZilog);
        gridBagConstraints2.insets.top = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnSyntaxZilog, gridBagConstraints2);
        this.btnSyntaxRobotron = new JRadioButton("Nur Robotron-Mnemonik/-Syntax erlauben");
        buttonGroup.add(this.btnSyntaxRobotron);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnSyntaxRobotron, gridBagConstraints2);
        this.btnAllowUndocInst = new JCheckBox("Undokumentierte Befehle erlauben");
        gridBagConstraints2.insets.top = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnAllowUndocInst, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Marken"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.btnLabelsCaseSensitive = new JCheckBox("Gro\u00df-/Kleinschreibung bei Marken beachten");
        jPanel2.add(this.btnLabelsCaseSensitive);
        this.btnPrintLabels = new JCheckBox("Markentabelle ausgeben");
        jPanel2.add(this.btnPrintLabels);
        JPanel jPanel3 = this.createCodeDestOptions();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Erzeugter Programmcode"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Sonstiges"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel4, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnWarnNonAsciiChars = new JCheckBox("Bei Nicht-ASCII-Zeichen warnen");
        jPanel4.add((Component)this.btnWarnNonAsciiChars, gridBagConstraints3);
        this.btnFormatSource = new JCheckBox("Quelltext formatieren");
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        jPanel4.add((Component)this.btnFormatSource, gridBagConstraints3);
        this.btnLabelsToDebugger = new JCheckBox("Im Debugger Halte-/Log-Punkte bzw. Variablen auf Marken anlegen");
        this.btnLabelsToDebugger.setEnabled(false);
        ++gridBagConstraints3.gridy;
        jPanel4.add((Component)this.btnLabelsToDebugger, gridBagConstraints3);
        this.btnSuppressLabelRecreateInDebugger = new JCheckBox("Im Debugger manuell entfernte Halte-/Log-Punkte bzw. Variablen nicht wieder anlegen");
        this.btnSuppressLabelRecreateInDebugger.setEnabled(false);
        ++gridBagConstraints3.gridy;
        jPanel4.add((Component)this.btnSuppressLabelRecreateInDebugger, gridBagConstraints3);
        this.btnLabelsToReass = new JCheckBox("Marken im Reassembler verwenden");
        this.btnLabelsToReass.setEnabled(false);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel4.add((Component)this.btnLabelsToReass, gridBagConstraints3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)this.createButtons("Assemblieren"), gridBagConstraints);
        if (prgOptions != null) {
            switch (prgOptions.getAsmSyntax()) {
                case ZILOG_ONLY: {
                    this.btnSyntaxZilog.setSelected(true);
                    break;
                }
                case ROBOTRON_ONLY: {
                    this.btnSyntaxRobotron.setSelected(true);
                    break;
                }
                default: {
                    this.btnSyntaxBoth.setSelected(true);
                }
            }
            this.btnAllowUndocInst.setSelected(prgOptions.getAllowUndocInst());
            this.btnLabelsCaseSensitive.setSelected(prgOptions.getLabelsCaseSensitive());
            this.btnPrintLabels.setSelected(prgOptions.getPrintLabels());
            this.btnWarnNonAsciiChars.setSelected(prgOptions.getWarnNonAsciiChars());
            this.btnFormatSource.setSelected(prgOptions.getFormatSource());
            this.btnLabelsToDebugger.setSelected(prgOptions.getLabelsToDebugger());
            this.btnSuppressLabelRecreateInDebugger.setSelected(prgOptions.getSuppressLabelRecreateInDebugger());
            this.btnLabelsToReass.setSelected(prgOptions.getLabelsToReassembler());
            this.updCodeDestFields(prgOptions, false);
        } else {
            this.btnSyntaxBoth.setSelected(true);
            this.btnAllowUndocInst.setSelected(false);
            this.btnLabelsCaseSensitive.setSelected(false);
            this.btnPrintLabels.setSelected(false);
            this.btnWarnNonAsciiChars.setSelected(true);
            this.btnFormatSource.setSelected(false);
            this.btnLabelsToDebugger.setSelected(false);
            this.btnSuppressLabelRecreateInDebugger.setSelected(false);
            this.btnLabelsToReass.setSelected(false);
            this.updCodeDestFields(prgOptions, true);
        }
        this.updSuppressLabelRecreateInDebuggerEnabled();
        this.btnLabelsToDebugger.addActionListener(this);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    @Override
    protected void codeToEmuChanged(boolean bl) {
        this.btnLabelsToDebugger.setEnabled(bl);
        this.btnLabelsToReass.setEnabled(bl);
        this.updSuppressLabelRecreateInDebuggerEnabled();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = super.doAction(eventObject);
        if (!bl && eventObject.getSource() == this.btnLabelsToDebugger) {
            this.updSuppressLabelRecreateInDebuggerEnabled();
            bl = true;
        }
        return bl;
    }

    @Override
    protected void doApply() {
        try {
            Z80Assembler.Syntax syntax = Z80Assembler.Syntax.ALL;
            if (this.btnSyntaxZilog.isSelected()) {
                syntax = Z80Assembler.Syntax.ZILOG_ONLY;
            } else if (this.btnSyntaxRobotron.isSelected()) {
                syntax = Z80Assembler.Syntax.ROBOTRON_ONLY;
            }
            this.appliedOptions = new PrgOptions();
            this.appliedOptions.setAsmSyntax(syntax);
            this.appliedOptions.setAllowUndocInst(this.btnAllowUndocInst.isSelected());
            this.appliedOptions.setLabelsCaseSensitive(this.btnLabelsCaseSensitive.isSelected());
            this.appliedOptions.setPrintLabels(this.btnPrintLabels.isSelected());
            this.appliedOptions.setLabelsToDebugger(this.btnLabelsToDebugger.isSelected());
            this.appliedOptions.setSuppressLabelRecreateInDebugger(this.btnSuppressLabelRecreateInDebugger.isSelected());
            this.appliedOptions.setLabelsToReassembler(this.btnLabelsToReass.isSelected());
            this.appliedOptions.setFormatSource(this.btnFormatSource.isSelected());
            this.appliedOptions.setWarnNonAsciiChars(this.btnWarnNonAsciiChars.isSelected());
            try {
                this.applyCodeDestOptionsTo(this.appliedOptions);
                this.doClose();
            }
            catch (UserInputException userInputException) {
                AsmOptionsDlg.showErrorDlg((Component)this, "Erzeugter Programmcode:\n" + userInputException.getMessage());
            }
        }
        catch (NumberFormatException numberFormatException) {
            AsmOptionsDlg.showErrorDlg((Component)this, numberFormatException.getMessage());
        }
    }

    private void updSuppressLabelRecreateInDebuggerEnabled() {
        this.btnSuppressLabelRecreateInDebugger.setEnabled(this.btnLabelsToDebugger.isEnabled() && this.btnLabelsToDebugger.isSelected());
    }
}

