/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.assembler;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import jkcemu.programming.PrgException;
import jkcemu.programming.PrgUtil;
import jkcemu.programming.assembler.AsmArg;
import jkcemu.programming.assembler.AsmLabel;
import jkcemu.programming.assembler.ExprParser;
import jkcemu.programming.assembler.Z80Assembler;

public class AsmLine {
    private boolean commentAtStart;
    private String comment;
    private String label;
    private String instruction;
    private AsmArg[] args;
    private int argPos;

    public static AsmLine scanLine(Z80Assembler z80Assembler, String string, boolean bl) throws PrgException {
        StringCharacterIterator stringCharacterIterator;
        char c;
        AsmLine asmLine = null;
        if (string != null && (c = (stringCharacterIterator = new StringCharacterIterator(string)).first()) != '\uffff') {
            CharSequence charSequence;
            boolean bl2 = false;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            ArrayList<AsmArg> arrayList = null;
            if (c == ';') {
                bl2 = true;
            } else {
                if (AsmLabel.isIdentifierStart(c)) {
                    String string5;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(c);
                    c = stringCharacterIterator.next();
                    while (AsmLabel.isIdentifierPart(c)) {
                        ((StringBuilder)charSequence).append(c);
                        c = stringCharacterIterator.next();
                    }
                    if (c != '\uffff' && !PrgUtil.isWhitespace(c) && c != ':' && c != ';') {
                        AsmLine.throwInvalidCharInLabel(c);
                    }
                    if ((string5 = ((StringBuilder)charSequence).toString().toUpperCase()).equals("IF") || string5.equals("IFT") || string5.equals("IFE") || string5.equals("IFF") || string5.equals("IF1") || string5.equals("IF2") || string5.equals("IFDEF") || string5.equals("IFNDEF") || string5.equals("ELSE") || string5.equals("ENDIF")) {
                        c = stringCharacterIterator.first();
                    } else {
                        if (c == ':') {
                            c = stringCharacterIterator.next();
                        }
                        string3 = ((StringBuilder)charSequence).toString();
                        String string6 = string3.toUpperCase();
                        if (!bl) {
                            string3 = string6;
                        }
                        if (z80Assembler != null) {
                            boolean bl3;
                            boolean bl4 = bl3 = z80Assembler.isReservedWord(string6) || AsmArg.isRegister(string6) || AsmArg.isFlagCondition(string6) || ExprParser.isReservedWord(string6);
                            if (!bl3 && z80Assembler.getOptions().getAllowUndocInst()) {
                                bl3 = AsmArg.isUndocRegister(string6);
                            }
                            if (bl3) {
                                z80Assembler.putWarning("Marke '" + string3 + "': Reserviertes Wort");
                            }
                        }
                    }
                } else if (c != '\uffff' && c != '.' && !PrgUtil.isWhitespace(c)) {
                    AsmLine.throwInvalidCharInLabel(c);
                }
                while (c != '\uffff' && PrgUtil.isWhitespace(c)) {
                    c = stringCharacterIterator.next();
                }
                if (c != '\uffff' && c != ';') {
                    charSequence = new StringBuilder();
                    while (c != '\uffff' && !PrgUtil.isWhitespace(c) && c != ';') {
                        ((StringBuilder)charSequence).append(Character.toUpperCase(c));
                        c = stringCharacterIterator.next();
                    }
                    string4 = ((StringBuilder)charSequence).toString();
                }
                charSequence = AsmLine.nextArgText(stringCharacterIterator);
                while (charSequence != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<AsmArg>();
                    }
                    arrayList.add(new AsmArg((String)charSequence));
                    charSequence = AsmLine.nextArgText(stringCharacterIterator);
                }
            }
            c = stringCharacterIterator.current();
            while (c != '\uffff' && PrgUtil.isWhitespace(c)) {
                c = stringCharacterIterator.next();
            }
            if (c == ';') {
                c = stringCharacterIterator.next();
                while (c != '\uffff' && PrgUtil.isWhitespace(c)) {
                    c = stringCharacterIterator.next();
                }
                if (c != '\uffff') {
                    charSequence = new StringBuilder(64);
                    ((StringBuilder)charSequence).append(c);
                    c = stringCharacterIterator.next();
                    while (c != '\uffff') {
                        ((StringBuilder)charSequence).append(c);
                        c = stringCharacterIterator.next();
                    }
                    string2 = ((StringBuilder)charSequence).toString();
                }
            }
            asmLine = new AsmLine(bl2, string2, string3, string4, arrayList != null ? arrayList.toArray(new AsmArg[arrayList.size()]) : null);
        }
        return asmLine;
    }

    public void appendFormattedTo(StringBuilder stringBuilder) {
        int n = 3;
        boolean bl = false;
        if (this.label != null && !this.label.isEmpty()) {
            stringBuilder.append(this.label);
            stringBuilder.append(':');
            bl = true;
        }
        if (this.instruction != null && !this.instruction.isEmpty()) {
            stringBuilder.append('\t');
            stringBuilder.append(this.instruction);
            --n;
        }
        if (this.args != null && this.args.length > 0) {
            stringBuilder.append('\t');
            for (int i = 0; i < this.args.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.args[i].createFormattedText());
            }
            --n;
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            if (bl || n < 3 || !this.commentAtStart) {
                while (n > 0) {
                    stringBuilder.append('\t');
                    --n;
                }
            }
            stringBuilder.append(';');
            stringBuilder.append(this.comment);
        }
    }

    public void checkEOL() throws PrgException {
        if (this.args != null && this.argPos < this.args.length) {
            StringBuilder stringBuilder = new StringBuilder(32);
            String string = this.args[this.argPos].toString();
            if (string != null && !string.isEmpty()) {
                stringBuilder.append(string);
                stringBuilder.append(": ");
            }
            stringBuilder.append("Unerwartetes Argument");
            throw new PrgException(stringBuilder.toString());
        }
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean hasMoreArgs() {
        boolean bl = false;
        if (this.args != null && this.argPos < this.args.length) {
            bl = true;
        }
        return bl;
    }

    public AsmArg nextArg() throws PrgException {
        AsmArg asmArg = null;
        if (this.args != null && this.argPos < this.args.length) {
            asmArg = this.args[this.argPos++];
        }
        if (asmArg == null) {
            throw new PrgException("Argument erwartet");
        }
        return asmArg;
    }

    private AsmLine(boolean bl, String string, String string2, String string3, AsmArg[] asmArgArray) {
        this.commentAtStart = bl;
        this.comment = string;
        this.label = string2;
        this.instruction = string3;
        this.args = asmArgArray;
        this.argPos = 0;
    }

    private static String nextArgText(CharacterIterator characterIterator) throws PrgException {
        char c = characterIterator.current();
        while (c != '\uffff' && PrgUtil.isWhitespace(c)) {
            c = characterIterator.next();
        }
        StringBuilder stringBuilder = null;
        if (c == '\'' || c == '\"') {
            char c2 = c;
            stringBuilder = new StringBuilder();
            stringBuilder.append(c);
            c = characterIterator.next();
            while (c != '\uffff' && c != c2) {
                stringBuilder.append(c);
                c = characterIterator.next();
            }
            if (c == c2) {
                stringBuilder.append(c);
                c = characterIterator.next();
            }
        }
        if (c != '\uffff' && c != ',' && c != ';') {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            while (c != '\uffff' && c != ',' && c != ';') {
                stringBuilder.append(c);
                c = characterIterator.next();
            }
        }
        if (c == ',') {
            if (stringBuilder == null) {
                throw new PrgException("Komma ohne vorheriges Argument");
            }
            characterIterator.next();
        }
        String string = null;
        if (stringBuilder != null && (string = stringBuilder.toString()).isEmpty()) {
            string = null;
        }
        return string;
    }

    private static void throwInvalidCharInLabel(char c) throws PrgException {
        StringBuilder stringBuilder = new StringBuilder(40);
        if (c >= ' ') {
            stringBuilder.append('\'');
            stringBuilder.append(c);
            stringBuilder.append("': ");
        }
        stringBuilder.append("Zeichen in Marke nicht erlaubt");
        throw new PrgException(stringBuilder.toString());
    }
}

