/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.assembler;

import java.text.StringCharacterIterator;
import jkcemu.programming.PrgException;
import jkcemu.programming.PrgUtil;

public class AsmArg {
    private int argLen;
    private String argText;
    private String upperText;
    private String indirectText;

    public AsmArg(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && PrgUtil.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n > 0) {
            string = string.substring(n);
        }
        n2 = string.length();
        for (n = n2 - 1; n >= 0 && PrgUtil.isWhitespace(string.charAt(n)); --n) {
        }
        if (n < 0) {
            string = "";
        } else if (n < n2 - 1) {
            string = string.substring(0, n + 1);
        }
        this.argText = string;
        this.argLen = this.argText.length();
        this.upperText = this.argText.toUpperCase();
        this.indirectText = null;
        if (this.argLen > 1 && this.argText.charAt(0) == '(' && this.argText.charAt(this.argLen - 1) == ')') {
            this.indirectText = this.upperText.substring(1, this.argLen - 1);
        }
    }

    public String createFormattedText() {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.argText);
        StringBuilder stringBuilder = new StringBuilder(Math.max(stringCharacterIterator.getEndIndex(), 16));
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\'') {
                stringBuilder.append(c);
                c = stringCharacterIterator.next();
                while (c != '\uffff' && c != '\'') {
                    stringBuilder.append(c);
                    c = stringCharacterIterator.next();
                }
                if (c != '\'') continue;
                stringBuilder.append(c);
                c = stringCharacterIterator.next();
                continue;
            }
            stringBuilder.append(Character.toUpperCase(c));
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public boolean equalsUpper(String string) {
        return this.upperText.equals(string);
    }

    public String getIndirectText() throws PrgException {
        if (this.indirectText == null) {
            throw new PrgException("Indirekte Adressierung erwartet");
        }
        return this.indirectText;
    }

    public String getIndirectIXYDist() throws PrgException {
        String string = this.getIndirectText();
        String string2 = "";
        if (!this.indirectText.startsWith("IX") && !this.indirectText.startsWith("IY")) {
            throw new PrgException("Indirekte Adressierung mit Indexregister erwartet");
        }
        if (this.indirectText.length() > 2 && !(string2 = this.indirectText.substring(2)).startsWith("+") && !string2.startsWith("-")) {
            throw new PrgException("Ung\u00fcltige Distanzangabe bei indirekter Adressierung mit Indexregister");
        }
        return string2;
    }

    public int getReg8Code() throws PrgException {
        int n = -1;
        if (this.equalsUpper("A")) {
            n = 7;
        } else if (this.equalsUpper("B")) {
            n = 0;
        } else if (this.equalsUpper("C")) {
            n = 1;
        } else if (this.equalsUpper("D")) {
            n = 2;
        } else if (this.equalsUpper("E")) {
            n = 3;
        } else if (this.equalsUpper("H")) {
            n = 4;
        } else if (this.equalsUpper("L")) {
            n = 5;
        } else if (this.equalsUpper("M")) {
            n = 6;
        } else if (this.isIndirectHL()) {
            n = 6;
        }
        if (n < 0 || n > 7) {
            throw new PrgException("Register oder (HL) erwartet");
        }
        return n;
    }

    public boolean isIndirectAddr() {
        boolean bl = false;
        if (this.indirectText != null && !AsmArg.isRegister(this.indirectText)) {
            char c;
            bl = true;
            if ((this.indirectText.startsWith("IX") || this.indirectText.startsWith("IY")) && this.indirectText.length() > 2 && ((c = this.indirectText.charAt(2)) == '+' || c == '-')) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isIndirectBC() {
        return this.indirectText != null ? this.indirectText.equals("BC") : false;
    }

    public boolean isIndirectDE() {
        return this.indirectText != null ? this.indirectText.equals("DE") : false;
    }

    public boolean isIndirectHL() {
        return this.indirectText != null ? this.indirectText.equals("HL") : false;
    }

    public boolean isIndirectIX() {
        return this.indirectText != null ? this.indirectText.equals("IX") : false;
    }

    public boolean isIndirectIY() {
        return this.indirectText != null ? this.indirectText.equals("IY") : false;
    }

    public boolean isIndirectIXDist() {
        return this.isIndirectDist("IX");
    }

    public boolean isIndirectIYDist() {
        return this.isIndirectDist("IY");
    }

    public boolean isIndirectSP() {
        return this.indirectText != null ? this.indirectText.equals("SP") : false;
    }

    public boolean isRegAtoL() {
        return this.equalsUpper("A") || this.isRegBtoL();
    }

    public boolean isRegBtoL() {
        return this.equalsUpper("B") || this.equalsUpper("C") || this.equalsUpper("D") || this.equalsUpper("E") || this.equalsUpper("H") || this.equalsUpper("L");
    }

    public static boolean isRegister(String string) {
        return string.equals("A") || string.equals("B") || string.equals("C") || string.equals("D") || string.equals("E") || string.equals("H") || string.equals("L") || string.equals("I") || string.equals("R") || string.equals("AF") || string.equals("BC") || string.equals("DE") || string.equals("HL") || string.equals("IX") || string.equals("IY") || string.equals("AF'") || string.equals("BC'") || string.equals("DE'") || string.equals("HL'");
    }

    public static boolean isFlagCondition(String string) {
        return string.equals("NZ") || string.equals("Z") || string.equals("NC") || string.equals("C") || string.equals("PO") || string.equals("PE") || string.equals("P") || string.equals("M");
    }

    public static boolean isUndocRegister(String string) {
        return string.equals("IXH") || string.equals("IXL") || string.equals("IYH") || string.equals("IYL") || string.equals("HX") || string.equals("LX") || string.equals("HY") || string.equals("LY");
    }

    public String toUpperString() {
        return this.upperText;
    }

    public String toString() {
        return this.argText;
    }

    private boolean isIndirectDist(String string) {
        boolean bl = false;
        if (this.indirectText != null && this.indirectText.startsWith(string)) {
            char c;
            bl = true;
            int n = string.length();
            if (this.indirectText.length() > n && (c = this.indirectText.charAt(n)) != '+' && c != '-') {
                bl = false;
            }
        }
        return bl;
    }
}

