/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.print;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;

public class PrintOptionsDlg
extends BaseDlg {
    private boolean applied = false;
    private JComboBox<String> comboFontSize;
    private JCheckBox btnFileName;
    private JCheckBox btnPageNum;
    private JButton btnOK;
    private JButton btnCancel;

    public static boolean showPrintOptionsDlg(Frame frame, boolean bl, boolean bl2) {
        PrintOptionsDlg printOptionsDlg = new PrintOptionsDlg(frame, bl, bl2);
        printOptionsDlg.setVisible(true);
        return printOptionsDlg.optionsApplied();
    }

    public boolean optionsApplied() {
        return this.applied;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        try {
            if (eventObject != null) {
                Object object = eventObject.getSource();
                if (object == this.btnOK) {
                    bl = true;
                    this.doApply();
                } else if (object == this.btnCancel) {
                    bl = true;
                    this.doClose();
                }
            }
        }
        catch (Exception exception) {
            EmuUtil.exitSysError(this, null, exception);
        }
        return bl;
    }

    private PrintOptionsDlg(Frame frame, boolean bl, boolean bl2) {
        super((Window)frame, "Druckoptionen");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.comboFontSize = null;
        if (bl) {
            jPanel.add((Component)new JLabel("Schriftgr\u00f6\u00dfe:"), gridBagConstraints2);
            this.comboFontSize = new JComboBox();
            this.comboFontSize.setEditable(false);
            this.comboFontSize.addItem("6");
            this.comboFontSize.addItem("7");
            this.comboFontSize.addItem("8");
            this.comboFontSize.addItem("9");
            this.comboFontSize.addItem("10");
            this.comboFontSize.addItem("11");
            this.comboFontSize.addItem("12");
            this.comboFontSize.addItem("14");
            this.comboFontSize.addItem("16");
            this.comboFontSize.addItem("18");
            this.comboFontSize.addItem("20");
            this.comboFontSize.addItem("22");
            this.comboFontSize.addItem("24");
            ++gridBagConstraints2.gridx;
            jPanel.add(this.comboFontSize, gridBagConstraints2);
            gridBagConstraints2.insets.top = 0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridx = 0;
            ++gridBagConstraints2.gridy;
            this.comboFontSize.setSelectedItem(String.valueOf(Main.getPrintFontSize()));
        }
        this.btnFileName = null;
        if (bl2) {
            this.btnFileName = new JCheckBox("Dateiname drucken", Main.getPrintFileName());
            jPanel.add((Component)this.btnFileName, gridBagConstraints2);
            gridBagConstraints2.insets.top = 0;
            gridBagConstraints2.gridwidth = 2;
            ++gridBagConstraints2.gridy;
        }
        this.btnPageNum = new JCheckBox("Seitennummer drucken", Main.getPrintPageNum());
        gridBagConstraints2.insets.bottom = 5;
        jPanel.add((Component)this.btnPageNum, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        jPanel2.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jPanel2.add(this.btnCancel);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    private void doApply() {
        String string;
        Object object;
        if (this.comboFontSize != null && (object = this.comboFontSize.getSelectedItem()) != null && (string = object.toString()) != null) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    Main.setPrintFontSize(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.btnFileName != null) {
            Main.setPrintFileName(this.btnFileName.isSelected());
        }
        Main.setPrintPageNum(this.btnPageNum.isSelected());
        this.applied = true;
        this.doClose();
    }
}

