/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.print;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jkcemu.print.PrintData;

public class PrintMngr
extends AbstractTableModel {
    private static final String[] colNames = new String[]{"Nummer", "Gr\u00f6\u00dfe", "Status"};
    private int nextEntryNum = 1;
    private List<PrintData> entries = new ArrayList<PrintData>();
    private PrintData activeEntry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivatePrintData(PrintData printData) {
        if (printData != null) {
            List<PrintData> list = this.entries;
            synchronized (list) {
                if (this.activeEntry != null && this.activeEntry == printData) {
                    this.activeEntry = null;
                    this.fireDataChanged(true);
                }
            }
        }
    }

    public PrintData getActivePrintData() {
        return this.activeEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintData getPrintData(int n) {
        PrintData printData = null;
        List<PrintData> list = this.entries;
        synchronized (list) {
            if (n >= 0 && n < this.entries.size()) {
                printData = this.entries.get(n);
            }
        }
        return printData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putByte(int n) {
        boolean bl = true;
        List<PrintData> list = this.entries;
        synchronized (list) {
            if (this.activeEntry == null) {
                this.activeEntry = new PrintData(this.nextEntryNum++);
                this.entries.add(this.activeEntry);
                bl = false;
            }
            this.activeEntry.putByte(n);
        }
        this.fireDataChanged(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(int n) {
        List<PrintData> list = this.entries;
        synchronized (list) {
            if (this.entries.remove(n) == this.activeEntry) {
                this.activeEntry = null;
            }
            this.fireTableRowsDeleted(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<PrintData> list = this.entries;
        synchronized (list) {
            boolean bl = true;
            if (this.activeEntry != null && this.activeEntry.size() < 1) {
                this.entries.remove(this.activeEntry);
                bl = false;
            }
            this.activeEntry = null;
            this.fireDataChanged(bl);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 || n == 1 ? Integer.class : Object.class;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return n >= 0 && n < colNames.length ? colNames[n] : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        int n = 0;
        List<PrintData> list = this.entries;
        synchronized (list) {
            n = this.entries.size();
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        PrintData printData = this.getPrintData(n);
        if (printData != null) {
            switch (n2) {
                case 0: {
                    object = printData.getEntryNum();
                    break;
                }
                case 1: {
                    object = printData.size();
                    break;
                }
                case 2: {
                    object = this.activeEntry != null && printData == this.activeEntry ? "aktiv" : "abgeschlossen";
                }
            }
        }
        return object;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private void fireDataChanged(boolean bl) {
        if (bl) {
            int n = this.entries.size() - 1;
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        } else {
            this.fireTableDataChanged();
        }
    }
}

