/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import jkcemu.net.W5100;

public class EmuDatagramSocket
implements AutoCloseable,
Closeable {
    private DatagramSocket datagramSocket;
    private int port;

    public static EmuDatagramSocket createDatagramSocket() throws SocketException {
        return new EmuDatagramSocket(new DatagramSocket(), 0);
    }

    public static EmuDatagramSocket createDatagramSocket(int n) throws SocketException {
        EmuDatagramSocket emuDatagramSocket = null;
        emuDatagramSocket = n == 68 ? new EmuDatagramSocket(null, n) : new EmuDatagramSocket(new DatagramSocket(n), n);
        return emuDatagramSocket;
    }

    public static EmuDatagramSocket createMulticastSocket() throws IOException {
        return new EmuDatagramSocket(new MulticastSocket(), 0);
    }

    public static EmuDatagramSocket createMulticastSocket(int n) throws IOException {
        EmuDatagramSocket emuDatagramSocket = null;
        emuDatagramSocket = n == 68 ? new EmuDatagramSocket(null, n) : new EmuDatagramSocket(new MulticastSocket(n), n);
        return emuDatagramSocket;
    }

    public int getLocalPort() {
        return this.datagramSocket != null ? this.datagramSocket.getLocalPort() : this.port;
    }

    public boolean isMulticastSocket() {
        boolean bl = false;
        if (this.datagramSocket != null && this.datagramSocket instanceof MulticastSocket) {
            bl = true;
        }
        return bl;
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        if (this.datagramSocket != null && this.datagramSocket instanceof MulticastSocket) {
            ((MulticastSocket)this.datagramSocket).joinGroup(inetAddress);
        }
    }

    public boolean receive(W5100 w5100, DatagramPacket datagramPacket) throws IOException {
        boolean bl = false;
        if (this.datagramSocket != null) {
            this.datagramSocket.receive(datagramPacket);
            bl = true;
        } else {
            bl = w5100.getDhcpServer().receive(datagramPacket);
        }
        return bl;
    }

    public void send(W5100 w5100, DatagramPacket datagramPacket) throws IOException {
        if (this.datagramSocket != null) {
            this.datagramSocket.send(datagramPacket);
        } else {
            w5100.getDhcpServer().send(datagramPacket);
        }
    }

    public void setTimeToLive(int n) throws IOException {
        if (this.datagramSocket != null && this.datagramSocket instanceof MulticastSocket) {
            ((MulticastSocket)this.datagramSocket).setTimeToLive(n);
        }
    }

    @Override
    public void close() {
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
        }
    }

    private EmuDatagramSocket(DatagramSocket datagramSocket, int n) {
        this.datagramSocket = datagramSocket;
        this.port = n;
    }
}

