/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.joystick;

import jkcemu.Main;
import jkcemu.base.DeviceIO;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;

public class JoystickThread
extends Thread {
    public static final int LEFT_MASK = 1;
    public static final int RIGHT_MASK = 2;
    public static final int UP_MASK = 4;
    public static final int DOWN_MASK = 8;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 32;
    public static final int BUTTONS_MASK = 48;
    private EmuThread emuThread;
    private int joyNum;
    private boolean allowAltJoy;
    private boolean interactive;
    private volatile boolean running;

    public JoystickThread(EmuThread emuThread, int n, boolean bl) {
        super(Main.getThreadGroup(), String.format("JKCEMU joystick %d listener", n));
        this.emuThread = emuThread;
        this.joyNum = n;
        this.interactive = bl;
        this.running = true;
    }

    public void fireStop() {
        this.running = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DeviceIO.Joystick joystick = null;
        try {
            int n;
            if (this.interactive) {
                n = this.joyNum + 1;
                while (n > 0) {
                    joystick = DeviceIO.openJoystick(--n);
                }
            } else {
                joystick = DeviceIO.openJoystick(this.joyNum);
            }
            if (joystick != null) {
                while (this.running) {
                    if (Main.isWindowActive() && joystick.waitForEvent()) {
                        n = 0;
                        float f = joystick.getXAxis();
                        float f2 = joystick.getYAxis();
                        int n2 = joystick.getPressedButtons();
                        if (f < -0.5f) {
                            n |= 1;
                        } else if (f > 0.5f) {
                            n |= 2;
                        }
                        if (f2 < -0.5f) {
                            n |= 4;
                        } else if (f2 > 0.5f) {
                            n |= 8;
                        }
                        if ((n2 & 0x5555) != 0) {
                            n |= 0x10;
                        }
                        if ((n2 & 0xAAAA) != 0) {
                            n |= 0x20;
                        }
                        this.emuThread.setJoystickAction(this.joyNum, n);
                        continue;
                    }
                    this.emuThread.setJoystickAction(this.joyNum, 0);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (this.interactive) {
                this.emuThread.fireShowJoystickError("Joystick nicht angeschlossen oder nicht unterst\u00fctzt");
            }
        }
        finally {
            this.emuThread.setJoystickAction(this.joyNum, 0);
            EmuUtil.closeSilent(joystick);
        }
        this.emuThread.joystickThreadTerminated(this);
    }
}

