/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.joystick;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;

public class JoystickActionFld
extends Component {
    private static Polygon pgLeft = null;
    private static Polygon pgRight = null;
    private static Polygon pgUp = null;
    private static Polygon pgDown = null;
    private boolean stateLeft;
    private boolean stateRight;
    private boolean stateUp;
    private boolean stateDown;
    private boolean stateButton1;
    private boolean stateButton2;

    public JoystickActionFld() {
        int[] nArray;
        int[] nArray2;
        if (pgLeft == null) {
            nArray2 = new int[]{0, 10, 10, 25, 25, 10, 10, 0};
            nArray = new int[]{35, 25, 31, 31, 39, 39, 45, 35};
            pgLeft = new Polygon(nArray2, nArray, Math.min(nArray2.length, nArray.length));
        }
        if (pgRight == null) {
            nArray2 = new int[]{60, 70, 60, 60, 45, 45, 60, 60};
            nArray = new int[]{25, 35, 45, 39, 39, 31, 31, 25};
            pgRight = new Polygon(nArray2, nArray, Math.min(nArray2.length, nArray.length));
        }
        if (pgUp == null) {
            nArray2 = new int[]{35, 45, 39, 39, 31, 31, 25, 35};
            nArray = new int[]{0, 10, 10, 25, 25, 10, 10, 0};
            pgUp = new Polygon(nArray2, nArray, Math.min(nArray2.length, nArray.length));
        }
        if (pgDown == null) {
            nArray2 = new int[]{31, 39, 39, 45, 35, 25, 31, 31};
            nArray = new int[]{45, 45, 60, 60, 70, 60, 60, 45};
            pgDown = new Polygon(nArray2, nArray, Math.min(nArray2.length, nArray.length));
        }
        this.stateLeft = false;
        this.stateRight = false;
        this.stateUp = false;
        this.stateDown = false;
        this.stateButton1 = false;
        this.stateButton2 = false;
        this.setPreferredSize(new Dimension(71, 106));
    }

    public int getJoystickAction(int n, int n2) {
        int n3 = 0;
        if (pgLeft.contains(n, n2)) {
            n3 |= 1;
        } else if (pgRight.contains(n, n2)) {
            n3 |= 2;
        } else if (pgUp.contains(n, n2)) {
            n3 |= 4;
        } else if (pgDown.contains(n, n2)) {
            n3 |= 8;
        } else if (JoystickActionFld.isInCircle(20, 90, 10, n, n2)) {
            n3 |= 0x10;
        } else if (JoystickActionFld.isInCircle(50, 90, 10, n, n2)) {
            n3 |= 0x20;
        }
        return n3;
    }

    public void setJoystickAction(int n) {
        this.stateLeft = (n & 1) != 0;
        this.stateRight = (n & 2) != 0;
        this.stateUp = (n & 4) != 0;
        this.stateDown = (n & 8) != 0;
        this.stateButton1 = (n & 0x10) != 0;
        this.stateButton2 = (n & 0x20) != 0;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        boolean bl = this.isEnabled();
        Color color = bl ? Color.black : Color.gray;
        graphics = graphics.create();
        graphics.setColor(bl && this.stateUp ? Color.red : Color.lightGray);
        graphics.fillPolygon(pgUp);
        graphics.setColor(color);
        graphics.drawPolygon(pgUp);
        graphics.setColor(bl && this.stateLeft ? Color.red : Color.lightGray);
        graphics.fillPolygon(pgLeft);
        graphics.setColor(color);
        graphics.drawPolygon(pgLeft);
        graphics.setColor(bl && this.stateRight ? Color.red : Color.lightGray);
        graphics.fillPolygon(pgRight);
        graphics.setColor(color);
        graphics.drawPolygon(pgRight);
        graphics.setColor(bl && this.stateDown ? Color.red : Color.lightGray);
        graphics.fillPolygon(pgDown);
        graphics.setColor(color);
        graphics.drawPolygon(pgDown);
        graphics.setColor(bl && this.stateButton1 ? Color.red : Color.lightGray);
        graphics.fillOval(10, 80, 20, 20);
        graphics.setColor(color);
        graphics.drawOval(10, 80, 20, 20);
        graphics.setColor(bl && this.stateButton2 ? Color.red : Color.lightGray);
        graphics.fillOval(40, 80, 20, 20);
        graphics.setColor(color);
        graphics.drawOval(40, 80, 20, 20);
        graphics.dispose();
    }

    private static boolean isInCircle(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = Math.abs(n - n4);
        return Math.sqrt(n7 * n7 + (n6 = Math.abs(n2 - n5)) * n6) <= (double)n3;
    }
}

