/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.base.BaseDlg;
import jkcemu.image.ImageFrm;
import jkcemu.image.ImgFld;
import jkcemu.image.ImgUtil;

public class ThresholdDlg
extends BaseDlg
implements ChangeListener {
    private ImgFld imgFld;
    private BufferedImage appliedImg;
    private BufferedImage grayImg;
    private int wImg;
    private int hImg;
    private byte[] palette;
    private JSlider slider;
    private JButton btnApply;
    private JButton btnCancel;

    public static BufferedImage showDlg(ImageFrm imageFrm) {
        ThresholdDlg thresholdDlg = new ThresholdDlg(imageFrm);
        thresholdDlg.setVisible(true);
        return thresholdDlg.appliedImg;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.slider) {
            this.sliderChanged();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnCancel) {
            bl = true;
            this.doClose();
        } else if (object == this.btnApply) {
            bl = true;
            this.doApply();
        }
        return bl;
    }

    private ThresholdDlg(ImageFrm imageFrm) {
        super((Window)imageFrm, "Schwellwert");
        Object object;
        this.imgFld = imageFrm.getImgFld();
        this.palette = new byte[256];
        this.appliedImg = null;
        this.grayImg = null;
        BufferedImage bufferedImage = this.imgFld.getImage();
        if (bufferedImage != null) {
            this.wImg = bufferedImage.getWidth();
            this.hImg = bufferedImage.getHeight();
            if (this.wImg > 0 && this.hImg > 0) {
                this.grayImg = new BufferedImage(this.wImg, this.hImg, 13, ImgUtil.getColorModelSortedGray());
                object = this.grayImg.createGraphics();
                ((Graphics)object).drawImage(bufferedImage, 0, 0, this);
                ((Graphics)object).dispose();
            }
        }
        this.setLayout(new GridBagLayout());
        object = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.slider = new JSlider(0, 0, 256, 128);
        this.add((Component)this.slider, object);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).fill = 0;
        ++((GridBagConstraints)object).gridy;
        this.add((Component)jPanel, object);
        this.btnApply = new JButton("OK");
        jPanel.add(this.btnApply);
        this.btnCancel = new JButton("Abbrechen");
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.sliderChanged();
        this.slider.addChangeListener(this);
        this.btnApply.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    private void doApply() {
        BufferedImage bufferedImage = this.imgFld.getImage();
        if (bufferedImage != null) {
            this.appliedImg = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12, ImgUtil.getColorModelBW());
            Graphics2D graphics2D = this.appliedImg.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
            graphics2D.dispose();
        }
        this.doClose();
    }

    private void sliderChanged() {
        if (this.grayImg != null) {
            int n = 256 - this.slider.getValue();
            for (int i = 0; i < this.palette.length; ++i) {
                this.palette[i] = (byte)(i < n ? 0 : 255);
            }
            this.imgFld.setImage(new BufferedImage(new IndexColorModel(8, this.palette.length, this.palette, this.palette, this.palette), this.grayImg.getRaster(), false, new Hashtable()));
            this.imgFld.repaint();
        }
    }
}

