/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jkcemu.base.BaseDlg;

public class RemoveTransparencyDlg
extends BaseDlg {
    private static int lastColorIdx = 0;
    private BufferedImage image;
    private BufferedImage appliedImage;
    private JRadioButton btnKeepColor;
    private JRadioButton btnToWhite;
    private JRadioButton btnToGray;
    private JRadioButton btnToBlack;
    private JButton btnApply;
    private JButton btnCancel;

    public static BufferedImage showDlg(Window window, BufferedImage bufferedImage) {
        RemoveTransparencyDlg removeTransparencyDlg = new RemoveTransparencyDlg(window, bufferedImage);
        removeTransparencyDlg.setVisible(true);
        return removeTransparencyDlg.appliedImage;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnApply) {
            bl = true;
            this.doApply();
        } else if (object == this.btnCancel) {
            bl = true;
            this.doClose();
        }
        return bl;
    }

    private RemoveTransparencyDlg(Window window, BufferedImage bufferedImage) {
        super(window, "Transparenz entfernen");
        this.image = bufferedImage;
        this.appliedImage = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Transparente Bereiche f\u00fcllen mit:"), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnKeepColor = new JRadioButton("in den Pixeln gespeicherte Farbe", lastColorIdx == 0);
        buttonGroup.add(this.btnKeepColor);
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnKeepColor, gridBagConstraints);
        this.btnToWhite = new JRadioButton("wei\u00df", lastColorIdx == 1);
        buttonGroup.add(this.btnToWhite);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnToWhite, gridBagConstraints);
        this.btnToGray = new JRadioButton("grau", lastColorIdx == 2);
        buttonGroup.add(this.btnToGray);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnToGray, gridBagConstraints);
        this.btnToBlack = new JRadioButton("schwarz", lastColorIdx == 3);
        buttonGroup.add(this.btnToBlack);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnToBlack, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnApply = new JButton("OK");
        jPanel.add(this.btnApply);
        this.btnCancel = new JButton("Abbrechen");
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.btnApply.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    private void doApply() {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        if (n > 0 && n2 > 0) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Color color = null;
            if (this.btnToWhite.isSelected()) {
                color = Color.WHITE;
                lastColorIdx = 1;
            } else if (this.btnToGray.isSelected()) {
                color = Color.GRAY;
                lastColorIdx = 2;
            } else if (this.btnToBlack.isSelected()) {
                color = Color.BLACK;
                lastColorIdx = 3;
            } else {
                lastColorIdx = 0;
            }
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n, n2);
            }
            graphics2D.drawImage((Image)this.image, 0, 0, this);
            graphics2D.dispose();
            this.appliedImage = bufferedImage;
            this.doClose();
        }
    }
}

