/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.filechooser.FileNameExtensionFilter;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.a5105.VIS;
import jkcemu.image.GrayScaler;
import jkcemu.image.ImgCopier;

public class ImgUtil {
    public static final int TRANSPARENT_ARGB = 0xFFFFFF;
    public static final Color transparentColor = new Color(0xFFFFFF);
    public static final int A5105_W = 320;
    public static final int A5105_H = 200;
    public static final int AC1_W = 384;
    public static final int AC1_H = 256;
    public static final int KC85_COLS = 40;
    public static final int KC85_ROWS = 32;
    public static final int KC85_W = 320;
    public static final int KC85_H = 256;
    public static final int LLC2_COLS = 64;
    public static final int LLC2_ROWS = 32;
    public static final int LLC2_W = 512;
    public static final int LLC2_H = 256;
    public static final int LLC2_H2 = 384;
    public static final int Z1013_W = 256;
    public static final int Z1013_H = 256;
    public static final int Z9001_W = 320;
    public static final int Z9001_H = 192;
    public static final int ROUND_PIXELS_MAX = 9;
    private static IndexColorModel cmBW = null;
    private static IndexColorModel cmSortedGray = null;
    private static IndexColorModel cmA5105 = null;
    private static IndexColorModel cmKC854Hires = null;

    public static BufferedImage createBlackKC854HiresImage() {
        BufferedImage bufferedImage = new BufferedImage(320, 256, 12, ImgUtil.getColorModelKC854Hires());
        ImgUtil.fillBlack(bufferedImage);
        return bufferedImage;
    }

    public static BufferedImage createBlackKC85BWImage() {
        BufferedImage bufferedImage = new BufferedImage(320, 256, 12, ImgUtil.getColorModelBW());
        ImgUtil.fillBlack(bufferedImage);
        return bufferedImage;
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage != null) {
            if (n < 1) {
                n = bufferedImage.getWidth();
            }
            if (n2 < 1) {
                n2 = bufferedImage.getHeight();
            }
            if (n > 0 && n2 > 0) {
                int n3 = bufferedImage.getType();
                IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
                if (indexColorModel != null && (n3 == 12 || n3 == 13)) {
                    bufferedImage2 = new BufferedImage(n, n2, n3, indexColorModel);
                }
                if (bufferedImage2 == null) {
                    if (n3 == 0) {
                        n3 = 2;
                    }
                    bufferedImage2 = new BufferedImage(n, n2, n3);
                }
            }
        }
        return bufferedImage2;
    }

    public static FileNameExtensionFilter createFileFilter(String string, String[] ... stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray != null) {
            for (String[] object : stringArray) {
                if (object == null) continue;
                for (Object object2 : object) {
                    if (object2 == null) continue;
                    treeSet.add(((String)object2).toLowerCase());
                }
            }
        }
        if (!treeSet.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append(string);
            int n = 1;
            for (String string2 : treeSet) {
                if (n != 0) {
                    stringBuilder.append(" (");
                    n = 0;
                } else {
                    stringBuilder.append("; ");
                }
                stringBuilder.append("*.");
                stringBuilder.append(string2);
            }
            if (n == 0) {
                stringBuilder.append(')');
            }
            string = stringBuilder.toString();
        }
        return new FileNameExtensionFilter(string, treeSet.toArray(new String[treeSet.size()]));
    }

    public static String createFileSuffixNotSupportedMsg(String[] ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("Das durch die Dateiendung angegebene Format wird nicht unterst\u00fctzt.");
        String string = ImgUtil.createFileSuffixesText(stringArray);
        if (!string.isEmpty()) {
            stringBuilder.append("\nFolgende Dateiendungen sind m\u00f6glich:\n");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static IndexColorModel createIndexColorModel(Collection<Integer> collection) {
        int n = collection.size();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        boolean bl = false;
        int n2 = 0;
        for (Integer n3 : collection) {
            int n4;
            if (n2 >= n) break;
            int n5 = 0;
            if (n3 != null) {
                n5 = n3;
            }
            if ((n4 = n5 >> 24 & 0xFF) < 255) {
                bl = true;
            }
            byArray4[n2] = (byte)n4;
            byArray[n2] = (byte)(n5 >> 16 & 0xFF);
            byArray2[n2] = (byte)(n5 >> 8 & 0xFF);
            byArray3[n2] = (byte)(n5 & 0xFF);
            ++n2;
        }
        if (!bl) {
            byArray4 = null;
        }
        return ImgUtil.createIndexColorModel(n, byArray, byArray2, byArray3, byArray4);
    }

    public static IndexColorModel createIndexColorModel(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = 8;
        if (n <= 16) {
            n2 = n <= 2 ? 1 : (n <= 4 ? 2 : 4);
        }
        return byArray4 != null ? new IndexColorModel(n2, n, byArray, byArray2, byArray3, byArray4) : new IndexColorModel(n2, n, byArray, byArray2, byArray3);
    }

    public static BufferedImage createIndexedColorsImage(int n, int n2, Collection<Integer> collection) {
        IndexColorModel indexColorModel = ImgUtil.createIndexColorModel(collection);
        return new BufferedImage(n, n2, indexColorModel.getMapSize() > 16 ? 13 : 12, indexColorModel);
    }

    public static FileNameExtensionFilter createA5105ImageFileFilter() {
        return new FileNameExtensionFilter("A5105-Bilddateien", "scr");
    }

    public static FileNameExtensionFilter createKC852ImageFileFilter() {
        return new FileNameExtensionFilter("KC85/2,3-Bilddateien", "pic");
    }

    public static FileNameExtensionFilter createKC854HiresImageFileFilter() {
        return new FileNameExtensionFilter("KC85/4,5-HIRES-Bilddateien", "hip");
    }

    public static FileNameExtensionFilter createKC854LowresImageFileFilter() {
        return new FileNameExtensionFilter("KC85/4,5-LOWRES-Bilddateien", "pip");
    }

    public static FileNameExtensionFilter createLLC2HiresImageFileFilter() {
        return new FileNameExtensionFilter("LLC2-HIRES-Bilddateien", "pix");
    }

    public static void createKC854HiresMemBytes(BufferedImage bufferedImage, byte[] byArray, byte[] byArray2) {
        IndexColorModel indexColorModel = ImgUtil.getColorModelKC854Hires();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 8;
        for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 256; ++j) {
                int n5 = i * 8;
                int n6 = 0;
                int n7 = 0;
                int n8 = 128;
                for (int k = 0; k < n4; ++k) {
                    int n9;
                    Integer n10;
                    int n11 = 0;
                    if (n5 < n2 && j < n3) {
                        n11 = bufferedImage.getRGB(n5, j);
                    }
                    if ((n10 = (Integer)hashMap.get(n11)) == null) {
                        n10 = ImgUtil.getNearestIndex(indexColorModel, n11);
                        hashMap.put(n11, n10);
                    }
                    if (((n9 = n10.intValue()) & 1) != 0) {
                        n6 |= n8;
                    }
                    if ((n9 & 2) != 0) {
                        n7 |= n8;
                    }
                    n8 >>= 1;
                    ++n5;
                }
                if (n < byArray.length) {
                    byArray[n] = (byte)n6;
                }
                if (n < byArray2.length) {
                    byArray2[n] = (byte)n7;
                }
                ++n;
            }
        }
    }

    public static void createKC852MonochromeMemBytes(BufferedImage bufferedImage, byte[] byArray) {
        HashMap hashMap = new HashMap();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = 8;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 40; ++j) {
                int n4 = 0;
                n4 = j < 32 ? i << 7 & 0x180 | i << 3 & 0x60 | i << 5 & 0x1E00 | j & 0x1F : i << 7 & 0x180 | i << 3 & 0x660 | i >> 1 & 0x18 | j & 7 | 0x2000;
                int n5 = j * 8;
                int n6 = 0;
                int n7 = 128;
                for (int k = 0; k < n3; ++k) {
                    int n8 = 0;
                    if (n5 < n && i < n2) {
                        n8 = bufferedImage.getRGB(n5, i);
                    }
                    if ((GrayScaler.toGray(n8) & 0xFF) < 128) {
                        n6 |= n7;
                    }
                    n7 >>= 1;
                    ++n5;
                }
                if (n4 < byArray.length) {
                    byArray[n4] = (byte)n6;
                }
                ++n4;
            }
        }
    }

    public static void createKC854MonochromeMemBytes(BufferedImage bufferedImage, byte[] byArray) {
        HashMap hashMap = new HashMap();
        int n = 0;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 8;
        for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 256; ++j) {
                int n5 = i * 8;
                int n6 = 0;
                int n7 = 128;
                for (int k = 0; k < n4; ++k) {
                    int n8 = 0;
                    if (n5 < n2 && j < n3) {
                        n8 = bufferedImage.getRGB(n5, j);
                    }
                    if ((GrayScaler.toGray(n8) & 0xFF) < 128) {
                        n6 |= n7;
                    }
                    n7 >>= 1;
                    ++n5;
                }
                if (n < byArray.length) {
                    byArray[n] = (byte)n6;
                }
                ++n;
            }
        }
    }

    public static byte[] createLLC2HiresMemBytes(BufferedImage bufferedImage) {
        byte[] byArray = new byte[16384];
        int n = 0;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 8;
        int n5 = 8;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < 32; ++j) {
                int n6 = 0;
                int n7 = j * n4 + i;
                for (int k = 0; k < 64; ++k) {
                    int n8 = 0;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        n8 <<= 1;
                        int n9 = 0;
                        if (n6 < n2 && n7 < n3) {
                            n9 = bufferedImage.getRGB(n6++, n7);
                        }
                        if ((n9 >> 16 & 0xFF) + (n9 >> 8 & 0xFF) + (n9 & 0xFF) < 384) continue;
                        n8 |= 1;
                    }
                    byArray[n++] = (byte)n8;
                }
            }
        }
        return byArray;
    }

    public static void ensureImageLoaded(Component component, Image image) {
        if (image != null) {
            int n;
            boolean bl = false;
            Toolkit toolkit = component.getToolkit();
            if (toolkit != null && ((n = toolkit.checkImage(image, -1, -1, component)) & 0xF0) != 0) {
                bl = true;
            }
            if (!bl) {
                MediaTracker mediaTracker = new MediaTracker(component);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void fillBlack(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.black);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
    }

    public static synchronized IndexColorModel getColorModelA5105() {
        if (cmA5105 == null) {
            cmA5105 = VIS.createColorModel(1.0f);
        }
        return cmA5105;
    }

    public static synchronized IndexColorModel getColorModelBW() {
        if (cmBW == null) {
            cmBW = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
        }
        return cmBW;
    }

    public static synchronized IndexColorModel getColorModelSortedGray() {
        if (cmSortedGray == null) {
            byte[] byArray = new byte[256];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)i;
            }
            cmSortedGray = new IndexColorModel(8, 256, byArray, byArray, byArray);
        }
        return cmSortedGray;
    }

    public static synchronized IndexColorModel getColorModelKC854Hires() {
        if (cmKC854Hires == null) {
            cmKC854Hires = new IndexColorModel(8, 4, new byte[]{0, -1, 0, -1}, new byte[]{0, 0, -1, -1}, new byte[]{0, 0, -1, -1});
        }
        return cmKC854Hires;
    }

    public static IndexColorModel getIndexColorModel(BufferedImage bufferedImage) {
        ColorModel colorModel;
        IndexColorModel indexColorModel = null;
        if (bufferedImage != null && (colorModel = bufferedImage.getColorModel()) != null && colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
        }
        return indexColorModel;
    }

    public static int getNearestIndex(IndexColorModel indexColorModel, int n, int n2, int n3) {
        int n4 = -1;
        long l = 0L;
        int n5 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < n5; ++i) {
            long l2 = Math.abs((byArray[i] & 0xFF) - n);
            long l3 = Math.abs((byArray2[i] & 0xFF) - n2);
            long l4 = Math.abs((byArray3[i] & 0xFF) - n3);
            long l5 = l2 * l2 + l3 * l3 + l4 * l4;
            if (n4 >= 0 && l5 >= l) continue;
            n4 = i;
            l = l5;
        }
        return n4 >= 0 ? n4 : 0;
    }

    public static int getNearestIndex(IndexColorModel indexColorModel, int n) {
        return ImgUtil.getNearestIndex(indexColorModel, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static BufferedImage roundCorners(Window window, BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage != null && (n > 0 || n2 > 0)) {
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            if (n3 > 0 && n4 > 0) {
                int n5;
                IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
                if (indexColorModel != null && indexColorModel.getTransparentPixel() >= 0) {
                    n5 = bufferedImage.getType();
                    if (n5 != 12) {
                        n5 = 13;
                    }
                    bufferedImage2 = new BufferedImage(n3, n4, n5, indexColorModel);
                }
                if (bufferedImage2 == null) {
                    bufferedImage2 = new BufferedImage(n3, n4, 2);
                }
                if (ImgCopier.work(window, "Runde Ecken ab...", bufferedImage, bufferedImage2)) {
                    n5 = 2 * Math.max(n, n2);
                    if (n3 > n5 && n4 > n5) {
                        double d;
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        int n10 = n - 1;
                        for (n9 = 0; n9 < n; ++n9) {
                            n8 = n - 1 - n9;
                            for (n7 = 0; n7 < n; ++n7) {
                                n6 = n - 1 - n7;
                                d = Math.sqrt(n8 * n8 + n6 * n6);
                                if (Math.round(d) < (long)n10) continue;
                                bufferedImage2.setRGB(n9, n7, 0);
                                bufferedImage2.setRGB(n3 - n9 - 1, n7, 0);
                            }
                        }
                        n10 = n2 - 1;
                        for (n9 = 0; n9 < n2; ++n9) {
                            n8 = n2 - 1 - n9;
                            for (n7 = 0; n7 < n2; ++n7) {
                                n6 = n2 - 1 - n7;
                                d = Math.sqrt(n8 * n8 + n6 * n6);
                                if (Math.round(d) < (long)n10) continue;
                                bufferedImage2.setRGB(n9, n4 - n7 - 1, 0);
                                bufferedImage2.setRGB(n3 - n9 - 1, n4 - n7 - 1, 0);
                            }
                        }
                    }
                } else {
                    bufferedImage2 = null;
                }
            }
        }
        return bufferedImage2;
    }

    public static void throwNoColorTab() throws IOException {
        throw new IOException("Datei enth\u00e4lt keine Farbpalette.");
    }

    public static byte[] toPackBits(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length > 32 ? byArray.length : 32);
        ImgUtil.writePackBits(byteArrayOutputStream, byArray);
        byteArrayOutputStream.write(128);
        return byteArrayOutputStream.toByteArray();
    }

    public static void writePackBits(OutputStream outputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3;
            int n4;
            int n5 = n;
            for (n4 = n; n4 < byArray.length; ++n4) {
                for (n5 = n4 + 1; n5 < byArray.length && byArray[n4] == byArray[n5]; ++n5) {
                }
                if (n5 - n4 > 2) break;
            }
            if ((n3 = n5 - n4) < 2) {
                n5 = n4 = byArray.length;
            }
            if ((n2 = n4 - n) > 0) {
                if (n2 > 128) {
                    n2 = 128;
                    n5 = n4 = n + n2;
                    n3 = 0;
                }
                outputStream.write(n2 - 1);
                while (n < n4) {
                    outputStream.write(byArray[n++]);
                }
            }
            if (n3 <= 1) continue;
            if (n3 > 128) {
                n3 = 128;
                n5 = n4 + n3;
            }
            outputStream.write(257 - n3);
            outputStream.write(byArray[n4]);
            n = n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(byte[] byArray, File file) throws IOException {
        if (byArray == null) {
            throw new IOException("Das Bild kann nicht in dem Format exportiert werden.");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
    }

    public static String createFileSuffixesText(String[] ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray != null) {
            for (String[] stringArray2 : stringArray) {
                if (stringArray2 == null) continue;
                for (Object object : stringArray2) {
                    if (object == null) continue;
                    treeSet.add(((String)object).toLowerCase());
                }
            }
        }
        if (!treeSet.isEmpty()) {
            for (String string : treeSet) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append("*.");
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    private ImgUtil() {
    }
}

