/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.filechooser.FileNameExtensionFilter;
import jkcemu.base.EmuUtil;
import jkcemu.image.ImgUtil;

public class IFFFile {
    private static final String[] fileSuffixes = new String[]{"iff", "ilbm", "lbm"};
    private static FileNameExtensionFilter imageFileFilter = null;
    private static FileNameExtensionFilter paletteFileFilter = null;
    private BufferedImage image;
    private IndexColorModel icm;

    public static boolean accept(File file) {
        return EmuUtil.accept(file, fileSuffixes);
    }

    public static String[] getFileSuffixes() {
        return fileSuffixes;
    }

    public static FileNameExtensionFilter getImageFileFilter() {
        if (imageFileFilter == null) {
            imageFileFilter = ImgUtil.createFileFilter("IFF/ILBM-Datei", new String[][]{fileSuffixes});
        }
        return imageFileFilter;
    }

    public static FileNameExtensionFilter getPaletteFileFilter() {
        if (paletteFileFilter == null) {
            paletteFileFilter = ImgUtil.createFileFilter("IFF/ILBM-Farbpalettendatei", new String[][]{fileSuffixes});
        }
        return paletteFileFilter;
    }

    public static BufferedImage readImage(File file) throws IOException {
        BufferedImage bufferedImage = IFFFile.readFile((File)file, (boolean)false).image;
        if (bufferedImage == null) {
            throw new IOException("Die Datei enth\u00e4lt keine Bilddaten.");
        }
        return bufferedImage;
    }

    public static IndexColorModel readPalette(File file) throws IOException {
        IndexColorModel indexColorModel = IFFFile.readFile((File)file, (boolean)true).icm;
        if (indexColorModel == null) {
            throw new IOException("Die Datei enth\u00e4lt keine Farbpalette.");
        }
        return indexColorModel;
    }

    public static void writeImage(File file, BufferedImage bufferedImage) throws IOException {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 24;
        IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
        if (indexColorModel != null && (n = indexColorModel.getMapSize()) > 0) {
            int n5 = 1;
            for (int i = 2; i < n; i <<= 1) {
                ++n5;
            }
            n4 = n5;
        }
        if (n4 > 8) {
            indexColorModel = null;
        }
        n = 0;
        AtomicInteger atomicInteger = null;
        if (bufferedImage.getTransparency() != 1) {
            atomicInteger = new AtomicInteger(0);
        }
        ByteArrayOutputStream byteArrayOutputStream = IFFFile.createHeaderChunks(n2, n3, n4, 1, indexColorModel, atomicInteger);
        if (atomicInteger != null && atomicInteger.get() < 0) {
            n = atomicInteger.get();
        }
        if (bufferedImage.getTransparency() != 1 && n == 0) {
            throw new IOException("Das Bild enth\u00e4lt transparente Pixel,\ndie nicht im IFF/ILBM-Format gespeichert werden k\u00f6nnen.");
        }
        int n6 = (n2 + 7) / 8;
        if (n6 % 2 != 0) {
            ++n6;
        }
        byte[][] byArrayArray = new byte[n4][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = new byte[n6];
        }
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(32768);
        for (int i = 0; i < n3; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < byArrayArray.length; ++n8) {
                Arrays.fill(byArrayArray[n8], (byte)0);
            }
            n8 = 0;
            for (n7 = 0; n7 < n6; ++n7) {
                int n9 = 128;
                for (int j = 0; j < 8; ++j) {
                    int n10 = 0;
                    if (n8 < n2) {
                        n10 = bufferedImage.getRGB(n8, i);
                    }
                    n10 = indexColorModel != null ? (n > 0 && (n10 >> 24 & 0xFF) < 128 ? n : ImgUtil.getNearestIndex(indexColorModel, n10)) : n10 & 0xFF000000 | n10 >> 16 & 0xFF | n10 & 0xFF00 | n10 << 16 & 0xFF0000;
                    int n11 = 1;
                    for (int k = 0; k < n4; ++k) {
                        if ((n10 & n11) != 0) {
                            byte[] byArray = byArrayArray[k];
                            int n12 = n7;
                            byArray[n12] = (byte)(byArray[n12] | n9);
                        }
                        n11 <<= 1;
                    }
                    n9 >>= 1;
                    ++n8;
                }
            }
            for (n7 = 0; n7 < byArrayArray.length; ++n7) {
                ImgUtil.writePackBits(byteArrayOutputStream2, byArrayArray[n7]);
            }
        }
        IFFFile.writeFile(file, byteArrayOutputStream, byteArrayOutputStream2);
    }

    public static void writePalette(File file, IndexColorModel indexColorModel) throws IOException {
        IFFFile.writeFile(file, IFFFile.createHeaderChunks(0, 0, 0, 0, indexColorModel, null), null);
    }

    private static ByteArrayOutputStream createHeaderChunks(int n, int n2, int n3, int n4, IndexColorModel indexColorModel, AtomicInteger atomicInteger) throws IOException {
        int n5 = 0;
        int n6 = 0;
        if (indexColorModel != null) {
            n6 = indexColorModel.getMapSize();
            if (atomicInteger != null && n6 > 0 && (n5 = indexColorModel.getTransparentPixel()) < 1 && n6 < 256) {
                n5 = n6++;
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(37 + 3 * n6);
        EmuUtil.writeASCII(byteArrayOutputStream, "BMHD");
        EmuUtil.writeInt4BE(byteArrayOutputStream, 20L);
        EmuUtil.writeInt2BE(byteArrayOutputStream, n);
        EmuUtil.writeInt2BE(byteArrayOutputStream, n2);
        EmuUtil.writeInt4BE(byteArrayOutputStream, 0L);
        byteArrayOutputStream.write(n3);
        byteArrayOutputStream.write(n5 > 0 ? 2 : 0);
        byteArrayOutputStream.write(n4);
        byteArrayOutputStream.write(0);
        EmuUtil.writeInt2BE(byteArrayOutputStream, n5);
        byteArrayOutputStream.write(n > 0 ? 1 : 0);
        byteArrayOutputStream.write(n2 > 0 ? 1 : 0);
        EmuUtil.writeInt2BE(byteArrayOutputStream, n);
        EmuUtil.writeInt2BE(byteArrayOutputStream, n2);
        if (indexColorModel != null) {
            EmuUtil.writeASCII(byteArrayOutputStream, "CMAP");
            EmuUtil.writeInt4BE(byteArrayOutputStream, 3 * n6);
            for (int i = 0; i < n6; ++i) {
                int n7 = 0xFFFFFF;
                if (i < indexColorModel.getMapSize()) {
                    n7 = indexColorModel.getRGB(i);
                }
                byteArrayOutputStream.write(n7 >> 16);
                byteArrayOutputStream.write(n7 >> 8);
                byteArrayOutputStream.write(n7);
            }
            if (byteArrayOutputStream.size() % 2 != 0) {
                byteArrayOutputStream.write(0);
            }
        }
        if (atomicInteger != null) {
            atomicInteger.set(n5);
        }
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IFFFile readFile(File file, boolean bl) throws IOException {
        BufferedImage bufferedImage = null;
        IndexColorModel indexColorModel = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Object[] objectArray;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[12];
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n6 = -1;
            int n7 = -1;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (EmuUtil.read(bufferedInputStream, byArray) == byArray.length && EmuUtil.isTextAt("FORM", byArray, 0) && EmuUtil.isTextAt("ILBM", byArray, 8)) {
                objectArray = new byte[8];
                while (EmuUtil.read(bufferedInputStream, objectArray) == objectArray.length && (n5 = (int)EmuUtil.getInt4BE(objectArray, 4)) >= 0) {
                    if (EmuUtil.isTextAt("BMHD", objectArray, 0)) {
                        byte[] byArray4 = new byte[n5];
                        if (EmuUtil.read(bufferedInputStream, byArray4) != byArray4.length) break;
                        if (n6 < 0) {
                            n6 = EmuUtil.getInt2BE(byArray4, 0);
                            n7 = EmuUtil.getInt2BE(byArray4, 2);
                            n8 = byArray4[8] & 0xFF;
                            n10 = byArray4[9] & 0xFF;
                            n9 = byArray4[10] & 0xFF;
                            n11 = EmuUtil.getInt2BE(byArray4, 12);
                            n12 = (n6 + 7) / 8;
                            if (n12 % 2 != 0) {
                                ++n12;
                            }
                        }
                    } else if (EmuUtil.isTextAt("CMAP", objectArray, 0)) {
                        byArray2 = new byte[n5];
                        if (EmuUtil.read(bufferedInputStream, byArray2) != byArray2.length) {
                            break;
                        }
                    } else if (EmuUtil.isTextAt("BODY", objectArray, 0)) {
                        byArray3 = IFFFile.readIFFBody(bufferedInputStream, n5, n7 * n8 * n12, n9);
                    } else {
                        ((InputStream)bufferedInputStream).skip(n5);
                    }
                    if (n5 % 2 != 0) {
                        ((InputStream)bufferedInputStream).read();
                    }
                    if ((!bl || byArray2 == null) && (n6 < 0 || byArray3 == null || byArray2 == null && n8 <= 8)) continue;
                    break;
                }
            }
            objectArray = null;
            n5 = 5;
            if (n8 == 32) {
                n5 = 2;
            }
            if (byArray2 != null && (n4 = byArray2.length / 3) > 0) {
                n3 = 8;
                n5 = 13;
                if (n4 <= 16) {
                    n5 = 12;
                    n3 = n4 <= 2 ? 1 : (n4 <= 4 ? 2 : 4);
                }
                byte[] byArray5 = null;
                byte[] byArray6 = new byte[n4];
                byte[] byArray7 = new byte[n4];
                byte[] byArray8 = new byte[n4];
                objectArray = new int[n4];
                n2 = 0;
                for (n = 0; n2 + 2 < byArray2.length && n < n4; ++n) {
                    int n13 = byArray2[n2++] & 0xFF;
                    int n14 = byArray2[n2++] & 0xFF;
                    int n15 = byArray2[n2++] & 0xFF;
                    byArray6[n] = (byte)n13;
                    byArray7[n] = (byte)n14;
                    byArray8[n] = (byte)n15;
                    objectArray[n] = 0xFF000000 | n13 << 16 & 0xFF0000 | n14 << 8 & 0xFF00 | n15 & 0xFF;
                }
                if (n10 == 2 && n11 > 0 && n11 < n4) {
                    byArray5 = new byte[n4];
                    Arrays.fill(byArray5, (byte)-1);
                    byArray5[n11] = 0;
                    int n16 = n11;
                    objectArray[n16] = objectArray[n16] & 0xFFFFFF;
                }
                indexColorModel = ImgUtil.createIndexColorModel(n4, byArray6, byArray7, byArray8, byArray5);
            }
            if (n6 > 0 && n7 > 0 && n8 > 0 && n12 > 0 && byArray3 != null) {
                bufferedImage = indexColorModel != null ? new BufferedImage(n6, n7, n5, indexColorModel) : new BufferedImage(n6, n7, n5);
                int n17 = 1 << n8 - 1;
                for (n3 = 0; n3 < n7; ++n3) {
                    int n18 = n3 * n8 * n12;
                    if (n10 == 1) {
                        n18 += n3 * n12;
                    }
                    for (int i = 0; i < n6; ++i) {
                        int n19 = 128 >> i % 8;
                        int n20 = 0;
                        for (n2 = 0; n2 < n8; ++n2) {
                            n20 >>= 1;
                            n = n18 + n2 * n12 + i / 8;
                            if (n >= byArray3.length || (byArray3[n] & n19) == 0) continue;
                            n20 |= n17;
                        }
                        n2 = 0;
                        if (n10 == 1 && (n = n18 + n8 * n12 + i / 8) < byArray3.length && (byArray3[n] & n19) == 0) {
                            n2 = 1;
                        }
                        if (objectArray != null) {
                            bufferedImage.setRGB(i, n3, n20 < objectArray.length ? objectArray[n20] : 0xFFFFFF);
                            continue;
                        }
                        if (n8 == 24 || n8 == 32) {
                            if (n8 == 24) {
                                n20 |= 0xFF000000;
                            }
                            if (n2 != 0) {
                                n20 &= 0xFFFFFF;
                            }
                            bufferedImage.setRGB(i, n3, n20 & 0xFF000000 | n20 << 16 & 0xFF0000 | n20 & 0xFF00 | n20 >> 16 & 0xFF);
                            continue;
                        }
                        if (n8 > 8) {
                            n20 >>= n8 - 8;
                        } else if (n8 < 8) {
                            n20 <<= n8 - 8;
                        }
                        n20 = n2 != 0 ? (n20 &= 0xFFFFFF) : (n20 |= 0xFF000000);
                        bufferedImage.setRGB(i, n3, n20 & 0xFF000000 | n20 << 16 & 0xFF0000 | n20 << 8 & 0xFF00 | n20 & 0xFF);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedInputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedInputStream);
        return new IFFFile(bufferedImage, indexColorModel);
    }

    private static byte[] readIFFBody(InputStream inputStream, int n, int n2, int n3) throws IOException {
        byte[] byArray = null;
        if (n3 == 0) {
            byArray = new byte[n];
            EmuUtil.read(inputStream, byArray);
        } else if (n3 == 1) {
            byArray = new byte[n2];
            Arrays.fill(byArray, (byte)0);
            int n4 = 0;
            while (n > 0) {
                int n5;
                int n6;
                int n7;
                int n8 = inputStream.read();
                if (n8 < 0) continue;
                --n;
                if (n8 < 128) {
                    n7 = n8 + 1;
                    for (n6 = 0; n6 < n7 && n > 0 && (n5 = inputStream.read()) >= 0; ++n6) {
                        --n;
                        if (n4 >= byArray.length) continue;
                        byArray[n4++] = (byte)n5;
                    }
                    continue;
                }
                if (n8 <= 128 || n <= 0) continue;
                n7 = 257 - n8;
                n6 = inputStream.read();
                if (n6 < 0) continue;
                --n;
                for (n5 = 0; n5 < n7 && n4 < byArray.length; ++n5) {
                    byArray[n4++] = (byte)n6;
                }
            }
        } else {
            throw new IOException(String.format("Kompressionsmethode %d nicht unterst\u00fctzt", n3));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            int n = 4;
            if (byteArrayOutputStream != null) {
                n += byteArrayOutputStream.size();
            }
            if (byteArrayOutputStream2 != null) {
                n += 8 + byteArrayOutputStream2.size();
            }
            if (n % 2 != 0) {
                ++n;
            }
            fileOutputStream = new FileOutputStream(file);
            EmuUtil.writeASCII(fileOutputStream, "FORM");
            EmuUtil.writeInt4BE(fileOutputStream, n);
            EmuUtil.writeASCII(fileOutputStream, "ILBM");
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.writeTo(fileOutputStream);
            }
            if (byteArrayOutputStream2 != null) {
                EmuUtil.writeASCII(fileOutputStream, "BODY");
                EmuUtil.writeInt4BE(fileOutputStream, byteArrayOutputStream2.size());
                byteArrayOutputStream2.writeTo(fileOutputStream);
                if (byteArrayOutputStream2.size() % 2 != 0) {
                    byteArrayOutputStream2.write(0);
                }
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
    }

    private IFFFile(BufferedImage bufferedImage, IndexColorModel indexColorModel) {
        this.image = bufferedImage;
        this.icm = indexColorModel;
    }
}

