/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import jkcemu.Main;
import jkcemu.base.CancelableProgressDlg;
import jkcemu.image.ImgUtil;

public class Dithering
implements CancelableProgressDlg.Progressable,
Runnable {
    private BufferedImage srcImg;
    private BufferedImage retImg;
    private IndexColorModel icm;
    private Algorithm algorithm;
    private int wImg;
    private int hImg;
    private short[][] rDiffBuf;
    private short[][] gDiffBuf;
    private short[][] bDiffBuf;
    private volatile int progressValue;
    private CancelableProgressDlg dlg;

    public Dithering(BufferedImage bufferedImage, IndexColorModel indexColorModel, Algorithm algorithm) {
        this.srcImg = bufferedImage;
        this.icm = indexColorModel;
        this.algorithm = algorithm;
        this.wImg = bufferedImage.getWidth();
        this.hImg = bufferedImage.getHeight();
        this.progressValue = 0;
        this.dlg = null;
        this.rDiffBuf = null;
        this.gDiffBuf = null;
        this.bDiffBuf = null;
        this.retImg = null;
    }

    public BufferedImage doDithering() {
        int n;
        this.progressValue = 0;
        int n2 = 3;
        if (this.algorithm.equals((Object)Algorithm.FLOYD_STEINBERG)) {
            n2 = 2;
        }
        this.rDiffBuf = new short[n2][];
        this.gDiffBuf = new short[n2][];
        this.bDiffBuf = new short[n2][];
        for (n = 0; n < n2; ++n) {
            this.rDiffBuf[n] = new short[this.wImg];
            this.gDiffBuf[n] = new short[this.wImg];
            this.bDiffBuf[n] = new short[this.wImg];
            Arrays.fill(this.rDiffBuf[n], (short)0);
            Arrays.fill(this.gDiffBuf[n], (short)0);
            Arrays.fill(this.bDiffBuf[n], (short)0);
        }
        n = -1;
        int n3 = this.icm.getTransparentPixel();
        if (n3 >= 0) {
            n = this.icm.getRGB(n3);
        }
        BufferedImage bufferedImage = new BufferedImage(this.wImg, this.hImg, this.icm.getMapSize() > 16 ? 13 : 12, this.icm);
        for (int i = 0; i < this.hImg; ++i) {
            int n4;
            for (int j = 0; j < this.wImg && !this.dlg.wasCancelled(); ++j) {
                int n5 = this.srcImg.getRGB(j, i);
                if (n != -1 && (n5 >> 24 & 0xFF) < 128) {
                    bufferedImage.setRGB(j, i, n);
                } else {
                    int n6 = (n5 >> 16 & 0xFF) + this.rDiffBuf[0][j];
                    if (n6 < 0) {
                        n6 = 0;
                    } else if (n6 > 255) {
                        n6 = 255;
                    }
                    n4 = (n5 >> 8 & 0xFF) + this.gDiffBuf[0][j];
                    if (n4 < 0) {
                        n4 = 0;
                    } else if (n4 > 255) {
                        n4 = 255;
                    }
                    int n7 = (n5 & 0xFF) + this.bDiffBuf[0][j];
                    if (n7 < 0) {
                        n7 = 0;
                    } else if (n7 > 255) {
                        n7 = 255;
                    }
                    int n8 = this.icm.getRGB(ImgUtil.getNearestIndex(this.icm, n6, n4, n7));
                    bufferedImage.setRGB(j, i, n8);
                    int n9 = n6 - (n8 >> 16 & 0xFF);
                    int n10 = n4 - (n8 >> 8 & 0xFF);
                    int n11 = n7 - (n8 & 0xFF);
                    switch (this.algorithm) {
                        case FLOYD_STEINBERG: {
                            this.addDiff(0, j + 1, n9, n10, n11, 0.4375f);
                            this.addDiff(1, j - 1, n9, n10, n11, 0.1875f);
                            this.addDiff(1, j, n9, n10, n11, 0.3125f);
                            this.addDiff(1, j + 1, n9, n10, n11, 0.0625f);
                            break;
                        }
                        case SIERRA3: {
                            this.addDiff(0, j + 1, n9, n10, n11, 0.15625f);
                            this.addDiff(0, j + 2, n9, n10, n11, 0.09375f);
                            this.addDiff(1, j - 2, n9, n10, n11, 0.0625f);
                            this.addDiff(1, j - 1, n9, n10, n11, 0.125f);
                            this.addDiff(1, j, n9, n10, n11, 0.15625f);
                            this.addDiff(1, j + 1, n9, n10, n11, 0.125f);
                            this.addDiff(1, j + 2, n9, n10, n11, 0.0625f);
                            this.addDiff(2, j - 1, n9, n10, n11, 0.0625f);
                            this.addDiff(2, j, n9, n10, n11, 0.09375f);
                            this.addDiff(2, j + 1, n9, n10, n11, 0.0625f);
                            break;
                        }
                        case ATKINSON: {
                            this.addDiff(0, j + 1, n9, n10, n11, 0.125f);
                            this.addDiff(0, j + 2, n9, n10, n11, 0.125f);
                            this.addDiff(1, j - 1, n9, n10, n11, 0.125f);
                            this.addDiff(1, j, n9, n10, n11, 0.125f);
                            this.addDiff(1, j + 1, n9, n10, n11, 0.125f);
                            this.addDiff(2, j, n9, n10, n11, 0.125f);
                        }
                    }
                }
                ++this.progressValue;
            }
            short[] sArray = this.rDiffBuf[0];
            short[] sArray2 = this.gDiffBuf[0];
            short[] sArray3 = this.bDiffBuf[0];
            for (n4 = 1; n4 < n2; ++n4) {
                this.rDiffBuf[n4 - 1] = this.rDiffBuf[n4];
                this.gDiffBuf[n4 - 1] = this.gDiffBuf[n4];
                this.bDiffBuf[n4 - 1] = this.bDiffBuf[n4];
            }
            Arrays.fill(sArray, (short)0);
            Arrays.fill(sArray2, (short)0);
            Arrays.fill(sArray3, (short)0);
            this.rDiffBuf[n2 - 1] = sArray;
            this.gDiffBuf[n2 - 1] = sArray2;
            this.bDiffBuf[n2 - 1] = sArray3;
        }
        return this.dlg.wasCancelled() ? null : bufferedImage;
    }

    public static String getAlgorithmText(Algorithm algorithm) {
        String string = "";
        switch (algorithm) {
            case FLOYD_STEINBERG: {
                string = "Floyd-Steinberg (Standardverfahren)";
                break;
            }
            case SIERRA3: {
                string = "Sierra-3 (feinere Abstufungen)";
                break;
            }
            case ATKINSON: {
                string = "Atkinson (reduziertes Farbbluten)";
            }
        }
        return string;
    }

    public void setDialog(CancelableProgressDlg cancelableProgressDlg) {
        this.dlg = cancelableProgressDlg;
    }

    public static BufferedImage work(Window window, BufferedImage bufferedImage, IndexColorModel indexColorModel, Algorithm algorithm) {
        Dithering dithering = new Dithering(bufferedImage, indexColorModel, algorithm);
        dithering.dlg = new CancelableProgressDlg(window, "Dithering...", dithering);
        new Thread(Main.getThreadGroup(), dithering, "JKCEMU dithering").start();
        dithering.dlg.setVisible(true);
        return dithering.dlg.wasCancelled() ? null : dithering.retImg;
    }

    @Override
    public int getProgressMax() {
        return this.wImg * this.hImg;
    }

    @Override
    public int getProgressValue() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.retImg = this.doDithering();
        }
        finally {
            this.dlg.fireProgressFinished();
        }
    }

    private void addDiff(int n, int n2, int n3, int n4, int n5, float f) {
        if (n < this.rDiffBuf.length && n2 >= 0 && n2 < this.rDiffBuf[n].length) {
            short[] sArray = this.rDiffBuf[n];
            int n6 = n2;
            sArray[n6] = (short)(sArray[n6] + (short)Math.round((float)n3 * f));
        }
        if (n < this.gDiffBuf.length && n2 >= 0 && n2 < this.gDiffBuf[n].length) {
            short[] sArray = this.gDiffBuf[n];
            int n7 = n2;
            sArray[n7] = (short)(sArray[n7] + (short)Math.round((float)n4 * f));
        }
        if (n < this.bDiffBuf.length && n2 >= 0 && n2 < this.bDiffBuf[n].length) {
            short[] sArray = this.bDiffBuf[n];
            int n8 = n2;
            sArray[n8] = (short)(sArray[n8] + (short)Math.round((float)n5 * f));
        }
    }

    public static enum Algorithm {
        FLOYD_STEINBERG,
        SIERRA3,
        ATKINSON;

    }
}

