/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import jkcemu.Main;
import jkcemu.base.CancelableProgressDlg;
import jkcemu.image.Dithering;
import jkcemu.image.ImgUtil;
import jkcemu.image.OcTree;

public class ColorReducer
implements CancelableProgressDlg.Progressable,
Runnable {
    private Window owner;
    private BufferedImage srcImg;
    private BufferedImage retImg;
    private Color colorForTransp;
    private Dithering.Algorithm dithAlgorithm;
    private int maxColors;
    private int wImg;
    private int hImg;
    private volatile int progressValue;
    private Dithering dithering;
    private CancelableProgressDlg dlg;

    public static BufferedImage work(Window window, String string, BufferedImage bufferedImage, int n, Color color, Dithering.Algorithm algorithm) {
        ColorReducer colorReducer = new ColorReducer(window, bufferedImage, n, color, algorithm);
        colorReducer.dlg = new CancelableProgressDlg(window, string, colorReducer);
        new Thread(Main.getThreadGroup(), colorReducer, "JKCEMU color reducer").start();
        colorReducer.dlg.setVisible(true);
        return colorReducer.dlg.wasCancelled() ? null : colorReducer.retImg;
    }

    @Override
    public int getProgressMax() {
        return 2 * this.wImg * this.hImg;
    }

    @Override
    public int getProgressValue() {
        Dithering dithering = this.dithering;
        return dithering != null ? this.progressValue + dithering.getProgressValue() : this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.wImg > 0 && this.hImg > 0) {
                int n;
                Object object;
                Object object2 = this.srcImg;
                if (((BufferedImage)object2).getTransparency() != 1 && this.colorForTransp != null) {
                    object = new BufferedImage(this.wImg, this.hImg, 5);
                    Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                    graphics2D.setColor(this.colorForTransp);
                    graphics2D.fillRect(0, 0, this.wImg, this.hImg);
                    graphics2D.drawImage((Image)object2, 0, 0, this.owner);
                    graphics2D.dispose();
                    object2 = object;
                }
                this.progressValue = 0;
                object = new OcTree();
                boolean bl = false;
                for (int i = 0; i < this.hImg; ++i) {
                    for (n = 0; n < this.wImg && !this.dlg.wasCancelled(); ++n) {
                        int n2 = ((BufferedImage)object2).getRGB(n, i);
                        if ((n2 >> 24 & 0xFF) < 128) {
                            bl = true;
                        } else {
                            ((OcTree)object).putPixel(n2);
                        }
                        ++this.progressValue;
                    }
                }
                int[] nArray = ((OcTree)object).reduceColors(bl ? this.maxColors - 1 : this.maxColors);
                if (nArray != null) {
                    n = nArray.length;
                    if (bl) {
                        ++n;
                    }
                    byte[] byArray = null;
                    byte[] byArray2 = new byte[n];
                    byte[] byArray3 = new byte[n];
                    byte[] byArray4 = new byte[n];
                    if (bl) {
                        byArray = new byte[n];
                        Arrays.fill(byArray, (byte)-1);
                        byArray[nArray.length] = 0;
                        byArray2[nArray.length] = -1;
                        byArray3[nArray.length] = -1;
                        byArray4[nArray.length] = -1;
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        byArray2[i] = (byte)(nArray[i] >> 16 & 0xFF);
                        byArray3[i] = (byte)(nArray[i] >> 8 & 0xFF);
                        byArray4[i] = (byte)(nArray[i] & 0xFF);
                    }
                    IndexColorModel indexColorModel = ImgUtil.createIndexColorModel(n, byArray2, byArray3, byArray4, byArray);
                    if (this.dithAlgorithm != null) {
                        this.dithering = new Dithering((BufferedImage)object2, indexColorModel, this.dithAlgorithm);
                        this.dithering.setDialog(this.dlg);
                        this.retImg = this.dithering.doDithering();
                    } else {
                        BufferedImage bufferedImage = new BufferedImage(this.wImg, this.hImg, n > 16 ? 13 : 12, indexColorModel);
                        for (int i = 0; i < this.hImg; ++i) {
                            for (int j = 0; j < this.wImg && !this.dlg.wasCancelled(); ++j) {
                                int n3 = ((BufferedImage)object2).getRGB(j, i);
                                if ((n3 >> 24 & 0xFF) < 128) {
                                    bufferedImage.setRGB(j, i, 0xFFFFFF);
                                } else {
                                    bufferedImage.setRGB(j, i, n3);
                                }
                                ++this.progressValue;
                            }
                        }
                        this.retImg = bufferedImage;
                    }
                }
            }
        }
        finally {
            this.dlg.fireProgressFinished();
        }
    }

    private ColorReducer(Window window, BufferedImage bufferedImage, int n, Color color, Dithering.Algorithm algorithm) {
        this.owner = window;
        this.srcImg = bufferedImage;
        this.maxColors = n;
        this.colorForTransp = color;
        this.dithAlgorithm = algorithm;
        this.wImg = bufferedImage.getWidth();
        this.hImg = bufferedImage.getHeight();
        this.progressValue = 0;
        this.dithering = null;
        this.dlg = null;
        this.retImg = null;
    }
}

