/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import jkcemu.Main;
import jkcemu.base.CancelableProgressDlg;
import jkcemu.image.ImgUtil;

public class ColorInverter
implements CancelableProgressDlg.Progressable,
Runnable {
    private Window owner;
    private BufferedImage srcImg;
    private BufferedImage retImg;
    private int wImg;
    private int hImg;
    private volatile int progressValue;
    private CancelableProgressDlg dlg;

    public static BufferedImage work(Window window, BufferedImage bufferedImage) {
        int n;
        BufferedImage bufferedImage2 = null;
        IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
        if (indexColorModel != null && (n = indexColorModel.getMapSize()) > 0) {
            boolean bl = false;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            byte[] byArray4 = new byte[n];
            for (int i = 0; i < n; ++i) {
                int n2 = indexColorModel.getRGB(i);
                int n3 = n2 >> 24 & 0xFF;
                if (n3 < 255) {
                    bl = true;
                }
                byArray[i] = (byte)n3;
                byArray2[i] = (byte)(255 - (n2 >> 16 & 0xFF));
                byArray3[i] = (byte)(255 - (n2 >> 8 & 0xFF));
                byArray4[i] = (byte)(255 - (n2 & 0xFF));
            }
            if (!bl) {
                byArray = null;
            }
            bufferedImage2 = new BufferedImage(ImgUtil.createIndexColorModel(n, byArray2, byArray3, byArray4, byArray), bufferedImage.getRaster(), false, new Hashtable());
        }
        if (bufferedImage2 == null) {
            ColorInverter colorInverter = new ColorInverter(window, bufferedImage);
            colorInverter.dlg = new CancelableProgressDlg(window, "Invertiere...", colorInverter);
            new Thread(Main.getThreadGroup(), colorInverter, "JKCEMU color inverter").start();
            colorInverter.dlg.setVisible(true);
            if (!colorInverter.dlg.wasCancelled()) {
                bufferedImage2 = colorInverter.retImg;
            }
        }
        return bufferedImage2;
    }

    @Override
    public int getProgressMax() {
        return this.wImg * this.hImg;
    }

    @Override
    public int getProgressValue() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.wImg > 0 && this.hImg > 0) {
                BufferedImage bufferedImage = new BufferedImage(this.wImg, this.hImg, this.srcImg.getTransparency() == 1 ? 5 : 2);
                block3: for (int i = 0; i < this.hImg; ++i) {
                    for (int j = 0; j < this.wImg; ++j) {
                        int n = this.srcImg.getRGB(j, i);
                        byte by = (byte)(255 - (n >> 16 & 0xFF));
                        byte by2 = (byte)(255 - (n >> 8 & 0xFF));
                        byte by3 = (byte)(255 - (n & 0xFF));
                        bufferedImage.setRGB(j, i, n & 0xFF000000 | by << 16 & 0xFF0000 | by2 << 8 & 0xFF00 | by3 & 0xFF);
                        ++this.progressValue;
                        if (this.dlg.wasCancelled()) continue block3;
                    }
                }
                this.retImg = bufferedImage;
            }
        }
        finally {
            this.dlg.fireProgressFinished();
        }
    }

    private ColorInverter(Window window, BufferedImage bufferedImage) {
        this.owner = window;
        this.srcImg = bufferedImage;
        this.wImg = bufferedImage.getWidth();
        this.hImg = bufferedImage.getHeight();
        this.progressValue = 0;
        this.dlg = null;
        this.retImg = null;
    }
}

