/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import jkcemu.image.ImgUtil;
import jkcemu.image.LZWEncoder;

public class AnimatedGIFWriter
implements ImageObserver {
    private static final int[] color6Map = new int[]{0, 51, 102, 153, 204, 255};
    private OutputStream out;
    private boolean infinite;
    private boolean firstFrame;
    private boolean forceColorReduction;
    private boolean smoothColorReduction;
    private int curTransparencyIdx;
    private int curColorDepth;
    private int curColorTabSize;
    private byte[] curColorTab;
    private byte[] curPixels;
    private int width;
    private int height;
    private int globalColorDepth;
    private int globalColorTabSize;
    private byte[] globalColorTab;
    private IndexColorModel indexColorModel255;
    private FrameData prevFrame;

    public AnimatedGIFWriter(OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        this.out = outputStream;
        this.infinite = bl2;
        this.smoothColorReduction = bl;
        this.forceColorReduction = false;
        this.firstFrame = true;
        this.curTransparencyIdx = -1;
        this.curColorDepth = 0;
        this.curColorTabSize = 0;
        this.curColorTab = null;
        this.curPixels = null;
        this.width = 0;
        this.height = 0;
        this.globalColorDepth = 0;
        this.globalColorTabSize = 0;
        this.globalColorTab = null;
        this.indexColorModel255 = null;
        this.prevFrame = null;
        this.writeASCII("GIF89a");
    }

    public void addFrame(int n, BufferedImage bufferedImage) throws IOException {
        boolean bl = false;
        if (this.out != null) {
            FrameData frameData;
            if (this.prevFrame != null) {
                this.prevFrame.delayMillis += n;
            }
            if ((frameData = this.createFrameData(bufferedImage)) != null) {
                if (this.prevFrame != null) {
                    if (frameData.colorDepth != this.prevFrame.colorDepth || frameData.colorTabSize != this.prevFrame.colorTabSize || !Arrays.equals(frameData.colorTab, this.prevFrame.colorTab) || !Arrays.equals(frameData.pixels, this.prevFrame.pixels)) {
                        this.writeFrame(this.prevFrame);
                        this.prevFrame = frameData;
                    }
                } else {
                    this.width = bufferedImage.getWidth();
                    this.height = bufferedImage.getHeight();
                    this.globalColorDepth = frameData.colorDepth;
                    this.globalColorTabSize = frameData.colorTabSize;
                    this.globalColorTab = frameData.colorTab;
                    this.prevFrame = frameData;
                }
            }
        }
        bufferedImage.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish() throws IOException {
        boolean bl = false;
        if (this.out != null) {
            try {
                if (this.prevFrame != null) {
                    this.writeFrame(this.prevFrame);
                    this.prevFrame = null;
                    this.out.write(59);
                    this.out.flush();
                    bl = true;
                }
            }
            finally {
                this.out = null;
            }
        }
        return bl;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xE0) == 0;
    }

    private FrameData createFrameData(BufferedImage bufferedImage) {
        FrameData frameData = null;
        this.curColorDepth = 0;
        this.curColorTabSize = 0;
        this.curColorTab = null;
        this.curPixels = null;
        if (bufferedImage != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (n > 0 && n2 > 0) {
                Object object;
                if (this.width < 1 || this.height < 1) {
                    this.width = n;
                    this.height = n2;
                }
                if (n == this.width && n2 == this.height) {
                    this.extractCompatibleImageData(bufferedImage);
                }
                if (!(this.curColorDepth >= 1 && this.curColorTabSize >= 1 && this.curColorTab != null && this.curPixels != null || this.forceColorReduction && this.smoothColorReduction)) {
                    int n3 = 0;
                    object = new int[256];
                    byte[] byArray = new byte[256];
                    byte[] byArray2 = new byte[768];
                    byte[] byArray3 = new byte[this.width * this.height];
                    do {
                        int n4 = 0;
                        int n5 = 0;
                        block1: for (int i = 0; n4 >= 0 && i < this.height; ++i) {
                            for (int j = 0; j < this.width; ++j) {
                                int n6;
                                int n7;
                                int n8;
                                int n9 = -16777216;
                                if (j < n && i < n2) {
                                    n9 = bufferedImage.getRGB(j, i);
                                    if (this.forceColorReduction) {
                                        n8 = (n9 >> 16 & 0xFF) / 43;
                                        n7 = (n9 >> 8 & 0xFF) / 43;
                                        n6 = (n9 & 0xFF) / 43;
                                        n9 = 0xFF000000 | color6Map[n8] << 16 | color6Map[n7] << 8 | color6Map[n6];
                                    }
                                }
                                n8 = 0;
                                n7 = 0;
                                if (n4 > 0) {
                                    n7 = Arrays.binarySearch((int[])object, 0, n4, n9);
                                    if (n7 >= 0) {
                                        n8 = 1;
                                    } else {
                                        if (n4 >= 256) {
                                            n4 = -1;
                                            continue block1;
                                        }
                                        n7 = -n7 - 1;
                                        for (n6 = n4 - 2; n6 >= n7; --n6) {
                                            object[n6 + 1] = object[n6];
                                            byArray[n6 + 1] = byArray[n6];
                                        }
                                    }
                                }
                                if (n8 == 0) {
                                    object[n7] = n9;
                                    byArray[n7] = (byte)(n3 / 3);
                                    byArray2[n3++] = (byte)(n9 >> 16 & 0xFF);
                                    byArray2[n3++] = (byte)(n9 >> 8 & 0xFF);
                                    byArray2[n3++] = (byte)(n9 & 0xFF);
                                    ++n4;
                                }
                                if (n4 <= 0) continue;
                                byArray3[n5++] = byArray[n7];
                            }
                        }
                        if (n4 > 0) {
                            if (n4 < 256) {
                                Arrays.fill(byArray2, 3 * n4, byArray2.length, (byte)0);
                            }
                            this.curColorDepth = 8;
                            this.curColorTabSize = byArray2.length;
                            this.curColorTab = byArray2;
                            this.curPixels = byArray3;
                            break;
                        }
                        if (this.smoothColorReduction || this.forceColorReduction) break;
                        this.forceColorReduction = true;
                    } while (!this.forceColorReduction);
                }
                if ((this.curColorDepth < 1 || this.curColorTabSize < 1 || this.curColorTab == null || this.curPixels == null) && this.smoothColorReduction) {
                    BufferedImage bufferedImage2 = new BufferedImage(this.width, this.height, 13, this.getIndexColorModel255());
                    object = bufferedImage2.createGraphics();
                    if (n < this.width || n2 < this.height) {
                        ((Graphics)object).setColor(Color.black);
                        ((Graphics)object).fillRect(0, 0, this.width, this.height);
                    }
                    ((Graphics)object).drawImage(bufferedImage, 0, 0, this);
                    ((Graphics)object).dispose();
                    this.extractCompatibleImageData(bufferedImage2);
                }
                if (this.curColorDepth > 0 && this.curColorTabSize > 0 && this.curColorTab != null && this.curPixels != null) {
                    frameData = new FrameData(this.curColorDepth, this.curColorTabSize, this.curColorTab, this.curPixels);
                }
            }
        }
        return frameData;
    }

    private void extractCompatibleImageData(BufferedImage bufferedImage) {
        byte[] byArray;
        DataBuffer dataBuffer;
        WritableRaster writableRaster;
        int n;
        IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
        if (indexColorModel != null && (n = indexColorModel.getMapSize()) > 0 && n <= 255 && (writableRaster = bufferedImage.getRaster()) != null && (dataBuffer = writableRaster.getDataBuffer()) != null && dataBuffer instanceof DataBufferByte && (byArray = ((DataBufferByte)dataBuffer).getData()) != null && byArray.length == this.width * this.height) {
            this.curTransparencyIdx = n;
            this.curPixels = byArray;
            this.curColorDepth = 8;
            this.curColorTabSize = 768;
            this.curColorTab = new byte[3 * n];
            int n2 = 0;
            for (int i = 0; i < n && n2 < this.curColorTab.length; ++i) {
                this.curColorTab[n2++] = (byte)indexColorModel.getRed(i);
                this.curColorTab[n2++] = (byte)indexColorModel.getGreen(i);
                this.curColorTab[n2++] = (byte)indexColorModel.getBlue(i);
            }
        }
    }

    private IndexColorModel getIndexColorModel255() {
        if (this.indexColorModel255 == null) {
            int n;
            int n2;
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            int n3 = 0;
            for (n2 = 0; n2 < 6; ++n2) {
                for (n = 0; n < 6; ++n) {
                    for (int i = 0; i < 6; ++i) {
                        byArray[n3] = (byte)color6Map[n2];
                        byArray2[n3] = (byte)color6Map[n];
                        byArray3[n3] = (byte)color6Map[i];
                        ++n3;
                    }
                }
            }
            n = n2 = 256 / (254 - n3);
            while (n3 < 254) {
                byArray[n3] = (byte)n;
                byArray2[n3] = (byte)n;
                byArray3[n3] = (byte)n;
                n += n2;
                ++n3;
            }
            this.indexColorModel255 = new IndexColorModel(8, 255, byArray, byArray2, byArray3, 255);
        }
        return this.indexColorModel255;
    }

    private void writeASCII(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)string.charAt(i));
        }
    }

    private void writeColorTab(int n, byte[] byArray) throws IOException {
        this.out.write(byArray);
        for (int i = byArray.length; i < n; ++i) {
            this.out.write(0);
        }
    }

    private void writeFrame(FrameData frameData) throws IOException {
        if (this.firstFrame) {
            this.writeWord(this.width);
            this.writeWord(this.height);
            this.out.write(0xF0 | this.globalColorDepth - 1);
            this.out.write(0);
            this.out.write(0);
            this.writeColorTab(this.globalColorTabSize, this.globalColorTab);
            this.out.write(33);
            this.out.write(254);
            this.out.write("Created by JKCEMU".length());
            this.writeASCII("Created by JKCEMU");
            this.out.write(0);
            if (this.infinite) {
                this.out.write(33);
                this.out.write(255);
                this.out.write(11);
                this.writeASCII("NETSCAPE2.0");
                this.out.write(3);
                this.out.write(1);
                this.writeWord(0);
                this.out.write(0);
            }
        }
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        this.out.write(0);
        this.writeWord(Math.round((float)frameData.delayMillis / 10.0f));
        this.out.write(0);
        this.out.write(0);
        this.out.write(44);
        this.writeWord(0);
        this.writeWord(0);
        this.writeWord(this.width);
        this.writeWord(this.height);
        if (Arrays.equals(frameData.colorTab, this.globalColorTab)) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | frameData.colorDepth - 1);
            this.writeColorTab(frameData.colorTabSize, frameData.colorTab);
        }
        new LZWEncoder(frameData.pixels, Math.max(frameData.colorDepth, 2)).encode(this.out);
        this.firstFrame = false;
    }

    private void writeWord(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    public static class FrameData {
        public int delayMillis = 0;
        public int colorDepth;
        public int colorTabSize;
        public byte[] colorTab;
        public byte[] pixels;

        public FrameData(int n, int n2, byte[] byArray, byte[] byArray2) {
            this.colorDepth = n;
            this.colorTabSize = n2;
            this.colorTab = byArray;
            this.pixels = byArray2;
        }
    }
}

