/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jkcemu.base.AbstractThreadDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileProgressInputStream;
import jkcemu.filebrowser.FileBrowserFrm;

public class ZipUnpacker
extends AbstractThreadDlg {
    private File srcFile;
    private File outDir;

    public static void unpackFile(Window window, File file, File file2) {
        ZipUnpacker zipUnpacker = new ZipUnpacker(window, file, file2);
        zipUnpacker.setTitle("ZIP-Datei entpacken");
        zipUnpacker.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProgress() {
        boolean bl;
        block34: {
            FileProgressInputStream fileProgressInputStream;
            block32: {
                bl = this.outDir.exists();
                this.outDir.mkdirs();
                fileProgressInputStream = null;
                ZipInputStream zipInputStream = null;
                try {
                    fileProgressInputStream = this.openInputFile(this.srcFile, 1);
                    zipInputStream = new ZipInputStream(new BufferedInputStream(fileProgressInputStream));
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (!this.cancelled && zipEntry != null) {
                        String string = zipEntry.getName();
                        if (string != null) {
                            File file = null;
                            int n = string.length();
                            int n2 = 0;
                            while (n2 < n) {
                                String string2 = null;
                                int n3 = string.indexOf(47, n2);
                                int n4 = string.indexOf(92, n2);
                                if (n3 < 0 || n4 >= 0 && n4 < n3) {
                                    n3 = n4;
                                }
                                if (n3 >= n2) {
                                    string2 = string.substring(n2, n3);
                                    n2 = n3 + 1;
                                } else {
                                    string2 = string.substring(n2);
                                    n2 = n;
                                }
                                if (string2 == null || string2.isEmpty()) continue;
                                if (file != null) {
                                    file = new File(file, string2);
                                    continue;
                                }
                                file = new File(this.outDir, string2);
                            }
                            if (file != null) {
                                this.appendToLog(file.getPath() + "\n");
                                long l = zipEntry.getTime();
                                if (zipEntry.isDirectory() || string.endsWith("/") || string.endsWith("\\")) {
                                    file.mkdirs();
                                    if (!file.exists()) {
                                        throw new IOException("Verzeichnis kann nicht angelegt werden");
                                    }
                                } else {
                                    File file2 = file.getParentFile();
                                    if (file2 != null) {
                                        file2.mkdirs();
                                    }
                                    boolean bl2 = false;
                                    BufferedOutputStream bufferedOutputStream = null;
                                    try {
                                        long l2 = zipEntry.getCrc();
                                        CRC32 cRC32 = null;
                                        if (l2 >= 0L) {
                                            cRC32 = new CRC32();
                                        }
                                        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                                        int n5 = zipInputStream.read();
                                        while (!this.cancelled && n5 != -1) {
                                            if (cRC32 != null) {
                                                cRC32.update(n5);
                                            }
                                            ((OutputStream)bufferedOutputStream).write(n5);
                                            n5 = zipInputStream.read();
                                        }
                                        ((OutputStream)bufferedOutputStream).close();
                                        bufferedOutputStream = null;
                                        if (cRC32 != null && cRC32.getValue() != l2) {
                                            this.appendErrorToLog("CRC32-Pr\u00fcfsumme differiert");
                                            this.incErrorCount();
                                        }
                                        EmuUtil.closeSilent(bufferedOutputStream);
                                    }
                                    catch (IOException iOException) {
                                        this.appendErrorToLog(iOException);
                                        this.incErrorCount();
                                        bl2 = true;
                                    }
                                    finally {
                                        EmuUtil.closeSilent(bufferedOutputStream);
                                    }
                                    if (bl2) {
                                        file.delete();
                                    } else if (l > 0L) {
                                        file.setLastModified(l);
                                    }
                                }
                            }
                        }
                        zipInputStream.closeEntry();
                        zipEntry = zipInputStream.getNextEntry();
                    }
                    if (zipInputStream == null) break block32;
                }
                catch (Exception exception) {
                    block33: {
                        try {
                            StringBuilder stringBuilder = new StringBuilder(256);
                            stringBuilder.append("\nFehler beim Lesen der Datei ");
                            stringBuilder.append(this.srcFile.getPath());
                            String string = exception.getMessage();
                            if (string != null && !string.isEmpty()) {
                                stringBuilder.append(":\n");
                                stringBuilder.append(string);
                            }
                            stringBuilder.append('\n');
                            this.appendToLog(stringBuilder.toString());
                            this.incErrorCount();
                            if (zipInputStream == null) break block33;
                        }
                        catch (Throwable throwable) {
                            if (zipInputStream != null) {
                                EmuUtil.closeSilent(zipInputStream);
                            } else {
                                EmuUtil.closeSilent(fileProgressInputStream);
                            }
                            throw throwable;
                        }
                        EmuUtil.closeSilent(zipInputStream);
                    }
                    EmuUtil.closeSilent(fileProgressInputStream);
                }
                EmuUtil.closeSilent(zipInputStream);
                break block34;
            }
            EmuUtil.closeSilent(fileProgressInputStream);
        }
        FileBrowserFrm.fireFileChanged(bl ? this.outDir : this.outDir.getParentFile());
    }

    private ZipUnpacker(Window window, File file, File file2) {
        super(window, "JKCEMU zip unpacker", true);
        this.srcFile = file;
        this.outDir = file2;
    }
}

