/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import jkcemu.base.AbstractThreadDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileProgressInputStream;
import jkcemu.filebrowser.FileBrowserFrm;

public class TarPacker
extends AbstractThreadDlg
implements FileVisitor<Path> {
    private Collection<Path> srcPaths;
    private Path curRootPath;
    private File outFile;
    private OutputStream out;
    private boolean compression;
    private boolean ownerEnabled;
    private boolean posixEnabled;

    public static void packFiles(Window window, Collection<Path> collection, File file, boolean bl) {
        TarPacker tarPacker = new TarPacker(window, collection, file, bl);
        if (bl) {
            tarPacker.setTitle("TGZ-Datei packen");
        } else {
            tarPacker.setTitle("TAR-Datei packen");
        }
        tarPacker.setVisible(true);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        String string;
        FileVisitResult fileVisitResult = FileVisitResult.SKIP_SUBTREE;
        if (this.out == null || this.cancelled) {
            fileVisitResult = FileVisitResult.TERMINATE;
        } else if (path != null && basicFileAttributes != null && basicFileAttributes.isDirectory() && !(string = this.getEntryDir(path)).isEmpty()) {
            this.appendToLog(path.toString() + "\n");
            try {
                this.writeTarHeader(path, string, '5', null, 0L, basicFileAttributes, true);
                fileVisitResult = FileVisitResult.CONTINUE;
            }
            catch (IOException iOException) {
                this.appendErrorToLog(iOException);
            }
        }
        return fileVisitResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult;
        block18: {
            block16: {
                String string;
                String string2;
                block19: {
                    FileProgressInputStream fileProgressInputStream;
                    block15: {
                        block17: {
                            fileVisitResult = FileVisitResult.SKIP_SIBLINGS;
                            if (this.out != null && !this.cancelled) break block17;
                            fileVisitResult = FileVisitResult.TERMINATE;
                            break block18;
                        }
                        if (path == null || basicFileAttributes == null) break block18;
                        Path path2 = path.getFileName();
                        if (path2 == null || (string2 = path2.toString()) == null || string2.isEmpty()) break block16;
                        this.appendToLog(path.toString() + "\n");
                        string = this.getEntryDir(path.getParent());
                        if (!basicFileAttributes.isRegularFile()) break block19;
                        fileProgressInputStream = null;
                        try {
                            long l;
                            fileProgressInputStream = this.openInputFile(path.toFile(), 2);
                            long l2 = fileProgressInputStream.length();
                            this.writeTarHeader(path, string + string2, '0', null, l2, basicFileAttributes, false);
                            if (l2 <= 0L) break block15;
                            int n = fileProgressInputStream.read();
                            for (l = 0L; !this.cancelled && l < l2 && n != -1; ++l) {
                                this.out.write(n);
                                n = fileProgressInputStream.read();
                            }
                            long l3 = l2 / 512L;
                            long l4 = l3 * 512L;
                            if (l4 < l2) {
                                l4 += 512L;
                            }
                            while (!this.cancelled && l < l4) {
                                this.out.write(0);
                                ++l;
                            }
                        }
                        catch (IOException iOException) {
                            this.appendErrorToLog(iOException);
                            this.incErrorCount();
                            EmuUtil.closeSilent(fileProgressInputStream);
                            break block16;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            this.appendIgnoredToLog();
                            {
                                catch (Throwable throwable) {
                                    EmuUtil.closeSilent(fileProgressInputStream);
                                    throw throwable;
                                }
                            }
                            EmuUtil.closeSilent(fileProgressInputStream);
                            break block16;
                        }
                    }
                    EmuUtil.closeSilent(fileProgressInputStream);
                    break block16;
                }
                if (basicFileAttributes.isSymbolicLink()) {
                    try {
                        Path path3 = Files.readSymbolicLink(path);
                        if (path3 != null) {
                            this.writeTarHeader(path, string + string2, '2', path3.toString(), 0L, basicFileAttributes, true);
                        }
                    }
                    catch (Exception exception) {
                        StringBuilder stringBuilder = new StringBuilder(256);
                        stringBuilder.append(" Lesen des symbolischen Links nicht m\u00f6glich\n");
                        String string3 = exception.getMessage();
                        if (string3 != null && (string3 = string3.trim()).isEmpty()) {
                            stringBuilder.append(":\n");
                            stringBuilder.append(string3);
                        }
                        stringBuilder.append('\n');
                        this.appendToLog(stringBuilder.toString());
                        this.disableAutoClose();
                    }
                } else {
                    this.appendIgnoredToLog();
                }
            }
            fileVisitResult = FileVisitResult.CONTINUE;
        }
        return fileVisitResult;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) {
        if (path != null) {
            this.appendToLog(path.toString());
            this.appendErrorToLog(iOException);
            this.incErrorCount();
        }
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProgress() {
        boolean bl = false;
        Object var2_2 = null;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(this.outFile));
            if (this.compression) {
                this.out = new GZIPOutputStream(this.out);
            }
            FileBrowserFrm.fireFileChanged(this.outFile.getParentFile());
            for (Path path : this.srcPaths) {
                this.curRootPath = path.getParent();
                Files.walkFileTree(path, this);
            }
            for (int i = 0; i < 1024; ++i) {
                this.out.write(0);
            }
            if (this.out instanceof GZIPOutputStream) {
                ((GZIPOutputStream)this.out).finish();
            }
            this.out.close();
            this.out = null;
            this.appendToLog("\nFertig\n");
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("\nFehler beim Schreiben in Datei ");
            stringBuilder.append(this.outFile.getPath());
            String string = iOException.getMessage();
            if (string != null && !string.isEmpty()) {
                stringBuilder.append(":\n");
                stringBuilder.append(string);
            }
            stringBuilder.append('\n');
            this.appendToLog(stringBuilder.toString());
            this.incErrorCount();
            bl = true;
        }
        finally {
            EmuUtil.closeSilent(this.out);
        }
        if (this.cancelled || bl) {
            this.outFile.delete();
        }
        FileBrowserFrm.fireFileChanged(this.outFile.getParentFile());
    }

    private TarPacker(Window window, Collection<Path> collection, File file, boolean bl) {
        super(window, "JKCEMU tar packer", true);
        this.srcPaths = collection;
        this.outFile = file;
        this.out = null;
        this.compression = bl;
        this.ownerEnabled = true;
        this.posixEnabled = true;
    }

    private String getEntryDir(Path path) {
        String string = "";
        if (this.curRootPath != null) {
            Path path2 = null;
            if (path != null) {
                try {
                    path2 = this.curRootPath.relativize(path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (path2 == null) {
                path2 = this.curRootPath;
            }
            if (path2.getNameCount() > 0) {
                StringBuilder stringBuilder = new StringBuilder(256);
                for (Path path3 : path2) {
                    String string2 = path3.toString();
                    if (string2 == null || string2.isEmpty()) continue;
                    stringBuilder.append(string2);
                    stringBuilder.append("/");
                }
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    private void writeASCII(byte[] byArray, int n, String string) {
        if (string != null) {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                byArray[n++] = (byte)(string.charAt(i) & 0xFF);
            }
        }
    }

    private void writeTarHeader(Path path, String string, char c, String string2, long l, BasicFileAttributes basicFileAttributes, boolean bl) throws IOException {
        String string3;
        int n;
        String string4;
        int n2;
        byte[] byArray = new byte[512];
        Arrays.fill(byArray, (byte)0);
        UserPrincipal userPrincipal = null;
        GroupPrincipal groupPrincipal = null;
        Set<PosixFilePermission> set = null;
        PosixFileAttributes posixFileAttributes = null;
        if (basicFileAttributes instanceof PosixFileAttributes) {
            posixFileAttributes = (PosixFileAttributes)basicFileAttributes;
        } else if (this.posixEnabled) {
            try {
                posixFileAttributes = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.posixEnabled = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (posixFileAttributes != null) {
            userPrincipal = posixFileAttributes.owner();
            groupPrincipal = posixFileAttributes.group();
            set = posixFileAttributes.permissions();
        }
        if (userPrincipal == null) {
            try {
                userPrincipal = Files.getOwner(path, LinkOption.NOFOLLOW_LINKS);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.ownerEnabled = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n2 = string.length()) > 99) {
            throw new IOException("Name des Eintrags zu lang");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("ISO-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray2 == null) {
            byArray2 = string.getBytes();
        }
        if (byArray2.length != n2) {
            throw new IOException("Name enth\u00e4lt nicht erlaubte Zeichen");
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        String string5 = "0000644";
        if (set != null) {
            int n3 = 0;
            if (set.contains((Object)PosixFilePermission.OWNER_READ)) {
                n3 |= 0x400;
            }
            if (set.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                n3 |= 0x200;
            }
            if (set.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                n3 |= 0x100;
            }
            if (set.contains((Object)PosixFilePermission.GROUP_READ)) {
                n3 |= 0x40;
            }
            if (set.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                n3 |= 0x20;
            }
            if (set.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                n3 |= 0x10;
            }
            if (set.contains((Object)PosixFilePermission.OTHERS_READ)) {
                n3 |= 4;
            }
            if (set.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                n3 |= 2;
            }
            if (set.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                n3 |= 1;
            }
            string5 = String.format("%07X", n3);
        } else if (basicFileAttributes.isDirectory() || bl) {
            string5 = "0000755";
        }
        this.writeASCII(byArray, 100, string5);
        this.writeASCII(byArray, 108, "0000000");
        this.writeASCII(byArray, 116, "0000000");
        this.writeASCII(byArray, 124, String.format("%011o", l));
        long l2 = System.currentTimeMillis();
        FileTime fileTime = basicFileAttributes.lastModifiedTime();
        if (fileTime != null) {
            l2 = fileTime.toMillis();
        }
        this.writeASCII(byArray, 136, String.format("%011o", l2 / 1000L));
        int n4 = 148;
        while (n4 < 156) {
            byArray[n4++] = 32;
        }
        byArray[156] = (byte)c;
        if (string2 != null) {
            n2 = string2.length();
            if (n2 > 99) {
                throw new IOException(string2 + ": Verlinkter Name zu lang");
            }
            byArray2 = null;
            try {
                byArray2 = string2.getBytes("ISO-8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray2 == null) {
                byArray2 = string.getBytes();
            }
            if (byArray2.length != n2) {
                throw new IOException(string2 + ": Verlinkter Name enth\u00e4lt nicht erlaubte Zeichen");
            }
            System.arraycopy(byArray2, 0, byArray, 157, byArray2.length);
        }
        this.writeASCII(byArray, 257, "ustar ");
        byArray[263] = 32;
        String string6 = "root";
        if (userPrincipal != null && (string4 = userPrincipal.getName()) != null && !string4.isEmpty()) {
            n = string4.lastIndexOf(92);
            string6 = n >= 0 && n + 1 < string4.length() ? string4.substring(n + 1) : string4;
        }
        this.writeASCII(byArray, 265, string6);
        string4 = null;
        if (groupPrincipal != null && (string3 = groupPrincipal.getName()) != null && !string3.isEmpty()) {
            string4 = string3;
        }
        if (string4 == null) {
            string4 = string6.equals("root") ? "root" : "users";
        }
        this.writeASCII(byArray, 297, string4);
        n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i] & 0xFF;
        }
        this.writeASCII(byArray, 148, String.format("%06o", n));
        byArray[154] = 0;
        this.out.write(byArray);
    }
}

