/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;

public class LastModifiedDlg
extends BaseDlg
implements FileVisitor<Path>,
Runnable {
    private List<Path> paths;
    private Thread thread;
    private FileTime time;
    private int numChanged;
    private int numUnchanged;
    private boolean cancelled;
    private boolean recursive;
    private boolean archiveFiles;
    private DateFormat dateFmtStd;
    private DateFormat dateFmtShort;
    private JRadioButton btnCurrentTime;
    private JRadioButton btnTimeInput;
    private JCheckBox btnRecursive;
    private JCheckBox btnWithinArchiveFiles;
    private JTextField fldTime;
    private JTextArea fldLog;
    private JButton btnOK;
    private JButton btnCancel;

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
        if (!this.cancelled && this.time != null) {
            if (this.recursive) {
                this.setLastModified(path);
            }
            fileVisitResult = FileVisitResult.CONTINUE;
        }
        return fileVisitResult;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
        if (!this.cancelled && this.time != null) {
            if (this.recursive) {
                fileVisitResult = FileVisitResult.CONTINUE;
            } else {
                this.setLastModified(path);
                fileVisitResult = FileVisitResult.SKIP_SUBTREE;
            }
        }
        return fileVisitResult;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
        if (!this.cancelled && this.time != null) {
            this.setLastModified(path);
            fileVisitResult = FileVisitResult.CONTINUE;
        }
        return fileVisitResult;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) {
        ++this.numUnchanged;
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string;
        String string2 = null;
        try {
            for (Path path : this.paths) {
                Files.walkFileTree(path, this);
            }
            string = string2;
        }
        catch (Exception exception) {
            String string3;
            try {
                string2 = exception.getMessage();
                this.cancelled = true;
                string3 = string2;
            }
            catch (Throwable throwable) {
                String string4 = string2;
                EventQueue.invokeLater(new Runnable(string4){
                    final /* synthetic */ String val$msg1;
                    {
                        this.val$msg1 = string;
                    }

                    @Override
                    public void run() {
                        LastModifiedDlg.this.threadTerminated(this.val$msg1);
                    }
                });
                throw throwable;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public static boolean open(Window window, List<Path> list) {
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            LastModifiedDlg lastModifiedDlg = new LastModifiedDlg(window, list);
            lastModifiedDlg.setVisible(true);
            if (lastModifiedDlg.numChanged > 0) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnCurrentTime || object == this.btnTimeInput) {
                bl = true;
                this.fldTime.setEditable(this.btnTimeInput.isSelected());
            } else if (object == this.btnOK) {
                bl = true;
                this.doOK();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doCancel();
            }
        }
        return bl;
    }

    private LastModifiedDlg(Window window, List<Path> list) {
        super(window, "\u00c4nderungszeitpunkt");
        Comparable<Path> comparable;
        Comparable<Path> comparable22;
        this.paths = list;
        this.thread = null;
        this.time = null;
        this.numChanged = 0;
        this.numUnchanged = 0;
        this.cancelled = false;
        this.recursive = false;
        this.archiveFiles = false;
        this.dateFmtStd = DateFormat.getDateTimeInstance(2, 2);
        this.dateFmtShort = DateFormat.getDateTimeInstance(2, 3);
        this.dateFmtStd.setLenient(false);
        this.dateFmtShort.setLenient(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("\u00c4nderungszeitpunkt setzen auf:"), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnCurrentTime = new JRadioButton("aktuellen Zeitpunkt", true);
        buttonGroup.add(this.btnCurrentTime);
        gridBagConstraints.insets.left = 50;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnCurrentTime, gridBagConstraints);
        this.btnTimeInput = new JRadioButton("Datum/Uhrzeit:", false);
        buttonGroup.add(this.btnTimeInput);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnTimeInput, gridBagConstraints);
        this.fldTime = new JTextField();
        this.fldTime.setEditable(false);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldTime, gridBagConstraints);
        this.btnRecursive = new JCheckBox("In Verzeichnisse hinein wechseln", false);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnRecursive, gridBagConstraints);
        this.btnWithinArchiveFiles = new JCheckBox("In JAR- und ZIP-Dateien hinein wechseln", false);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnWithinArchiveFiles, gridBagConstraints);
        boolean bl = false;
        boolean bl2 = false;
        for (Comparable<Path> comparable22 : this.paths) {
            String string;
            if (Files.isDirectory(comparable22, new LinkOption[]{LinkOption.NOFOLLOW_LINKS})) {
                bl = true;
            }
            if (Files.isRegularFile(comparable22, new LinkOption[]{LinkOption.NOFOLLOW_LINKS}) && (comparable = comparable22.getFileName()) != null && (string = comparable.toString()) != null && ((string = string.toLowerCase()).endsWith(".jar") || string.endsWith(".zip"))) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            break;
        }
        this.btnRecursive.setEnabled(bl);
        this.btnWithinArchiveFiles.setEnabled(bl || bl2);
        this.fldLog = new JTextArea(4, 0);
        this.fldLog.setEditable(false);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JScrollPane(this.fldLog), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.btnOK = new JButton("OK");
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        jPanel.add(this.btnCancel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        comparable22 = null;
        if (!this.paths.isEmpty()) {
            try {
                comparable = Files.getLastModifiedTime(this.paths.get(0), new LinkOption[0]);
                if (comparable != null) {
                    comparable22 = new Date(((FileTime)comparable).toMillis());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (comparable22 == null) {
            comparable22 = new Date();
        }
        this.fldTime.setText(this.dateFmtStd.format((Date)comparable22));
        this.btnCurrentTime.addActionListener(this);
        this.btnTimeInput.addActionListener(this);
        this.fldTime.addActionListener(this);
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.fldLog.setRows(0);
    }

    private void doCancel() {
        if (this.thread != null) {
            this.cancelled = true;
            this.btnOK.setEnabled(true);
        } else {
            this.doClose();
        }
    }

    private void doOK() {
        if (this.thread != null) {
            if (this.cancelled || this.thread.getState().equals((Object)Thread.State.TERMINATED)) {
                this.doClose();
            }
        } else {
            try {
                String string;
                if (this.btnCurrentTime.isSelected()) {
                    this.time = FileTime.fromMillis(System.currentTimeMillis());
                } else if (this.btnTimeInput.isSelected() && (string = this.fldTime.getText()) != null) {
                    Date date = null;
                    try {
                        date = this.dateFmtStd.parse(string);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (date == null) {
                        date = this.dateFmtShort.parse(string);
                    }
                    this.time = FileTime.fromMillis(date != null ? date.getTime() : System.currentTimeMillis());
                }
                if (this.time != null) {
                    this.btnOK.setEnabled(false);
                    this.numChanged = 0;
                    this.numUnchanged = 0;
                    this.cancelled = false;
                    this.recursive = this.btnRecursive.isSelected();
                    this.archiveFiles = this.btnWithinArchiveFiles.isSelected();
                    this.thread = new Thread((Runnable)this, "JKCEMU set last modified");
                    this.thread.start();
                } else {
                    LastModifiedDlg.showErrorDlg((Component)this, "Sie m\u00fcssen eine Zeit festlegen.");
                }
            }
            catch (ParseException parseException) {
                LastModifiedDlg.showErrorDlg((Component)this, "Datum/Uhrzeit: ung\u00fcltige Eingabe");
            }
        }
    }

    private void appendToLog(String string) {
        if (string != null && !string.isEmpty()) {
            Document document = this.fldLog.getDocument();
            if (document != null && document.getLength() > 0) {
                this.fldLog.append("\n\n");
            }
            this.fldLog.append(string);
        }
    }

    private void fireAppendToLog(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LastModifiedDlg.this.appendToLog(string);
            }
        });
    }

    private void setLastModified(Path path) {
        if (this.time != null) {
            String string;
            Path path2;
            if (this.archiveFiles && Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS) && (path2 = path.getFileName()) != null && (string = path2.toString()) != null && ((string = string.toLowerCase()).endsWith(".jar") || string.endsWith(".zip"))) {
                this.setLastModifiedInZIP(path);
            }
            try {
                Files.setLastModifiedTime(path, this.time);
                ++this.numChanged;
            }
            catch (Exception exception) {
                ++this.numUnchanged;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastModifiedInZIP(Path path) {
        if (path != null && this.time != null) {
            ZipOutputStream zipOutputStream;
            InputStream inputStream;
            block12: {
                inputStream = null;
                ZipInputStream zipInputStream = null;
                zipOutputStream = null;
                try {
                    Map<String, Object> map = Files.readAttributes(path, "*", LinkOption.NOFOLLOW_LINKS);
                    Path path2 = null;
                    if (!Files.isWritable(path)) {
                        throw new IOException("Datei ist schreibgesch\u00fctzt.");
                    }
                    inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                    zipInputStream = new ZipInputStream(inputStream);
                    Path path3 = path.getParent();
                    path2 = path3 != null ? Files.createTempFile(path3, "jkcemu_", ".zip", new FileAttribute[0]) : Files.createTempFile("jkcemu_", ".zip", new FileAttribute[0]);
                    zipOutputStream = new ZipOutputStream(Files.newOutputStream(path2, StandardOpenOption.CREATE));
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (zipEntry != null) {
                        zipEntry.setTime(this.time.toMillis());
                        zipOutputStream.putNextEntry(zipEntry);
                        int n = zipInputStream.read();
                        while (n >= 0) {
                            zipOutputStream.write(n);
                            n = zipInputStream.read();
                        }
                        zipOutputStream.closeEntry();
                        zipInputStream.closeEntry();
                        zipEntry = zipInputStream.getNextEntry();
                    }
                    zipOutputStream.finish();
                    zipOutputStream.close();
                    zipOutputStream = null;
                    zipInputStream.close();
                    zipInputStream = null;
                    Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
                    if (map == null) break block12;
                    for (String string : map.keySet()) {
                        Object object = map.get(string);
                        if (object == null) continue;
                        try {
                            Files.setAttribute(path, string, object, LinkOption.NOFOLLOW_LINKS);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    try {
                        StringBuilder stringBuilder = new StringBuilder(256);
                        stringBuilder.append(path.toString());
                        stringBuilder.append(":\nDie Zeitstempel der in der Archivdatei enthaltenen\nDateien konnten nicht ge\u00e4ndert werden.");
                        String string = exception.getMessage();
                        if (string != null && !string.isEmpty()) {
                            stringBuilder.append("\n\n");
                            stringBuilder.append(string);
                        }
                        this.fireAppendToLog(stringBuilder.toString());
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(inputStream);
                        EmuUtil.closeSilent(zipOutputStream);
                        throw throwable;
                    }
                    EmuUtil.closeSilent(inputStream);
                    EmuUtil.closeSilent(zipOutputStream);
                }
            }
            EmuUtil.closeSilent(inputStream);
            EmuUtil.closeSilent(zipOutputStream);
        }
    }

    private void threadTerminated(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.cancelled) {
            stringBuilder.append("Vorgang abgebrochen\n");
        }
        stringBuilder.append(this.numChanged);
        if (this.numChanged == 1) {
            stringBuilder.append(" Datei/Verzeichnis");
        } else {
            stringBuilder.append(" Dateien/Verzeichnissen");
        }
        stringBuilder.append(" ge\u00e4ndert");
        if (this.numUnchanged > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(this.numUnchanged);
            if (this.numUnchanged == 1) {
                stringBuilder.append(" Datei/Verzeichnis konnte");
            } else {
                stringBuilder.append(" Dateien/Verzeichnisse konnten");
            }
            stringBuilder.append(" nicht ge\u00e4ndert werden.");
        }
        if (!this.cancelled) {
            stringBuilder.append("\nFertig");
        }
        this.appendToLog(stringBuilder.toString());
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(false);
    }
}

