/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jkcemu.Main;
import jkcemu.base.AbstractFileWorker;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.DirSelectDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.ScreenFrm;
import jkcemu.base.UserInputException;
import jkcemu.filebrowser.FileActionMngr;
import jkcemu.filebrowser.FileBrowserFrm;
import jkcemu.filebrowser.FileCheckResult;
import jkcemu.filebrowser.FileListSelection;
import jkcemu.filebrowser.FindFilesCellRenderer;

public class FindFilesFrm
extends BaseFrm
implements AbstractFileWorker.PathListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
FileVisitor<Path>,
FocusListener,
ListSelectionListener,
Runnable {
    private static final int MAX_RESULT_ROWS = 2000;
    private static final int MAX_ROW_LEN = 1024;
    private static final String COPY_TEXT = "Zeilen als Text kopieren";
    private static final String HELP_PAGE = "/help/tools/findfiles.htm";
    private static FindFilesFrm instance = null;
    private static DateFormat dateFmtShort = null;
    private static DateFormat dateFmtMedium = null;
    private ScreenFrm screenFrm;
    private JPopupMenu popup;
    private JMenuItem popupCopyText;
    private JMenuItem mnuStart;
    private JMenuItem mnuStop;
    private JMenuItem mnuClose;
    private JMenuItem mnuCopyText;
    private JMenuItem mnuRemoveFromResult;
    private JMenuItem mnuHelpContent;
    private JButton btnStartStop;
    private JButton btnRootDirSelect;
    private JTextField fldRootDir;
    private JTextField fldFileNameMask;
    private JTextField fldFileSizeFrom;
    private JTextField fldFileSizeTo;
    private JTextField fldLastModified;
    private JTextField fldLastModifiedTill;
    private JTextField fldText;
    private JTextField fldCurDir;
    private JCheckBox btnSubTrees;
    private JCheckBox btnCaseSensitive;
    private JCheckBox btnPrintMatchedRows;
    private JLabel labelCurDir;
    private JList<Object> list;
    private DefaultListModel<Object> listModel;
    private Path dirPath;
    private Collection<Pattern> findFileNamePatterns;
    private Long findFileSizeFrom;
    private Long findFileSizeTo;
    private Long findLastModifiedFrom;
    private Long findLastModifiedTill;
    private String findText;
    private boolean findIgnoreCase;
    private boolean findPrintMatchedRows;
    private boolean findSubTrees;
    private FileActionMngr fileActionMngr;
    private volatile FileVisitResult fileVisitResult;
    private volatile Thread thread;

    public static void open(ScreenFrm screenFrm) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new FindFilesFrm(screenFrm);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void open(ScreenFrm screenFrm, Path path) {
        FindFilesFrm.open(screenFrm);
        if (path != null) {
            instance.setDirectory(path);
        }
    }

    public void setDirectory(Path path) {
        if (path != null && !Files.isDirectory(path, new LinkOption[0])) {
            path = null;
        }
        this.dirPath = path;
        this.fldRootDir.setText(path != null ? path.toString() : "");
    }

    @Override
    public void pathsPasted(Set<Path> set) {
    }

    @Override
    public void pathsRemoved(Set<Path> set) {
        if (set != null) {
            this.removeFromResult(set);
            Set<Path> set2 = EmuUtil.createPathSet();
            for (Path path : set) {
                Path path2 = path.getParent();
                if (path2 == null) continue;
                FileBrowserFrm.fireFileChanged(path2);
            }
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n;
        List<FileActionMngr.FileObject> list = this.getFileObjectList(this.list.getSelectedIndices());
        if (list != null && (n = list.size()) > 0) {
            ArrayList<File> arrayList = new ArrayList<File>(n);
            for (FileActionMngr.FileObject fileObject : list) {
                File file;
                if (!(fileObject instanceof FileActionMngr.FileObject) || (file = fileObject.getFile()) == null) continue;
                arrayList.add(file);
            }
            if (!arrayList.isEmpty()) {
                try {
                    dragGestureEvent.startDrag(null, new FileListSelection(arrayList));
                }
                catch (Exception exception) {
                    BaseDlg.showErrorDlg((Component)this, exception);
                }
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        DragSourceContext dragSourceContext;
        if (dragSourceDropEvent.getDropAction() == 2 && (dragSourceContext = dragSourceDropEvent.getDragSourceContext()) != null) {
            try {
                Object object;
                Transferable transferable = dragSourceContext.getTransferable();
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (object = transferable.getTransferData(DataFlavor.javaFileListFlavor)) != null && object instanceof Collection) {
                    this.removeFromResult((Collection)object);
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.thread != null || !EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file;
        boolean bl = false;
        if (this.thread == null && EmuUtil.isFileDrop(dropTargetDropEvent) && (file = EmuUtil.fileDrop(this, dropTargetDropEvent)) != null && file.isDirectory()) {
            try {
                this.setDirectory(file.toPath());
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            bl = true;
        }
        if (bl) {
            dropTargetDropEvent.dropComplete(true);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.thread != null || !EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        this.fldCurDir.setText(path.toString());
        if (iOException != null) {
            this.appendErrorToResult(path, iOException);
        }
        return this.fileVisitResult;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        return this.fileVisitResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileVisitResult visitFile(final Path path, BasicFileAttributes basicFileAttributes) {
        Object object3;
        Object object4;
        boolean bl;
        block39: {
            int n;
            Object object;
            long l;
            bl = true;
            Collection<Pattern> collection = this.findFileNamePatterns;
            if (collection != null && !collection.isEmpty()) {
                bl = false;
                object4 = path.getFileName();
                if (object4 != null && (object3 = object4.toString()) != null) {
                    for (Pattern object22 : collection) {
                        if (!object22.matcher((CharSequence)object3).matches()) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (bl && basicFileAttributes != null && (this.findFileSizeFrom != null || this.findFileSizeTo != null) && (l = basicFileAttributes.size()) >= 0L) {
                Long l2;
                Long l22 = this.findFileSizeFrom;
                if (l22 != null && l < l22) {
                    bl = false;
                }
                if ((l2 = this.findFileSizeTo) != null && l > l2) {
                    bl = false;
                }
            }
            if (bl && basicFileAttributes != null && (this.findLastModifiedFrom != null || this.findLastModifiedTill != null) && (object4 = basicFileAttributes.lastModifiedTime()) != null) {
                long l3 = ((FileTime)object4).toMillis();
                Long l4 = this.findLastModifiedFrom;
                if (l4 != null && l3 < l4) {
                    bl = false;
                }
                if ((object = this.findLastModifiedTill) != null && l3 >= (Long)object) {
                    bl = false;
                }
            }
            object4 = new ArrayList();
            if (bl && (object3 = this.findText) != null && (n = ((String)object3).length()) > 0) {
                PushbackInputStream pushbackInputStream;
                Closeable closeable = null;
                object = null;
                try {
                    pushbackInputStream = new PushbackInputStream(Files.newInputStream(path, new OpenOption[0]), 3);
                    String string = null;
                    byte[] byArray = new byte[3];
                    int n2 = pushbackInputStream.read(byArray);
                    if (n2 == byArray.length) {
                        if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                            string = "UTF-8";
                        } else if (byArray[0] == -2 && byArray[1] == -1) {
                            string = "UTF-16BE";
                            pushbackInputStream.unread(byArray[2]);
                        } else if (byArray[0] == -1 && byArray[1] == -2) {
                            string = "UTF-16LE";
                            pushbackInputStream.unread(byArray[2]);
                        }
                    } else if (n2 > 0) {
                        pushbackInputStream.unread(byArray, 0, Math.max(n2, byArray.length));
                    }
                    object = string != null ? new InputStreamReader((InputStream)pushbackInputStream, string) : new InputStreamReader(pushbackInputStream);
                    bl = false;
                    char[] cArray = new char[n];
                    if (((Reader)object).read(cArray) == n) {
                        int n3;
                        char c;
                        int n4;
                        StringBuilder stringBuilder = null;
                        if (this.findPrintMatchedRows) {
                            stringBuilder = new StringBuilder(256);
                            for (n4 = 0; n4 < cArray.length; ++n4) {
                                c = cArray[n4];
                                if (c <= '\r') {
                                    stringBuilder.setLength(0);
                                    continue;
                                }
                                n3 = stringBuilder.length();
                                if (n3 < 1024) {
                                    stringBuilder.append(c);
                                    continue;
                                }
                                if (n3 != 1024) continue;
                                stringBuilder.append("...");
                            }
                        }
                        n4 = 0;
                        c = '\u0001';
                        n3 = 0;
                        while (c != '\u0000') {
                            int n5;
                            int n6;
                            boolean bl2 = true;
                            for (n6 = 0; n6 < n; ++n6) {
                                n5 = cArray[(n3 + n6) % n];
                                if (this.findIgnoreCase) {
                                    n5 = Character.toUpperCase((char)n5);
                                }
                                if (n5 == ((String)object3).charAt(n6)) continue;
                                bl2 = false;
                                break;
                            }
                            if (bl2) {
                                bl = true;
                                n4 = 1;
                                if (stringBuilder == null) break;
                            }
                            if ((n6 = ((Reader)object).read()) < 0) {
                                c = '\u0000';
                                break;
                            }
                            cArray[n3++] = (char)n6;
                            if (n3 >= n) {
                                n3 = 0;
                            }
                            if (stringBuilder == null) continue;
                            if (n6 <= 13) {
                                if (n4 != 0 && stringBuilder.length() > 0) {
                                    object4.add(stringBuilder.toString());
                                }
                                stringBuilder.setLength(0);
                                n4 = 0;
                                continue;
                            }
                            n5 = stringBuilder.length();
                            if (n5 < 1024) {
                                stringBuilder.append((char)n6);
                                continue;
                            }
                            if (n5 != 1024) continue;
                            stringBuilder.append("...");
                        }
                        if (stringBuilder != null && n4 != 0 && stringBuilder.length() > 0) {
                            object4.add(stringBuilder.toString());
                        }
                    }
                    EmuUtil.closeSilent((Closeable)object);
                }
                catch (IOException iOException) {
                    this.appendErrorToResult(path, iOException);
                    bl = false;
                    break block39;
                }
                finally {
                    EmuUtil.closeSilent((Closeable)object);
                    EmuUtil.closeSilent(closeable);
                }
                EmuUtil.closeSilent(pushbackInputStream);
            }
        }
        if (bl) {
            object3 = object4;
            EventQueue.invokeLater(new Runnable((List)object3){
                final /* synthetic */ List val$rows;
                {
                    this.val$rows = list;
                }

                @Override
                public void run() {
                    FindFilesFrm.this.appendToResult(new FileEntry(path), this.val$rows);
                }
            });
        }
        return this.fileVisitResult;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) {
        if (iOException != null) {
            this.appendErrorToResult(path, iOException);
        }
        return this.fileVisitResult;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component;
        if (!focusEvent.isTemporary() && (component = focusEvent.getComponent()) != null && component instanceof JTextField && (component == this.fldLastModified || component == this.fldLastModifiedTill)) {
            try {
                FindFilesFrm.parseTimestamp((JTextField)component, null);
            }
            catch (UserInputException userInputException) {
                // empty catch block
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.list.getSelectedIndex() >= 0;
        this.popupCopyText.setEnabled(bl);
        this.mnuCopyText.setEnabled(bl);
        this.mnuRemoveFromResult.setEnabled(bl);
        this.fileActionMngr.updActionButtonsEnabled(this.getFileObjectList(this.list.getSelectedIndices()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        try {
            object = this.dirPath;
            if (object != null) {
                this.fileVisitResult = FileVisitResult.CONTINUE;
                Files.walkFileTree((Path)object, EnumSet.noneOf(FileVisitOption.class), this.findSubTrees ? Integer.MAX_VALUE : 1, this);
            }
            object = this;
        }
        catch (Exception exception) {
            FindFilesFrm findFilesFrm;
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FindFilesFrm.this.showError(exception);
                    }
                });
                findFilesFrm = this;
            }
            catch (Throwable throwable) {
                FindFilesFrm findFilesFrm2 = this;
                synchronized (findFilesFrm2) {
                    this.thread = null;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FindFilesFrm.this.searchFinished();
                    }
                });
                throw throwable;
            }
            synchronized (findFilesFrm) {
                this.thread = null;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        synchronized (object) {
            this.thread = null;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        try {
            int[] nArray;
            Object object;
            Object object2;
            Object object3 = eventObject.getSource();
            if (object3 == this.btnRootDirSelect) {
                bl = true;
                this.doSelectRootDir();
            } else if (object3 == this.btnStartStop) {
                bl = true;
                if (this.thread == null) {
                    this.doStart();
                } else {
                    this.doStop();
                }
            } else if (object3 == this.fldFileNameMask) {
                bl = true;
                this.fldFileSizeFrom.requestFocus();
            } else if (object3 == this.fldFileSizeFrom) {
                bl = true;
                this.fldFileSizeTo.requestFocus();
            } else if (object3 == this.fldFileSizeTo) {
                bl = true;
                this.fldLastModified.requestFocus();
            } else if (object3 == this.fldLastModified) {
                bl = true;
                this.fldLastModifiedTill.requestFocus();
            } else if (object3 == this.fldLastModifiedTill) {
                bl = true;
                this.fldText.requestFocus();
            } else if (object3 == this.fldText || object3 == this.mnuStart) {
                bl = true;
                this.doStart();
            } else if (object3 == this.mnuStop) {
                bl = true;
                this.doStop();
            } else if (object3 == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object3 == this.mnuCopyText || object3 == this.popupCopyText) {
                bl = true;
                this.doCopyText();
            } else if (object3 == this.mnuRemoveFromResult) {
                bl = true;
                this.doRemoveFromResult();
            } else if (object3 == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else if (object3 == this.list) {
                Object object4;
                bl = true;
                object2 = this.list.getSelectedIndices();
                if (((Object)object2).length == 1 && (object4 = object2[0]) >= 0 && object4 < this.listModel.getSize() && (object = this.listModel.getElementAt((int)object4)) != null) {
                    FileActionMngr.FileObject fileObject = null;
                    if (object instanceof FindFilesCellRenderer.CodeEntry) {
                        fileObject = ((FindFilesCellRenderer.CodeEntry)object).getFileObject();
                    } else if (object instanceof FileActionMngr.FileObject) {
                        fileObject = (FileActionMngr.FileObject)object;
                    }
                    if (fileObject != null) {
                        bl = this.fileActionMngr.doFileAction(fileObject);
                    }
                }
            }
            if (!bl && eventObject instanceof ActionEvent && (object2 = ((ActionEvent)eventObject).getActionCommand()) != null && (nArray = this.list.getSelectedIndices()).length > 0 && !(object = this.getFileObjectList(nArray)).isEmpty()) {
                switch (this.fileActionMngr.actionPerformed((String)object2, (List<FileActionMngr.FileObject>)object)) {
                    case FILES_CHANGED: {
                        FindFilesFrm.fireFilesChanged(object);
                        bl = true;
                        break;
                    }
                    case DONE: {
                        bl = true;
                        break;
                    }
                    case FILE_RENAMED: {
                        this.list.setModel(this.listModel);
                        FindFilesFrm.fireFilesChanged(object);
                        bl = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = AbstractFileWorker.checkWindowClosing(this, this.fileActionMngr.getFileWorkers());
        if (bl) {
            bl = super.doClose();
        }
        if (bl) {
            this.fileVisitResult = FileVisitResult.TERMINATE;
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
            instance = null;
            Main.checkQuit(this);
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.checkPopup(mouseEvent)) {
            mouseEvent.consume();
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.checkPopup(mouseEvent)) {
            mouseEvent.consume();
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.checkPopup(mouseEvent)) {
            mouseEvent.consume();
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.fileVisitResult = FileVisitResult.TERMINATE;
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this && this.fldFileNameMask != null) {
            this.fldFileNameMask.requestFocus();
        }
    }

    private FindFilesFrm(ScreenFrm screenFrm) {
        this.setTitle("JKCEMU Dateisuche");
        Main.updIcon(this);
        this.screenFrm = screenFrm;
        this.fileActionMngr = new FileActionMngr(this, screenFrm, this);
        this.fileVisitResult = FileVisitResult.TERMINATE;
        this.thread = null;
        this.dirPath = null;
        this.findFileNamePatterns = null;
        this.findFileSizeFrom = null;
        this.findFileSizeTo = null;
        this.findLastModifiedFrom = null;
        this.findLastModifiedTill = null;
        this.findText = null;
        this.findIgnoreCase = false;
        this.findPrintMatchedRows = false;
        this.findSubTrees = false;
        this.popup = new JPopupMenu();
        this.popupCopyText = this.createJMenuItem(COPY_TEXT);
        this.popupCopyText.setEnabled(false);
        this.popup.add(this.popupCopyText);
        this.popup.addSeparator();
        JMenu jMenu = new JMenu("Bearbeiten");
        jMenu.setMnemonic(66);
        this.mnuCopyText = this.createJMenuItem(COPY_TEXT);
        this.mnuCopyText.setEnabled(false);
        jMenu.add(this.mnuCopyText);
        jMenu.addSeparator();
        this.fileActionMngr.addCopyFileNameMenuItemsTo(this.popup, jMenu);
        this.fileActionMngr.addCopyFileMenuItemTo(this.popup, jMenu);
        this.popup.addSeparator();
        jMenu.addSeparator();
        this.mnuRemoveFromResult = this.createJMenuItem("Aus Suchergebnis entfernen", KeyStroke.getKeyStroke(127, 0));
        this.mnuRemoveFromResult.setEnabled(false);
        jMenu.add(this.mnuRemoveFromResult);
        JMenu jMenu2 = new JMenu("Datei");
        jMenu2.setMnemonic(68);
        this.mnuStart = this.createJMenuItem("Suche starten");
        jMenu2.add(this.mnuStart);
        this.mnuStop = this.createJMenuItem("Suche beenden");
        jMenu2.add(this.mnuStop);
        jMenu2.addSeparator();
        if (this.screenFrm != null) {
            this.fileActionMngr.addLoadIntoEmuMenuItemsTo(this.popup, jMenu2);
            this.popup.addSeparator();
            jMenu2.addSeparator();
        }
        this.fileActionMngr.addFileMenuItemsTo(this.popup, jMenu2);
        jMenu2.addSeparator();
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu2.add(this.mnuClose);
        JMenu jMenu3 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Suchen in:"), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.fldRootDir = new JTextField();
        this.fldRootDir.setEnabled(false);
        jPanel.add((Component)this.fldRootDir, gridBagConstraints2);
        this.btnRootDirSelect = this.createImageButton("/images/file/open.png", "Verzeichnis ausw\u00e4hlen");
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnRootDirSelect, gridBagConstraints2);
        this.btnSubTrees = new JCheckBox("Unterverzeichnisse durchsuchen", true);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnSubTrees, gridBagConstraints);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Dateinamensmaske:"), gridBagConstraints);
        this.fldFileNameMask = new JTextField();
        this.fldFileNameMask.setEnabled(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldFileNameMask, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Dateigr\u00f6\u00dfe (Bytes):"), gridBagConstraints);
        this.fldFileSizeFrom = new JTextField();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldFileSizeFrom, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("bis:"), gridBagConstraints);
        this.fldFileSizeTo = new JTextField();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldFileSizeTo, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Zuletzt ge\u00e4ndert am:"), gridBagConstraints);
        this.fldLastModified = new JTextField();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldLastModified, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("bis:"), gridBagConstraints);
        this.fldLastModifiedTill = new JTextField();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldLastModifiedTill, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Enthaltener Text:"), gridBagConstraints);
        this.fldText = new JTextField();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldText, gridBagConstraints);
        this.btnCaseSensitive = new JCheckBox("Gro\u00df-/Kleinschreibung beachten", false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnCaseSensitive, gridBagConstraints);
        this.btnPrintMatchedRows = new JCheckBox("Gefundene Textstellen ausgeben", false);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnPrintMatchedRows, gridBagConstraints);
        this.btnStartStop = new JButton("Suche starten");
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnStartStop, gridBagConstraints);
        this.labelCurDir = new JLabel("Aktuell wird gesucht in:");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelCurDir, gridBagConstraints);
        this.fldCurDir = new JTextField();
        this.fldCurDir.setEnabled(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldCurDir, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Suchergebnis:"), gridBagConstraints);
        this.listModel = new DefaultListModel();
        this.list = new JList<Object>(this.listModel);
        this.list.setCellRenderer(new FindFilesCellRenderer());
        this.list.setSelectionMode(2);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JScrollPane(this.list), gridBagConstraints);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.list.setVisibleRowCount(8);
            this.pack();
            this.setScreenCentered();
            this.list.setVisibleRowCount(1);
        }
        this.setResizable(true);
        this.updFieldsEnabled();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.list, 1, this);
        new DropTarget(this.fldRootDir, this).setActive(true);
        this.fldFileNameMask.addActionListener(this);
        this.fldFileSizeFrom.addActionListener(this);
        this.fldFileSizeTo.addActionListener(this);
        this.fldLastModified.addActionListener(this);
        this.fldLastModified.addFocusListener(this);
        this.fldLastModifiedTill.addActionListener(this);
        this.fldLastModifiedTill.addFocusListener(this);
        this.fldText.addActionListener(this);
        this.btnStartStop.addActionListener(this);
        this.list.addKeyListener(this);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        this.fileActionMngr.updActionButtonsEnabled(null);
        File file = Main.getLastDirFile("find");
        if (file != null) {
            try {
                this.setDirectory(file.toPath());
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyText() {
        block9: {
            Toolkit toolkit = this.getToolkit();
            if (toolkit != null) {
                try {
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    if (clipboard == null) break block9;
                    StringBuilder stringBuilder = new StringBuilder(1024);
                    Object object = this.listModel;
                    synchronized (object) {
                        int[] nArray;
                        int n = this.listModel.getSize();
                        for (int n2 : nArray = this.list.getSelectedIndices()) {
                            String string;
                            Object object2;
                            if (n2 < 0 || n2 >= n || (object2 = this.listModel.getElementAt(n2)) == null || (string = object2.toString()) == null || string.isEmpty()) continue;
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append('\n');
                            }
                            stringBuilder.append(string);
                        }
                    }
                    if (stringBuilder.length() > 0) {
                        object = new StringSelection(stringBuilder.toString());
                        clipboard.setContents((Transferable)object, (ClipboardOwner)object);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private void doSelectRootDir() {
        File file;
        File file2 = null;
        if (this.dirPath != null) {
            try {
                file2 = this.dirPath.toFile();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if ((file = DirSelectDlg.selectDirectory(this, file2)) != null) {
            try {
                this.setDirectory(file.toPath());
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() {
        if (this.thread == null) {
            try {
                Object object;
                Object object2;
                if (this.dirPath == null) {
                    throw new UserInputException("Sie m\u00fcssen im Feld 'Suchen in:' ein Verzeichnis ausw\u00e4hlen\nwelches durchsucht werden soll!");
                }
                this.findFileNamePatterns = this.parseFileNameMask();
                this.findFileSizeFrom = FindFilesFrm.parseFileSize(this.fldFileSizeFrom);
                this.findFileSizeTo = FindFilesFrm.parseFileSize(this.fldFileSizeTo);
                AtomicInteger atomicInteger = new AtomicInteger();
                this.findLastModifiedFrom = FindFilesFrm.parseTimestamp(this.fldLastModified, atomicInteger);
                AtomicInteger atomicInteger2 = new AtomicInteger();
                this.findLastModifiedTill = FindFilesFrm.parseTimestamp(this.fldLastModifiedTill, atomicInteger2);
                if (this.findLastModifiedTill != null) {
                    object2 = Calendar.getInstance();
                    ((Calendar)object2).clear();
                    ((Calendar)object2).setTimeInMillis(this.findLastModifiedTill);
                    ((Calendar)object2).add(atomicInteger2.get(), 1);
                    this.findLastModifiedTill = ((Calendar)object2).getTimeInMillis();
                }
                if (this.findLastModifiedFrom != null && this.findLastModifiedTill == null) {
                    object2 = Calendar.getInstance();
                    ((Calendar)object2).clear();
                    ((Calendar)object2).setTimeInMillis(this.findLastModifiedFrom);
                    ((Calendar)object2).add(atomicInteger.get(), 1);
                    this.findLastModifiedTill = ((Calendar)object2).getTimeInMillis();
                }
                if ((object2 = this.fldText.getText()) != null && ((String)object2).isEmpty()) {
                    object2 = null;
                }
                if (this.findFileNamePatterns == null) {
                    throw new IOException("Sie m\u00fcssen Suchkriterien eingeben,\nmindestens die Dateinamensmaske!");
                }
                this.listModel.clear();
                this.findSubTrees = this.btnSubTrees.isSelected();
                this.findIgnoreCase = !this.btnCaseSensitive.isSelected();
                this.findPrintMatchedRows = this.btnPrintMatchedRows.isSelected();
                this.findText = object2;
                if (object2 != null && this.findIgnoreCase) {
                    object = ((String)object2).toCharArray();
                    if (object != null) {
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            object[i] = Character.toUpperCase((char)object[i]);
                        }
                        this.findText = new String((char[])object);
                    } else {
                        this.findText = ((String)object2).toUpperCase();
                    }
                }
                object = this;
                synchronized (object) {
                    this.thread = new Thread(Main.getThreadGroup(), this, "JKCEMU file search");
                    this.thread.start();
                }
                this.updFieldsEnabled();
                this.btnStartStop.setText("Suche beenden");
                try {
                    Main.setLastFile(this.dirPath.toFile(), "find");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            catch (UserInputException userInputException) {
                BaseDlg.showErrorDlg((Component)this, userInputException.getMessage(), "Eingabefehler");
            }
            catch (IOException | PatternSyntaxException exception) {
                BaseDlg.showErrorDlg((Component)this, exception);
            }
        }
    }

    private void doStop() {
        this.fileVisitResult = FileVisitResult.TERMINATE;
        this.mnuStop.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveFromResult() {
        DefaultListModel<Object> defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            this.removeFromResult(this.list.getSelectedIndices());
        }
    }

    private void appendErrorToResult(Path path, IOException iOException) {
        String string;
        if (path != null && (string = path.toString()) != null && !(string = string.trim()).isEmpty()) {
            String string2 = null;
            if (iOException != null && (string2 = iOException.getMessage()) != null && ((string2 = string2.trim()).isEmpty() || string2.equalsIgnoreCase(string))) {
                string2 = null;
            }
            if (string2 != null) {
                this.appendToResult(new FindFilesCellRenderer.EmphasizedEntry("Fehler: " + string + ": " + string2), null);
            } else {
                this.appendToResult(new FindFilesCellRenderer.EmphasizedEntry("Fehler: \"" + string + "\" kann nicht gelesen werden"), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToResult(Object object, List<String> list) {
        if (this.fileVisitResult == FileVisitResult.CONTINUE && object != null) {
            DefaultListModel<Object> defaultListModel = this.listModel;
            synchronized (defaultListModel) {
                this.listModel.addElement(object);
                if (list != null) {
                    for (String string : list) {
                        this.listModel.addElement(new FindFilesCellRenderer.CodeEntry("    " + string, object instanceof FileEntry ? (FileEntry)object : null));
                    }
                }
                if (this.listModel.getSize() >= 2000) {
                    this.listModel.addElement("");
                    this.listModel.addElement(new FindFilesCellRenderer.EmphasizedEntry("Suche abgebrochen aufgrund zu vieler Eintr\u00e4ge im Suchergebnis"));
                    this.doStop();
                }
            }
        }
    }

    private boolean checkPopup(MouseEvent mouseEvent) {
        Component component;
        boolean bl = false;
        if (mouseEvent != null && mouseEvent.isPopupTrigger() && (component = mouseEvent.getComponent()) != null) {
            this.popup.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    private static void fireFilesChanged(List<FileActionMngr.FileObject> list) {
        Set<Path> set = EmuUtil.createPathSet();
        for (FileActionMngr.FileObject fileObject : list) {
            Path path = fileObject.getPath();
            if (path == null) continue;
            set.add(path);
        }
        if (!set.isEmpty()) {
            FileBrowserFrm.fireFilesChanged(set);
        }
    }

    private List<FileActionMngr.FileObject> getFileObjectList(int[] nArray) {
        int n = this.listModel.getSize();
        int n2 = n > 1 ? n : 1;
        ArrayList<FileActionMngr.FileObject> arrayList = new ArrayList<FileActionMngr.FileObject>(n2);
        HashSet<FileActionMngr.FileObject> hashSet = new HashSet<FileActionMngr.FileObject>();
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            int n3 = nArray[i];
            if (n3 < 0 || n3 >= n || (object = this.listModel.getElementAt(n3)) == null) continue;
            FileActionMngr.FileObject fileObject = null;
            if (object instanceof FileActionMngr.FileObject) {
                fileObject = (FileActionMngr.FileObject)object;
            } else if (object instanceof FindFilesCellRenderer.CodeEntry) {
                fileObject = ((FindFilesCellRenderer.CodeEntry)object).getFileObject();
            }
            if (fileObject == null || !hashSet.add(fileObject)) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    private static Long parseFileSize(JTextField jTextField) throws UserInputException {
        Long l = null;
        String string = jTextField.getText();
        if (string != null && !(string = string.trim()).isEmpty()) {
            try {
                long l2 = Long.parseLong(string);
                if (l2 < 0L) {
                    throw new UserInputException("Dateigr\u00f6\u00dfe kann nicht kleiner Null sein");
                }
                l = l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new UserInputException("Ung\u00fcltige Dateigr\u00f6\u00dfe");
            }
        }
        return l;
    }

    private static Long parseTimestamp(JTextField jTextField, AtomicInteger atomicInteger) throws UserInputException {
        Long l = null;
        String string = jTextField.getText();
        if (string != null && !(string = string.trim()).isEmpty()) {
            Object object;
            String string2 = null;
            String string3 = null;
            try {
                object = string.split("\\s");
                if (object != null) {
                    for (String string4 : object) {
                        if (string4 == null || string4.isEmpty()) continue;
                        if (string2 == null) {
                            string2 = string4;
                            continue;
                        }
                        if (string3 == null) {
                            string3 = string4;
                            continue;
                        }
                        throw new UserInputException("Ung\u00fcltige Eingabe f\u00fcr Datem/Uhrzeit");
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
            if (string2 != null) {
                if (dateFmtShort == null) {
                    dateFmtShort = DateFormat.getDateInstance(3);
                }
                if (dateFmtMedium == null) {
                    dateFmtMedium = DateFormat.getDateInstance(2);
                }
                object = new StringBuilder(20);
                int n = 5;
                Date date = null;
                try {
                    date = dateFmtShort.parse(string2);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (date == null) {
                    try {
                        date = dateFmtMedium.parse(string2);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (date == null) {
                    throw new UserInputException("Ung\u00fcltiges Datum");
                }
                ((StringBuilder)object).append(dateFmtMedium.format(date));
                l = date.getTime();
                if (string3 != null) {
                    int n2 = -1;
                    int n3 = -1;
                    int n4 = -1;
                    try {
                        int n5 = string3.length();
                        int n6 = -1;
                        int n7 = -1;
                        int n8 = -1;
                        int n9 = -1;
                        int n10 = -1;
                        int n11 = -1;
                        if (n5 == 4) {
                            n6 = 0;
                            n7 = string3.charAt(1) == ':' ? 1 : 2;
                            n8 = 2;
                            n9 = 4;
                        } else if (n5 == 5) {
                            if (string3.charAt(2) == ':') {
                                n6 = 0;
                                n7 = 2;
                                n8 = 3;
                                n9 = 5;
                            }
                        } else if (n5 == 6) {
                            n6 = 0;
                            n7 = 2;
                            n8 = 2;
                            n9 = 4;
                            n10 = 4;
                            n11 = 6;
                        } else if (n5 == 7) {
                            if (string3.charAt(1) == ':' && string3.charAt(4) == ':') {
                                n6 = 0;
                                n7 = 1;
                                n8 = 2;
                                n9 = 4;
                                n10 = 5;
                                n11 = 7;
                            }
                        } else if (n5 == 8 && string3.charAt(2) == ':' && string3.charAt(5) == ':') {
                            n6 = 0;
                            n7 = 2;
                            n8 = 3;
                            n9 = 5;
                            n10 = 6;
                            n11 = 8;
                        }
                        if (n6 >= 0 && n7 > n6 && n8 >= 0 && n9 > n8) {
                            n2 = Integer.parseInt(string3.substring(n6, n7));
                            n3 = Integer.parseInt(string3.substring(n8, n9));
                            n = 12;
                            ((StringBuilder)object).append(String.format(" %02d:%02d", n2, n3));
                            if (n10 >= 0 && n11 > n10) {
                                n4 = Integer.parseInt(string3.substring(n10, n11));
                                n = 13;
                                ((StringBuilder)object).append(String.format(":%02d", n4));
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = -1;
                    }
                    if (n2 >= 0 && n2 < 24 && n3 >= 0 && n3 < 60) {
                        l = l + (long)(n2 * 60 + n3) * 60000L;
                        if (n4 >= 0 && n4 < 60) {
                            l = l + (long)n4 * 1000L;
                        }
                    } else {
                        throw new UserInputException("Ung\u00fcltige Uhrzeit");
                    }
                }
                jTextField.setText(((StringBuilder)object).toString());
                if (atomicInteger != null) {
                    atomicInteger.set(n);
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromResult(Collection collection) {
        DefaultListModel<Object> defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            for (Object e : collection) {
                String string = e.toString();
                int n = this.listModel.size();
                for (int i = n - 1; i >= 0; --i) {
                    if (!this.listModel.get(i).toString().equals(string)) continue;
                    this.listModel.remove(i);
                }
            }
        }
    }

    private void removeFromResult(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                if (n < 0 || n >= this.listModel.size()) continue;
                this.listModel.removeElementAt(n);
            }
        }
    }

    public void searchFinished() {
        this.btnStartStop.setText("Suche starten");
        this.fldCurDir.setText("");
        if (this.fileVisitResult == FileVisitResult.CONTINUE && this.listModel.isEmpty()) {
            this.listModel.addElement("Keine Datei gefunden");
        }
        this.updFieldsEnabled();
    }

    private void showError(Exception exception) {
        BaseDlg.showErrorDlg((Component)this, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Pattern> parseFileNameMask() {
        int n;
        ArrayList<Pattern> arrayList = null;
        String string = this.fldFileNameMask.getText();
        if (string != null && (n = string.length()) > 0) {
            StringBuilder stringBuilder = new StringBuilder(n);
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                while (c == ' ' || c == ',' || c == ';') {
                    c = stringCharacterIterator.next();
                }
                while (c != '\uffff' && c != ' ' && c != ',' && c != ';') {
                    if (c == '\"') {
                        c = stringCharacterIterator.next();
                        while (c != '\uffff' && c != '\"') {
                            stringBuilder.append(c);
                            c = stringCharacterIterator.next();
                        }
                        if (c != '\"') continue;
                        c = stringCharacterIterator.next();
                        continue;
                    }
                    stringBuilder.append(c);
                    c = stringCharacterIterator.next();
                }
                if (stringBuilder.length() <= 0) continue;
                try {
                    Pattern pattern = EmuUtil.compileFileNameMask(stringBuilder.toString());
                    if (pattern == null) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Pattern>();
                    }
                    arrayList.add(pattern);
                }
                catch (PatternSyntaxException patternSyntaxException) {}
                continue;
                finally {
                    stringBuilder.setLength(0);
                }
            }
        }
        return arrayList;
    }

    private void updFieldsEnabled() {
        boolean bl = this.thread == null;
        boolean bl2 = !bl;
        this.btnRootDirSelect.setEnabled(bl);
        this.fldFileNameMask.setEnabled(bl);
        this.fldFileSizeFrom.setEnabled(bl);
        this.fldFileSizeTo.setEnabled(bl);
        this.fldLastModified.setEnabled(bl);
        this.fldLastModifiedTill.setEnabled(bl);
        this.fldText.setEnabled(bl);
        this.btnCaseSensitive.setEnabled(bl);
        this.btnPrintMatchedRows.setEnabled(bl);
        this.btnSubTrees.setEnabled(bl);
        this.labelCurDir.setEnabled(bl2);
        this.fldCurDir.setEnabled(bl2);
        this.mnuStart.setEnabled(bl);
        this.mnuStop.setEnabled(bl2);
    }

    public static class FileEntry
    implements FileActionMngr.FileObject {
        private Path path;
        private boolean wasChecked;
        private FileCheckResult checkResult;

        public FileEntry(Path path) {
            this.path = path;
            this.wasChecked = false;
            this.checkResult = null;
        }

        @Override
        public File getFile() {
            File file = null;
            try {
                file = this.path.toFile();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return file;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public FileCheckResult getCheckResult() {
            if (!this.wasChecked) {
                this.wasChecked = true;
                try {
                    this.checkResult = FileCheckResult.checkFile(this.path.toFile());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            return this.checkResult;
        }

        @Override
        public void setPath(Path path) {
            this.path = path;
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

