/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import jkcemu.filebrowser.FileActionMngr;

public class FindFilesCellRenderer
extends DefaultListCellRenderer {
    private Font defaultFont = this.getFont();
    private Font codeFont = null;

    public FindFilesCellRenderer() {
        if (this.defaultFont != null) {
            this.codeFont = new Font("Monospaced", 0, this.defaultFont.getSize());
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (component != null && this.defaultFont != null) {
            component.setFont(this.defaultFont);
            component.setForeground(bl ? Color.WHITE : Color.BLACK);
            if (object != null) {
                if (object instanceof CodeEntry) {
                    component.setForeground(bl ? Color.LIGHT_GRAY : Color.DARK_GRAY);
                    if (this.codeFont != null) {
                        component.setFont(this.codeFont);
                    }
                } else if (object instanceof EmphasizedEntry) {
                    component.setForeground(bl ? Color.YELLOW : Color.RED);
                }
            }
        }
        return component;
    }

    public static class EmphasizedEntry {
        private String text;

        public EmphasizedEntry(String string) {
            this.text = string;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class CodeEntry {
        private String text;
        private FileActionMngr.FileObject file;

        public CodeEntry(String string, FileActionMngr.FileObject fileObject) {
            this.text = string;
            this.file = fileObject;
        }

        public FileActionMngr.FileObject getFileObject() {
            return this.file;
        }

        public String toString() {
            return this.text;
        }
    }
}

