/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.audio.AudioPlayer;
import jkcemu.base.AbstractFileWorker;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.FileInfo;
import jkcemu.base.FileRemover;
import jkcemu.base.LoadDlg;
import jkcemu.base.RAMFloppy;
import jkcemu.base.ReplyFileHeadDlg;
import jkcemu.base.ScreenFrm;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.DiskImgViewFrm;
import jkcemu.disk.DiskUtil;
import jkcemu.emusys.ac1_llc2.AC1AudioCreator;
import jkcemu.emusys.ac1_llc2.SCCHAudioCreator;
import jkcemu.emusys.kc85.KCAudioCreator;
import jkcemu.emusys.z1013.Z1013AudioCreator;
import jkcemu.filebrowser.FileCheckResult;
import jkcemu.filebrowser.FileChecksumFrm;
import jkcemu.filebrowser.FileListSelection;
import jkcemu.filebrowser.FilePropDlg;
import jkcemu.filebrowser.GZipPacker;
import jkcemu.filebrowser.GZipUnpacker;
import jkcemu.filebrowser.LastModifiedDlg;
import jkcemu.filebrowser.TarPacker;
import jkcemu.filebrowser.TarUnpacker;
import jkcemu.filebrowser.ZipPacker;
import jkcemu.filebrowser.ZipUnpacker;
import jkcemu.image.ImageFrm;
import jkcemu.text.TextEditFrm;
import jkcemu.tools.fileconverter.FileConvertFrm;
import jkcemu.tools.hexdiff.HexDiffFrm;
import jkcemu.tools.hexedit.HexEditFrm;

public class FileActionMngr {
    public static final String ACTION_AUDIO_IN = "audio.in";
    public static final String ACTION_CHECKSUM = "checksum";
    public static final String ACTION_CONVERT = "convert";
    public static final String ACTION_COPY = "copy";
    public static final String ACTION_COPY_PATH = "copy.path";
    public static final String ACTION_COPY_URL = "copy.url";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_DISK_VIEW = "disk.view";
    public static final String ACTION_EMU_LOAD_OPT = "emu.load_opt";
    public static final String ACTION_EMU_LOAD = "emu.load";
    public static final String ACTION_EMU_START = "emu.start";
    public static final String ACTION_HEX_DIFF = "hex.diff";
    public static final String ACTION_HEX_EDIT = "hex.edit";
    public static final String ACTION_IMAGE_VIEW = "image.view";
    public static final String ACTION_LAST_MODIFIED = "last_modified";
    public static final String ACTION_PACK_GZIP = "pack.gzip";
    public static final String ACTION_PACK_TAR = "pack.tar";
    public static final String ACTION_PACK_TGZ = "pack.tgz";
    public static final String ACTION_PACK_ZIP = "pack.zip";
    public static final String ACTION_PLAY = "play";
    public static final String ACTION_PLAY_AC1 = "play.ac1";
    public static final String ACTION_PLAY_AC1BASIC = "play.ac1basic";
    public static final String ACTION_PLAY_KC85 = "play.kc85";
    public static final String ACTION_PLAY_SCCH = "play.scch";
    public static final String ACTION_PLAY_Z1013 = "play.z1013";
    public static final String ACTION_PLAY_Z1013HS = "play.z1013hs";
    public static final String ACTION_PLAY_Z9001 = "play.z9001";
    public static final String ACTION_PROPERTIES = "properties";
    public static final String ACTION_RENAME = "rename";
    public static final String ACTION_RF1_LOAD = "rf1.load";
    public static final String ACTION_RF2_LOAD = "rf2.load";
    public static final String ACTION_TEXT_EDIT = "text.edit";
    public static final String ACTION_UNPACK = "unpack";
    private BaseFrm owner;
    private ScreenFrm screenFrm;
    private AbstractFileWorker.PathListener pathListener;
    private Map<String, Collection<AbstractButton>> actionCmd2Btn;
    private List<AbstractFileWorker> fileWorkers;

    public FileActionMngr(BaseFrm baseFrm, ScreenFrm screenFrm, AbstractFileWorker.PathListener pathListener) {
        this.owner = baseFrm;
        this.screenFrm = screenFrm;
        this.pathListener = pathListener;
        this.actionCmd2Btn = new HashMap<String, Collection<AbstractButton>>();
        this.fileWorkers = new ArrayList<AbstractFileWorker>();
    }

    public FileActionResult actionPerformed(String string, List<FileObject> list) throws IOException {
        FileActionResult fileActionResult = FileActionResult.NONE;
        if (string != null && list != null && !list.isEmpty()) {
            fileActionResult = FileActionResult.DONE;
            if (string.equals(ACTION_COPY_PATH)) {
                this.doEditPathCopy(list);
            } else if (string.equals(ACTION_COPY_URL)) {
                this.doEditURLCopy(list);
            } else if (string.equals(ACTION_COPY)) {
                this.doEditFileCopy(list);
            } else if (string.equals(ACTION_EMU_LOAD_OPT)) {
                this.doFileLoadIntoEmu(list, true, false);
            } else if (string.equals(ACTION_EMU_LOAD)) {
                this.doFileLoadIntoEmu(list, false, false);
            } else if (string.equals(ACTION_EMU_START)) {
                this.doFileLoadIntoEmu(list, false, true);
            } else if (string.equals(ACTION_RF1_LOAD)) {
                EmuThread emuThread = this.getEmuThread();
                if (emuThread != null) {
                    this.doFileRAMFloppyLoad(list, emuThread.getRAMFloppy1());
                }
            } else if (string.equals(ACTION_RF2_LOAD)) {
                EmuThread emuThread = this.getEmuThread();
                if (emuThread != null) {
                    this.doFileRAMFloppyLoad(list, emuThread.getRAMFloppy2());
                }
            } else if (string.equals(ACTION_TEXT_EDIT)) {
                this.doFileEditText(list);
            } else if (string.equals(ACTION_IMAGE_VIEW)) {
                this.doFileShowImage(list);
            } else if (string.equals(ACTION_DISK_VIEW)) {
                this.doFileShowDisk(list);
            } else if (string.equals(ACTION_HEX_EDIT)) {
                this.doFileEditHex(list);
            } else if (string.equals(ACTION_HEX_DIFF)) {
                this.doFileDiffHex(list);
            } else if (string.equals(ACTION_CONVERT)) {
                this.doFileConvert(list);
            } else if (string.equals(ACTION_AUDIO_IN)) {
                this.doFileAudioIn(list);
            } else if (string.equals(ACTION_PLAY)) {
                this.doFilePlay(list);
            } else if (string.equals(ACTION_PLAY_AC1)) {
                this.doFilePlayAC1(list);
            } else if (string.equals(ACTION_PLAY_AC1BASIC)) {
                this.doFilePlayAC1Basic(list);
            } else if (string.equals(ACTION_PLAY_SCCH)) {
                this.doFilePlaySCCH(list);
            } else if (string.equals(ACTION_PLAY_KC85)) {
                this.doFilePlayKC(list, 1);
            } else if (string.equals(ACTION_PLAY_Z1013)) {
                this.doFilePlayZ1013(list, false);
            } else if (string.equals(ACTION_PLAY_Z1013HS)) {
                this.doFilePlayZ1013(list, true);
            } else if (string.equals(ACTION_PLAY_Z9001)) {
                this.doFilePlayKC(list, 0);
            } else if (string.equals(ACTION_PACK_TAR)) {
                this.doFilePackTar(list, false);
            } else if (string.equals(ACTION_PACK_TGZ)) {
                this.doFilePackTar(list, true);
            } else if (string.equals(ACTION_PACK_ZIP)) {
                this.doFilePackZip(list);
            } else if (string.equals(ACTION_PACK_GZIP)) {
                this.doFilePackGZip(list);
            } else if (string.equals(ACTION_UNPACK)) {
                this.doFileUnpack(list);
            } else if (string.equals(ACTION_CHECKSUM)) {
                this.doFileChecksum(list);
            } else if (string.equals(ACTION_LAST_MODIFIED)) {
                if (LastModifiedDlg.open(this.owner, this.getPaths(list))) {
                    fileActionResult = FileActionResult.FILES_CHANGED;
                }
            } else if (string.equals(ACTION_RENAME)) {
                if (this.doFileRename(list)) {
                    fileActionResult = FileActionResult.FILE_RENAMED;
                }
            } else if (string.equals(ACTION_DELETE)) {
                this.doFileDelete(list);
            } else if (string.equals(ACTION_PROPERTIES)) {
                this.doFileProp(list);
            } else {
                fileActionResult = FileActionResult.NONE;
            }
        }
        return fileActionResult;
    }

    public void addCopyFileNameMenuItemsTo(JPopupMenu jPopupMenu, JMenu jMenu) {
        this.addJMenuItem("Vollst\u00e4ndige Datei-/Verzeichnisnamen kopieren", ACTION_COPY_PATH, jPopupMenu, jMenu);
        this.addJMenuItem("Datei-/Verzeichnisnamen als URL kopieren", ACTION_COPY_URL, jPopupMenu, jMenu);
    }

    public void addCopyFileMenuItemTo(JPopupMenu jPopupMenu, JMenu jMenu) {
        this.addJMenuItem("Dateien/Verzeichnisse kopieren", ACTION_COPY, jPopupMenu, jMenu);
    }

    public void addFileMenuItemsTo(JPopupMenu jPopupMenu, JMenu jMenu) {
        this.addJMenuItem("Im Texteditor \u00f6ffnen...", ACTION_TEXT_EDIT, 69, 2, jPopupMenu, jMenu);
        this.addJMenuItem("Im Bildbetrachter anzeigen...", ACTION_IMAGE_VIEW, 66, 2, jPopupMenu, jMenu);
        this.addJMenuItem("Im Diskettenabbilddatei-Insprektor anzeigen...", ACTION_DISK_VIEW, jPopupMenu, jMenu);
        this.addJMenuItem("Im Hex-Editor \u00f6ffnen...", ACTION_HEX_EDIT, jPopupMenu, jMenu);
        this.addJMenuItem("Im Hex-Dateivergleicher \u00f6ffnen...", ACTION_HEX_DIFF, jPopupMenu, jMenu);
        this.addJMenuItem("Im Dateikonverter \u00f6ffnen...", ACTION_CONVERT, jPopupMenu, jMenu);
        this.addJMenuItem("In Audio/Kassette \u00f6ffnen...", ACTION_AUDIO_IN, jPopupMenu, jMenu);
        this.addJMenuItem("Wiedergeben", ACTION_PLAY, jPopupMenu, jMenu);
        JMenu jMenu2 = null;
        JMenu jMenu3 = null;
        if (jMenu != null) {
            jMenu2 = new JMenu("Wiedergeben im");
            jMenu.add(jMenu2);
        }
        if (jPopupMenu != null) {
            jMenu3 = new JMenu("Wiedergeben im");
            jPopupMenu.add(jMenu3);
        }
        this.addJMenuItem("AC1-Format", ACTION_PLAY_AC1, null, jMenu3, jMenu2);
        this.addJMenuItem("AC1-BASIC-Format", ACTION_PLAY_AC1, null, jMenu3, jMenu2);
        this.addJMenuItem("AC1/LLC2-TurboSave-Format", ACTION_PLAY_SCCH, null, jMenu3, jMenu2);
        this.addJMenuItem("KC-Format (HC900, KC85/2..5, KC-BASIC)", ACTION_PLAY_KC85, null, jMenu3, jMenu2);
        this.addJMenuItem("KC-Format (KC85/1, KC87, Z9001)", ACTION_PLAY_Z9001, null, jMenu3, jMenu2);
        this.addJMenuItem("Z1013-Format", ACTION_PLAY_Z1013, null, jMenu3, jMenu2);
        this.addJMenuItem("Z1013-Headersave-Format", ACTION_PLAY_Z1013HS, null, jMenu3, jMenu2);
        JMenu jMenu4 = null;
        JMenu jMenu5 = null;
        if (jMenu != null) {
            jMenu4 = new JMenu("Packen in");
            jMenu.add(jMenu4);
        }
        if (jPopupMenu != null) {
            jMenu5 = new JMenu("Packen in");
            jPopupMenu.add(jMenu5);
        }
        this.addJMenuItem("TAR-Archiv...", ACTION_PACK_TAR, null, jMenu5, jMenu4);
        this.addJMenuItem("TGZ-Archiv...", ACTION_PACK_TGZ, null, jMenu5, jMenu4);
        this.addJMenuItem("ZIP-Archiv...", ACTION_PACK_ZIP, null, jMenu5, jMenu4);
        FileActionMngr.addSeparator(null, jMenu5, jMenu4);
        this.addJMenuItem("GZip-Datei...", ACTION_PACK_GZIP, null, jMenu5, jMenu4);
        this.addJMenuItem("Entpacken...", ACTION_UNPACK, jPopupMenu, jMenu);
        FileActionMngr.addSeparator(jPopupMenu, jMenu);
        this.addJMenuItem("Pr\u00fcfsumme/Hash-Wert berechnen...", ACTION_CHECKSUM, jPopupMenu, jMenu);
        this.addJMenuItem("\u00c4nderungszeitpunkt setzen...", ACTION_LAST_MODIFIED, jPopupMenu, jMenu);
        this.addJMenuItem("Umbenennen...", ACTION_RENAME, jPopupMenu, jMenu);
        this.addJMenuItem("L\u00f6schen", ACTION_DELETE, jPopupMenu, jMenu);
        FileActionMngr.addSeparator(jPopupMenu, jMenu);
        this.addJMenuItem("Eigenschaften...", ACTION_PROPERTIES, jPopupMenu, jMenu);
    }

    public void addLoadIntoEmuMenuItemsTo(JPopupMenu jPopupMenu, JMenu jMenu) {
        this.addJMenuItem("In Emulator laden mit...", ACTION_EMU_LOAD_OPT, 76, 2, jPopupMenu, jMenu);
        this.addJMenuItem("In Emulator laden", ACTION_EMU_LOAD, 76, 3, jPopupMenu, jMenu);
        this.addJMenuItem("Im Emulator starten", ACTION_EMU_START, 82, 2, jPopupMenu, jMenu);
        FileActionMngr.addSeparator(jPopupMenu, jMenu);
        this.addJMenuItem("In RAM-Floppy 1 laden", ACTION_RF1_LOAD, jPopupMenu, jMenu);
        this.addJMenuItem("In RAM-Floppy 2 laden", ACTION_RF2_LOAD, jPopupMenu, jMenu);
    }

    public JButton createEditTextButton() {
        return this.createAndRegisterImageButton("/images/file/edit.png", "Im Texteditor \u00f6ffnen", ACTION_TEXT_EDIT);
    }

    public JButton createLoadIntoEmuButton() {
        return this.createAndRegisterImageButton("/images/file/load.png", "In Emulator laden", ACTION_EMU_LOAD);
    }

    public JButton createPlayButton() {
        return this.createAndRegisterImageButton("/images/file/play.png", "Wiedergeben", ACTION_PLAY);
    }

    public JButton createStartInEmuButton() {
        return this.createAndRegisterImageButton("/images/file/start.png", "Im Emulator starten", ACTION_EMU_START);
    }

    public JButton createViewImageButton() {
        return this.createAndRegisterImageButton("/images/file/image.png", "Im Bildbetrachter anzeigen", ACTION_IMAGE_VIEW);
    }

    public boolean doFileAction(FileObject fileObject) throws IOException {
        File file;
        boolean bl = false;
        if (fileObject != null && (file = fileObject.getFile()) != null && file.isFile()) {
            Object object;
            String string;
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (fileCheckResult != null) {
                if (fileCheckResult.isArchiveFile() || fileCheckResult.isCompressedFile()) {
                    this.doFileUnpack(fileObject);
                    bl = true;
                } else if (fileCheckResult.isAudioFile()) {
                    AudioPlayer.play(this.owner, file);
                    bl = true;
                } else if (fileCheckResult.isImageFile()) {
                    ImageFrm.open(file);
                    bl = true;
                } else if (fileCheckResult.isTextFile()) {
                    TextEditFrm.open(this.getEmuThread()).openFile(file);
                    bl = true;
                }
            }
            string = (string = file.getName()) != null ? string.toLowerCase() : "";
            if (!bl && string.endsWith(".prj")) {
                object = TextEditFrm.loadProject(file);
                if (object != null) {
                    TextEditFrm.open(this.getEmuThread()).openProject(file, (Properties)object);
                    bl = true;
                } else {
                    throw new IOException("Die PRJ-Datei ist keine JKCEMU-Projektdatei.");
                }
            }
            if (!bl && fileCheckResult != null) {
                FileFormat fileFormat;
                boolean bl2 = false;
                FileInfo fileInfo = fileCheckResult.getFileInfo();
                if (fileInfo != null && (fileFormat = fileInfo.getFileFormat()) != null && !fileFormat.equals(FileFormat.BIN)) {
                    bl2 = true;
                }
                if (string.endsWith(".bin")) {
                    bl2 = true;
                }
                if (bl2 && this.screenFrm != null) {
                    LoadDlg.loadFile(this.owner, this.screenFrm, file, true, true, fileCheckResult.isStartableFile());
                    bl = true;
                }
            }
            if (!bl && file.canRead()) {
                try {
                    if (Desktop.isDesktopSupported() && (object = Desktop.getDesktop()) != null && ((Desktop)object).isSupported(Desktop.Action.OPEN)) {
                        ((Desktop)object).open(file);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    BaseDlg.showErrorDlg((Component)this.owner, exception);
                }
            }
        }
        return bl;
    }

    public List<AbstractFileWorker> getFileWorkers() {
        return this.fileWorkers;
    }

    public void updActionButtonsEnabled(List<FileObject> list) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        boolean bl20 = false;
        boolean bl21 = false;
        boolean bl22 = false;
        FileCheckResult fileCheckResult = null;
        if (list != null) {
            int n = list.size();
            if (n == 1) {
                FileObject fileObject = list.get(0);
                File file = fileObject.getFile();
                if (file != null) {
                    bl15 = file.isFile();
                }
                fileCheckResult = fileObject.getCheckResult();
                bl14 = true;
            }
            if (n > 0) {
                bl16 = true;
            }
        }
        if (fileCheckResult != null) {
            FileInfo fileInfo;
            bl = fileCheckResult.isAudioFile() || fileCheckResult.isTapeFile();
            bl2 = fileCheckResult.isNonPlainDiskFile() || fileCheckResult.isPlainDiskFile();
            bl3 = fileCheckResult.isImageFile();
            bl4 = fileCheckResult.isStartableFile();
            bl5 = fileCheckResult.isArchiveFile() || fileCheckResult.isCompressedFile() || bl2;
            bl6 = fileCheckResult.isHeadersaveFile();
            bl7 = fileCheckResult.isBinFile();
            bl8 = fileCheckResult.isKCBasicHeadFile();
            bl9 = fileCheckResult.isKCBasicFile();
            bl10 = fileCheckResult.isKCSysFile();
            bl11 = fileCheckResult.isKC85TapFile();
            bl12 = fileCheckResult.isZ9001TapFile();
            bl13 = false;
            if (bl6 && (fileInfo = fileCheckResult.getFileInfo()) != null && fileInfo.getBegAddr() == 24823 && fileInfo.getFileType() == 66) {
                bl13 = true;
            }
            bl17 = bl15 && bl4;
            bl18 = bl15 && bl;
            bl19 = bl15 && bl2;
            bl20 = bl15 && bl3;
            bl21 = bl15 && !bl20 && !bl18;
            bl22 = bl15 && bl5;
        }
        this.setActionBtnsEnabled(ACTION_COPY_PATH, bl16);
        this.setActionBtnsEnabled(ACTION_COPY_URL, bl16);
        this.setActionBtnsEnabled(ACTION_COPY, bl16);
        this.setActionBtnsEnabled(ACTION_EMU_LOAD_OPT, bl15);
        this.setActionBtnsEnabled(ACTION_EMU_LOAD, bl15);
        this.setActionBtnsEnabled(ACTION_EMU_START, bl15);
        this.setActionBtnsEnabled(ACTION_RF1_LOAD, bl15);
        this.setActionBtnsEnabled(ACTION_RF2_LOAD, bl15);
        this.setActionBtnsEnabled(ACTION_TEXT_EDIT, bl21);
        this.setActionBtnsEnabled(ACTION_IMAGE_VIEW, bl20);
        this.setActionBtnsEnabled(ACTION_DISK_VIEW, bl19);
        this.setActionBtnsEnabled(ACTION_HEX_EDIT, bl15);
        this.setActionBtnsEnabled(ACTION_HEX_DIFF, bl16);
        this.setActionBtnsEnabled(ACTION_AUDIO_IN, bl || bl11 || bl12);
        this.setActionBtnsEnabled(ACTION_PLAY, bl18);
        this.setActionBtnsEnabled(ACTION_PLAY_AC1, bl7);
        this.setActionBtnsEnabled(ACTION_PLAY_AC1BASIC, bl13);
        this.setActionBtnsEnabled(ACTION_PLAY_SCCH, bl7 || bl13);
        this.setActionBtnsEnabled(ACTION_PLAY_KC85, bl8 || bl9 || bl10 || bl11);
        this.setActionBtnsEnabled(ACTION_PLAY_Z9001, bl10 || bl12);
        this.setActionBtnsEnabled(ACTION_PLAY_Z1013, bl7);
        this.setActionBtnsEnabled(ACTION_PLAY_Z1013HS, bl6);
        this.setActionBtnsEnabled(ACTION_PACK_TAR, bl16);
        this.setActionBtnsEnabled(ACTION_PACK_TGZ, bl16);
        this.setActionBtnsEnabled(ACTION_PACK_ZIP, bl16);
        this.setActionBtnsEnabled(ACTION_PACK_GZIP, bl15);
        this.setActionBtnsEnabled(ACTION_UNPACK, bl22);
        this.setActionBtnsEnabled(ACTION_CONVERT, bl15);
        this.setActionBtnsEnabled(ACTION_CHECKSUM, bl16);
        this.setActionBtnsEnabled(ACTION_LAST_MODIFIED, bl16);
        this.setActionBtnsEnabled(ACTION_RENAME, bl14);
        this.setActionBtnsEnabled(ACTION_DELETE, bl16);
        this.setActionBtnsEnabled(ACTION_PROPERTIES, bl14);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEditFileCopy(List<FileObject> list) {
        List<File> list2 = this.getFiles(list, false);
        int n = list2.size();
        if (n > 0) {
            int n2 = 0;
            try {
                Clipboard clipboard;
                Toolkit toolkit = this.owner.getToolkit();
                if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                    FileListSelection fileListSelection = new FileListSelection(list2);
                    clipboard.setContents(fileListSelection, fileListSelection);
                    n2 = n;
                }
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this.owner, exception);
                n = 0;
            }
            finally {
                this.checkShowCopyError(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEditPathCopy(List<FileObject> list) {
        int n = list.size();
        if (n > 0) {
            int n2 = 0;
            try {
                Clipboard clipboard;
                Toolkit toolkit = this.owner.getToolkit();
                if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                    StringBuilder stringBuilder = new StringBuilder(n * 256);
                    for (FileObject fileObject : list) {
                        String string;
                        Path path = fileObject.getPath();
                        if (path == null || (string = path.toAbsolutePath().normalize().toString()) == null || string.isEmpty()) continue;
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('\n');
                            ++n2;
                        }
                        stringBuilder.append(string);
                    }
                    if (stringBuilder.length() > 0) {
                        if (n2 > 1) {
                            stringBuilder.append('\n');
                        }
                        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
                        clipboard.setContents(stringSelection, stringSelection);
                    }
                }
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this.owner, exception);
                n = 0;
            }
            finally {
                this.checkShowCopyError(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEditURLCopy(List<FileObject> list) {
        int n = list.size();
        if (n > 0) {
            int n2 = 0;
            try {
                Clipboard clipboard;
                Toolkit toolkit = this.owner.getToolkit();
                if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder(n * 256);
                    for (FileObject fileObject : list) {
                        String string;
                        URL uRL;
                        URI uRI;
                        File file = fileObject.getFile();
                        if (file == null || (uRI = file.toURI()) == null || (uRL = uRI.toURL()) == null || (string = uRI.toString()) == null || string.isEmpty()) continue;
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('\n');
                            ++n2;
                        }
                        stringBuilder.append(string);
                    }
                    if (stringBuilder.length() > 0) {
                        if (n2 > 1) {
                            stringBuilder.append('\n');
                        }
                        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
                        clipboard.setContents(stringSelection, stringSelection);
                    }
                }
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this.owner, exception);
                n = 0;
            }
            finally {
                this.checkShowCopyError(n, n2);
            }
        }
    }

    private void doFileAudioIn(List<FileObject> list) {
        if (this.screenFrm != null && list.size() == 1) {
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && (fileCheckResult.isAudioFile() || fileCheckResult.isTapeFile())) {
                this.screenFrm.openAudioInFile(file);
            }
        }
    }

    private void doFileChecksum(List<FileObject> list) {
        List<File> list2 = this.getFiles(list, true);
        if (!list2.isEmpty()) {
            FileChecksumFrm.open(list2);
        }
    }

    private void doFileConvert(List<FileObject> list) {
        File file = this.getFile(list, true);
        if (file != null && file.isFile()) {
            FileConvertFrm.open(file);
        }
    }

    private void doFileDelete(List<FileObject> list) {
        List<Path> list2 = this.getPaths(list);
        if (!list2.isEmpty()) {
            FileRemover.startRemove(this.owner, list2, this.pathListener, this.fileWorkers);
        }
    }

    private void doFileDiffHex(List<FileObject> list) {
        List<File> list2 = this.getFiles(list, true);
        if (!list2.isEmpty()) {
            HexDiffFrm.open().addFiles(list2);
        }
    }

    private void doFileEditHex(List<FileObject> list) {
        File file = this.getFile(list, true);
        if (file != null && file.isFile()) {
            HexEditFrm.open(file);
        }
    }

    private void doFileEditText(List<FileObject> list) {
        File file = this.getFile(list, true);
        if (file != null && file.isFile()) {
            TextEditFrm.open(this.getEmuThread()).openFile(file);
        }
    }

    private void doFileLoadIntoEmu(List<FileObject> list, boolean bl, boolean bl2) {
        File file;
        if (this.screenFrm != null && (file = this.getFile(list, true)) != null && file.isFile()) {
            LoadDlg.loadFile(this.owner, this.screenFrm, file, bl, true, bl2);
        }
    }

    private void doFilePackGZip(List<FileObject> list) {
        File file = this.getFile(list, true);
        if (file != null) {
            File file2;
            String string = file.getName();
            if (string != null) {
                string = string + ".gz";
            }
            if ((file2 = this.askForOutputFile(file, "GZip-Datei speichern", string)) != null) {
                GZipPacker.packFile(this.owner, file, file2);
            }
        }
    }

    private void doFilePackTar(List<FileObject> list, boolean bl) {
        String string;
        Path path;
        Path path2;
        List<Path> list2 = this.getPaths(list);
        if (!list2.isEmpty() && (path2 = (path = list2.get(0)).getFileName()) != null && (string = path2.toString()) != null) {
            int n = string.indexOf(46);
            if (n == 0 && string.length() > 1) {
                n = string.indexOf(46, 1);
            }
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (!string.isEmpty()) {
                string = bl ? string + ".tgz" : string + ".tar";
            }
            try {
                File file = this.askForOutputFile(path.toFile(), bl ? "TGZ-Datei speichern" : "TAR-Datei speichern", string);
                if (file != null) {
                    TarPacker.packFiles(this.owner, list2, file, bl);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private void doFilePackZip(List<FileObject> list) {
        String string;
        Path path;
        Path path2;
        List<Path> list2 = this.getPaths(list);
        if (!list2.isEmpty() && (path2 = (path = list2.get(0)).getFileName()) != null && (string = path2.toString()) != null) {
            int n = string.indexOf(46);
            if (n == 0 && string.length() > 1) {
                n = string.indexOf(46, 1);
            }
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (!string.isEmpty()) {
                string = string + ".zip";
            }
            try {
                File file = this.askForOutputFile(path.toFile(), "ZIP-Datei speichern", string);
                if (file != null) {
                    ZipPacker.packFiles(this.owner, list2, file);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private void doFilePlay(List<FileObject> list) {
        if (list.size() == 1) {
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && (fileCheckResult.isAudioFile() || fileCheckResult.isTapeFile())) {
                AudioPlayer.play(this.owner, file);
            }
        }
    }

    private void doFilePlayAC1(List<FileObject> list) throws IOException {
        if (list.size() == 1) {
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && fileCheckResult.isBinFile()) {
                String string = "AC1-Wiedergabe von " + file.getName();
                ReplyFileHeadDlg replyFileHeadDlg = new ReplyFileHeadDlg(this.owner, file.getName(), "Wiedergeben", string, ReplyFileHeadDlg.Option.BEGIN_ADDRESS, ReplyFileHeadDlg.Option.START_ADDRESS, ReplyFileHeadDlg.Option.FILE_NAME_16);
                replyFileHeadDlg.setVisible(true);
                if (replyFileHeadDlg.wasApproved()) {
                    int n = replyFileHeadDlg.getApprovedStartAddress();
                    if (n < 0) {
                        n = 0;
                    }
                    AudioPlayer.play(this.owner, new AC1AudioCreator(false, EmuUtil.readFile(file, true, 65536), replyFileHeadDlg.getApprovedFileName(), replyFileHeadDlg.getApprovedBeginAddress(), n).newReader(), string + "...");
                }
            }
        }
    }

    private void doFilePlayAC1Basic(List<FileObject> list) throws IOException {
        if (list.size() == 1) {
            byte[] byArray;
            int n;
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && (fileCheckResult.isBinFile() || fileCheckResult.isHeadersaveFile()) && (n = (byArray = EmuUtil.readFile(file, true, 65536)).length) > 0) {
                String string;
                String string2 = file.getName();
                int n2 = 0;
                if (n > 32 && byArray[13] == -45 && byArray[14] == -45 && byArray[15] == -45) {
                    n2 += 32;
                    n -= 32;
                    string = EmuUtil.extractSingleAsciiLine(byArray, 16, 16);
                    if (string != null) {
                        string2 = string;
                    }
                }
                string = "AC1-BASIC-Wiedergabe von " + file.getName();
                ReplyFileHeadDlg replyFileHeadDlg = new ReplyFileHeadDlg(this.owner, string2, "Wiedergeben", string, ReplyFileHeadDlg.Option.FILE_NAME_6);
                replyFileHeadDlg.setVisible(true);
                if (replyFileHeadDlg.wasApproved()) {
                    AudioPlayer.play(this.owner, new AC1AudioCreator(true, byArray, n2, n, replyFileHeadDlg.getApprovedFileName(), -1, -1).newReader(), string + "...");
                }
            }
        }
    }

    private void doFilePlayKC(List<FileObject> list, int n) throws IOException {
        if (list.size() == 1) {
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null) {
                String string = "KC-Wiedergabe von " + file.getName() + "...";
                if (fileCheckResult.isKCBasicHeadFile()) {
                    AudioPlayer.play(this.owner, new KCAudioCreator(false, 1, EmuUtil.readFile(file, true, 65536)).newReader(), string);
                } else if (fileCheckResult.isKCBasicFile()) {
                    byte[] byArray = EmuUtil.readFile(file, true, 65536);
                    if (byArray != null && byArray.length > 0) {
                        ReplyFileHeadDlg replyFileHeadDlg = new ReplyFileHeadDlg(this.owner, file.getName(), "Wiedergeben", string, ReplyFileHeadDlg.Option.FILE_NAME_8);
                        replyFileHeadDlg.setVisible(true);
                        if (replyFileHeadDlg.wasApproved()) {
                            String string2 = replyFileHeadDlg.getApprovedFileName();
                            byte[] byArray2 = new byte[byArray.length + 11];
                            int n2 = 0;
                            byArray2[n2++] = -45;
                            byArray2[n2++] = -45;
                            byArray2[n2++] = -45;
                            if (string2 != null) {
                                int n3 = string2.length();
                                int n4 = 0;
                                while (n2 < 11 && n4 < n3) {
                                    byArray2[n2++] = (byte)(string2.charAt(n4++) & 0x7F);
                                }
                            }
                            while (n2 < 11) {
                                byArray2[n2++] = 32;
                            }
                            AudioPlayer.play(this.owner, new KCAudioCreator(false, 1, byArray2).newReader(), string);
                        }
                    }
                } else if (fileCheckResult.isKCSysFile()) {
                    AudioPlayer.play(this.owner, new KCAudioCreator(false, n, EmuUtil.readFile(file, true, 65536)).newReader(), string);
                } else if (fileCheckResult.isKC85TapFile() && n == 1 || fileCheckResult.isZ9001TapFile() && n == 0) {
                    AudioPlayer.play(this.owner, new KCAudioCreator(true, 0, EmuUtil.readFile(file, true, 65536)).newReader(), string);
                }
            }
        }
    }

    private void doFilePlaySCCH(List<FileObject> list) throws IOException {
        if (list.size() == 1) {
            byte[] byArray;
            int n;
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && (fileCheckResult.isBinFile() || fileCheckResult.isHeadersaveFile()) && (n = (byArray = EmuUtil.readFile(file, true, 65536)).length) > 0) {
                String string;
                ReplyFileHeadDlg.Option[] optionArray = null;
                String string2 = file.getName();
                int n2 = 0;
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                if (n > 32 && byArray[13] == -45 && byArray[14] == -45 && byArray[15] == -45) {
                    n2 += 32;
                    n -= 32;
                    n3 = EmuUtil.getWord(byArray, 0);
                    n4 = EmuUtil.getWord(byArray, 2);
                    if (n3 == 24823 && byArray[12] == 66) {
                        n5 = 66;
                        optionArray = new ReplyFileHeadDlg.Option[]{ReplyFileHeadDlg.Option.FILE_NAME_16};
                    } else {
                        optionArray = new ReplyFileHeadDlg.Option[]{ReplyFileHeadDlg.Option.FILE_NAME_16, ReplyFileHeadDlg.Option.SCCH_FILE_TYPE};
                    }
                    string = EmuUtil.extractSingleAsciiLine(byArray, 16, 16);
                    if (string != null) {
                        string2 = string;
                    }
                }
                if (optionArray == null) {
                    optionArray = new ReplyFileHeadDlg.Option[]{ReplyFileHeadDlg.Option.BEGIN_ADDRESS, ReplyFileHeadDlg.Option.END_ADDRESS, ReplyFileHeadDlg.Option.FILE_NAME_16, ReplyFileHeadDlg.Option.SCCH_FILE_TYPE};
                }
                string = "AC1/LLC2-TurboSave-Wiedergabe von " + file.getName();
                ReplyFileHeadDlg replyFileHeadDlg = new ReplyFileHeadDlg(this.owner, string2, "Wiedergeben", string, optionArray);
                replyFileHeadDlg.setVisible(true);
                if (replyFileHeadDlg.wasApproved()) {
                    if (n3 < 0) {
                        n3 = replyFileHeadDlg.getApprovedBeginAddress();
                    }
                    if (n4 < 0 && (n4 = replyFileHeadDlg.getApprovedEndAddress()) < 0) {
                        n4 = n3 + n - 1;
                    }
                    if (n5 < 0) {
                        n5 = replyFileHeadDlg.getApprovedSCCHFileType();
                    }
                    AudioPlayer.play(this.owner, new SCCHAudioCreator(byArray, n2, n, replyFileHeadDlg.getApprovedFileName(), (char)n5, n3, n4).newReader(), string + "...");
                }
            }
        }
    }

    private void doFilePlayZ1013(List<FileObject> list, boolean bl) throws IOException {
        if (list.size() == 1) {
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && (fileCheckResult.isBinFile() || bl && fileCheckResult.isHeadersaveFile())) {
                AudioPlayer.play(this.owner, new Z1013AudioCreator(bl, EmuUtil.readFile(file, true, 65568)).newReader(), String.format("Z1013%s-Wiedergabe von %s...", bl ? "-Headersave" : "", file.getName()));
            }
        }
    }

    private void doFileProp(List<FileObject> list) throws IOException {
        Path path = this.getPath(list);
        if (path != null) {
            new FilePropDlg((Frame)this.owner, path).setVisible(true);
        }
    }

    private void doFileRAMFloppyLoad(List<FileObject> list, RAMFloppy rAMFloppy) {
        File file = this.getFile(list, true);
        if (file != null) {
            try {
                rAMFloppy.load(file);
                Main.setLastFile(file, "ramfloppy");
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this.owner, "Die RAM-Floppy kann nicht geladen werden.\n\n" + iOException.getMessage());
            }
        }
    }

    private boolean doFileRename(List<FileObject> list) {
        FileObject fileObject;
        Path path;
        boolean bl = false;
        if (list.size() == 1 && (path = (fileObject = list.get(0)).getPath()) != null && (path = EmuUtil.renamePath(this.owner, path)) != null) {
            fileObject.setPath(path);
            bl = true;
        }
        return bl;
    }

    private void doFileShowDisk(List<FileObject> list) {
        if (list.size() == 1) {
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && (fileCheckResult.isNonPlainDiskFile() || fileCheckResult.isPlainDiskFile())) {
                DiskImgViewFrm.open(file);
            }
        }
    }

    private void doFileShowImage(List<FileObject> list) {
        if (list.size() == 1) {
            FileObject fileObject = list.get(0);
            File file = fileObject.getFile();
            FileCheckResult fileCheckResult = fileObject.getCheckResult();
            if (file != null && fileCheckResult != null && fileCheckResult.isImageFile()) {
                ImageFrm.open(file);
            }
        }
    }

    private void doFileUnpack(FileObject fileObject) throws IOException {
        String string;
        File file;
        if (fileObject != null && (file = fileObject.getFile()) != null && (string = file.getName()) != null && file.isFile()) {
            String string2 = string.toUpperCase();
            if (string2.endsWith(".GZ")) {
                File file2 = this.askForOutputFile(file, "Entpackte Datei speichern", string.substring(0, string.length() - 3));
                if (file2 != null) {
                    GZipUnpacker.unpackFile(this.owner, file, file2);
                }
            } else if (string2.endsWith(".TAR") || string2.endsWith(".TGZ")) {
                File file3 = EmuUtil.askForOutputDir(this.owner, file, "Entpacken nach:", "Archiv-Datei entpacken");
                if (file3 != null) {
                    TarUnpacker.unpackFile(this.owner, file, file3, string2.endsWith(".TGZ"));
                }
            } else if (string2.endsWith(".JAR") || string2.endsWith(".ZIP")) {
                File file4 = EmuUtil.askForOutputDir(this.owner, file, "Entpacken nach:", "Archiv-Datei entpacken");
                if (file4 != null) {
                    ZipUnpacker.unpackFile(this.owner, file, file4);
                }
            } else {
                FileCheckResult fileCheckResult = fileObject.getCheckResult();
                if (fileCheckResult != null) {
                    AbstractFloppyDisk abstractFloppyDisk;
                    if (fileCheckResult.isPlainDiskFile()) {
                        DiskUtil.unpackPlainDiskFile(this.owner, file);
                    } else if (fileCheckResult.isNonPlainDiskFile() && (abstractFloppyDisk = DiskUtil.readNonPlainDiskFile(this.owner, file, true)) != null && DiskUtil.checkAndConfirmWarning(this.owner, abstractFloppyDisk)) {
                        DiskUtil.unpackDisk(this.owner, file, abstractFloppyDisk, true);
                    }
                }
            }
        }
    }

    private void doFileUnpack(List<FileObject> list) throws IOException {
        if (list.size() == 1) {
            this.doFileUnpack(list.get(0));
        }
    }

    private File askForOutputFile(File file, String string, String string2) {
        File file2 = null;
        File file3 = file.getParentFile();
        file2 = string2 != null ? (file3 != null ? new File(file3, string2) : new File(string2)) : file3;
        File file4 = EmuUtil.showFileSaveDlg(this.owner, string, file2, new FileFilter[0]);
        if (file4 != null && file4.exists()) {
            if (file4.equals(file)) {
                BaseDlg.showErrorDlg((Component)this.owner, "Die Ausgabedatei kann nicht\nmit der Quelldatei identisch sein.");
                file4 = null;
            } else if (!file4.isFile()) {
                BaseDlg.showErrorDlg((Component)this.owner, file4.getPath() + " existiert bereits\n" + "und kann nicht als Datei angelegt werden.");
                file4 = null;
            }
        }
        return file4;
    }

    private void addJMenuItem(String string, String string2, JPopupMenu jPopupMenu, JMenu ... jMenuArray) {
        this.addJMenuItem(string, string2, null, jPopupMenu, jMenuArray);
    }

    private void addJMenuItem(String string, String string2, int n, int n2, JPopupMenu jPopupMenu, JMenu ... jMenuArray) {
        this.addJMenuItem(string, string2, KeyStroke.getKeyStroke(n, n2), jPopupMenu, jMenuArray);
    }

    private void addJMenuItem(String string, String string2, KeyStroke keyStroke, JPopupMenu jPopupMenu, JMenu ... jMenuArray) {
        if (jPopupMenu != null) {
            jPopupMenu.add(this.createAndRegisterJMenuItem(string, string2, keyStroke));
        }
        if (jMenuArray != null) {
            for (JMenu jMenu : jMenuArray) {
                if (jMenu == null) continue;
                jMenu.add(this.createAndRegisterJMenuItem(string, string2, keyStroke));
            }
        }
    }

    private static void addSeparator(JPopupMenu jPopupMenu, JMenu ... jMenuArray) {
        if (jPopupMenu != null) {
            jPopupMenu.addSeparator();
        }
        if (jMenuArray != null) {
            for (JMenu jMenu : jMenuArray) {
                if (jMenu == null) continue;
                jMenu.addSeparator();
            }
        }
    }

    private void checkShowCopyError(int n, int n2) {
        if (n > 0 && n2 < n) {
            String string = null;
            string = n2 == 1 ? "Es konnte nur eine Datei bzw. ein Verzeichnis kopiert werden." : (n2 > 1 ? String.format("Es konnten nur %d Dateien bzw. Verzeichnisse kopiert werden.", n2) : (n == 1 ? "Die Datei bzw. das Verzeichnis\nkonnte nicht kopiert werden." : "Die Dateien bzw. Verzeichnisse\nkonnten nicht kopiert werden."));
            if (string != null) {
                BaseDlg.showErrorDlg((Component)this.owner, string);
            }
        }
    }

    private JButton createAndRegisterImageButton(String string, String string2, String string3) {
        JButton jButton = EmuUtil.createImageButton(this.owner, string, string2);
        jButton.setActionCommand(string3);
        jButton.addActionListener(this.owner);
        this.registerButton(jButton, string3);
        return jButton;
    }

    private JMenuItem createAndRegisterJMenuItem(String string, String string2, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this.owner);
        this.registerButton(jMenuItem, string2);
        return jMenuItem;
    }

    private EmuThread getEmuThread() {
        return this.screenFrm != null ? this.screenFrm.getEmuThread() : null;
    }

    private File getFile(List<FileObject> list, boolean bl) {
        File file = null;
        if (list.size() == 1 && (file = list.get(0).getFile()) != null && bl && !file.isFile()) {
            file = null;
        }
        return file;
    }

    private List<File> getFiles(List<FileObject> list, boolean bl) {
        int n = list.size();
        ArrayList<File> arrayList = new ArrayList<File>(n > 0 ? n : 1);
        for (FileObject fileObject : list) {
            File file = fileObject.getFile();
            if (file == null || bl && !file.isFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private Path getPath(List<FileObject> list) {
        Path path = null;
        if (list.size() == 1) {
            path = list.get(0).getPath();
        }
        return path;
    }

    private List<Path> getPaths(List<FileObject> list) {
        int n = list.size();
        ArrayList<Path> arrayList = new ArrayList<Path>(n > 0 ? n : 1);
        for (FileObject fileObject : list) {
            Path path = fileObject.getPath();
            if (path == null) continue;
            arrayList.add(path);
        }
        return arrayList;
    }

    private void registerButton(AbstractButton abstractButton, String string) {
        Collection<AbstractButton> collection = this.actionCmd2Btn.get(string);
        if (collection == null) {
            collection = new ArrayList<AbstractButton>();
            this.actionCmd2Btn.put(string, collection);
        }
        collection.add(abstractButton);
    }

    private void setActionBtnsEnabled(String string, boolean bl) {
        Collection<AbstractButton> collection = this.actionCmd2Btn.get(string);
        if (collection != null) {
            for (AbstractButton abstractButton : collection) {
                abstractButton.setEnabled(bl);
            }
        }
    }

    public static interface FileObject {
        public File getFile();

        public Path getPath();

        public FileCheckResult getCheckResult();

        public void setPath(Path var1);
    }

    public static enum FileActionResult {
        NONE,
        DONE,
        FILE_RENAMED,
        FILES_CHANGED;

    }
}

